/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildUpdater;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParentBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultBuildUpdater
extends BaseBuildUpdater {
    private Boolean _buildCompleted;
    private Boolean _buildFailing;

    @Override
    public void invoke() {
        Build build = this.getBuild();
        JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
        if (jenkinsMaster == null) {
            JenkinsCohort jenkinsCohort = build.getJenkinsCohort();
            jenkinsMaster = jenkinsCohort.getMostAvailableJenkinsMaster(build.getInvokedBatchSize(), build.getMinimumSlaveRAM(), build.getMaximumSlavesPerHost());
            build.setJenkinsMaster(jenkinsMaster);
        }
        build.addInvocation(this._invoke(jenkinsMaster));
    }

    @Override
    public void reinvoke() {
        Build build = this.getBuild();
        JenkinsCohort jenkinsCohort = build.getJenkinsCohort();
        JenkinsMaster jenkinsMaster = jenkinsCohort.getMostAvailableJenkinsMaster(build.getInvokedBatchSize(), 24, build.getMaximumSlavesPerHost());
        build.setJenkinsMaster(jenkinsMaster);
        build.addInvocation(this._invoke(jenkinsMaster));
        build.reset();
        build.setStatus("queued");
    }

    @Override
    public void reset() {
        super.reset();
        this._buildCompleted = null;
        this._buildFailing = null;
    }

    protected DefaultBuildUpdater(Build build) {
        super(build);
    }

    @Override
    protected boolean isBuildCompleted() {
        if (this._buildCompleted != null) {
            return this._buildCompleted;
        }
        Build build = this.getBuild();
        JSONObject buildJSONObject = build.getBuildJSONObject("duration,result");
        if (buildJSONObject == null) {
            return false;
        }
        long duration = buildJSONObject.optLong("duration");
        String result = buildJSONObject.optString("result");
        if (duration == 0L || JenkinsResultsParserUtil.isNullOrEmpty(result)) {
            return false;
        }
        if (build instanceof ParentBuild) {
            ParentBuild parentBuild = (ParentBuild)build;
            for (Build downstreamBuild : parentBuild.getDownstreamBuilds()) {
                if (downstreamBuild.isCompleted()) continue;
                return false;
            }
        }
        this._buildCompleted = true;
        return this._buildCompleted;
    }

    @Override
    protected boolean isBuildFailing() {
        if (this._buildFailing != null) {
            return this._buildFailing;
        }
        Build build = this.getBuild();
        String result = build.getResult();
        if (result == null) {
            JSONObject buildJSONObject = build.getBuildJSONObject("result");
            if (buildJSONObject == null) {
                return true;
            }
            result = buildJSONObject.optString("result");
        }
        if (!Objects.equals(result, "SUCCESS")) {
            return true;
        }
        this._buildFailing = false;
        return this._buildFailing;
    }

    @Override
    protected boolean isBuildQueued() {
        try {
            JSONObject queueItemJSONObject = this._getQueueItemJSONObject();
            if (queueItemJSONObject == null) {
                return false;
            }
            Build build = this.getBuild();
            Build.Invocation buildInvocation = build.getCurrentInvocation();
            buildInvocation.setQueueId(queueItemJSONObject.getLong("id"));
            return true;
        }
        catch (Exception exception) {
            Build build = this.getBuild();
            System.out.println(JenkinsResultsParserUtil.combine("[", build.getBuildName(), "] Unable to get queue item"));
            return false;
        }
    }

    @Override
    protected boolean isBuildRunning() {
        try {
            JSONObject buildJSONObject = this._getBuildJSONObject();
            if (buildJSONObject == null) {
                return false;
            }
            Build build = this.getBuild();
            build.setBuildURL(buildJSONObject.getString("url"));
            build.saveBuildURLInBuildDatabase();
            Build.Invocation buildInvocation = build.getCurrentInvocation();
            buildInvocation.setQueueId(buildJSONObject.getLong("queueId"));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Build build = this.getBuild();
            System.out.println(JenkinsResultsParserUtil.combine("[", build.getBuildName(), "] Unable to get build item"));
            return false;
        }
    }

    private JSONObject _getBuildJSONObject() {
        Build build = this.getBuild();
        Build.Invocation currentInvocation = build.getCurrentInvocation();
        long currentQueueId = currentInvocation.getQueueId();
        JenkinsMaster jenkinsMaster = currentInvocation.getJenkinsMaster();
        List<JSONObject> buildJSONObjects = jenkinsMaster.getBuildJSONObjects(build.getJobName());
        for (JSONObject buildJSONObject : buildJSONObjects) {
            Build.Invocation previousInvocation;
            if (currentQueueId > 0L) {
                if (!Objects.equals(buildJSONObject.getLong("queueId"), currentQueueId)) continue;
                return buildJSONObject;
            }
            if (!this._matchesBuildParameters(this._getBuildParameters(buildJSONObject)) || (previousInvocation = build.getPreviousInvocation()) != null && Objects.equals(previousInvocation.getBuildURL(), buildJSONObject.optString("url"))) continue;
            return buildJSONObject;
        }
        return null;
    }

    private Map<String, String> _getBuildParameters(JSONObject jsonObject) {
        int i;
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        if (!jsonObject.has("actions")) {
            return buildParameters;
        }
        JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
        if (actionsJSONArray.length() <= 0) {
            return buildParameters;
        }
        JSONArray parametersJSONArray = null;
        for (i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            if (!actionJSONObject.has("parameters")) continue;
            parametersJSONArray = actionJSONObject.getJSONArray("parameters");
        }
        if (parametersJSONArray == null || parametersJSONArray.isEmpty()) {
            return buildParameters;
        }
        for (i = 0; i < parametersJSONArray.length(); ++i) {
            JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(i);
            buildParameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
        }
        return buildParameters;
    }

    private JSONObject _getQueueItemJSONObject() {
        try {
            Build build = this.getBuild();
            JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
            if (jenkinsMaster == null) {
                return null;
            }
            ArrayList<JSONObject> queueItemJSONObjects = new ArrayList<JSONObject>(jenkinsMaster.getQueueItemJSONObjects());
            String jenkinsJobName = build.getJobName();
            Build.Invocation currentInvocation = build.getCurrentInvocation();
            long currentQueueId = currentInvocation.getQueueId();
            for (JSONObject queueItemJSONObject : queueItemJSONObjects) {
                JSONObject taskJSONObject;
                String taskURL;
                if (!(currentQueueId > 0L ? Objects.equals(queueItemJSONObject.getLong("id"), currentQueueId) : (taskURL = (taskJSONObject = queueItemJSONObject.getJSONObject("task")).getString("url")).contains("/job/" + jenkinsJobName) && this._matchesBuildParameters(this._getBuildParameters(queueItemJSONObject)))) continue;
                return queueItemJSONObject;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    private Build.Invocation _invoke(JenkinsMaster jenkinsMaster) {
        Build build = this.getBuild();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(jenkinsMaster.getURL());
            sb.append("/job/");
            sb.append(build.getJobName());
            sb.append("/buildWithParameters?token=");
            sb.append(JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
            HashMap<String, String> buildParameters = new HashMap<String, String>(build.getParameters());
            for (Map.Entry buildParameter : buildParameters.entrySet()) {
                String buildParameterName = (String)buildParameter.getKey();
                if (!buildParameterName.matches("[A-Z0-9_]+")) continue;
                sb.append("&");
                sb.append(buildParameterName);
                sb.append("=");
                sb.append((String)buildParameter.getValue());
            }
            JenkinsResultsParserUtil.toString(sb.toString());
            return new Build.Invocation(build, jenkinsMaster);
        }
        catch (IOException ioException) {
            System.out.println("WARNING: Unable to invoke Jenkins using curl");
            try {
                JSONObject jsonObject = JenkinsResultsParserUtil.invokeJenkinsBuild(jenkinsMaster, build.getJobName(), build.getParameters());
                return new Build.Invocation(build, jenkinsMaster, jsonObject.getLong("queueId"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private boolean _matchesBuildParameters(Map<String, String> buildParameters) {
        Build build = this.getBuild();
        for (Map.Entry<String, String> buildParameter : buildParameters.entrySet()) {
            String parameterValue = build.getParameterValue(buildParameter.getKey());
            if (JenkinsResultsParserUtil.isNullOrEmpty(parameterValue) || Objects.equals(buildParameter.getValue(), parameterValue)) continue;
            return false;
        }
        return true;
    }
}

