/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseTopLevelBuildReport;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JUnitTestResult;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultTopLevelBuildReport
extends BaseTopLevelBuildReport {
    private static final long _TIMEOUT = 21600L;
    private static final Pattern _axisNamePattern = Pattern.compile("(?<batchName>[^/]+)/[^/]+/[^/]+");
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(30, true);
    private static final Pattern _testClassFilePathPattern = Pattern.compile(".+/modules(?<relativePath>/.+)/src/(?<type>test|testIntegration)/.*");
    private final File _jenkinsConsoleLocalFile;
    private final TopLevelBuild _topLevelBuild;

    @Override
    public JSONObject getBuildReportJSONObject() {
        if (this.buildReportJSONObject != null) {
            return this.buildReportJSONObject;
        }
        this.buildReportJSONObject = new JSONObject();
        this.buildReportJSONObject.put("buildParameters", this._topLevelBuild.getParameters());
        this.buildReportJSONObject.put("buildURL", (Object)this._topLevelBuild.getBuildURL());
        this.buildReportJSONObject.put("duration", this._topLevelBuild.getDuration());
        this.buildReportJSONObject.put("result", (Object)this._topLevelBuild.getResult());
        this.buildReportJSONObject.put("startTime", (Object)this._topLevelBuild.getStartTime());
        StopWatchRecordsGroup stopWatchRecordsGroup = this._topLevelBuild.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup != null) {
            this.buildReportJSONObject.put("stopWatchRecords", (Object)stopWatchRecordsGroup.getJSONArray());
        }
        ArrayList callables = new ArrayList();
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService, "getBuildReportJSONObject");
        for (final Build build : this._topLevelBuild.getDownstreamBuilds(null)) {
            if (build instanceof BatchBuild) {
                BatchBuild batchBuild = (BatchBuild)build;
                for (final AxisBuild axisBuild : batchBuild.getDownstreamAxisBuilds()) {
                    JenkinsMaster jenkinsMaster = axisBuild.getJenkinsMaster();
                    callables.add(new ParallelExecutor.SequentialCallable<JSONObject>(jenkinsMaster.getName()){

                        @Override
                        public JSONObject call() throws Exception {
                            return DefaultTopLevelBuildReport.this._getDownstreamBuildJSONObject(axisBuild);
                        }
                    });
                }
                continue;
            }
            JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
            callables.add(new ParallelExecutor.SequentialCallable<JSONObject>(jenkinsMaster.getName()){

                @Override
                public JSONObject call() throws Exception {
                    return DefaultTopLevelBuildReport.this._getDownstreamBuildJSONObject(build);
                }
            });
        }
        HashMap<String, List> downstreamBuildMap = new HashMap<String, List>();
        try {
            for (JSONObject jsonObject : parallelExecutor.execute(21600L)) {
                String batchName = "default";
                Matcher matcher = _axisNamePattern.matcher(jsonObject.optString("axisName", ""));
                if (matcher.find()) {
                    batchName = matcher.group("batchName");
                }
                List downstreamBuildJSONObjects = downstreamBuildMap.getOrDefault(batchName, new ArrayList());
                downstreamBuildJSONObjects.add(jsonObject);
                downstreamBuildMap.put(batchName, downstreamBuildJSONObjects);
            }
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry downstreamBuildEntry : downstreamBuildMap.entrySet()) {
            JSONObject batchJSONObject = new JSONObject();
            batchJSONObject.put("batchName", downstreamBuildEntry.getKey()).put("builds", (Collection)downstreamBuildEntry.getValue());
            jSONArray.put((Object)batchJSONObject);
        }
        this.buildReportJSONObject.put("batches", (Object)jSONArray);
        this.buildReportJSONObject.put("testSuiteName", (Object)this._topLevelBuild.getTestSuiteName());
        return this.buildReportJSONObject;
    }

    protected DefaultTopLevelBuildReport(TopLevelBuild topLevelBuild) {
        super(topLevelBuild);
        this._topLevelBuild = topLevelBuild;
        this._jenkinsConsoleLocalFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp());
        try {
            JenkinsResultsParserUtil.write(this._jenkinsConsoleLocalFile, topLevelBuild.getConsoleText());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    protected JSONObject getBuildJSONObject() {
        return this._topLevelBuild.getBuildJSONObject();
    }

    @Override
    protected File getJenkinsConsoleLocalFile() {
        return this._jenkinsConsoleLocalFile;
    }

    private JSONObject _getDownstreamBuildJSONObject(Build build) {
        JSONObject downstreamBuildJSONObject = new JSONObject();
        if (build instanceof AxisBuild) {
            AxisBuild axisBuild = (AxisBuild)build;
            downstreamBuildJSONObject.put("axisName", (Object)axisBuild.getAxisName());
        } else if (build instanceof DownstreamBuild) {
            DownstreamBuild downstreamBuild = (DownstreamBuild)build;
            downstreamBuildJSONObject.put("axisName", (Object)downstreamBuild.getAxisName());
        }
        downstreamBuildJSONObject.put("buildURL", (Object)build.getBuildURL()).put("duration", build.getDuration()).put("result", (Object)build.getResult()).put("startTime", (Object)build.getStartTime());
        StopWatchRecordsGroup stopWatchRecordsGroup = build.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup != null) {
            downstreamBuildJSONObject.put("stopWatchRecords", (Object)stopWatchRecordsGroup.getJSONArray());
        }
        JSONArray testResultsJSONArray = new JSONArray();
        for (TestResult testResult : build.getTestResults(null)) {
            testResultsJSONArray.put((Object)this._getTestResultJSONObject(testResult));
        }
        downstreamBuildJSONObject.put("testResults", (Object)testResultsJSONArray);
        return downstreamBuildJSONObject;
    }

    private JSONObject _getTestResultJSONObject(TestResult testResult) {
        JSONObject testResultJSONObject = new JSONObject();
        testResultJSONObject.put("duration", testResult.getDuration());
        String errorDetails = testResult.getErrorDetails();
        if (errorDetails != null) {
            if (errorDetails.contains("\n")) {
                int index = errorDetails.indexOf("\n");
                errorDetails = errorDetails.substring(0, index);
            }
            if (errorDetails.length() > 200) {
                errorDetails = errorDetails.substring(0, 200);
            }
            testResultJSONObject.put("errorDetails", (Object)errorDetails);
        }
        testResultJSONObject.put("name", (Object)testResult.getDisplayName()).put("status", (Object)testResult.getStatus()).put("testTaskName", (Object)this._getTestTaskName(testResult));
        return testResultJSONObject;
    }

    private String _getTestTaskName(TestResult testResult) {
        if (!(testResult instanceof JUnitTestResult)) {
            return null;
        }
        TestClassResult testClassResult = testResult.getTestClassResult();
        if (testClassResult == null) {
            return null;
        }
        TestClass testClass = testClassResult.getTestClass();
        if (testClass == null) {
            return null;
        }
        Matcher matcher = _testClassFilePathPattern.matcher(String.valueOf(testClass.getTestClassFile()));
        if (!matcher.find()) {
            return null;
        }
        String relativePath = matcher.group("relativePath");
        return JenkinsResultsParserUtil.combine(relativePath.replaceAll("\\/", ":"), ":", matcher.group("type"));
    }
}

