/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PoshiJUnitTestResult;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.CIFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CompileFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GradleTaskFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.IntegrationTestTimeoutFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.JSUnitTestFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.LocalGitMirrorFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.ModulesCompilationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PMDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PlaywrightCompilationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PluginGitIDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SemanticVersioningFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.ServiceBuilderFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SourceFormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.StartupFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.UpgradeFailureMessageGenerator;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONObject;

public class DownstreamBuild
extends BaseBuild {
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new ModulesCompilationFailureMessageGenerator(), new CompileFailureMessageGenerator(), new IntegrationTestTimeoutFailureMessageGenerator(), new JSUnitTestFailureMessageGenerator(), new PMDFailureMessageGenerator(), new PlaywrightCompilationFailureMessageGenerator(), new PluginGitIDFailureMessageGenerator(), new SemanticVersioningFailureMessageGenerator(), new ServiceBuilderFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new StartupFailureMessageGenerator(), new UpgradeFailureMessageGenerator(), new GradleTaskFailureMessageGenerator(), new LocalGitMirrorFailureMessageGenerator(), new CIFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private Element _gitHubMessageElement;

    @Override
    public void addTimelineData(Build.TimelineData timelineData) {
        timelineData.addTimelineData(this);
    }

    @Override
    public URL getArtifactsBaseURL() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append(topLevelBuild.getArtifactsBaseURL());
        sb.append("/");
        sb.append(this.getJobVariant());
        sb.append("/");
        sb.append(this.getAxisVariable());
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public long getAverageDuration() {
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        if (axisTestClassGroup == null) {
            return 0L;
        }
        return axisTestClassGroup.getAverageDuration();
    }

    public long getAverageOverheadDuration() {
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        if (axisTestClassGroup == null) {
            return 0L;
        }
        return axisTestClassGroup.getAverageOverheadDuration();
    }

    public long getAverageTotalTestDuration() {
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        if (axisTestClassGroup == null) {
            return 0L;
        }
        return axisTestClassGroup.getAverageTotalTestDuration();
    }

    public String getAxisName() {
        return JenkinsResultsParserUtil.combine(this.getJobVariant(), "/", this.getAxisVariable());
    }

    public AxisTestClassGroup getAxisTestClassGroup() {
        Job job = this.getJob();
        return job.getAxisTestClassGroup(this.getAxisName());
    }

    public String getAxisVariable() {
        return this.getParameterValue("AXIS_VARIABLE");
    }

    @Override
    public String getBaseGitRepositoryName() {
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this.gitRepositoryName)) {
            return this.gitRepositoryName;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        this.gitRepositoryName = topLevelBuild.getParameterValue("REPOSITORY_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this.gitRepositoryName)) {
            return this.gitRepositoryName;
        }
        String branchName = this.getBranchName();
        this.gitRepositoryName = "liferay-portal-ee";
        if (branchName.equals("master")) {
            this.gitRepositoryName = "liferay-portal";
        }
        return this.gitRepositoryName;
    }

    public String getBatchName() {
        String jobVariant = this.getJobVariant();
        return jobVariant.replaceAll("([^/]+)/.*", "$1");
    }

    @Override
    public String getBuildName() {
        return this.getAxisName();
    }

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobVariant());
        sb.append("/");
        sb.append(this.getAxisVariable());
        return sb.toString();
    }

    @Override
    public Element getGitHubMessageElement() {
        String batchName;
        if (this._gitHubMessageElement != null) {
            return this._gitHubMessageElement;
        }
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            System.out.println(JenkinsResultsParserUtil.combine("[", this.getBuildName(), "] Skipped creating a failure GitHub ", "message because status is ", status));
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            System.out.println(JenkinsResultsParserUtil.combine("[", this.getBuildName(), "] Skipped creating a failure GitHub ", "message because result is ", result));
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/consoleText", null, this.getDisplayName()));
        if (result.equals("ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
            List<Element> untestedElements = this.getTestResultGitHubElements(this.getUniqueFailureTestResults(), true);
            if (!untestedElements.isEmpty()) {
                Dom4JUtil.getOrderedListElement(untestedElements, messageElement, 3);
            }
        }
        if ((batchName = this.getBatchName()).contains("playwright-js")) {
            for (URL url : this.getTestrayS3AttachmentURLs()) {
                String urlString = url.toString();
                if (!urlString.contains("playwright-report/index.html")) continue;
                Dom4JUtil.addToElement(messageElement, " - ", Dom4JUtil.getNewAnchorElement(urlString, null, "Playwright Report"));
                break;
            }
        }
        if (result.equals("FAILURE")) {
            List<Element> untestedElements;
            Element failureMessageElement = this.getFailureMessageElement();
            if (failureMessageElement != null && !batchName.contains("playwright-js")) {
                messageElement.add(failureMessageElement);
            }
            if (!(untestedElements = this.getTestResultGitHubElements(this.getUniqueFailureTestResults(), true)).isEmpty()) {
                Dom4JUtil.getOrderedListElement(untestedElements, messageElement, 3);
            }
        }
        if (result.equals("MISSING")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build is missing"));
        }
        if (result.equals("UNSTABLE")) {
            List<Element> failureElements = this.getTestResultGitHubElements(this.getUniqueFailureTestResults(), true);
            List<Element> upstreamJobFailureElements = this.getTestResultGitHubElements(this.getUpstreamJobFailureTestResults(), false);
            if (!upstreamJobFailureElements.isEmpty()) {
                this.upstreamJobFailureMessageElement = messageElement.createCopy();
                Dom4JUtil.getOrderedListElement(upstreamJobFailureElements, this.upstreamJobFailureMessageElement, 3);
                System.out.println(JenkinsResultsParserUtil.combine("[", this.getBuildName(), "] Saved an upstream failure ", "GitHub message"));
            }
            Dom4JUtil.getOrderedListElement(failureElements, messageElement, 3);
            if (failureElements.isEmpty()) {
                System.out.println(JenkinsResultsParserUtil.combine("[", this.getBuildName(), "] Skipped creating a failure GitHub message because ", "no failure elements were created"));
                return null;
            }
        }
        System.out.println(JenkinsResultsParserUtil.combine("[", this.getBuildName(), "] Created a failure GitHub message: ", String.valueOf(this.hashCode())));
        this._gitHubMessageElement = messageElement;
        return this._gitHubMessageElement;
    }

    public Map<String, List<String>> getTestClassMethodsMap() {
        String batchName = this.getBatchName();
        if (!batchName.contains("integration") && !batchName.contains("unit")) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> testClassMethodsMap = new HashMap<String, List<String>>();
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        if (axisTestClassGroup == null || !axisTestClassGroup.hasTestClasses()) {
            return testClassMethodsMap;
        }
        List<TestClass> testClasses = axisTestClassGroup.getTestClasses();
        for (TestClass testClass : testClasses) {
            if (!(testClass instanceof JUnitTestClass)) continue;
            JUnitTestClass jUnitTestClass = (JUnitTestClass)testClass;
            ArrayList<String> methodNames = new ArrayList<String>();
            for (TestClassMethod testClassMethod : testClass.getTestClassMethods()) {
                String testMethodName = testClassMethod.getName();
                if (methodNames.contains(testMethodName)) continue;
                methodNames.add(testClassMethod.getName());
            }
            testClassMethodsMap.put(jUnitTestClass.getTestClassName(), methodNames);
        }
        return testClassMethodsMap;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(testStatus)) {
            return this.getTestResults();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestResult testResult : this.getTestResults()) {
            if (!testStatus.equals(testResult.getStatus())) continue;
            testResults.add(testResult);
        }
        return testResults;
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        ArrayList<TestResult> uniqueFailureTestResults = new ArrayList<TestResult>();
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        testResults.addAll(this.getTestResults(null));
        List<TestResult> passedTestResults = this.getTestResults("PASSED");
        if (this.isFailing() && passedTestResults.size() == 1 && testResults.isEmpty()) {
            testResults.addAll(passedTestResults);
        }
        for (TestResult testResult : testResults) {
            if (!testResult.isFailing() || !testResult.isUniqueFailure()) continue;
            uniqueFailureTestResults.add(testResult);
        }
        for (TestResult untestedTestResult : this.getUntestedTestResults()) {
            if (!untestedTestResult.isUniqueFailure()) continue;
            uniqueFailureTestResults.add(untestedTestResult);
        }
        return uniqueFailureTestResults;
    }

    public Map<String, List<String>> getUntestedTestClassMethodsMap() {
        Map<String, List<String>> untestedTestClassMethodsMap = this.getTestClassMethodsMap();
        if (untestedTestClassMethodsMap.isEmpty()) {
            return Collections.emptyMap();
        }
        List<TestResult> testResults = this.getTestResults();
        if (testResults.isEmpty()) {
            return Collections.emptyMap();
        }
        for (TestResult testResult : testResults) {
            String testResultClassName = testResult.getClassName();
            if (!untestedTestClassMethodsMap.containsKey(testResultClassName)) continue;
            List<String> testClassMethods = untestedTestClassMethodsMap.get(testResultClassName);
            testClassMethods.remove(testResult.getTestName());
            untestedTestClassMethodsMap.put(testResultClassName, testClassMethods);
        }
        return untestedTestClassMethodsMap;
    }

    public List<TestResult> getUntestedTestResults() {
        Map<String, List<String>> untestedTestsMap = this.getUntestedTestClassMethodsMap();
        if (untestedTestsMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TestResult> untestedTestResults = new ArrayList<TestResult>();
        for (Map.Entry<String, List<String>> entry : untestedTestsMap.entrySet()) {
            List<String> testClassMethods = entry.getValue();
            if (testClassMethods.isEmpty()) continue;
            for (String methodName : testClassMethods) {
                String status;
                JSONObject caseJSONObject = new JSONObject();
                String testClassName = entry.getKey();
                caseJSONObject.put("className", (Object)testClassName).put("duration", 0).put("errorDetails", (Object)"This test was untested.").put("errorStackTrace", (Object)"").put("name", (Object)methodName).put("status", (Object)"UNTESTED").put("testName", (Object)methodName);
                TestResult testResult = TestResultFactory.newTestResult(this, caseJSONObject);
                TestClassResult testClassResult = testResult.getTestClassResult();
                if (testClassResult != null && (status = testClassResult.getStatus()).equals("SKIPPED")) continue;
                untestedTestResults.add(testResult);
            }
        }
        return untestedTestResults;
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        ArrayList<TestResult> upstreamFailureTestResults = new ArrayList<TestResult>();
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        testResults.addAll(this.getTestResults(null));
        List<TestResult> passedTestResults = this.getTestResults("PASSED");
        if (this.isFailing() && passedTestResults.size() == 1 && testResults.isEmpty()) {
            testResults.addAll(passedTestResults);
        }
        for (TestResult testResult : testResults) {
            if (!testResult.isFailing() || testResult.isUniqueFailure()) continue;
            upstreamFailureTestResults.add(testResult);
        }
        for (TestResult untestedTestResult : this.getUntestedTestResults()) {
            if (untestedTestResult.isUniqueFailure()) continue;
            upstreamFailureTestResults.add(untestedTestResult);
        }
        return upstreamFailureTestResults;
    }

    public List<String> getWarningMessages() {
        ArrayList<String> warningMessages = new ArrayList<String>();
        URL poshiWarningsURL = null;
        try {
            poshiWarningsURL = new URL(this.getArtifactsBaseURL() + "/poshi-warnings.xml.gz");
        }
        catch (IOException ioException) {
            return warningMessages;
        }
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = poshiWarningsURL.openStream();
             GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            int i = 0;
            while ((i = gzipInputStream.read()) > 0) {
                sb.append((char)i);
            }
        }
        catch (IOException ioException) {
            return warningMessages;
        }
        try {
            Document document = Dom4JUtil.parse(sb.toString());
            Element rootElement = document.getRootElement();
            for (Element valueElement : rootElement.elements("value")) {
                String liferayErrorText = "LIFERAY_ERROR: ";
                String valueElementText = StringEscapeUtils.escapeHtml((String)valueElement.getText());
                if (valueElementText.startsWith(liferayErrorText)) {
                    valueElementText = valueElementText.substring(liferayErrorText.length());
                }
                warningMessages.add(valueElementText);
            }
        }
        catch (DocumentException documentException) {
            warningMessages.add("Unable to parse Poshi warnings");
        }
        return warningMessages;
    }

    @Override
    public void saveBuildURLInBuildDatabase() {
        BuildDatabase buildDatabase = this.getBuildDatabase();
        buildDatabase.putProperty("build-urls.properties", this.getAxisName(), this.getBuildURL(), false);
    }

    protected DownstreamBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return null;
    }

    @Override
    protected List<Element> getJenkinsReportBuildDurationsElements() {
        String urlSuffix = "buildDurationsElements";
        if (this.archiveFileExists(urlSuffix)) {
            return this.getArchiveFileElements(urlSuffix);
        }
        ArrayList<Element> jenkinsReportTableRowElements = new ArrayList<Element>();
        Element buildDurationsHeaderElement = Dom4JUtil.getNewElement("tr");
        ArrayList<String> childStopWatchRows = new ArrayList<String>();
        childStopWatchRows.add("build-duration-names");
        childStopWatchRows.add("build-duration-values");
        childStopWatchRows.add("build-overhead-duration-values");
        childStopWatchRows.add("build-test-duration-values");
        buildDurationsHeaderElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRows));
        buildDurationsHeaderElement.addAttribute("id", this.hashCode() + "-build-durations-header");
        buildDurationsHeaderElement.addAttribute("style", "display: none");
        Element buildDurationsElement = Dom4JUtil.getNewElement("td", buildDurationsHeaderElement, this.getExpanderAnchorElement("build-durations-header", String.valueOf(this.hashCode())), Dom4JUtil.getNewElement("u", null, "Build Durations"));
        buildDurationsElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(this.getDepth() * 35), "px"));
        jenkinsReportTableRowElements.add(buildDurationsHeaderElement);
        Element durationNamesElement = Dom4JUtil.getNewElement("tr");
        durationNamesElement.addAttribute("id", this.hashCode() + "-build-duration-names");
        durationNamesElement.addAttribute("style", "display: none;");
        Element durationNamesDataElement = Dom4JUtil.getNewElement("th", durationNamesElement, "Name");
        String style = JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf((this.getDepth() + 1) * 35), "px");
        durationNamesDataElement.addAttribute("style", style);
        boolean overheadIncluded = false;
        String batchName = this.getBatchName();
        if (batchName.startsWith("function") || batchName.startsWith("integration") || batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit") || batchName.startsWith("unit")) {
            overheadIncluded = true;
        }
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (est)");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (+/-)");
        jenkinsReportTableRowElements.add(durationNamesElement);
        Element durationValuesElement = Dom4JUtil.getNewElement("tr");
        durationValuesElement.addAttribute("id", this.hashCode() + "-build-duration-values");
        durationValuesElement.addAttribute("style", "display: none;");
        Element durationValuesDataElement = Dom4JUtil.getNewElement("td", durationValuesElement, "Total Duration");
        durationValuesDataElement.addAttribute("style", style);
        long duration = this.getDuration();
        long averageDuration = this.getAverageDuration();
        Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(duration));
        Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(averageDuration));
        Dom4JUtil.getNewElement("td", durationValuesElement, this.getDiffDurationString(duration - averageDuration));
        jenkinsReportTableRowElements.add(durationValuesElement);
        if (!overheadIncluded) {
            this.archiveFileElements(urlSuffix, jenkinsReportTableRowElements);
            return jenkinsReportTableRowElements;
        }
        Element totalTestDurationValuesElement = Dom4JUtil.getNewElement("tr");
        totalTestDurationValuesElement.addAttribute("id", this.hashCode() + "-build-test-duration-values");
        totalTestDurationValuesElement.addAttribute("style", "display: none;");
        Element totalTestDurationsValuesDataElement = Dom4JUtil.getNewElement("td", totalTestDurationValuesElement, "Total Test Durations");
        totalTestDurationsValuesDataElement.addAttribute("style", style);
        long totalTestDuration = 0L;
        for (TestResult testResult : this.getTestResults()) {
            totalTestDuration += testResult.getDuration();
        }
        long averageTotalTestDuration = this.getAverageTotalTestDuration();
        Dom4JUtil.getNewElement("td", totalTestDurationValuesElement, JenkinsResultsParserUtil.toDurationString(totalTestDuration));
        Dom4JUtil.getNewElement("td", totalTestDurationValuesElement, JenkinsResultsParserUtil.toDurationString(averageTotalTestDuration));
        Dom4JUtil.getNewElement("td", totalTestDurationValuesElement, this.getDiffDurationString(totalTestDuration - averageTotalTestDuration));
        jenkinsReportTableRowElements.add(totalTestDurationValuesElement);
        Element overheadDurationValuesElement = Dom4JUtil.getNewElement("tr");
        overheadDurationValuesElement.addAttribute("id", this.hashCode() + "-build-overhead-duration-values");
        overheadDurationValuesElement.addAttribute("style", "display: none;");
        Element overheadDurationValuesDataElement = Dom4JUtil.getNewElement("td", overheadDurationValuesElement, "Overhead Duration");
        overheadDurationValuesDataElement.addAttribute("style", style);
        long overheadDuration = duration - totalTestDuration;
        if (overheadDuration <= 0L) {
            overheadDuration = 0L;
        }
        long averageOverheadDuration = this.getAverageOverheadDuration();
        Dom4JUtil.getNewElement("td", overheadDurationValuesElement, JenkinsResultsParserUtil.toDurationString(overheadDuration));
        Dom4JUtil.getNewElement("td", overheadDurationValuesElement, JenkinsResultsParserUtil.toDurationString(averageOverheadDuration));
        Dom4JUtil.getNewElement("td", overheadDurationValuesElement, this.getDiffDurationString(overheadDuration - averageOverheadDuration));
        jenkinsReportTableRowElements.add(overheadDurationValuesElement);
        this.archiveFileElements(urlSuffix, jenkinsReportTableRowElements);
        return jenkinsReportTableRowElements;
    }

    @Override
    protected List<Element> getJenkinsReportTestDurationsElements() {
        ArrayList<String> childStopWatchRows;
        Element testDurationsHeaderElement;
        ArrayList<Element> jenkinsReportTableRowElements;
        String urlSuffix;
        block6: {
            String batchName = this.getBatchName();
            if (!(batchName.startsWith("function") || batchName.startsWith("integration") || batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit") || batchName.startsWith("unit"))) {
                return Collections.emptyList();
            }
            urlSuffix = "testDurationsElements";
            if (this.archiveFileExists(urlSuffix)) {
                return this.getArchiveFileElements(urlSuffix);
            }
            jenkinsReportTableRowElements = new ArrayList<Element>();
            testDurationsHeaderElement = Dom4JUtil.getNewElement("tr");
            testDurationsHeaderElement.addAttribute("id", this.hashCode() + "-test-durations-header");
            testDurationsHeaderElement.addAttribute("style", "display: none");
            childStopWatchRows = new ArrayList<String>();
            childStopWatchRows.add("test-duration-names");
            Element testDurationsElement = Dom4JUtil.getNewElement("td", testDurationsHeaderElement, this.getExpanderAnchorElement("test-durations-header", String.valueOf(this.hashCode())), Dom4JUtil.getNewElement("u", null, "Test Durations"));
            testDurationsElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(this.getDepth() * 35), "px"));
            jenkinsReportTableRowElements.add(testDurationsHeaderElement);
            Element durationNamesElement = Dom4JUtil.getNewElement("tr");
            durationNamesElement.addAttribute("id", this.hashCode() + "-test-duration-names");
            durationNamesElement.addAttribute("style", "display: none;");
            Element durationNamesDataElement = Dom4JUtil.getNewElement("th", durationNamesElement, "Name");
            String style = JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf((this.getDepth() + 1) * 35), "px");
            durationNamesDataElement.addAttribute("style", style);
            Dom4JUtil.getNewElement("th", durationNamesElement, "Duration");
            Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (est)");
            Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (+/-)");
            jenkinsReportTableRowElements.add(durationNamesElement);
            AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
            if (axisTestClassGroup == null) break block6;
            List<TestClass> testClasses = axisTestClassGroup.getTestClasses();
            for (int i = 0; i < testClasses.size(); ++i) {
                long duration;
                String testClassName;
                TestClass testClass;
                block8: {
                    TestClassResult testClassResult;
                    block7: {
                        testClass = testClasses.get(i);
                        testClassResult = null;
                        testClassName = null;
                        duration = 0L;
                        if (!(testClass instanceof JUnitTestClass)) break block7;
                        JUnitTestClass jUnitTestClass = (JUnitTestClass)testClass;
                        testClassName = jUnitTestClass.getTestClassName();
                        testClassResult = this.getTestClassResult(testClassName);
                        if (testClassResult == null) break block8;
                        duration = testClassResult.getDuration();
                        break block8;
                    }
                    if (testClass instanceof FunctionalTestClass) {
                        FunctionalTestClass functionalTestClass = (FunctionalTestClass)testClass;
                        testClassName = functionalTestClass.getTestClassMethodName();
                        testClassResult = this.getTestClassResult("com.liferay.poshi.runner.PoshiRunner");
                        if (testClassResult != null) {
                            for (TestResult testResult : testClassResult.getTestResults()) {
                                String testMethodName = "test[" + testClassName + "]";
                                if (!Objects.equals(testMethodName, testResult.getTestName())) continue;
                                duration = testResult.getDuration();
                                break;
                            }
                        }
                    }
                }
                Element durationValuesElement = Dom4JUtil.getNewElement("tr");
                childStopWatchRows.add("test-duration-values-" + i);
                durationValuesElement.addAttribute("id", this.hashCode() + "-test-duration-values-" + i);
                durationValuesElement.addAttribute("style", "display: none;");
                Element durationValuesDataElement = Dom4JUtil.getNewElement("td", durationValuesElement, testClassName);
                durationValuesDataElement.addAttribute("style", style);
                long averageDuration = testClass.getAverageDuration();
                Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(duration));
                Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(averageDuration));
                Dom4JUtil.getNewElement("td", durationValuesElement, this.getDiffDurationString(duration - averageDuration));
                jenkinsReportTableRowElements.add(durationValuesElement);
            }
        }
        testDurationsHeaderElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRows));
        this.archiveFileElements(urlSuffix, jenkinsReportTableRowElements);
        return jenkinsReportTableRowElements;
    }

    protected long getStopWatchRecordDuration(String stopWatchRecordName) {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup == null) {
            return 0L;
        }
        StopWatchRecord stopWatchRecord = stopWatchRecordsGroup.get(stopWatchRecordName);
        if (stopWatchRecord == null) {
            return 0L;
        }
        Long duration = stopWatchRecord.getDuration();
        if (duration == null) {
            return 0L;
        }
        return duration;
    }

    protected List<Element> getTestResultGitHubElements(List<TestResult> testResults, boolean uniqueFailures) {
        ArrayList<Element> testResultGitHubElements = new ArrayList<Element>();
        ArrayList<TestClassResult> testClassResults = new ArrayList<TestClassResult>();
        for (TestResult testResult : testResults) {
            Element gitHubElement;
            if (testResult instanceof PoshiJUnitTestResult) {
                testResultGitHubElements.add(testResult.getGitHubElement());
                continue;
            }
            TestClassResult testClassResult = testResult.getTestClassResult();
            if (testClassResult == null) {
                testResultGitHubElements.add(testResult.getGitHubElement());
                continue;
            }
            if (testClassResults.contains(testClassResult) || (gitHubElement = testClassResult.getGitHubElement(uniqueFailures)) == null) continue;
            testResultGitHubElements.add(gitHubElement);
            testClassResults.add(testClassResult);
        }
        return testResultGitHubElements;
    }
}

