/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.PluginsTopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtraAppsPluginsTopLevelBuild
extends PluginsTopLevelBuild {
    private static final Pattern _pattern = Pattern.compile("https?://.*/(?<pluginName>[^/]+)");

    public ExtraAppsPluginsTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        String branchName = this.getBranchName();
        if (branchName.equals("master")) {
            return "liferay-portal";
        }
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        return this.getParameterValue("TEST_PORTAL_BRANCH_NAME");
    }

    @Override
    public String getPluginName() {
        String testBuildExtraAppsZipURLString = this.getParameterValue("TEST_BUILD_EXTRAAPPS_ZIP_URL");
        if (testBuildExtraAppsZipURLString == null) {
            return null;
        }
        Matcher matcher = _pattern.matcher(testBuildExtraAppsZipURLString);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("pluginName");
    }
}

