/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;

public class FilePropagator {
    private static final long _TIMEOUT_DEFAULT = 0x6DDD00L;
    private static Integer _instanceCount = 0;
    private final List<String> _busySlaves = new ArrayList<String>();
    private final List<String> _errorSlaves = new ArrayList<String>();
    private final List<FilePropagatorTask> _filePropagatorTasks = new ArrayList<FilePropagatorTask>();
    private final String _id;
    private long _lastMessageTime = System.currentTimeMillis();
    private final List<String> _mirrorSlaves = new ArrayList<String>();
    private String _postDistCommand;
    private String _preDistCommand;
    private final List<String> _targetSlaves = new ArrayList<String>();
    private int _threadsCompletedCount;
    private long _threadsDurationTotal;
    private final long _timeout;

    public FilePropagator(String[] fileNames, String sourceDirName, String targetDirName, List<String> targetSlaves) {
        this(fileNames, sourceDirName, targetDirName, null, targetSlaves);
    }

    public FilePropagator(String[] fileNames, String sourceDirName, String targetDirName, String primaryTargetSlave, List<String> targetSlaves) {
        this(fileNames, sourceDirName, targetDirName, primaryTargetSlave, targetSlaves, 0x6DDD00L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePropagator(String[] fileNames, String sourceDirName, String targetDirName, String primaryTargetSlave, List<String> targetSlaves, long timeout) {
        this._timeout = timeout;
        String[] stringArray = _instanceCount;
        synchronized (_instanceCount) {
            Thread thread = Thread.currentThread();
            String[] stringArray2 = new String[3];
            stringArray2[0] = String.valueOf(thread.getId());
            stringArray2[1] = "-";
            Integer n = _instanceCount;
            Integer n2 = _instanceCount = Integer.valueOf(_instanceCount + 1);
            stringArray2[2] = String.valueOf(n);
            this._id = JenkinsResultsParserUtil.combine(stringArray2);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            for (String fileName : fileNames) {
                this._filePropagatorTasks.add(new FilePropagatorTask(sourceDirName + "/" + fileName, targetDirName + "/" + fileName));
            }
            if (primaryTargetSlave != null) {
                targetSlaves.remove(primaryTargetSlave);
                this._targetSlaves.add(primaryTargetSlave);
            }
            this._targetSlaves.addAll(targetSlaves);
            return;
        }
    }

    public long getAverageThreadDuration() {
        if (this._threadsCompletedCount == 0) {
            return 0L;
        }
        return this._threadsDurationTotal / (long)this._threadsCompletedCount;
    }

    public List<String> getErrorSlaves() {
        return this._errorSlaves;
    }

    public void setPostDistCommand(String postDistCommand) {
        this._postDistCommand = postDistCommand;
    }

    public void setPreDistCommand(String preDistCommand) {
        this._preDistCommand = preDistCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int threadCount) {
        this._copyFromSource();
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        this.log("File propagation starting with " + threadCount + " threads.");
        try {
            String previousString = null;
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            long duration = 0L;
            while (!(this._targetSlaves.isEmpty() && this._busySlaves.isEmpty() || executorService.isShutdown())) {
                duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
                if (duration >= this._timeout) {
                    this.log("Timeout limit exceeded.");
                    executorService.shutdownNow();
                } else {
                    FilePropagator filePropagator = this;
                    synchronized (filePropagator) {
                        for (String mirrorSlave : this._mirrorSlaves) {
                            if (this._targetSlaves.isEmpty()) break;
                            String targetSlave = this._targetSlaves.remove(0);
                            executorService.execute(new FilePropagatorThread(this, mirrorSlave, targetSlave));
                            this._busySlaves.add(mirrorSlave);
                            this._busySlaves.add(targetSlave);
                        }
                        this._mirrorSlaves.removeAll(this._busySlaves);
                    }
                }
                StringBuffer sb = new StringBuffer();
                sb.append("Average thread duration: ");
                sb.append(JenkinsResultsParserUtil.toDurationString(this.getAverageThreadDuration()));
                sb.append("\nBusy slaves:");
                sb.append(this._busySlaves.size());
                sb.append("\nError slaves:");
                sb.append(this._errorSlaves.size());
                sb.append("\nMirror slaves:");
                sb.append(this._mirrorSlaves.size());
                sb.append("\nTarget slaves:");
                sb.append(this._targetSlaves.size());
                String currentString = sb.toString();
                if (!Objects.equals(previousString, currentString) || executorService.isShutdown()) {
                    sb.append("\nTotal duration: ");
                    sb.append(JenkinsResultsParserUtil.toDurationString(duration));
                    sb.append("\n");
                    this.log(sb.toString());
                    previousString = currentString;
                } else {
                    long millisSinceLastMessage = System.currentTimeMillis() - this._lastMessageTime;
                    if (millisSinceLastMessage > 300000L) {
                        this.log(JenkinsResultsParserUtil.combine("No change in ", JenkinsResultsParserUtil.toDurationString(millisSinceLastMessage), ". Timeout will occur in ", JenkinsResultsParserUtil.toDurationString(this._timeout - duration), "."));
                    }
                }
                JenkinsResultsParserUtil.sleep(5000L);
            }
            this.log(JenkinsResultsParserUtil.combine("File propagation completed in ", JenkinsResultsParserUtil.toDurationString(duration), "."));
            if (!this._errorSlaves.isEmpty()) {
                System.out.println(this._errorSlaves.size() + " slaves failed to respond:\n" + this._errorSlaves);
            }
        }
        finally {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
        }
        int totalSlaveCount = this._busySlaves.size() + this._errorSlaves.size() + this._mirrorSlaves.size() + this._targetSlaves.size();
        if (totalSlaveCount > 0 && (float)this._mirrorSlaves.size() / (float)totalSlaveCount < 0.5f) {
            throw new FilePropagatorRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to propagate to ", String.valueOf(totalSlaveCount - this._mirrorSlaves.size()), " out of ", String.valueOf(totalSlaveCount), " slave nodes"));
        }
    }

    protected void log(String message) {
        this._lastMessageTime = System.currentTimeMillis();
        System.out.print("File propagator ID: ");
        System.out.print(this._id);
        if (message.contains("\n")) {
            System.out.print("\n");
        } else {
            System.out.print(" - ");
        }
        System.out.println(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyFromSource() {
        if (this._filePropagatorTasks.isEmpty() || this._targetSlaves.isEmpty()) {
            return;
        }
        ArrayList<String> commands = new ArrayList<String>();
        for (FilePropagatorTask filePropagatorTask : this._filePropagatorTasks) {
            String sourceFileName = filePropagatorTask._sourceFileName;
            this.log("Copying from source " + sourceFileName);
            String targetFileName = filePropagatorTask._targetFileName;
            commands.add(this._getMkdirCommand(targetFileName));
            if (sourceFileName.startsWith("http")) {
                StringBuilder sb = new StringBuilder();
                sb.append("curl ");
                try {
                    if (sourceFileName.startsWith("https://release.liferay.com")) {
                        sb.append(" -u ");
                        sb.append(JenkinsResultsParserUtil.getBuildProperty("jenkins.admin.user.name"));
                        sb.append(":");
                        sb.append(JenkinsResultsParserUtil.getBuildProperty("jenkins.admin.user.password"));
                    }
                }
                catch (IOException ioException) {
                    throw new FilePropagatorRuntimeException(this, "Unable to get jenkins-admin user credentials", ioException);
                }
                sb.append("-o ");
                sb.append(targetFileName);
                sb.append(" ");
                sb.append(sourceFileName);
                commands.add(sb.toString());
            } else {
                commands.add("rsync -Iqs " + sourceFileName + " " + targetFileName);
            }
            String targetDirName = targetFileName.substring(0, targetFileName.lastIndexOf("/"));
            commands.add("ls -al " + targetDirName);
        }
        FilePropagator filePropagator = this;
        synchronized (filePropagator) {
            String targetSlave = this._targetSlaves.remove(0);
            this._busySlaves.add(targetSlave);
            try {
                int result = this._executeBashCommands(commands, targetSlave);
                this._busySlaves.remove(targetSlave);
                if (result != 0) {
                    this._errorSlaves.add(targetSlave);
                    this._copyFromSource();
                } else {
                    this._mirrorSlaves.add(targetSlave);
                }
            }
            catch (Exception exception) {
                this._busySlaves.remove(targetSlave);
                if (!this._errorSlaves.contains(targetSlave)) {
                    this._errorSlaves.add(targetSlave);
                }
                throw new FilePropagatorRuntimeException(this, "Unable to copy from source. Executed: " + commands, exception);
            }
        }
        this.log("Finished copying from source.");
    }

    private int _executeBashCommands(List<String> commands, String targetSlave) throws IOException, TimeoutException {
        StringBuffer sb = new StringBuffer();
        sb.append("ssh -o ConnectTimeout=60");
        sb.append(" -o NumberOfPasswordPrompts=0 ");
        sb.append(targetSlave);
        sb.append(" '");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._preDistCommand)) {
            sb.append(this._preDistCommand);
            sb.append(" ; ");
        }
        for (int i = 0; i < commands.size(); ++i) {
            sb.append(commands.get(i));
            if (i >= commands.size() - 1) continue;
            sb.append(" ; ");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._postDistCommand)) {
            sb.append(" ; ");
            sb.append(this._postDistCommand);
        }
        sb.append("'");
        Process process = JenkinsResultsParserUtil.executeBashCommands(sb.toString());
        return process.exitValue();
    }

    private String _getMkdirCommand(String fileName) {
        String dirName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        return "mkdir -p " + dirName;
    }

    private static class FilePropagatorThread
    implements Runnable {
        private long _duration;
        private final FilePropagator _filePropagator;
        private final String _mirrorSlave;
        private boolean _successful;
        private final String _targetSlave;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            List filePropagatorTasks = this._filePropagator._filePropagatorTasks;
            ArrayList<String> commands = new ArrayList<String>(filePropagatorTasks.size() * 2);
            for (FilePropagatorTask filePropagatorTask : filePropagatorTasks) {
                commands.add(this._filePropagator._getMkdirCommand(filePropagatorTask._targetFileName));
                commands.add("rsync -Iqs " + this._mirrorSlave + ":" + filePropagatorTask._targetFileName + " " + filePropagatorTask._targetFileName);
            }
            Thread currentThread = Thread.currentThread();
            if (currentThread.isInterrupted()) {
                this._successful = false;
            } else {
                try {
                    int value = this._filePropagator._executeBashCommands(commands, this._targetSlave);
                    this._successful = value == 0;
                }
                catch (Exception exception) {
                    this._successful = false;
                }
            }
            this._duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
            String durationString = JenkinsResultsParserUtil.toDurationString(this._duration);
            if (this._successful) {
                this._filePropagator.log(JenkinsResultsParserUtil.combine("Propagated to ", this._targetSlave, " from ", this._mirrorSlave, " in ", durationString, "."));
            } else {
                this._filePropagator.log(JenkinsResultsParserUtil.combine("Unable to propagate to ", this._targetSlave, " from ", this._mirrorSlave, "."));
            }
            FilePropagator filePropagator = this._filePropagator;
            synchronized (filePropagator) {
                this._filePropagator._busySlaves.remove(this._mirrorSlave);
                this._filePropagator._busySlaves.remove(this._targetSlave);
                this._filePropagator._mirrorSlaves.add(this._mirrorSlave);
                this._filePropagator._threadsCompletedCount++;
                FilePropagator filePropagator2 = this._filePropagator;
                filePropagator2._threadsDurationTotal = filePropagator2._threadsDurationTotal + this._duration;
                if (!this._successful) {
                    this._filePropagator._errorSlaves.add(this._targetSlave);
                    return;
                }
                this._filePropagator._mirrorSlaves.add(this._targetSlave);
            }
        }

        private FilePropagatorThread(FilePropagator filePropagator, String mirrorSlave, String targetSlave) {
            this._filePropagator = filePropagator;
            this._mirrorSlave = mirrorSlave;
            this._targetSlave = targetSlave;
        }
    }

    private static class FilePropagatorTask {
        private final String _sourceFileName;
        private final String _targetFileName;

        private FilePropagatorTask(String sourceFileName, String targetFileName) {
            this._sourceFileName = this._escapeParentheses(sourceFileName);
            this._targetFileName = this._escapeParentheses(targetFileName);
        }

        private String _escapeParentheses(String fileName) {
            fileName = fileName.replace(")", "\\)");
            fileName = fileName.replace("(", "\\(");
            return fileName;
        }
    }

    private static class FilePropagatorRuntimeException
    extends RuntimeException {
        public FilePropagatorRuntimeException(FilePropagator filePropagator, String message) {
            this(filePropagator, message, null);
        }

        public FilePropagatorRuntimeException(FilePropagator filePropagator, String message, Exception exception) {
            super(filePropagator._id + " - " + message, exception);
        }
    }
}

