/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;

public class FixPackBuilderGitRepositoryJob
extends GitRepositoryJob
implements TestSuiteJob {
    private final String _testSuiteName;
    private final String _upstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        return this.gitWorkingDirectory;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("test_suite_name", (Object)this._testSuiteName);
        this.jsonObject.put("upstream_branch_name", (Object)this._upstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected FixPackBuilderGitRepositoryJob(Job.BuildProfile buildProfile, String jobName, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName);
        this._testSuiteName = testSuiteName;
        this._upstreamBranchName = upstreamBranchName;
        this._initialize();
    }

    protected FixPackBuilderGitRepositoryJob(JSONObject jsonObject) {
        super(jsonObject);
        this._testSuiteName = jsonObject.getString("test_suite_name");
        this._upstreamBranchName = jsonObject.getString("upstream_branch_name");
        this._initialize();
    }

    private File _getFixPackBuilderGitRepositoryDir() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String fixPackBuilderDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "fix.pack.builder.dir", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(fixPackBuilderDirPath)) {
            throw new RuntimeException("Unable to find Fix Pack Builder directory path");
        }
        File fixPackBuilderDir = new File(fixPackBuilderDirPath);
        if (!fixPackBuilderDir.exists()) {
            throw new RuntimeException("Unable to find Fix Pack Builder directory");
        }
        return fixPackBuilderDir;
    }

    private String _getFixPackBuilderRepositoryName() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String fixPackBuilderRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "fix.pack.builder.repository", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(fixPackBuilderRepository)) {
            throw new RuntimeException("Unable to find Fix Pack Builder repository");
        }
        return fixPackBuilderRepository;
    }

    private void _initialize() {
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this._upstreamBranchName, this._getFixPackBuilderGitRepositoryDir(), this._getFixPackBuilderRepositoryName());
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        this.jobPropertiesFiles.add(new File(this.gitWorkingDirectory.getWorkingDirectory(), "test.properties"));
    }
}

