/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Element;

public class FreestyleBatchBuild
extends BaseBuild {
    @Override
    public void addTimelineData(Build.TimelineData timelineData) {
        timelineData.addTimelineData(this);
    }

    @Override
    public URL getArtifactsBaseURL() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append(topLevelBuild.getArtifactsBaseURL());
        sb.append("/");
        sb.append(this.getJobVariant());
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public String getBuildName() {
        return this.getJobVariant();
    }

    @Override
    public String getJobVariant() {
        return this.getParameterValue("RUN_ID");
    }

    protected FreestyleBatchBuild(String url) {
        this(url, null);
    }

    protected FreestyleBatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        String result = this.getResult();
        int failCount = 0;
        int successCount = 0;
        if (result.equals("UNSTABLE")) {
            failCount = this.getTestCountByStatus("FAILURE");
            successCount = this.getTestCountByStatus("SUCCESS");
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, String.valueOf(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Tests", " Test"), " Passed.", Dom4JUtil.getNewElement("br"), String.valueOf(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Tests", " Test"), " Failed."));
    }
}

