/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.BaseBatchBuildData;
import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BasePortalTestBatch;
import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.Workspace;
import java.io.File;
import java.io.IOException;

public class FunctionalPortalTestBatch
extends BasePortalTestBatch<PortalBatchBuildData> {
    @Override
    public void run() {
        try {
            this.executeBatch();
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        finally {
            this.publishResults();
            this.publishPoshiReport();
        }
    }

    protected FunctionalPortalTestBatch(PortalBatchBuildData portalBatchBuildData, Workspace workspace) {
        super(portalBatchBuildData, workspace);
    }

    protected void publishPoshiReport() {
        File[] poshiResultsDirs;
        BatchBuildData portalBatchBuildData = this.getBatchBuildData();
        File portalWebTestResultsDir = new File(this.getPrimaryPortalWorkspaceDirectory(), "portal-web/test-results");
        for (File poshiResultsDir : poshiResultsDirs = portalWebTestResultsDir.listFiles()) {
            String poshiResultsDirName = poshiResultsDir.getName();
            for (String test : ((BaseBatchBuildData)portalBatchBuildData).getTestList()) {
                if (!poshiResultsDirName.contains(test.replace('#', '_'))) continue;
                try {
                    JenkinsResultsParserUtil.copy(poshiResultsDir, new File(((BaseBuildData)((Object)portalBatchBuildData)).getArtifactDir(), poshiResultsDirName));
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((PortalBatchBuildData)portalBatchBuildData).getPortalBranchSHA());
        sb.append(" - ");
        sb.append(((BaseBatchBuildData)portalBatchBuildData).getBatchName());
        sb.append(" - ");
        sb.append("<a href=\"https://");
        sb.append(((BaseBatchBuildData)portalBatchBuildData).getTopLevelMasterHostname());
        sb.append(".liferay.com/userContent/");
        sb.append(((BaseBuildData)((Object)portalBatchBuildData)).getUserContentRelativePath());
        sb.append("jenkins-report.html\">Jenkins Report</a>");
        sb.append("<ul>");
        for (String test : ((BaseBatchBuildData)portalBatchBuildData).getTestList()) {
            String testName = test.replace('#', '_');
            if (!testName.matches("[^\\.]+\\.[^_]+_.+")) {
                testName = "LocalFile." + testName;
            }
            String poshiReportBaseURL = JenkinsResultsParserUtil.combine("https://", ((BaseBatchBuildData)portalBatchBuildData).getTopLevelMasterHostname(), ".liferay.com/userContent/", ((BaseBuildData)((Object)portalBatchBuildData)).getUserContentRelativePath(), ((BaseBuildData)((Object)portalBatchBuildData)).getRunID(), "/", testName);
            sb.append("<li>");
            sb.append(test);
            sb.append(" - <a href=\"");
            sb.append(poshiReportBaseURL);
            sb.append("/index.html\">index.html</a>");
            sb.append(" - <a href=\"");
            sb.append(poshiReportBaseURL);
            sb.append("/summary.html\">summary.html</a>");
            sb.append(" - <a href=\"");
            sb.append(poshiReportBaseURL);
            sb.append("/console.txt\">console.txt</a>");
        }
        sb.append("</ul>");
        ((BaseBuildData)((Object)portalBatchBuildData)).setBuildDescription(sb.toString());
    }
}

