/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.CISystemHistoryReportUtil;
import com.liferay.jenkins.results.parser.CISystemStatusReportUtil;
import com.liferay.jenkins.results.parser.CloudStorageSyncUtil;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.metrics.BuildHistoryProcessor;
import com.liferay.jenkins.results.parser.metrics.BuildHistoryReport;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import com.liferay.jenkins.results.parser.testray.TestrayS3Object;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class GenerateReportsBuildRunner
extends BaseBuildRunner<BuildData> {
    private static final String _ARCHIVE_BASE_DIR_PATH = GenerateReportsBuildRunner._getBuildProperty("google.cloud.bucket.local.dir[jenkins]");
    private static final String _CURRENT_DATE_STRING;
    private static final String _LINK_ELEMENT_REGEX = "(?<linkElement><link.*href=\\\"(?<hrefValue>.*?)\\\".*\\/>)";
    private static final String _REPORT_RSYNC_DESTINATION_DIR_PATH = "/opt/java/jenkins/userContent/reports/";
    private static final String _SCRIPT_ELEMENT_REGEX = "(?<scriptElement><script.*src=\\\"(?<srcValue>.*?)\\\".*<\\/script>)";
    private static final String _TMP_BASE_DIR_PATH;
    private static final DateTimeFormatter _dateTimeFormatter;
    private static final Pattern _linkElementPattern;
    private static final Map<String, String> _reportDirNames;
    private static final Pattern _scriptElementPattern;
    private static final List<String> _validReportNames;
    private Workspace _workspace;

    @Override
    public Workspace getWorkspace() {
        if (this._workspace != null) {
            return this._workspace;
        }
        this._workspace = WorkspaceFactory.newWorkspace();
        return this._workspace;
    }

    @Override
    public void run() {
        this._validateBuildParameters();
        this._generateReports();
    }

    @Override
    public void tearDown() {
        try {
            FileUtils.deleteDirectory((File)new File(_TMP_BASE_DIR_PATH));
        }
        catch (IOException ioException) {
            System.out.println("Unable to delete directory: " + _TMP_BASE_DIR_PATH);
        }
        try {
            this._deleteStaleTestrayBuildReportJSONFiles();
        }
        catch (IOException | TimeoutException exception) {
            System.out.println("Unable to delete stale build-report.json files");
        }
        super.tearDown();
    }

    protected GenerateReportsBuildRunner(BuildData buildData) {
        super(buildData);
    }

    protected String getBuildParameter(String key) {
        Object buildData = this.getBuildData();
        return buildData.getBuildParameter(key);
    }

    private static String _getBuildProperty(String propertyName) {
        try {
            return JenkinsResultsParserUtil.getBuildProperty(propertyName);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _archiveReport(String filePath) {
        this._mergeHTMLFiles(filePath);
        JenkinsResultsParserUtil.rsync("test-1-0", "/opt/java/jenkins/userContent/reports/archived-reports/" + _CURRENT_DATE_STRING, null, filePath);
        JenkinsResultsParserUtil.rsync(null, _ARCHIVE_BASE_DIR_PATH + "/reports/" + _CURRENT_DATE_STRING, null, filePath);
        CloudStorageSyncUtil.syncGCPFiles(_ARCHIVE_BASE_DIR_PATH + "/reports", "gs://jenkins-ci-data/reports");
    }

    private void _copyArchivedBuildData(long durationDays, String startDateString) {
        String[] dateStrings = JenkinsResultsParserUtil.getDateStrings(durationDays, LocalDate.parse(startDateString, _dateTimeFormatter));
        final File archivedDataDir = new File(_ARCHIVE_BASE_DIR_PATH + "/data");
        ArrayList callables = new ArrayList();
        for (final String dateString : dateStrings) {
            callables.add(new Callable<Void>(){

                @Override
                public Void call() {
                    File archiveFile = new File(archivedDataDir, dateString + ".tar.gz");
                    File unarchivedDir = new File(_TMP_BASE_DIR_PATH, "/builds/" + dateString);
                    if (archiveFile.exists() && !unarchivedDir.exists()) {
                        System.out.println("Extracting " + archiveFile + " to " + unarchivedDir);
                        JenkinsResultsParserUtil.unTarGzip(archiveFile, unarchivedDir);
                    }
                    return null;
                }
            });
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, BuildHistoryProcessor.getExecutorService(), "_copyArchivedBuildData");
        try {
            parallelExecutor.execute();
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    private void _copyArchivedNodeData(long durationDays, String startDateString) throws IOException {
        String[] dateStrings = JenkinsResultsParserUtil.getDateStrings(durationDays, LocalDate.parse(startDateString, _dateTimeFormatter));
        File dataArchiveDir = new File(GenerateReportsBuildRunner._getBuildProperty("google.cloud.bucket.local.dir[jenkins]"), "data");
        File baseArchiveDir = dataArchiveDir.getParentFile();
        for (String dateString : dateStrings) {
            File nodeDataArchiveFile = new File(baseArchiveDir, "reports/" + dateString + "/node.json");
            File nodeDataFile = new File(_TMP_BASE_DIR_PATH + "/nodes/" + dateString, "node.json");
            if (!nodeDataArchiveFile.exists()) continue;
            FileUtils.copyFile((File)nodeDataArchiveFile, (File)nodeDataFile);
        }
    }

    private void _deleteEmptyDirs(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            this._deleteEmptyDirs(file);
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            boolean deleted = dir.delete();
            if (deleted) {
                System.out.println("Deleted empty directory: " + dir.getAbsolutePath());
            } else {
                System.out.println("Unable to delete empty directory: " + dir.getAbsolutePath());
            }
        }
    }

    private void _deleteStaleTestrayBuildReportJSONFiles() throws IOException, TimeoutException {
        File testrayResultsBucketLocalDir = new File(GenerateReportsBuildRunner._getBuildProperty("google.cloud.bucket.local.dir[testray]"));
        List<File> buildReportFiles = JenkinsResultsParserUtil.findFiles(testrayResultsBucketLocalDir, Pattern.quote("build-report.json"));
        for (File buildReportFile : buildReportFiles) {
            long millisSinceLastModification = System.currentTimeMillis() - buildReportFile.lastModified();
            if (millisSinceLastModification <= TimeUnit.DAYS.toMillis(60L) || buildReportFile.delete()) continue;
            throw new RuntimeException("Unable to delete file " + buildReportFile);
        }
        this._deleteEmptyDirs(testrayResultsBucketLocalDir);
    }

    private void _downloadTestrayBuildReportJSONFiles() {
        LocalDate currentLocalDate = LocalDate.now();
        String currentMonthString = currentLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        String startMonthString = null;
        LocalDate startLocalDate = currentLocalDate.minusDays(15L);
        if (currentLocalDate.getMonth() != startLocalDate.getMonth()) {
            startMonthString = startLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        }
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        ArrayList<String> keys = new ArrayList<String>();
        String jobName = "test-portal-acceptance-pullrequest(master)";
        for (int i = 1; i <= 40; ++i) {
            String jenkinsMasterName = "test-1-" + i;
            keys.addAll(this._getTestrayBucketBuildReportJSONFilePaths(currentMonthString, jenkinsMasterName, jobName));
            if (startMonthString == null) continue;
            keys.addAll(this._getTestrayBucketBuildReportJSONFilePaths(startMonthString, jenkinsMasterName, jobName));
        }
        try {
            File testrayResultsBucketLocalDir = new File(GenerateReportsBuildRunner._getBuildProperty("google.cloud.bucket.local.dir[testray]"));
            testrayS3Bucket.downloadTestrayS3Objects(testrayResultsBucketLocalDir, keys);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    private void _generateBuildHistoryReport(String reportName) throws IOException {
        long reportDurationDays = this._getReportDurationDays(reportName);
        String startDateString = this._getStartDateString(reportName);
        this._copyArchivedBuildData(reportDurationDays, startDateString);
        String filePath = this._getReportFilePath(reportName);
        BuildHistoryReport aggregateBuildHistoryReport = BuildHistoryReport.newAggregateReport(reportDurationDays, new File(filePath), startDateString);
        aggregateBuildHistoryReport.write();
        this._updateReport(filePath);
        this._archiveReport(filePath);
    }

    private void _generateCISystemHistoryReport(String reportName) throws IOException {
        String filePath = this._getReportFilePath(reportName);
        this._downloadTestrayBuildReportJSONFiles();
        CISystemHistoryReportUtil.generateCISystemHistoryReport(filePath, GenerateReportsBuildRunner._getBuildProperty("ci.system.history.report.job.name"), GenerateReportsBuildRunner._getBuildProperty("ci.system.history.report.test.suite.name"));
        this._updateReport(filePath);
    }

    private void _generateCISystemStatusReport(String reportName) throws IOException {
        String filePath = this._getReportFilePath(reportName);
        CISystemStatusReportUtil.copyBaseReportFiles(filePath);
        Files.deleteIfExists(Paths.get(filePath, "js/testray-data.js"));
        long reportDurationDays = this._getReportDurationDays(reportName);
        this._copyArchivedNodeData(this._getReportDurationDays(reportName), this._getStartDateString(reportDurationDays - 1L));
        CISystemStatusReportUtil.writeJenkinsDataJavaScriptFile(filePath + "/js/jenkins-data.js");
        String testrayDataFilepath = null;
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(30000L, JenkinsResultsParserUtil.combine("ssh test-1-0 'find ", _REPORT_RSYNC_DESTINATION_DIR_PATH, this._getReportDirName(Report.CI_SYSTEM_STATUS.toString()), "/js -name testray-data.js -mmin +60'"));
            testrayDataFilepath = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
        }
        catch (IOException | TimeoutException exception) {
            System.out.println("Unable to get age of testray-data.js");
        }
        if (testrayDataFilepath != null && testrayDataFilepath.contains("testray-data.js")) {
            this._downloadTestrayBuildReportJSONFiles();
            CISystemStatusReportUtil.writeTestrayDataJavaScriptFile(filePath + "/js/testray-data.js", GenerateReportsBuildRunner._getBuildProperty("ci.system.status.report.job.name"), GenerateReportsBuildRunner._getBuildProperty("ci.system.status.report.test.suite.name"));
        }
        this._updateReport(filePath);
        this._updateNodeDataFile(filePath);
        this._archiveReport(filePath);
    }

    private void _generatePullRequestReport(String reportName) throws IOException {
        long reportDurationDays = this._getReportDurationDays(reportName);
        String startDateString = this._getStartDateString(reportName);
        this._copyArchivedBuildData(reportDurationDays, startDateString);
        String filePath = this._getReportFilePath(reportName);
        BuildHistoryReport testSuiteBuildHistoryReport = BuildHistoryReport.newPullRequestTestSuiteReport(reportDurationDays, new File(filePath), startDateString);
        testSuiteBuildHistoryReport.write();
        this._updateReport(filePath);
        this._archiveReport(filePath);
    }

    private void _generateReleaseReport(String reportName) throws IOException {
        long reportDurationDays = this._getReportDurationDays(reportName);
        String startDateString = this._getStartDateString(reportName);
        this._copyArchivedBuildData(reportDurationDays, startDateString);
        String filePath = this._getReportFilePath(reportName);
        BuildHistoryReport testSuiteBuildHistoryReport = BuildHistoryReport.newReleaseTestSuiteReport(reportDurationDays, new File(filePath), startDateString);
        testSuiteBuildHistoryReport.write();
        this._updateReport(filePath);
        this._archiveReport(filePath);
    }

    private void _generateReports() {
        String[] reportNames = this._getReportNames();
        if (reportNames == null) {
            return;
        }
        CloudStorageSyncUtil.syncGCPFiles("gs://jenkins-ci-data/reports", _ARCHIVE_BASE_DIR_PATH + "/reports");
        StringBuilder sb = new StringBuilder();
        for (String reportName : reportNames) {
            block10: {
                try {
                    if (reportName.equals(Report.BUILD_HISTORY.toString())) {
                        this._generateBuildHistoryReport(reportName);
                    }
                    if (reportName.equals(Report.CI_SYSTEM_HISTORY.toString())) {
                        this._generateCISystemHistoryReport(reportName);
                    }
                    if (reportName.equals(Report.CI_SYSTEM_STATUS.toString())) {
                        this._generateCISystemStatusReport(reportName);
                    }
                    if (reportName.equals(Report.PULL_REQUEST_HISTORY.toString())) {
                        this._generatePullRequestReport(reportName);
                    }
                    if (reportName.equals(Report.RELEASE_HISTORY.toString())) {
                        this._generateReleaseReport(reportName);
                    }
                    if (reportName.equals(Report.UPSTREAM_HISTORY.toString())) {
                        this._generateUpstreamReport(reportName);
                    }
                    if (!reportName.equals(Report.UTILIZATION.toString())) break block10;
                    this._generateUtilizationReport(reportName);
                }
                catch (IOException ioException) {
                    System.out.println("Unable to write " + reportName + " to " + this._getReportFilePath(reportName));
                    Object buildData = this.getBuildData();
                    NotificationUtil.sendSlackNotification(buildData.getBuildURL() + " <@U04GTH03Q>", "ci-notifications", "Unable to generate " + reportName + " report");
                    continue;
                }
            }
            sb.append("<a href=\"");
            sb.append("http://test-1-0.liferay.com/userContent/reports/");
            sb.append(this._getReportDirName(reportName));
            sb.append("/index.html\">");
            sb.append(reportName);
            sb.append(" Report</a><br />");
        }
        Object buildData = this.getBuildData();
        buildData.setBuildDescription(sb.toString());
        this.updateBuildDescription();
    }

    private void _generateUpstreamReport(String reportName) throws IOException {
        long reportDurationDays = this._getReportDurationDays(reportName);
        String startDateString = this._getStartDateString(reportName);
        this._copyArchivedBuildData(reportDurationDays, startDateString);
        String filePath = this._getReportFilePath(reportName);
        BuildHistoryReport testSuiteBuildHistoryReport = BuildHistoryReport.newUpstreamTestSuiteReport(reportDurationDays, new File(filePath), startDateString);
        testSuiteBuildHistoryReport.write();
        this._updateReport(filePath);
        this._archiveReport(filePath);
    }

    private void _generateUtilizationReport(String reportName) throws IOException {
        String startDateString = this._getStartDateString(reportName);
        LocalDate localDate = LocalDate.parse(startDateString, _dateTimeFormatter);
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        while (dayOfWeek.getValue() != 1) {
            localDate = localDate.minusDays(1L);
            dayOfWeek = localDate.getDayOfWeek();
        }
        startDateString = localDate.format(_dateTimeFormatter);
        long reportDurationDays = this._getReportDurationDays(reportName);
        this._copyArchivedBuildData(reportDurationDays, startDateString);
        String filePath = this._getReportFilePath(reportName);
        BuildHistoryReport utilizationReport = BuildHistoryReport.newUtilizationReport(reportDurationDays, new File(filePath), startDateString);
        utilizationReport.write();
        this._updateReport(filePath);
        this._archiveReport(filePath);
    }

    private String _getReportDirName(String reportName) {
        return _reportDirNames.get(reportName);
    }

    private long _getReportDurationDays(String reportName) {
        String reportDurationDays = GenerateReportsBuildRunner._getBuildProperty(JenkinsResultsParserUtil.combine("report.duration.days[", reportName, "]"));
        if (reportDurationDays == null) {
            reportDurationDays = GenerateReportsBuildRunner._getBuildProperty("report.duration.days");
        }
        return Long.parseLong(reportDurationDays);
    }

    private String _getReportFilePath(String reportName) {
        return _TMP_BASE_DIR_PATH + "/reports/" + this._getReportDirName(reportName);
    }

    private String[] _getReportNames() {
        String buildParameter = this.getBuildParameter("REPORT_NAMES");
        if (buildParameter == null) {
            return null;
        }
        return buildParameter.split("\\s*,\\s*");
    }

    private String _getStartDateString(long daysAgo) {
        LocalDate localDate = LocalDate.parse(_CURRENT_DATE_STRING, _dateTimeFormatter);
        localDate = localDate.minusDays(daysAgo);
        return localDate.format(_dateTimeFormatter);
    }

    private String _getStartDateString(String reportName) {
        return this._getStartDateString(this._getReportDurationDays(reportName));
    }

    private List<String> _getTestrayBucketBuildReportJSONFilePaths(String monthString, String jenkinsMasterName, String jobName) {
        ArrayList<String> filePaths = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(monthString);
        sb.append("/");
        sb.append(jenkinsMasterName);
        sb.append("/");
        sb.append(jobName);
        sb.append("/");
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        for (TestrayS3Object testrayS3Object : testrayS3Bucket.getTestrayS3Objects(sb.toString())) {
            String filePath = testrayS3Object.getKey() + "build-report.json.gz";
            filePaths.add(filePath);
        }
        return filePaths;
    }

    private void _mergeHTMLFiles(String reportDirPath) {
        File reportDir = new File(reportDirPath);
        File reportFile = new File(reportDir, "index.html");
        if (!reportFile.exists()) {
            return;
        }
        try {
            String reportFileContent;
            String newReportFileContent = reportFileContent = JenkinsResultsParserUtil.read(reportFile);
            for (String line : reportFileContent.split("\n")) {
                File cssFile;
                String hrefValue;
                Matcher matcher = _scriptElementPattern.matcher(line);
                if (matcher.find()) {
                    File javaScriptFile;
                    String srcValue = matcher.group("srcValue");
                    if (srcValue.startsWith("http://") || srcValue.startsWith("https://") || !(javaScriptFile = new File(reportDir, srcValue)).exists()) continue;
                    String scriptElementContent = "<script>" + JenkinsResultsParserUtil.read(javaScriptFile) + "</script>";
                    newReportFileContent = newReportFileContent.replace(line, scriptElementContent);
                    javaScriptFile.delete();
                    continue;
                }
                matcher = _linkElementPattern.matcher(line);
                if (!matcher.find() || (hrefValue = matcher.group("hrefValue")).startsWith("http://") || hrefValue.startsWith("https://") || !(cssFile = new File(reportDir, hrefValue)).exists()) continue;
                String styleElementContent = "<style>" + JenkinsResultsParserUtil.read(cssFile) + "</style>";
                newReportFileContent = newReportFileContent.replace(line, styleElementContent);
                cssFile.delete();
            }
            if (!reportFileContent.equals(newReportFileContent)) {
                JenkinsResultsParserUtil.write(reportFile, newReportFileContent);
            }
        }
        catch (IOException ioException) {
            System.out.println("Unable to merge files in: " + reportDirPath);
            ioException.printStackTrace();
        }
    }

    private void _updateNodeDataFile(String filePath) throws IOException {
        File dataArchiveDir = new File(GenerateReportsBuildRunner._getBuildProperty("google.cloud.bucket.local.dir[jenkins]"), "data");
        File baseArchiveDir = dataArchiveDir.getParentFile();
        File nodeDataArchiveFile = new File(baseArchiveDir, "reports/" + _CURRENT_DATE_STRING + "/node.json");
        File nodeDataFile = new File(filePath, "node.json");
        if (nodeDataArchiveFile.exists()) {
            FileUtils.copyFile((File)nodeDataArchiveFile, (File)nodeDataFile);
        }
        JenkinsCohort jenkinsCohort = JenkinsCohort.getInstance("test-1");
        jenkinsCohort.writeNodeDataJSONFile(nodeDataFile.getPath());
        FileUtils.copyFile((File)nodeDataFile, (File)nodeDataArchiveFile);
        FileUtils.delete((File)nodeDataFile);
    }

    private void _updateReport(String filePath) {
        JenkinsResultsParserUtil.rsync("test-1-0", _REPORT_RSYNC_DESTINATION_DIR_PATH, null, filePath);
    }

    private void _validateBuildParameters() {
        String[] reportNames = this._getReportNames();
        if (reportNames == null) {
            throw new RuntimeException("REPORT_NAMES parameter must be set");
        }
        for (String reportName : reportNames) {
            if (_validReportNames.contains(reportName)) continue;
            throw new RuntimeException("REPORT_NAMES parameter contains invalid report type: " + reportName);
        }
    }

    static {
        _TMP_BASE_DIR_PATH = GenerateReportsBuildRunner._getBuildProperty("archive.ci.build.data.tmp.dir");
        _dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        _linkElementPattern = Pattern.compile(_LINK_ELEMENT_REGEX);
        _reportDirNames = new HashMap<String, String>(){
            {
                this.put(Report.BUILD_HISTORY.toString(), "build-history-report");
                this.put(Report.CI_SYSTEM_HISTORY.toString(), "ci-system-history");
                this.put(Report.CI_SYSTEM_STATUS.toString(), "ci-system-status");
                this.put(Report.PULL_REQUEST_HISTORY.toString(), "pull-request-report");
                this.put(Report.RELEASE_HISTORY.toString(), "release-report");
                this.put(Report.UPSTREAM_HISTORY.toString(), "upstream-report");
                this.put(Report.UTILIZATION.toString(), "utilization-report");
            }
        };
        _scriptElementPattern = Pattern.compile(_SCRIPT_ELEMENT_REGEX);
        _validReportNames = Arrays.asList(Report.BUILD_HISTORY.toString(), Report.CI_SYSTEM_HISTORY.toString(), Report.CI_SYSTEM_STATUS.toString(), Report.PULL_REQUEST_HISTORY.toString(), Report.RELEASE_HISTORY.toString(), Report.UPSTREAM_HISTORY.toString(), Report.UTILIZATION.toString());
        Instant instant = Instant.now();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        _CURRENT_DATE_STRING = zonedDateTime.format(_dateTimeFormatter);
    }

    public static enum Report {
        BUILD_HISTORY("Build History"),
        CI_SYSTEM_HISTORY("CI System History"),
        CI_SYSTEM_STATUS("CI System Status"),
        PULL_REQUEST_HISTORY("Pull Request History"),
        RELEASE_HISTORY("Release History"),
        UPSTREAM_HISTORY("Upstream History"),
        UTILIZATION("Utilization");

        private final String _string;

        public String getDirName() {
            return (String)_reportDirNames.get(this._string);
        }

        public String toString() {
            return this._string;
        }

        private Report(String string2) {
            this._string = string2;
        }
    }
}

