/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.GenerateReportsBuildRunner;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class GenerateReportsControllerBuildRunner
extends BaseBuildRunner<BuildData> {
    private static final long _DEFAULT_REPORT_STALE_DURATION = 86400000L;
    private List<String> _selectedReportNames;
    private Workspace _workspace;

    @Override
    public Workspace getWorkspace() {
        if (this._workspace != null) {
            return this._workspace;
        }
        this._workspace = WorkspaceFactory.newWorkspace();
        return this._workspace;
    }

    @Override
    public void run() {
        this.invokeGenerateReportsBuild();
    }

    @Override
    public void tearDown() {
    }

    protected GenerateReportsControllerBuildRunner(BuildData buildData) {
        super(buildData);
    }

    protected void invokeGenerateReportsBuild() {
        List<String> reportNames = this._getSelectedReportNames();
        if (reportNames.isEmpty()) {
            System.out.println("There are no reports to create at this time.");
            this.keepJenkinsBuild(false);
            return;
        }
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        StringBuilder sb = new StringBuilder();
        String jenkinsMasterName = buildProperties.getProperty("report.generate.reports.jenkins.master");
        String jobURL = "http://" + jenkinsMasterName + "/job/generate-reports";
        sb.append(jobURL);
        sb.append("/buildWithParameters?token=");
        sb.append(buildProperties.getProperty("jenkins.authentication.token"));
        HashMap<String, String> invocationParameters = new HashMap<String, String>();
        Object buildData = this.getBuildData();
        invocationParameters.put("JENKINS_GITHUB_URL", buildData.getJenkinsGitHubURL());
        Collections.sort(reportNames);
        invocationParameters.put("REPORT_NAMES", String.join((CharSequence)",", reportNames));
        for (Map.Entry invocationParameter : invocationParameters.entrySet()) {
            String invocationParameterValue = (String)invocationParameter.getValue();
            if (JenkinsResultsParserUtil.isNullOrEmpty(invocationParameterValue)) continue;
            sb.append("&");
            sb.append((String)invocationParameter.getKey());
            sb.append("=");
            sb.append(invocationParameterValue);
        }
        try {
            JenkinsResultsParserUtil.toString(sb.toString());
            System.out.println("The following reports will be generated at: " + jobURL);
            for (String reportName : reportNames) {
                System.out.println(reportName);
            }
        }
        catch (IOException ioException) {
            System.out.println("Unable to invoke a new build to generate reports");
            ioException.printStackTrace();
        }
        this._updateBuildDescription(reportNames);
    }

    private String _getBuildDescription(Build build) {
        String buildDescription = build.getBuildDescription();
        if (buildDescription == null) {
            return "";
        }
        return buildDescription;
    }

    private List<Build> _getBuildHistory() {
        Object buildData = this.getBuildData();
        Build build = BuildFactory.newBuild(buildData.getBuildURL(), null);
        Job job = JobFactory.newJob(buildData.getJobName());
        return job.getBuildHistory(build.getJenkinsMaster());
    }

    private Map<String, Long> _getLatestReportUpdateTimes() {
        String reportName;
        HashMap<String, Long> latestReportUpdateTimes = new HashMap<String, Long>();
        List<Build> builds = this._getBuildHistory();
        Object buildData = this.getBuildData();
        Build currentBuild = BuildFactory.newBuild(buildData.getBuildURL(), null);
        builds.remove(currentBuild);
        block0: for (GenerateReportsBuildRunner.Report report : GenerateReportsBuildRunner.Report.values()) {
            reportName = report.toString();
            for (Build build : builds) {
                String buildDescription = this._getBuildDescription(build);
                if (!buildDescription.contains(reportName)) continue;
                latestReportUpdateTimes.put(reportName, build.getStartTime());
                continue block0;
            }
        }
        for (GenerateReportsBuildRunner.Report report : GenerateReportsBuildRunner.Report.values()) {
            reportName = report.toString();
            long defaultStartTime = buildData.getStartTime() - this._getReportStaleDuration(reportName);
            if (latestReportUpdateTimes.containsKey(reportName)) continue;
            latestReportUpdateTimes.put(reportName, defaultStartTime);
        }
        return latestReportUpdateTimes;
    }

    private long _getReportStaleDuration(String reportName) {
        Properties buildProperties;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String reportStaleDuration = buildProperties.getProperty(JenkinsResultsParserUtil.combine("report.stale.duration[", reportName, "]"));
        if (reportStaleDuration == null) {
            return 86400000L;
        }
        return TimeUnit.MINUTES.toMillis(Long.parseLong(reportStaleDuration));
    }

    private List<String> _getSelectedReportNames() {
        if (this._selectedReportNames != null) {
            return this._selectedReportNames;
        }
        this._selectedReportNames = new ArrayList<String>();
        Map<String, Long> latestReportUpdateTimes = this._getLatestReportUpdateTimes();
        Object buildData = this.getBuildData();
        long startTime = buildData.getStartTime();
        for (Map.Entry<String, Long> entry : latestReportUpdateTimes.entrySet()) {
            String reportName = entry.getKey();
            long reportStaleDuration = startTime - entry.getValue();
            if (reportStaleDuration < this._getReportStaleDuration(reportName)) continue;
            System.out.println(JenkinsResultsParserUtil.combine(reportName, " was last generated ", JenkinsResultsParserUtil.toDurationString(reportStaleDuration), " ago which exceeds the stale duration of ", JenkinsResultsParserUtil.toDurationString(this._getReportStaleDuration(reportName))));
            this._selectedReportNames.add(reportName);
        }
        return this._selectedReportNames;
    }

    private void _updateBuildDescription(List<String> reportNames) {
        StringBuilder sb = new StringBuilder();
        for (String reportName : reportNames) {
            sb.append(reportName);
            sb.append(" - ");
        }
        sb.setLength(sb.length() - 3);
        Object buildData = this.getBuildData();
        buildData.setBuildDescription(sb.toString());
        this.updateBuildDescription();
    }
}

