/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GenerateTestrayCSVUtil {
    private static final String _CSV_DELIMITER = ",";

    public static void generate(String projectBuildDir, long projectTestrayBuildId, URL testrayServerURL) {
        if (testrayServerURL == null) {
            try {
                testrayServerURL = new URL(JenkinsResultsParserUtil.getBuildProperty("testray.server.url"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        TestrayServer testrayServer = TestrayFactory.newTestrayServer(String.valueOf(testrayServerURL));
        TestrayBuild testrayBuild = testrayServer.getTestrayBuildByID(projectTestrayBuildId);
        System.out.println("Generating Testray CSV.");
        StringBuilder sb = new StringBuilder();
        sb.append(JenkinsResultsParserUtil.join(_CSV_DELIMITER, "Case Name", "Case History URL", "Failure Type", "Error Message"));
        sb.append("\n");
        ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
        for (TestrayCaseResult testrayCaseResult : testrayBuild.getTestrayCaseResults()) {
            if (testrayCaseResult.getStatus() != TestrayCaseResult.Status.FAILED || Objects.equals(testrayCaseResult.getName(), "Top Level Build")) continue;
            testrayCaseResults.add(testrayCaseResult);
        }
        if (testrayCaseResults.isEmpty()) {
            System.out.println(JenkinsResultsParserUtil.combine("There are no Testray case results to report. Testray may ", "not have imported the results yet or the results ", "contained no failures."));
            return;
        }
        sb.append(GenerateTestrayCSVUtil._generate(testrayCaseResults, TestrayCaseResult.ErrorType.UNIQUE));
        sb.append("\n");
        sb.append(GenerateTestrayCSVUtil._generate(testrayCaseResults, TestrayCaseResult.ErrorType.DID_NOT_RUN));
        sb.append("\n");
        sb.append(GenerateTestrayCSVUtil._generate(testrayCaseResults, TestrayCaseResult.ErrorType.COMMON));
        try {
            System.out.println("Setting testray results to: " + sb.toString());
            JenkinsResultsParserUtil.write(new File(projectBuildDir, JenkinsResultsParserUtil.combine("testray-results-", String.valueOf(testrayBuild.getID()), ".csv")), sb.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static void generate(String projectBuildDir, String projectTestrayBuildId) {
        GenerateTestrayCSVUtil.generate(projectBuildDir, Long.valueOf(projectTestrayBuildId), null);
    }

    private static String _cleanCSVData(String string) {
        return string.replace(_CSV_DELIMITER, ".");
    }

    private static String _generate(List<TestrayCaseResult> testrayCaseResults, TestrayCaseResult.ErrorType testrayCaseResultErrorType) {
        System.out.println("Parsing Testray case results for " + testrayCaseResultErrorType.toString() + ".");
        StringBuilder sb = new StringBuilder();
        for (TestrayCaseResult testrayCaseResult : testrayCaseResults) {
            if (testrayCaseResult.getErrorType() != testrayCaseResultErrorType) continue;
            sb.append(GenerateTestrayCSVUtil._generateCSV(testrayCaseResult, testrayCaseResultErrorType));
            sb.append("\n");
        }
        if (sb.length() == 0) {
            sb.append(JenkinsResultsParserUtil.join(_CSV_DELIMITER, "NONE", "N/A", testrayCaseResultErrorType.toString(), "N/A"));
            sb.append("\n");
        }
        return JenkinsResultsParserUtil.combine(testrayCaseResultErrorType.toString(), " Failures\n", sb.toString());
    }

    private static String _generateCSV(TestrayCaseResult testrayCaseResult, TestrayCaseResult.ErrorType testrayCaseResultType) {
        return JenkinsResultsParserUtil.join(_CSV_DELIMITER, GenerateTestrayCSVUtil._cleanCSVData(testrayCaseResult.getName()), GenerateTestrayCSVUtil._cleanCSVData(String.valueOf(testrayCaseResult.getHistoryURL())), GenerateTestrayCSVUtil._cleanCSVData(String.valueOf((Object)testrayCaseResultType)), GenerateTestrayCSVUtil._cleanCSVData(testrayCaseResult.getErrors()));
    }
}

