/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.DefaultLocalGitCommit;
import com.liferay.jenkins.results.parser.GitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitCommit;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class GitCommitFactory {
    private static final Map<String, GitHubRemoteGitCommit> _gitHubRemoteGitCommits = new HashMap<String, GitHubRemoteGitCommit>();

    public static GitHubRemoteGitCommit newGitHubRemoteGitCommit(String gitHubUsername, String gitRepositoryName, String sha) {
        String gitHubCommitURL = GitCommitFactory._getGitHubCommitURL(gitHubUsername, gitRepositoryName, sha);
        if (_gitHubRemoteGitCommits.containsKey(gitHubCommitURL)) {
            return _gitHubRemoteGitCommits.get(gitHubCommitURL);
        }
        try {
            return GitCommitFactory.newGitHubRemoteGitCommit(gitHubUsername, gitRepositoryName, sha, JenkinsResultsParserUtil.toJSONObject(gitHubCommitURL));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get commit details", ioException);
        }
    }

    public static GitHubRemoteGitCommit newGitHubRemoteGitCommit(String gitHubUsername, String gitRepositoryName, String sha, JSONObject jsonObject) {
        JSONObject commitJSONObject = jsonObject.getJSONObject("commit");
        String message = commitJSONObject.getString("message");
        JSONObject committerJSONObject = commitJSONObject.getJSONObject("committer");
        JSONArray filesJSONArray = jsonObject.optJSONArray("files");
        ArrayList<String> fileNames = null;
        if (filesJSONArray != null) {
            fileNames = new ArrayList<String>(filesJSONArray.length());
            for (int i = 0; i < filesJSONArray.length(); ++i) {
                JSONObject fileJSONObject = filesJSONArray.getJSONObject(i);
                fileNames.add(fileJSONObject.getString("filename"));
            }
        }
        try {
            DateFormat gitHubDateFormat = JenkinsResultsParserUtil.getGitHubDateFormat();
            Date date = gitHubDateFormat.parse(committerJSONObject.getString("date"));
            GitHubRemoteGitCommit remoteGitCommit = new GitHubRemoteGitCommit(committerJSONObject.getString("email"), gitHubUsername, gitRepositoryName, message, fileNames, jsonObject.getString("sha"), GitCommitFactory._getGitCommitType(message), date.getTime());
            _gitHubRemoteGitCommits.put(jsonObject.getString("url"), remoteGitCommit);
            return remoteGitCommit;
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static LocalGitCommit newLocalGitCommit(String emailAddress, GitWorkingDirectory gitWorkingDirectory, String message, String sha, long commitTime) {
        return new DefaultLocalGitCommit(emailAddress, gitWorkingDirectory, message, sha, GitCommitFactory._getGitCommitType(message), commitTime);
    }

    private static GitCommit.Type _getGitCommitType(String message) {
        if (message.startsWith("archive:ignore")) {
            return GitCommit.Type.LEGACY_ARCHIVE;
        }
        return GitCommit.Type.MANUAL;
    }

    private static String _getGitHubCommitURL(String gitHubUsername, String gitRepositoryName, String sha) {
        return JenkinsResultsParserUtil.getGitHubApiUrl(gitRepositoryName, gitHubUsername, "commits/" + sha);
    }
}

