/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitHubDevSyncUtil {
    protected static List<String> gitHubDevNodeHostnames;
    private static final long _MILLIS_BRANCH_EXPIRATION = 172800000L;
    private static final long _MILLIS_BRANCH_UPDATE_AGE = 86400000L;
    private static final Pattern _cacheBranchPattern;
    private static final Pattern _lockedCacheBranchPattern;
    private static final ThreadPoolExecutor _threadPoolExecutor;

    public static void clone(String repositoryName, File workingDirectory) {
        ArrayList<String> usedGitHubDevRemoteHostnames = new ArrayList<String>();
        String gitHubDevRemoteHostname = JenkinsResultsParserUtil.getRandomGitHubDevNodeHostname(usedGitHubDevRemoteHostnames);
        usedGitHubDevRemoteHostnames.add(gitHubDevRemoteHostname);
        String gitHubDevRemoteURL = JenkinsResultsParserUtil.combine("git@", gitHubDevRemoteHostname, ":liferay/", repositoryName);
        try {
            GitUtil.clone(gitHubDevRemoteURL, workingDirectory);
        }
        catch (Exception exception) {
            String message = JenkinsResultsParserUtil.combine("Unable to clone ", repositoryName, " from ", gitHubDevRemoteURL, ".");
            if (usedGitHubDevRemoteHostnames.size() == 3) {
                throw new RuntimeException(message, exception);
            }
            System.out.println("Retrying: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteGitBranch fetchCacheBranchFromGitHubDev(GitWorkingDirectory gitWorkingDirectory, String cacheBranchName) {
        List<GitRemote> gitHubDevGitRemotes = GitHubDevSyncUtil.getGitHubDevGitRemotes(gitWorkingDirectory);
        try {
            RemoteGitBranch remoteGitBranch = GitHubDevSyncUtil._fetchCacheBranchFromGitHubDev(gitWorkingDirectory, cacheBranchName, GitHubDevSyncUtil.getGitRemotesWithBranch(cacheBranchName, gitHubDevGitRemotes, gitWorkingDirectory));
            return remoteGitBranch;
        }
        finally {
            gitWorkingDirectory.removeGitRemotes(gitHubDevGitRemotes);
        }
    }

    public static String getCacheBranchName(PullRequest pullRequest) {
        return GitHubDevSyncUtil.getCacheBranchName(pullRequest.getReceiverUsername(), pullRequest.getSenderUsername(), pullRequest.getSenderSHA(), pullRequest.getUpstreamBranchSHA());
    }

    public static String getCacheBranchName(RemoteGitRef remoteGitRef) {
        return GitHubDevSyncUtil.getCacheBranchName(remoteGitRef.getUsername(), remoteGitRef.getUsername(), remoteGitRef.getSHA(), remoteGitRef.getSHA());
    }

    public static List<GitRemote> getGitHubDevGitRemotes(GitWorkingDirectory gitWorkingDirectory) {
        List<String> gitHubDevRemoteURLs = GitHubDevSyncUtil.getGitHubDevRemoteURLs(gitWorkingDirectory);
        ArrayList<GitRemote> gitHubDevGitRemotes = new ArrayList<GitRemote>(gitHubDevRemoteURLs.size());
        for (String gitHubDevRemoteURL : gitHubDevRemoteURLs) {
            String gitHubDevRemoteName = "git-hub-dev-remote-" + gitHubDevRemoteURLs.indexOf(gitHubDevRemoteURL);
            GitRemote gitRemote = gitWorkingDirectory.getGitRemote(gitHubDevRemoteName);
            if (gitRemote == null || !gitHubDevRemoteURL.equals(gitRemote.getRemoteURL())) {
                gitRemote = gitWorkingDirectory.addGitRemote(true, gitHubDevRemoteName, gitHubDevRemoteURL);
            }
            gitHubDevGitRemotes.add(gitRemote);
        }
        return gitHubDevGitRemotes;
    }

    public static List<GitRemote> getGitRemotesWithBranch(final String branchName, List<GitRemote> gitRemotes, final GitWorkingDirectory gitWorkingDirectory) {
        ArrayList callables = new ArrayList(gitRemotes.size());
        for (final GitRemote gitRemote : gitRemotes) {
            SafeCallable<GitRemote> callable = new SafeCallable<GitRemote>(gitRemote.getHostname()){

                @Override
                public GitRemote safeCall() {
                    try {
                        if (gitWorkingDirectory.remoteGitBranchExists(branchName, gitRemote.getRemoteURL())) {
                            return gitRemote;
                        }
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, true, _threadPoolExecutor, "getGitRemotesWithBranch");
        try {
            return parallelExecutor.execute(300L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    public static String synchronizeToGitHubDev(GitWorkingDirectory gitWorkingDirectory, String receiverUsername, String senderBranchName, String senderUsername, String senderBranchSHA, String upstreamBranchSHA) {
        return GitHubDevSyncUtil.synchronizeToGitHubDev(gitWorkingDirectory, receiverUsername, 0, senderBranchName, senderUsername, senderBranchSHA, upstreamBranchSHA);
    }

    public static String synchronizeToGitHubDev(LocalGitBranch localGitBranch, WorkspaceGitRepository workspaceGitRepository) {
        return GitHubDevSyncUtil.synchronizeToGitHubDev(localGitBranch, workspaceGitRepository, 0);
    }

    public static boolean synchronizeUpstreamBranchToGitHubDev(GitWorkingDirectory gitWorkingDirectory, LocalGitBranch localGitBranch) {
        return GitHubDevSyncUtil.synchronizeUpstreamBranchToGitHubDev(gitWorkingDirectory, localGitBranch, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cacheBranch(GitWorkingDirectory gitWorkingDirectory, LocalGitBranch localGitBranch, String cacheBranchName, GitRemote gitRemote, long timestamp) {
        RemoteGitBranch lockRemoteGitBranch = null;
        try {
            lockRemoteGitBranch = gitWorkingDirectory.pushToRemoteGitRepository(true, localGitBranch, cacheBranchName + "-LOCK", gitRemote);
            gitWorkingDirectory.pushToRemoteGitRepository(true, localGitBranch, cacheBranchName, gitRemote);
            gitWorkingDirectory.pushToRemoteGitRepository(true, localGitBranch, JenkinsResultsParserUtil.combine(cacheBranchName, "-", String.valueOf(timestamp)), gitRemote);
            if (lockRemoteGitBranch != null) {
                gitWorkingDirectory.deleteRemoteGitBranch(lockRemoteGitBranch);
            }
        }
        catch (Throwable throwable) {
            if (lockRemoteGitBranch != null) {
                gitWorkingDirectory.deleteRemoteGitBranch(lockRemoteGitBranch);
            }
            throw throwable;
        }
    }

    protected static void cacheBranches(final GitWorkingDirectory gitWorkingDirectory, final LocalGitBranch localGitBranch, final String cacheBranchName, List<GitRemote> gitHubDevGitRemotes, final String upstreamUsername) {
        final long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        final RemoteGitBranch upstreamRemoteGitBranch = gitWorkingDirectory.getRemoteGitBranch(gitWorkingDirectory.getUpstreamBranchName(), gitWorkingDirectory.getGitRemote("upstream"), true);
        ArrayList callables = new ArrayList();
        for (final GitRemote gitHubDevGitRemote : gitHubDevGitRemotes) {
            SafeCallable<Object> callable = new SafeCallable<Object>(gitHubDevGitRemote.getHostname()){

                @Override
                public Object safeCall() {
                    GitHubDevSyncUtil.cacheBranch(gitWorkingDirectory, localGitBranch, cacheBranchName, gitHubDevGitRemote, start);
                    if (upstreamUsername.equals("liferay")) {
                        LocalGitBranch upstreamLocalGitBranch = gitWorkingDirectory.getLocalGitBranch(upstreamRemoteGitBranch.getName(), true);
                        gitWorkingDirectory.pushToRemoteGitRepository(true, upstreamLocalGitBranch, upstreamRemoteGitBranch.getName(), gitHubDevGitRemote);
                    }
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "cacheBranches");
        try {
            parallelExecutor.execute(3600L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println("Cache branches pushed up in " + JenkinsResultsParserUtil.toDurationString(duration));
    }

    protected static void checkoutUpstreamLocalGitBranch(GitWorkingDirectory gitWorkingDirectory, String upstreamBranchSHA) {
        LocalGitBranch upstreamLocalGitBranch = GitHubDevSyncUtil.updateUpstreamLocalGitBranch(gitWorkingDirectory, upstreamBranchSHA);
        if (upstreamLocalGitBranch != null) {
            gitWorkingDirectory.checkoutLocalGitBranch(upstreamLocalGitBranch);
        }
    }

    protected static void copyUpstreamRefsToHeads(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        File gitDir = gitWorkingDirectory.getGitDirectory();
        File headsDir = new File(gitDir, "refs/heads");
        File upstreamDir = new File(gitDir, "refs/remotes/upstream-temp");
        for (File file : upstreamDir.listFiles()) {
            System.out.println(JenkinsResultsParserUtil.combine("Copying ", headsDir.getPath(), " to ", upstreamDir.getPath()));
            JenkinsResultsParserUtil.copy(file, new File(headsDir, file.getName()));
        }
    }

    protected static void deleteCacheLocalGitBranches(String excludeBranchName, GitWorkingDirectory gitWorkingDirectory) {
        for (String localGitBranchName : gitWorkingDirectory.getLocalGitBranchNames()) {
            if (!localGitBranchName.matches(_cacheBranchPattern.pattern()) || localGitBranchName.equals(excludeBranchName)) continue;
            gitWorkingDirectory.deleteLocalGitBranch(localGitBranchName);
        }
    }

    protected static void deleteCacheRemoteGitBranch(String cacheBranchName, GitWorkingDirectory gitWorkingDirectory, Map<String, RemoteGitBranch> remoteGitBranches) {
        ArrayList<RemoteGitBranch> cacheRemoteGitBranches = new ArrayList<RemoteGitBranch>(2);
        for (Map.Entry<String, RemoteGitBranch> entry : remoteGitBranches.entrySet()) {
            String remoteGitBranchName = entry.getKey();
            if (!remoteGitBranchName.startsWith(cacheBranchName)) continue;
            cacheRemoteGitBranches.add(entry.getValue());
        }
        if (!cacheRemoteGitBranches.isEmpty()) {
            GitHubDevSyncUtil.deleteRemoteGitBranches(gitWorkingDirectory, cacheRemoteGitBranches);
        }
    }

    protected static void deleteExpiredCacheBranches(GitRemote gitRemote, long timestamp) {
        int branchCount = 0;
        int deleteCount = 0;
        long oldestBranchAge = Long.MIN_VALUE;
        HashMap<String, RemoteGitBranch> remoteGitBranches = new HashMap<String, RemoteGitBranch>();
        GitWorkingDirectory gitWorkingDirectory = gitRemote.getGitWorkingDirectory();
        for (RemoteGitBranch remoteGitBranch : gitWorkingDirectory.getRemoteGitBranches(gitRemote)) {
            remoteGitBranches.put(remoteGitBranch.getName(), remoteGitBranch);
        }
        ArrayList<RemoteGitBranch> expiredRemoteGitBranches = new ArrayList<RemoteGitBranch>();
        for (Map.Entry entry : remoteGitBranches.entrySet()) {
            String lastBlock;
            RemoteGitBranch remoteGitBranch = (RemoteGitBranch)entry.getValue();
            String remoteGitBranchName = remoteGitBranch.getName();
            Matcher matcher = _cacheBranchPattern.matcher(remoteGitBranchName);
            if (!matcher.matches() || !(lastBlock = matcher.group(2)).matches("\\d+")) continue;
            ++branchCount;
            long remoteGitBranchTimestamp = Long.parseLong(lastBlock);
            long branchAge = timestamp - remoteGitBranchTimestamp;
            if (branchAge > 172800000L) {
                String gitRepositoryBaseRemoteGitBranchName = remoteGitBranchName.replaceAll("(.*)-\\d+", "$1");
                RemoteGitBranch gitRepositoryBaseRemoteGitBranch = (RemoteGitBranch)remoteGitBranches.get(gitRepositoryBaseRemoteGitBranchName);
                if (gitRepositoryBaseRemoteGitBranch != null) {
                    expiredRemoteGitBranches.add(gitRepositoryBaseRemoteGitBranch);
                }
                expiredRemoteGitBranches.add(remoteGitBranch);
                ++deleteCount;
                continue;
            }
            oldestBranchAge = Math.max(oldestBranchAge, branchAge);
        }
        System.out.println(JenkinsResultsParserUtil.combine("Deleting ", String.valueOf(expiredRemoteGitBranches.size()), " branches from ", gitRemote.getRemoteURL()));
        GitHubDevSyncUtil.deleteRemoteGitBranches(gitWorkingDirectory, expiredRemoteGitBranches);
        System.out.println(JenkinsResultsParserUtil.combine("Found ", String.valueOf(branchCount), " cache branches on ", gitRemote.getRemoteURL(), " ", String.valueOf(deleteCount), " were deleted. ", String.valueOf(branchCount - deleteCount), " remain. The oldest branch is ", JenkinsResultsParserUtil.toDurationString(oldestBranchAge), " old."));
    }

    protected static void deleteExpiredRemoteGitBranches(List<GitRemote> gitHubDevGitRemotes) {
        final long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        ArrayList callables = new ArrayList();
        for (final GitRemote gitHubDevGitRemote : gitHubDevGitRemotes) {
            SafeCallable<Object> callable = new SafeCallable<Object>(gitHubDevGitRemote.getHostname()){

                @Override
                public Object safeCall() {
                    GitHubDevSyncUtil.deleteExpiredCacheBranches(gitHubDevGitRemote, start);
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "deleteExpiredRemoteGitBranches");
        try {
            parallelExecutor.execute(300L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println("Expired cache branches deleted in " + JenkinsResultsParserUtil.toDurationString(duration));
    }

    protected static void deleteExtraTimestampBranches(GitRemote gitHubDevGitRemote) {
        GitWorkingDirectory gitWorkingDirectory = gitHubDevGitRemote.getGitWorkingDirectory();
        List<RemoteGitBranch> remoteGitBranches = gitWorkingDirectory.getRemoteGitBranches(gitHubDevGitRemote);
        Collections.sort(remoteGitBranches);
        HashMap remoteGitBranchesMap = new HashMap();
        for (RemoteGitBranch remoteGitBranch : remoteGitBranches) {
            String remoteGitBranchName = remoteGitBranch.getName();
            if (!remoteGitBranchName.matches(_cacheBranchPattern.pattern() + "-\\d+")) continue;
            String baseCacheBranchName = remoteGitBranchName.replaceAll("(.*)-\\d+", "$1");
            if (!remoteGitBranchesMap.containsKey(baseCacheBranchName)) {
                remoteGitBranchesMap.put(baseCacheBranchName, new ArrayList());
            }
            List timestampedRemoteGitBranches = (List)remoteGitBranchesMap.get(baseCacheBranchName);
            timestampedRemoteGitBranches.add(remoteGitBranch);
        }
        for (Map.Entry entry : remoteGitBranchesMap.entrySet()) {
            List timestampedRemoteGitBranches = (List)entry.getValue();
            if (timestampedRemoteGitBranches.size() <= 1) continue;
            timestampedRemoteGitBranches.remove(timestampedRemoteGitBranches.size() - 1);
            GitHubDevSyncUtil.deleteRemoteGitBranches(gitWorkingDirectory, timestampedRemoteGitBranches);
        }
    }

    protected static void deleteExtraTimestampBranches(List<GitRemote> gitHubDevGitRemotes) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        ArrayList callables = new ArrayList();
        for (final GitRemote gitHubDevGitRemote : gitHubDevGitRemotes) {
            SafeCallable<Object> callable = new SafeCallable<Object>(gitHubDevGitRemote.getHostname()){

                @Override
                public Object safeCall() {
                    GitHubDevSyncUtil.deleteExtraTimestampBranches(gitHubDevGitRemote);
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "deleteExtraTimestampBranches");
        try {
            parallelExecutor.execute(300L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println("Local Git nodes cleaned in " + JenkinsResultsParserUtil.toDurationString(duration));
    }

    protected static void deleteFromAllRemotes(final String remoteGitBranchName, List<GitRemote> gitRemotes) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        ArrayList callables = new ArrayList();
        for (final GitRemote gitRemote : gitRemotes) {
            SafeCallable<Boolean> callable = new SafeCallable<Boolean>(gitRemote.getHostname()){

                @Override
                public Boolean safeCall() {
                    GitWorkingDirectory gitWorkingDirectory = gitRemote.getGitWorkingDirectory();
                    gitWorkingDirectory.deleteRemoteGitBranch(remoteGitBranchName, gitRemote);
                    return true;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "deleteFromAllRemotes");
        try {
            parallelExecutor.execute(300L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("Deleted ", remoteGitBranchName, " on ", String.valueOf(gitRemotes.size()), " Git nodes in ", JenkinsResultsParserUtil.toDurationString(duration)));
    }

    protected static void deleteOrphanedCacheBranches(GitRemote gitRemote) {
        List<RemoteGitBranch> cacheRemoteGitBranches = GitHubDevSyncUtil.getCacheRemoteGitBranches(gitRemote);
        HashMap baseCacheRemoteGitBranchesMap = new HashMap();
        HashMap timestampedCacheRemoteGitBranchMap = new HashMap();
        for (RemoteGitBranch cacheRemoteGitBranch : cacheRemoteGitBranches) {
            String cacheRemoteGitBranchName = cacheRemoteGitBranch.getName();
            if (!cacheRemoteGitBranchName.matches(_cacheBranchPattern.pattern())) continue;
            if (cacheRemoteGitBranchName.matches(_cacheBranchPattern.pattern() + "-\\d+")) {
                timestampedCacheRemoteGitBranchMap.put(cacheRemoteGitBranchName, cacheRemoteGitBranch);
                continue;
            }
            baseCacheRemoteGitBranchesMap.put(cacheRemoteGitBranchName, cacheRemoteGitBranch);
        }
        HashMap orphanedBaseCacheRemoteGitBranchesMap = new HashMap(baseCacheRemoteGitBranchesMap);
        HashMap orphanedTimestampedCacheRemoteGitBranchesMap = new HashMap(timestampedCacheRemoteGitBranchMap);
        for (String baseCacheRemoteGitBranchName : baseCacheRemoteGitBranchesMap.keySet()) {
            String timestampedCacheRemoteGitBranchNamePattern = Pattern.quote(baseCacheRemoteGitBranchName) + "-\\d+";
            for (String timestampedCacheRemoteGitBranchName : timestampedCacheRemoteGitBranchMap.keySet()) {
                if (!timestampedCacheRemoteGitBranchName.matches(timestampedCacheRemoteGitBranchNamePattern)) continue;
                orphanedBaseCacheRemoteGitBranchesMap.remove(baseCacheRemoteGitBranchName);
            }
        }
        for (Object timestampedCacheRemoteGitBranchName : timestampedCacheRemoteGitBranchMap.keySet()) {
            String baseCacheRemoteGitBranchName = ((String)timestampedCacheRemoteGitBranchName).replaceAll("(.*)-\\d+", "$1");
            if (!baseCacheRemoteGitBranchesMap.containsKey(baseCacheRemoteGitBranchName)) continue;
            orphanedTimestampedCacheRemoteGitBranchesMap.remove(timestampedCacheRemoteGitBranchName);
        }
        StringBuilder sb = new StringBuilder();
        for (String orphanedBaseCacheRemoteGitBranchName : orphanedBaseCacheRemoteGitBranchesMap.keySet()) {
            sb.append(orphanedBaseCacheRemoteGitBranchName);
            sb.append("\n");
        }
        for (String orphanedTimestampedCacheRemoteGitBranchName : orphanedTimestampedCacheRemoteGitBranchesMap.keySet()) {
            sb.append(orphanedTimestampedCacheRemoteGitBranchName);
            sb.append("\n");
        }
        System.out.println(JenkinsResultsParserUtil.combine("Found ", String.valueOf(orphanedBaseCacheRemoteGitBranchesMap.size()), " orphaned base cache branches ", "and ", String.valueOf(orphanedTimestampedCacheRemoteGitBranchesMap.size()), " orphaned timestamp branches on ", gitRemote.getRemoteURL(), ".\n", sb.toString()));
        ArrayList<RemoteGitBranch> orphanedCacheRemoteGitBranches = new ArrayList<RemoteGitBranch>(orphanedBaseCacheRemoteGitBranchesMap.size() + orphanedTimestampedCacheRemoteGitBranchesMap.size());
        orphanedCacheRemoteGitBranches.addAll(orphanedBaseCacheRemoteGitBranchesMap.values());
        orphanedCacheRemoteGitBranches.addAll(orphanedTimestampedCacheRemoteGitBranchesMap.values());
        GitHubDevSyncUtil.deleteRemoteGitBranches(gitRemote.getGitWorkingDirectory(), orphanedCacheRemoteGitBranches);
    }

    protected static void deleteOrphanedCacheBranches(List<GitRemote> gitRemotes) {
        ArrayList callables = new ArrayList(gitRemotes.size());
        for (final GitRemote gitRemote : gitRemotes) {
            SafeCallable<Object> callable = new SafeCallable<Object>(gitRemote.getHostname()){

                @Override
                public Object safeCall() {
                    GitHubDevSyncUtil.deleteOrphanedCacheBranches(gitRemote);
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "deleteOrphanedCacheBranches");
        try {
            parallelExecutor.execute(900L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    protected static void deleteRemoteGitBranches(GitWorkingDirectory gitWorkingDirectory, List<RemoteGitBranch> remoteGitBranches) {
        if (remoteGitBranches.isEmpty()) {
            return;
        }
        gitWorkingDirectory.deleteRemoteGitBranches(remoteGitBranches);
        StringBuilder sb = new StringBuilder();
        sb.append(JenkinsResultsParserUtil.toDateString(new Date()));
        sb.append("\n\n");
        JenkinsSlave jenkinsSlave = new JenkinsSlave();
        if (jenkinsSlave != null) {
            sb.append("Build URL: ");
            Build build = jenkinsSlave.getCurrentBuild();
            sb.append(build.getBuildURL());
            sb.append("\n");
        }
        sb.append("\n\n");
        sb.append("Deleted ");
        sb.append(String.valueOf(remoteGitBranches.size()));
        sb.append(" GitHub dev branches:\n");
        for (RemoteGitBranch remoteGitBranch : remoteGitBranches) {
            sb.append("    ");
            sb.append(remoteGitBranch.getRemoteURL());
            sb.append(" ");
            sb.append(remoteGitBranch.getName());
            sb.append("\n");
        }
        NotificationUtil.sendEmail(sb.toString(), "jenkins", "GitHub dev branches deleted", "peter.yoo@liferay.com");
    }

    protected static String getCacheBranchName(String receiverUsername, String senderUsername, String senderSHA, String upstreamSHA) {
        return JenkinsResultsParserUtil.combine("cache-", receiverUsername, "-", upstreamSHA, "-", senderUsername, "-", senderSHA);
    }

    protected static List<RemoteGitBranch> getCacheRemoteGitBranches(GitRemote gitRemote) {
        ArrayList<RemoteGitBranch> cacheRemoteGitBranches = new ArrayList<RemoteGitBranch>();
        HashSet<String> lockedBaseCacheRemoteGitBranchNames = new HashSet<String>();
        HashMap<String, RemoteGitBranch> remoteGitBranches = new HashMap<String, RemoteGitBranch>();
        GitWorkingDirectory gitWorkingDirectory = gitRemote.getGitWorkingDirectory();
        for (RemoteGitBranch remoteGitBranch : gitWorkingDirectory.getRemoteGitBranches(gitRemote)) {
            Matcher matcher = _lockedCacheBranchPattern.matcher(remoteGitBranch.getName());
            if (matcher.matches()) {
                lockedBaseCacheRemoteGitBranchNames.add(matcher.group(1));
                continue;
            }
            remoteGitBranches.put(remoteGitBranch.getName(), remoteGitBranch);
        }
        block1: for (String string : new HashSet(remoteGitBranches.keySet())) {
            for (String lockedBaseCacheRemoteGitBranchName : lockedBaseCacheRemoteGitBranchNames) {
                if (!string.startsWith(lockedBaseCacheRemoteGitBranchName)) continue;
                remoteGitBranches.remove(string);
                System.out.println(JenkinsResultsParserUtil.combine("Ignoring ", string, " because this branch is currently locked."));
                continue block1;
            }
        }
        for (Map.Entry entry : remoteGitBranches.entrySet()) {
            String remoteGitBranchName = (String)entry.getKey();
            if (!remoteGitBranchName.matches(_cacheBranchPattern.pattern())) continue;
            if (GitHubDevSyncUtil.hasTimestampBranch(remoteGitBranches)) {
                cacheRemoteGitBranches.add((RemoteGitBranch)entry.getValue());
                continue;
            }
            GitHubDevSyncUtil.deleteCacheRemoteGitBranch(remoteGitBranchName, gitWorkingDirectory, remoteGitBranches);
        }
        return cacheRemoteGitBranches;
    }

    protected static List<String> getGitHubDevNodeHostnames() {
        if (gitHubDevNodeHostnames != null) {
            return new ArrayList<String>(gitHubDevNodeHostnames);
        }
        gitHubDevNodeHostnames = JenkinsResultsParserUtil.getGitHubCacheHostnames();
        return gitHubDevNodeHostnames;
    }

    protected static List<String> getGitHubDevRemoteURLs(GitWorkingDirectory gitWorkingDirectory) {
        ArrayList<String> gitHubDevRemoteURLs = new ArrayList<String>();
        for (String gitHubDevNodeHostname : GitHubDevSyncUtil.getGitHubDevNodeHostnames()) {
            if (gitHubDevNodeHostname.startsWith("slave-")) {
                gitHubDevRemoteURLs.add(JenkinsResultsParserUtil.combine("root@", gitHubDevNodeHostname.substring(6), ":/opt/dev/projects/github/", gitWorkingDirectory.getGitRepositoryName()));
                continue;
            }
            gitHubDevRemoteURLs.add(JenkinsResultsParserUtil.combine("git@", gitHubDevNodeHostname, ":liferay/", gitWorkingDirectory.getGitRepositoryName(), ".git"));
        }
        return gitHubDevRemoteURLs;
    }

    protected static String getGitHubRemoteURL(String repositoryName, String userName) {
        return JenkinsResultsParserUtil.combine("git@github.com:", userName, "/", repositoryName, ".git");
    }

    protected static GitRemote getRandomGitRemote(List<GitRemote> gitRemotes) {
        return gitRemotes.get(JenkinsResultsParserUtil.getRandomValue(0, gitRemotes.size() - 1));
    }

    protected static boolean hasTimestampBranch(Map<String, RemoteGitBranch> remoteGitBranches) {
        for (String remoteGitBranchName : remoteGitBranches.keySet()) {
            String lastBlock;
            Matcher matcher = _cacheBranchPattern.matcher(remoteGitBranchName);
            if (!matcher.matches() || !(lastBlock = matcher.group(2)).matches("\\d+")) continue;
            return true;
        }
        return false;
    }

    protected static void pushToAllRemotes(final boolean force, final LocalGitBranch localGitBranch, final String remoteGitBranchName, List<GitRemote> gitRemotes) {
        if (localGitBranch == null) {
            throw new RuntimeException("Local Git branch is null");
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        ArrayList callables = new ArrayList();
        for (final GitRemote gitRemote : gitRemotes) {
            SafeCallable<Boolean> callable = new SafeCallable<Boolean>(gitRemote.getHostname()){

                @Override
                public Boolean safeCall() {
                    GitWorkingDirectory gitWorkingDirectory = gitRemote.getGitWorkingDirectory();
                    RemoteGitBranch remoteGitBranch = gitWorkingDirectory.getRemoteGitBranch(remoteGitBranchName, gitRemote);
                    if (remoteGitBranch == null || !Objects.equals(remoteGitBranch.getSHA(), localGitBranch.getSHA())) {
                        remoteGitBranch = gitWorkingDirectory.pushToRemoteGitRepository(force, localGitBranch, remoteGitBranchName, gitRemote);
                        return remoteGitBranch != null;
                    }
                    return true;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "pushToAllRemotes");
        try {
            parallelExecutor.execute(3600L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("Pushed ", localGitBranch.getName(), " to ", remoteGitBranchName, " on ", String.valueOf(gitRemotes.size()), " Git nodes in ", JenkinsResultsParserUtil.toDurationString(duration)));
    }

    protected static boolean remoteGitBranchExists(final String remoteGitBranchName, final GitWorkingDirectory gitWorkingDirectory, List<GitRemote> gitRemotes) {
        ArrayList callables = new ArrayList(gitRemotes.size());
        for (final GitRemote gitRemote : gitRemotes) {
            SafeCallable<Boolean> callable = new SafeCallable<Boolean>(gitRemote.getHostname()){

                @Override
                public Boolean safeCall() {
                    try {
                        return gitWorkingDirectory.remoteGitBranchExists(remoteGitBranchName, gitRemote);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return true;
                    }
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _threadPoolExecutor, "remoteGitBranchExists");
        try {
            for (Boolean bool : parallelExecutor.execute(300L)) {
                if (bool != null && bool.booleanValue()) continue;
                return false;
            }
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    protected static String synchronizeToGitHubDev(GitWorkingDirectory gitWorkingDirectory, String receiverUsername, int retryCount, String senderBranchName, String senderUsername, String senderBranchSHA, String upstreamBranchSHA) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected static String synchronizeToGitHubDev(LocalGitBranch localGitBranch, WorkspaceGitRepository workspaceGitRepository, int retryCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean synchronizeUpstreamBranchToGitHubDev(GitWorkingDirectory gitWorkingDirectory, LocalGitBranch localGitBranch, int retryCount) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        File gitRepositoryDirectory = gitWorkingDirectory.getWorkingDirectory();
        gitWorkingDirectory.checkoutLocalGitBranch(localGitBranch);
        String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
        System.out.println(JenkinsResultsParserUtil.combine("Starting synchronization with local-git. Current repository ", "directory is ", gitRepositoryDirectory.getPath(), ". Current ", "branch is ", localGitBranch.getName(), " at hash ", localGitBranch.getSHA(), ". Synchronization target upstream ", "branch is ", upstreamBranchName, "."));
        try {
            List<GitRemote> gitHubDevGitRemotes = GitHubDevSyncUtil.getGitHubDevGitRemotes(gitWorkingDirectory);
            try {
                GitHubDevSyncUtil.pushToAllRemotes(true, localGitBranch, upstreamBranchName, gitHubDevGitRemotes);
            }
            finally {
                if (gitHubDevGitRemotes != null) {
                    try {
                        gitWorkingDirectory.removeGitRemotes(gitHubDevGitRemotes);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        finally {
            String durationString = JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start);
            System.out.println("Synchronization with local Git completed in " + durationString);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateCacheRemoteGitBranchTimestamp(String cacheBranchName, GitWorkingDirectory gitWorkingDirectory, List<GitRemote> gitHubDevGitRemotes) {
        RemoteGitBranch oldTimestampCacheRemoteGitBranch;
        long start;
        block11: {
            start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            try {
                List<RemoteGitBranch> cacheRemoteGitBranches = null;
                GitRemote gitHubDevGitRemote = null;
                while (cacheRemoteGitBranches == null) {
                    try {
                        gitHubDevGitRemote = GitHubDevSyncUtil.getRandomGitRemote(gitHubDevGitRemotes);
                        cacheRemoteGitBranches = GitHubDevSyncUtil.getCacheRemoteGitBranches(gitHubDevGitRemote);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        gitHubDevGitRemotes.remove(gitHubDevGitRemote);
                        if (!gitHubDevGitRemotes.isEmpty()) continue;
                        throw new RuntimeException("No remote repositories could be reached", exception);
                    }
                }
                oldTimestampCacheRemoteGitBranch = null;
                Pattern pattern = Pattern.compile(Pattern.quote(cacheBranchName) + "-(\\d+)");
                for (RemoteGitBranch cacheRemoteGitBranch : cacheRemoteGitBranches) {
                    Matcher matcher = pattern.matcher(cacheRemoteGitBranch.getName());
                    if (!matcher.matches()) continue;
                    long existingTimestamp = Long.parseLong(matcher.group(1));
                    long branchAge = JenkinsResultsParserUtil.getCurrentTimeMillis() - existingTimestamp;
                    if (branchAge <= 86400000L) break;
                    oldTimestampCacheRemoteGitBranch = cacheRemoteGitBranch;
                    break;
                }
                if (oldTimestampCacheRemoteGitBranch != null) break block11;
            }
            catch (Throwable throwable) {
                System.out.println(JenkinsResultsParserUtil.combine("Cache branch timestamp updated in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                throw throwable;
            }
            System.out.println(JenkinsResultsParserUtil.combine("Cache branch timestamp updated in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return;
        }
        String newTimestampCacheRemoteBranchName = JenkinsResultsParserUtil.combine(cacheBranchName, "-", String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis()));
        System.out.println(JenkinsResultsParserUtil.combine("Updating existing timestamp for branch ", oldTimestampCacheRemoteGitBranch.getName(), " to ", newTimestampCacheRemoteBranchName));
        LocalGitBranch originalCheckedOutLocalGitBranch = gitWorkingDirectory.getCurrentLocalGitBranch();
        if (originalCheckedOutLocalGitBranch == null) {
            originalCheckedOutLocalGitBranch = gitWorkingDirectory.getUpstreamLocalGitBranch();
        }
        LocalGitBranch newTimestampLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(newTimestampCacheRemoteBranchName);
        newTimestampLocalGitBranch = gitWorkingDirectory.fetch(newTimestampLocalGitBranch, oldTimestampCacheRemoteGitBranch);
        try {
            GitHubDevSyncUtil.pushToAllRemotes(true, newTimestampLocalGitBranch, newTimestampCacheRemoteBranchName, gitHubDevGitRemotes);
            GitHubDevSyncUtil.deleteFromAllRemotes(oldTimestampCacheRemoteGitBranch.getName(), gitHubDevGitRemotes);
        }
        finally {
            gitWorkingDirectory.checkoutLocalGitBranch(originalCheckedOutLocalGitBranch);
            gitWorkingDirectory.deleteLocalGitBranch(newTimestampLocalGitBranch);
        }
        System.out.println(JenkinsResultsParserUtil.combine("Cache branch timestamp updated in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LocalGitBranch updateUpstreamLocalGitBranch(GitWorkingDirectory gitWorkingDirectory, String upstreamBranchSHA) {
        String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
        RemoteGitBranch upstreamRemoteGitBranch = gitWorkingDirectory.getRemoteGitBranch(upstreamBranchName, gitWorkingDirectory.getUpstreamGitRemote(), true);
        LocalGitBranch upstreamLocalGitBranch = gitWorkingDirectory.getUpstreamLocalGitBranch();
        if (upstreamLocalGitBranch == null) {
            upstreamLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(upstreamBranchName);
            gitWorkingDirectory.fetch(upstreamLocalGitBranch, upstreamRemoteGitBranch);
        }
        String upstreamLocalGitBranchSHA = upstreamLocalGitBranch.getSHA();
        String upstreamRemoteGitBranchSHA = upstreamRemoteGitBranch.getSHA();
        if (upstreamBranchSHA != null && !upstreamRemoteGitBranchSHA.equals(upstreamBranchSHA)) {
            upstreamRemoteGitBranchSHA = upstreamBranchSHA;
        }
        if (upstreamLocalGitBranchSHA.equals(upstreamRemoteGitBranchSHA)) {
            return upstreamLocalGitBranch;
        }
        gitWorkingDirectory.rebaseAbort();
        gitWorkingDirectory.clean();
        gitWorkingDirectory.reset("--hard");
        gitWorkingDirectory.fetch(upstreamRemoteGitBranch);
        String tempBranchName = "temp-" + JenkinsResultsParserUtil.getCurrentTimeMillis();
        LocalGitBranch tempLocalGitBranch = null;
        try {
            tempLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(tempBranchName, true, upstreamRemoteGitBranchSHA);
            gitWorkingDirectory.checkoutLocalGitBranch(tempLocalGitBranch, "-f");
            gitWorkingDirectory.deleteLocalGitBranch(upstreamBranchName);
            upstreamLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(upstreamRemoteGitBranch.getName(), true, upstreamRemoteGitBranchSHA);
            gitWorkingDirectory.checkoutLocalGitBranch(upstreamLocalGitBranch);
        }
        finally {
            if (tempLocalGitBranch != null) {
                gitWorkingDirectory.deleteLocalGitBranch(tempLocalGitBranch);
            }
        }
        return upstreamLocalGitBranch;
    }

    private static RemoteGitBranch _fetchCacheBranchFromGitHubDev(GitWorkingDirectory gitWorkingDirectory, String cacheBranchName, List<GitRemote> gitHubDevGitRemotesWithCacheBranch) {
        List<GitRemote> gitRemotesWithoutCacheBranch = GitHubDevSyncUtil.getGitHubDevGitRemotes(gitWorkingDirectory);
        gitRemotesWithoutCacheBranch.removeAll(gitHubDevGitRemotesWithCacheBranch);
        while (!gitHubDevGitRemotesWithCacheBranch.isEmpty()) {
            GitRemote gitHubDevGitRemote = GitHubDevSyncUtil.getRandomGitRemote(gitHubDevGitRemotesWithCacheBranch);
            gitHubDevGitRemotesWithCacheBranch.remove(gitHubDevGitRemote);
            try {
                RemoteGitBranch cachedRemoteGitBranch = gitWorkingDirectory.getRemoteGitBranch(cacheBranchName, gitHubDevGitRemote, true);
                LocalGitBranch cachedLocalGitBranch = gitWorkingDirectory.fetch(cachedRemoteGitBranch, 1);
                if (!gitRemotesWithoutCacheBranch.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (GitRemote gitRemoteWithoutCacheBranch : gitRemotesWithoutCacheBranch) {
                        sb.append("    ");
                        sb.append(gitRemoteWithoutCacheBranch.getHostname());
                        sb.append("\n");
                    }
                    System.out.println(JenkinsResultsParserUtil.combine("Pushing ", cacheBranchName, " to the following GitHub-dev nodes because they ", "do not have it.\n", sb.toString()));
                    GitHubDevSyncUtil.pushToAllRemotes(true, cachedLocalGitBranch, cacheBranchName, gitRemotesWithoutCacheBranch);
                }
                return cachedRemoteGitBranch;
            }
            catch (RuntimeException runtimeException) {
                String message = JenkinsResultsParserUtil.combine("Unable to fetch cached remote Git branch ", cacheBranchName, "\n", runtimeException.getMessage());
                if (gitHubDevGitRemotesWithCacheBranch.isEmpty()) {
                    System.out.println(message);
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to fetch ", cacheBranchName, " from git@github-dev.com"), runtimeException);
                }
                System.out.println("Retrying: " + message);
            }
        }
        return null;
    }

    static {
        _cacheBranchPattern = Pattern.compile("cache(-([^-]+))+");
        _lockedCacheBranchPattern = Pattern.compile("(cache-.*)-LOCK");
        _threadPoolExecutor = JenkinsResultsParserUtil.getNewThreadPoolExecutor(16, true);
    }

    private static abstract class SafeCallable<T>
    extends ParallelExecutor.SequentialCallable<T> {
        public SafeCallable() {
            this(null);
        }

        public SafeCallable(String groupName) {
            super(groupName);
        }

        @Override
        public final T call() {
            try {
                return this.safeCall();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public abstract T safeCall();
    }
}

