/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.MultiPattern;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitRemote {
    public static final Pattern gitLsRemotePattern = Pattern.compile("(?<sha>[^\\s]{40}+)[\\s]+refs/(?<type>[^/]+)+/(?<name>[^\\s]+)");
    private static final Pattern _remotePattern = Pattern.compile(JenkinsResultsParserUtil.combine("(?<name>[^\\s]+)[\\s]+(?<remoteURL>[^\\s]+)[\\s]+\\(", "(?<type>[^\\s]+)\\)"));
    private static final MultiPattern _remoteURLMultiPattern = new MultiPattern("git@(?<hostname>[^:]+):(?<username>[^/]+)/(?<gitRepositoryName>[^\\.^\\s]+)(\\.git)?+\\s*", "https://(?<hostname>[^/]+)/(?<username>[^/]+)/(?<gitRepositoryName>[^\\.^\\s]+)(\\.git)?+\\s*", "root@(?<hostname>[^:]+):/opt/dev/projects/github/(?<gitRepositoryName>[^\\\\.]+)");
    private final String _fetchRemoteURL;
    private String _gitRepositoryName;
    private final GitWorkingDirectory _gitWorkingDirectory;
    private String _hostname;
    private final String _name;
    private final String _pushRemoteURL;
    private String _username;

    public static Matcher getRemoteURLMatcher(String remoteURL) {
        Matcher matcher = _remoteURLMultiPattern.matches(remoteURL);
        if (matcher == null) {
            matcher = _remoteURLMultiPattern.find(remoteURL);
        }
        if (matcher != null) {
            matcher.reset();
        }
        return matcher;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GitRemote)) {
            return false;
        }
        GitRemote otherGitRemote = (GitRemote)object;
        return Objects.equals(this.getGitRepositoryName(), otherGitRemote.getGitRepositoryName()) && Objects.equals(this.getRemoteURL(), otherGitRemote.getRemoteURL());
    }

    public String getGitRepositoryName() {
        return this._gitRepositoryName;
    }

    public GitWorkingDirectory getGitWorkingDirectory() {
        return this._gitWorkingDirectory;
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getName() {
        return this._name;
    }

    public String getPushRemoteURL() {
        if (this._pushRemoteURL != null) {
            return this._pushRemoteURL;
        }
        return this._fetchRemoteURL;
    }

    public String getRemoteURL() {
        return this._fetchRemoteURL;
    }

    public String getUsername() {
        return this._username;
    }

    public int hashCode() {
        String key = this.getRemoteURL() + this.getGitRepositoryName();
        return key.hashCode();
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine(this.getName(), " (", this.getRemoteURL(), ")");
    }

    protected GitRemote(GitWorkingDirectory gitWorkingDirectory, String name, String remoteURL) {
        this._gitWorkingDirectory = gitWorkingDirectory;
        this._name = name;
        this._fetchRemoteURL = remoteURL;
        this._pushRemoteURL = remoteURL;
        this.parseRemoteURL();
    }

    protected GitRemote(GitWorkingDirectory gitWorkingDirectory, String[] remoteInputLines) {
        this._gitWorkingDirectory = gitWorkingDirectory;
        if (remoteInputLines.length != 2) {
            throw new IllegalArgumentException("\"remoteInputLines\" must be an array of 2 strings");
        }
        if (remoteInputLines[0].equals(remoteInputLines[1])) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine("\"remoteInputLines[0]\" and ", "\"remoteInputLines[1]\" are identical: ", remoteInputLines[0]));
        }
        if (remoteInputLines[0] == null || remoteInputLines[1] == null) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine("Neither \"remoteInputLines[0]\" nor ", "\"remoteInputLines[1]\" may be NULL: ", Arrays.toString(remoteInputLines)));
        }
        String name = null;
        String fetchRemoteURL = null;
        String pushRemoteURL = null;
        for (String remoteInputLine : remoteInputLines) {
            Matcher matcher = _remotePattern.matcher(remoteInputLine);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid Git remote input line " + remoteInputLine);
            }
            if (name == null) {
                name = matcher.group("name");
            }
            String remoteURL = matcher.group("remoteURL");
            String type = matcher.group("type");
            if (fetchRemoteURL == null && type.equals("fetch")) {
                fetchRemoteURL = remoteURL;
            }
            if (pushRemoteURL != null || !type.equals("push")) continue;
            pushRemoteURL = remoteURL;
        }
        this._fetchRemoteURL = fetchRemoteURL;
        this._name = name;
        this._pushRemoteURL = pushRemoteURL;
        this.parseRemoteURL();
    }

    protected void parseRemoteURL() {
        Matcher remoteURLMatcher = GitRemote.getRemoteURLMatcher(this._fetchRemoteURL);
        if (remoteURLMatcher == null || !remoteURLMatcher.find()) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("fetch remote URL ", this._fetchRemoteURL, " is not a valid remote URL"));
        }
        this._hostname = remoteURLMatcher.group("hostname");
        try {
            this._username = remoteURLMatcher.group("username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._username = "liferay";
        }
        this._gitRepositoryName = remoteURLMatcher.group("gitRepositoryName");
    }
}

