/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.DefaultLocalGitRepository;
import com.liferay.jenkins.results.parser.DefaultRemoteGitRepository;
import com.liferay.jenkins.results.parser.DefaultWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.GitHubRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitRepository;
import com.liferay.jenkins.results.parser.PluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.QAWebsitesWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.ReleaseToolWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.json.JSONObject;

public class GitRepositoryFactory {
    private static final Map<String, WorkspaceGitRepository> _workspaceGitRepositories = new HashMap<String, WorkspaceGitRepository>();

    public static LocalGitRepository getLocalGitRepository(String repositoryName, String upstreamBranchName) {
        return new DefaultLocalGitRepository(repositoryName, upstreamBranchName);
    }

    public static LocalGitRepository getLocalGitRepository(String repositoryName, String upstreamBranchName, File repositoryDir) {
        return new DefaultLocalGitRepository(repositoryName, upstreamBranchName, repositoryDir);
    }

    public static RemoteGitRepository getRemoteGitRepository(GitRemote gitRemote) {
        String hostname = gitRemote.getHostname();
        if (hostname.equalsIgnoreCase("github.com")) {
            return new GitHubRemoteGitRepository(gitRemote);
        }
        return new DefaultRemoteGitRepository(gitRemote);
    }

    public static RemoteGitRepository getRemoteGitRepository(String remoteURL) {
        Matcher matcher = GitRemote.getRemoteURLMatcher(remoteURL);
        if (matcher == null || !matcher.find()) {
            throw new RuntimeException("Invalid remote URL " + remoteURL);
        }
        String patternString = String.valueOf(matcher.pattern());
        String username = "liferay";
        if (patternString.contains("(?<username>")) {
            username = matcher.group("username");
        }
        return GitRepositoryFactory.getRemoteGitRepository(matcher.group("hostname"), matcher.group("gitRepositoryName"), username);
    }

    public static RemoteGitRepository getRemoteGitRepository(String hostname, String gitRepositoryName, String username) {
        if (hostname.equalsIgnoreCase("github.com")) {
            return new GitHubRemoteGitRepository(gitRepositoryName, username);
        }
        return new DefaultRemoteGitRepository(hostname, gitRepositoryName, username);
    }

    public static WorkspaceGitRepository getWorkspaceGitRepository(PullRequest pullRequest) {
        String gitDirectoryName = JenkinsResultsParserUtil.getGitDirectoryName(pullRequest.getGitRepositoryName(), pullRequest.getUpstreamRemoteGitBranchName());
        WorkspaceGitRepository workspaceGitRepository = _workspaceGitRepositories.get(gitDirectoryName);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        if (workspaceGitRepository != null) {
            workspaceGitRepository.setGitHubURL(pullRequest.getHtmlURL());
            buildDatabase.putWorkspaceGitRepository(gitDirectoryName, workspaceGitRepository);
            return workspaceGitRepository;
        }
        if (buildDatabase.hasWorkspaceGitRepository(gitDirectoryName)) {
            workspaceGitRepository = buildDatabase.getWorkspaceGitRepository(gitDirectoryName);
            workspaceGitRepository.setGitHubURL(pullRequest.getHtmlURL());
            _workspaceGitRepositories.put(gitDirectoryName, workspaceGitRepository);
            return workspaceGitRepository;
        }
        String gitRepositoryName = JenkinsResultsParserUtil.getGitRepositoryName(gitDirectoryName);
        String gitUpstreamBranchName = pullRequest.getUpstreamRemoteGitBranchName();
        if (gitRepositoryName == null || gitUpstreamBranchName == null) {
            throw new RuntimeException("Unable to find git directory name " + gitDirectoryName);
        }
        workspaceGitRepository = gitRepositoryName.matches("liferay-plugins(-ee)?") ? new PluginsWorkspaceGitRepository(pullRequest, gitUpstreamBranchName) : (gitRepositoryName.matches("liferay-portal(-ee)?") ? new PortalWorkspaceGitRepository(pullRequest, gitUpstreamBranchName) : (gitRepositoryName.equals("liferay-qa-websites-ee") ? new QAWebsitesWorkspaceGitRepository(pullRequest, gitUpstreamBranchName) : (gitRepositoryName.equals("liferay-release-tool-ee") ? new ReleaseToolWorkspaceGitRepository(pullRequest, gitUpstreamBranchName) : new DefaultWorkspaceGitRepository(pullRequest, gitUpstreamBranchName))));
        buildDatabase.putWorkspaceGitRepository(gitDirectoryName, workspaceGitRepository);
        _workspaceGitRepositories.put(gitDirectoryName, workspaceGitRepository);
        return workspaceGitRepository;
    }

    public static WorkspaceGitRepository getWorkspaceGitRepository(String gitDirectoryName) {
        return GitRepositoryFactory.getWorkspaceGitRepository(JenkinsResultsParserUtil.getGitRepositoryName(gitDirectoryName), JenkinsResultsParserUtil.getGitUpstreamBranchName(gitDirectoryName));
    }

    public static WorkspaceGitRepository getWorkspaceGitRepository(String repositoryName, String upstreamBranchName) {
        String gitDirectoryName = JenkinsResultsParserUtil.getGitDirectoryName(repositoryName, upstreamBranchName);
        WorkspaceGitRepository workspaceGitRepository = _workspaceGitRepositories.get(gitDirectoryName);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        if (workspaceGitRepository != null) {
            buildDatabase.putWorkspaceGitRepository(gitDirectoryName, workspaceGitRepository);
            return workspaceGitRepository;
        }
        if (buildDatabase.hasWorkspaceGitRepository(gitDirectoryName)) {
            workspaceGitRepository = buildDatabase.getWorkspaceGitRepository(gitDirectoryName);
            _workspaceGitRepositories.put(gitDirectoryName, workspaceGitRepository);
            return workspaceGitRepository;
        }
        String gitRepositoryName = JenkinsResultsParserUtil.getGitRepositoryName(gitDirectoryName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
            upstreamBranchName = JenkinsResultsParserUtil.getGitUpstreamBranchName(gitDirectoryName);
        }
        if (gitRepositoryName == null || upstreamBranchName == null) {
            throw new RuntimeException("Unable to find git directory name " + gitDirectoryName);
        }
        RemoteGitRef remoteGitRef = GitUtil.getRemoteGitRef(JenkinsResultsParserUtil.combine("https://github.com/", JenkinsResultsParserUtil.getUpstreamUserName(repositoryName, upstreamBranchName), "/", gitRepositoryName, "/tree/", upstreamBranchName));
        workspaceGitRepository = gitRepositoryName.matches("liferay-plugins(-ee)?") ? new PluginsWorkspaceGitRepository(remoteGitRef, upstreamBranchName) : (gitRepositoryName.matches("liferay-portal(-ee)?") ? new PortalWorkspaceGitRepository(remoteGitRef, upstreamBranchName) : (gitRepositoryName.equals("liferay-qa-websites-ee") ? new QAWebsitesWorkspaceGitRepository(remoteGitRef, upstreamBranchName) : (gitRepositoryName.equals("liferay-release-tool-ee") ? new ReleaseToolWorkspaceGitRepository(remoteGitRef, upstreamBranchName) : new DefaultWorkspaceGitRepository(remoteGitRef, upstreamBranchName))));
        buildDatabase.putWorkspaceGitRepository(gitDirectoryName, workspaceGitRepository);
        _workspaceGitRepositories.put(gitDirectoryName, workspaceGitRepository);
        return workspaceGitRepository;
    }

    protected static WorkspaceGitRepository getWorkspaceGitRepository(JSONObject jsonObject) {
        String gitDirectoryName = jsonObject.optString("directory_name", null);
        if (gitDirectoryName == null) {
            throw new RuntimeException("Invalid JSONObject " + jsonObject);
        }
        WorkspaceGitRepository workspaceGitRepository = _workspaceGitRepositories.get(gitDirectoryName);
        if (workspaceGitRepository != null) {
            return workspaceGitRepository;
        }
        String repositoryName = jsonObject.optString("name", null);
        if (repositoryName == null) {
            throw new RuntimeException("Invalid JSONObject " + jsonObject);
        }
        workspaceGitRepository = repositoryName.matches("liferay-plugins(-ee)?") ? new PluginsWorkspaceGitRepository(jsonObject) : (repositoryName.matches("liferay-portal(-ee)?") ? new PortalWorkspaceGitRepository(jsonObject) : (repositoryName.equals("liferay-qa-websites-ee") ? new QAWebsitesWorkspaceGitRepository(jsonObject) : (repositoryName.equals("liferay-release-tool-ee") ? new ReleaseToolWorkspaceGitRepository(jsonObject) : new DefaultWorkspaceGitRepository(jsonObject))));
        _workspaceGitRepositories.put(gitDirectoryName, workspaceGitRepository);
        return workspaceGitRepository;
    }
}

