/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.GitBranchFactory;
import com.liferay.jenkins.results.parser.GitCommitFactory;
import com.liferay.jenkins.results.parser.GitHubDevSyncUtil;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import com.liferay.jenkins.results.parser.LocalGitRepository;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import com.liferay.jenkins.results.parser.Retryable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class GitWorkingDirectory {
    private static final int _BRANCHES_DELETE_BATCH_SIZE = 5;
    private static final Pattern _badRefPattern = Pattern.compile("fatal: bad object (?<badRef>.+/HEAD)");
    private static final Map<String, List<File>> _deletedFilesMap = new ConcurrentHashMap<String, List<File>>();
    private static final Pattern _gitDirectoryPathPattern = Pattern.compile("gitdir\\: (.*)\\s*");
    private static final Pattern _gitLogEntityPattern = Pattern.compile("(?<sha>[0-9a-f]{40}) (?<commitTime>\\d+) (?<email>[^\\s]*) (?<message>.*)");
    private static final Map<String, List<File>> _modifiedFilesMap = new ConcurrentHashMap<String, List<File>>();
    private static final MultiPattern _poshiFileNamesMultiPattern = new MultiPattern(".*\\.function", ".*\\.macro", ".*\\.path", ".*\\.prose", ".*\\.testcase");
    private static final List<String> _privateOnlyGitRepositoryNames = Collections.synchronizedList(GitWorkingDirectory._getBuildPropertyAsList("git.working.directory.private.only.repository.names"));
    private static final List<String> _publicOnlyGitRepositoryNames = Collections.synchronizedList(GitWorkingDirectory._getBuildPropertyAsList("git.working.directory.public.only.repository.names"));
    private boolean _cacheBashCommands;
    private final Map<String, GitUtil.ExecutionResult> _executionResults = new HashMap<String, GitUtil.ExecutionResult>();
    private File _gitDirectory;
    private final Map<String, GitRemote> _gitRemotes = new ConcurrentHashMap<String, GitRemote>();
    private final String _gitRepositoryName;
    private final String _gitRepositoryUsername;
    private final String _upstreamBranchName;
    private File _workingDirectory;

    public static String getGitHubUserName(GitRemote gitRemote) {
        String remoteURL = gitRemote.getRemoteURL();
        if (!remoteURL.contains("github.com")) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine(gitRemote.getName(), " does not point to a GitHub repository"));
        }
        String userName = null;
        userName = remoteURL.startsWith("https://github.com/") ? remoteURL.substring("https://github.com/".length()) : remoteURL.substring("git@github.com:".length());
        return userName.substring(0, userName.indexOf("/"));
    }

    public GitRemote addGitRemote(boolean force, String gitRemoteName, String remoteURL) {
        return this.addGitRemote(force, gitRemoteName, remoteURL, false);
    }

    public GitRemote addGitRemote(boolean force, String gitRemoteName, String remoteURL, boolean write) {
        GitUtil.ExecutionResult executionResult;
        if (this.gitRemoteExists(gitRemoteName)) {
            if (force) {
                this.removeGitRemote(this.getGitRemote(gitRemoteName));
            } else {
                throw new GitWorkingDirectoryIllegalArgumentException(this, JenkinsResultsParserUtil.combine("Git remote ", gitRemoteName, " already exists"));
            }
        }
        GitRemote newGitRemote = new GitRemote(this, gitRemoteName, remoteURL);
        this._gitRemotes.put(gitRemoteName, newGitRemote);
        if (write && (executionResult = this.executeBashCommands(1, 30000L, 120000L, JenkinsResultsParserUtil.combine("if [ \"$(git remote | grep ", gitRemoteName, ")\" != \"\" ] ; then git remote remove ", gitRemoteName, " ; fi"), JenkinsResultsParserUtil.combine("git remote add ", gitRemoteName, " ", remoteURL))).getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to write Git remote ", gitRemoteName, "\n", executionResult.getStandardError()));
        }
        return newGitRemote;
    }

    public LocalGitBranch checkoutLocalGitBranch(Build.BranchInformation branchInformation) {
        this.checkoutUpstreamLocalGitBranch();
        LocalGitBranch localGitBranch = this.createLocalGitBranch(JenkinsResultsParserUtil.combine(branchInformation.getUpstreamBranchName(), "-temp-", String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis())), true);
        try {
            RemoteGitBranch cacheBranchFromGitHubDev = GitHubDevSyncUtil.fetchCacheBranchFromGitHubDev(this, branchInformation.getCachedRemoteGitRefName());
            localGitBranch = this.createLocalGitBranch(localGitBranch.getName(), true, cacheBranchFromGitHubDev.getSHA());
        }
        catch (Exception exception) {
            RemoteGitRef senderRemoteGitRef = branchInformation.getSenderRemoteGitRef();
            localGitBranch = this.getRebasedLocalGitBranch(localGitBranch.getName(), branchInformation.getSenderBranchName(), senderRemoteGitRef.getRemoteURL(), branchInformation.getSenderBranchSHA(), branchInformation.getUpstreamBranchName(), branchInformation.getUpstreamBranchSHA());
        }
        this.checkoutLocalGitBranch(localGitBranch);
        this.createLocalGitBranch(branchInformation.getUpstreamBranchName(), true, branchInformation.getUpstreamBranchSHA());
        return localGitBranch;
    }

    public void checkoutLocalGitBranch(LocalGitBranch localGitBranch) {
        this.checkoutLocalGitBranch(localGitBranch, "-f");
    }

    public void checkoutLocalGitBranch(LocalGitBranch localGitBranch, String options) {
        this.waitForIndexLock();
        StringBuilder sb = new StringBuilder();
        sb.append("git checkout ");
        if (options != null) {
            sb.append(options);
            sb.append(" ");
        }
        String branchName = localGitBranch.getName();
        sb.append(branchName);
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 600000L, sb.toString());
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to checkout ", branchName, "\n", executionResult.getStandardError()));
        }
        int timeout = 0;
        File headFile = new File(this._gitDirectory, "HEAD");
        String expectedContent = JenkinsResultsParserUtil.combine("ref: refs/heads/", branchName);
        do {
            String headContent = null;
            try {
                headContent = JenkinsResultsParserUtil.read(headFile);
            }
            catch (IOException ioException) {
                throw new GitWorkingDirectoryRuntimeException(this, "Unable to read file " + headFile.getPath(), ioException);
            }
            headContent = headContent.trim();
            if (headContent.equals(expectedContent)) {
                return;
            }
            System.out.println(JenkinsResultsParserUtil.combine("HEAD file content is: ", headContent, ". Waiting for branch to be updated."));
            JenkinsResultsParserUtil.sleep(5000L);
        } while (++timeout < 59);
        if (Objects.equals(branchName, this.getCurrentBranchName())) {
            return;
        }
        throw new GitWorkingDirectoryRuntimeException(this, "Unable to checkout branch " + branchName);
    }

    public void checkoutUpstreamLocalGitBranch() {
        if (!Objects.equals(this.getCurrentBranchName(), this.getUpstreamBranchName())) {
            this.checkoutLocalGitBranch(this.getUpstreamLocalGitBranch());
        }
    }

    public void cherryPick(LocalGitCommit localGitCommit) {
        this.cherryPick(localGitCommit.getSHA());
    }

    public void cherryPick(String localGitCommitSHA) {
        String cherryPickCommand = JenkinsResultsParserUtil.combine("git cherry-pick " + localGitCommitSHA);
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, cherryPickCommand);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to cherry pick commit ", localGitCommitSHA, "\n", executionResult.getStandardError()));
        }
    }

    public void clean() {
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(3, 30000L, 600000L, "git clean -dfx");
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to clean Git repository\n", executionResult.getStandardError()));
        }
    }

    public void cleanTempBranches() {
        this.checkoutUpstreamLocalGitBranch();
        List<String> localGitBranchNames = this.getLocalGitBranchNames();
        ArrayList<String> tempBranchNames = new ArrayList<String>(localGitBranchNames.size());
        String pattern = JenkinsResultsParserUtil.combine(".*", Pattern.quote(this.getUpstreamBranchName()), "-temp", ".*");
        for (String localGitBranchName : localGitBranchNames) {
            if (!localGitBranchName.matches(pattern)) continue;
            tempBranchNames.add(localGitBranchName);
        }
        if (!tempBranchNames.isEmpty()) {
            for (List branchNames : Lists.partition(new ArrayList(tempBranchNames), (int)5)) {
                this._deleteLocalGitBranches(branchNames.toArray(new String[0]));
            }
        }
    }

    public void commitFileToCurrentBranch(String fileName, String message) {
        String commitCommand = JenkinsResultsParserUtil.combine("git add ", fileName, " ; git commit -m \"", message, "\"");
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, commitCommand);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to commit file ", fileName, "\n", executionResult.getStandardError()));
        }
    }

    public void commitStagedFilesToCurrentBranch(String message) {
        String commitCommand = JenkinsResultsParserUtil.combine("git commit -m \"", message, "\" ");
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, commitCommand);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to commit staged files", "\n", executionResult.getStandardError()));
        }
    }

    public void configure(Map<String, String> configMap, String options) {
        String[] commands = new String[configMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("git config ");
            if (options != null && !options.isEmpty()) {
                sb.append(options);
                sb.append(" ");
            }
            sb.append(entry.getKey());
            sb.append(" ");
            sb.append(entry.getValue());
            commands[i] = sb.toString();
            ++i;
        }
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, commands);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to configure Git repository.\n" + executionResult.getStandardError());
        }
    }

    public void configure(String configName, String configValue, String options) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(configName, configValue);
        this.configure(configMap, options);
    }

    public LocalGitBranch createLocalGitBranch(LocalGitBranch localGitBranch) {
        return this.createLocalGitBranch(localGitBranch.getName(), false, localGitBranch.getSHA());
    }

    public LocalGitBranch createLocalGitBranch(LocalGitBranch localGitBranch, boolean force) {
        return this.createLocalGitBranch(localGitBranch.getName(), force, localGitBranch.getSHA());
    }

    public LocalGitBranch createLocalGitBranch(String localGitBranchName) {
        return this.createLocalGitBranch(localGitBranchName, false, null);
    }

    public LocalGitBranch createLocalGitBranch(String localGitBranchName, boolean force) {
        return this.createLocalGitBranch(localGitBranchName, force, null);
    }

    public LocalGitBranch createLocalGitBranch(final String localGitBranchName, final boolean force, final String startPoint) {
        Retryable<LocalGitBranch> createLocalGitBranchRetryable = new Retryable<LocalGitBranch>(true, 3, 0, true){

            @Override
            public LocalGitBranch execute() {
                return GitWorkingDirectory.this._createLocalGitBranch(localGitBranchName, force, startPoint);
            }
        };
        return (LocalGitBranch)createLocalGitBranchRetryable.executeWithRetries();
    }

    public String createPullRequest(final String body, final String pullRequestBranchName, final String receiverUserName, final String senderUserName, final String title) {
        Retryable<String> retryable = new Retryable<String>(true, 5, 0, true){

            @Override
            public String execute() {
                JSONObject responseJSONObject;
                JSONObject requestJSONObject = new JSONObject();
                requestJSONObject.put("base", (Object)GitWorkingDirectory.this._upstreamBranchName).put("body", (Object)body).put("head", (Object)(senderUserName + ":" + pullRequestBranchName)).put("title", (Object)title);
                String url = JenkinsResultsParserUtil.getGitHubApiUrl(GitWorkingDirectory.this._gitRepositoryName, receiverUserName, "pulls");
                try {
                    responseJSONObject = JenkinsResultsParserUtil.toJSONObject(url, requestJSONObject.toString());
                }
                catch (IOException ioException) {
                    throw new RuntimeException("Unable to create pull request", ioException);
                }
                String pullRequestURL = responseJSONObject.getString("html_url");
                System.out.println("Created a pull request at " + pullRequestURL);
                return pullRequestURL;
            }
        };
        return (String)retryable.executeWithRetries();
    }

    public void deleteLocalGitBranch(LocalGitBranch localGitBranch) {
        if (localGitBranch == null) {
            return;
        }
        this.deleteLocalGitBranches(Arrays.asList(localGitBranch));
    }

    public void deleteLocalGitBranch(String branchName) {
        this.deleteLocalGitBranch(this.getLocalGitBranch(branchName));
    }

    public void deleteLocalGitBranches(List<LocalGitBranch> localGitBranches) {
        if (localGitBranches.isEmpty()) {
            return;
        }
        HashSet<String> localGitBranchNames = new HashSet<String>();
        for (LocalGitBranch localGitBranch : localGitBranches) {
            localGitBranchNames.add(localGitBranch.getName());
        }
        for (List branchNames : Lists.partition(new ArrayList(localGitBranchNames), (int)5)) {
            this._deleteLocalGitBranches(branchNames.toArray(new String[0]));
        }
    }

    public void deleteLockFiles() {
        String[] lockFileNames;
        File gitDirectory = this.getGitDirectory();
        for (String lockFileName : lockFileNames = gitDirectory.list(JenkinsResultsParserUtil.newFilenameFilter(".*\\.lock"))) {
            boolean deleted = false;
            File lockFile = new File(gitDirectory, lockFileName);
            if (lockFile.exists() && lockFile.canWrite()) {
                System.out.println("Deleting lock file " + lockFile.getPath());
                deleted = lockFile.delete();
            }
            if (deleted) continue;
            System.out.println("Unable to delete " + lockFile.getPath());
        }
    }

    public void deleteRemoteGitBranch(RemoteGitBranch remoteGitBranch) {
        this.deleteRemoteGitBranches(Arrays.asList(remoteGitBranch));
    }

    public void deleteRemoteGitBranch(String branchName, GitRemote gitRemote) {
        this.deleteRemoteGitBranch(branchName, gitRemote.getRemoteURL());
    }

    public void deleteRemoteGitBranch(String branchName, RemoteGitRepository remoteGitRepository) {
        this.deleteRemoteGitBranch(branchName, remoteGitRepository.getRemoteURL());
    }

    public void deleteRemoteGitBranch(String branchName, String remoteURL) {
        this.deleteRemoteGitBranch(this.getRemoteGitBranch(branchName, remoteURL));
    }

    public void deleteRemoteGitBranches(List<RemoteGitBranch> remoteGitBranches) {
        if (remoteGitBranches.isEmpty()) {
            return;
        }
        HashMap<String, Set> remoteURLGitBranchNameMap = new HashMap<String, Set>();
        for (RemoteGitBranch remoteGitBranch : remoteGitBranches) {
            RemoteGitRepository remoteGitRepository = remoteGitBranch.getRemoteGitRepository();
            String remoteURL = remoteGitRepository.getRemoteURL();
            if (!remoteURLGitBranchNameMap.containsKey(remoteURL)) {
                remoteURLGitBranchNameMap.put(remoteURL, new HashSet());
            }
            Set remoteGitBranchNames = (Set)remoteURLGitBranchNameMap.get(remoteURL);
            remoteGitBranchNames.add(remoteGitBranch.getName());
            remoteURLGitBranchNameMap.put(remoteURL, remoteGitBranchNames);
        }
        ArrayList callables = new ArrayList(remoteURLGitBranchNameMap.size());
        for (final Map.Entry entry : remoteURLGitBranchNameMap.entrySet()) {
            ParallelExecutor.SequentialCallable<Boolean> callable = new ParallelExecutor.SequentialCallable<Boolean>((String)entry.getKey()){

                @Override
                public Boolean call() throws Exception {
                    Set allBranchNames = (Set)entry.getValue();
                    if (allBranchNames.isEmpty()) {
                        return true;
                    }
                    String remoteURL = (String)entry.getKey();
                    for (List branchNames : Lists.partition(new ArrayList(allBranchNames), (int)5)) {
                        GitWorkingDirectory.this._deleteRemoteGitBranches(remoteURL, branchNames.toArray(new String[0]));
                    }
                    return true;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, true, JenkinsResultsParserUtil.getNewThreadPoolExecutor(callables.size(), true), "deleteRemoteGitBranches");
        try {
            parallelExecutor.execute();
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    public void displayLog() {
        this.displayLog(1);
    }

    public void displayLog(int logNumber) {
        String command = "git log -n " + logNumber;
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 180000L, command);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to display log");
        }
        System.out.println();
        System.out.println(executionResult.getStandardOut());
        System.out.println();
    }

    public void fetch(GitRemote gitRemote) {
        this.fetch(gitRemote.getRemoteURL());
    }

    public void fetch(GitRemote gitRemote, boolean noTags) {
        this.fetch(gitRemote.getRemoteURL(), noTags);
    }

    public LocalGitBranch fetch(LocalGitBranch localGitBranch) {
        return this.fetch(null, localGitBranch);
    }

    public LocalGitBranch fetch(LocalGitBranch localGitBranch, boolean noTags, RemoteGitRef remoteGitRef) {
        return this.fetch(localGitBranch, noTags, remoteGitRef, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalGitBranch fetch(LocalGitBranch localGitBranch, boolean noTags, RemoteGitRef remoteGitRef, int retries) {
        String upstreamBranchSHA;
        if (remoteGitRef == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Remote Git reference is null");
        }
        String remoteGitRefSHA = remoteGitRef.getSHA();
        if (this.localSHAExists(remoteGitRefSHA)) {
            System.out.println(remoteGitRefSHA + " already exists in Git repository");
            if (localGitBranch != null && Objects.equals(localGitBranch.getSHA(), remoteGitRefSHA)) {
                return localGitBranch;
            }
            if (localGitBranch == null) {
                return this.createLocalGitBranch(remoteGitRef.getName(), true, remoteGitRefSHA);
            }
            return this.createLocalGitBranch(localGitBranch.getName(), true, remoteGitRefSHA);
        }
        StringBuilder gitBranchesSHAReportStringBuilder = new StringBuilder();
        gitBranchesSHAReportStringBuilder.append(this._getLocalGitBranchesSHAReport());
        gitBranchesSHAReportStringBuilder.append("\nRemote Git branch\n    ");
        gitBranchesSHAReportStringBuilder.append(remoteGitRef.getName());
        gitBranchesSHAReportStringBuilder.append(": ");
        gitBranchesSHAReportStringBuilder.append(remoteGitRef.getSHA());
        RemoteGitRepository remoteGitRepository = remoteGitRef.getRemoteGitRepository();
        String remoteURL = remoteGitRepository.getRemoteURL();
        if (JenkinsResultsParserUtil.isCINode() && remoteURL.contains("github.com:liferay/")) {
            String gitHubDevRemoteURL = remoteURL.replace("github.com:liferay/", "github-dev.liferay.com:liferay/");
            RemoteGitBranch gitHubDevRemoteGitBranch = this.getRemoteGitBranch(remoteGitRef.getName(), gitHubDevRemoteURL);
            if (gitHubDevRemoteGitBranch != null) {
                this.fetch(null, noTags, gitHubDevRemoteGitBranch);
                if (this.localSHAExists(remoteGitRefSHA)) {
                    if (localGitBranch != null) {
                        return this.createLocalGitBranch(localGitBranch.getName(), true, remoteGitRefSHA);
                    }
                    return null;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git fetch -f ");
        if (noTags) {
            sb.append("--no-tags ");
        } else {
            sb.append("--tags ");
        }
        sb.append(remoteURL);
        String remoteGitRefName = remoteGitRef.getName();
        if (remoteGitRefName != null && !remoteGitRefName.isEmpty()) {
            sb.append(" ");
            sb.append(remoteGitRefName);
            if (localGitBranch != null) {
                sb.append(":");
                sb.append(localGitBranch.getName());
            }
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(retries, 30000L, 900000L, sb.toString());
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        if (executionResult.getExitValue() != 0) {
            System.out.println(executionResult.getStandardOut());
            System.out.println(executionResult.getStandardError());
            System.out.println(gitBranchesSHAReportStringBuilder.toString());
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to fetch remote Git ref ", remoteGitRefName, " after ", JenkinsResultsParserUtil.toDurationString(duration), "\n", executionResult.getStandardError()));
        }
        System.out.println("Fetch completed in " + JenkinsResultsParserUtil.toDurationString(duration));
        if (duration > 60000L) {
            System.out.println(gitBranchesSHAReportStringBuilder.toString());
        }
        if (JenkinsResultsParserUtil.isCINode() && remoteGitRef instanceof RemoteGitBranch && remoteURL.contains("github.com:liferay/") && (upstreamBranchSHA = this.getRemoteGitBranchSHA(remoteGitRef.getName(), this.getUpstreamGitRemote())) != null && upstreamBranchSHA.equals(remoteGitRef.getSHA())) {
            LocalGitBranch liferayGitHubLocalGitBranch = this.createLocalGitBranch(JenkinsResultsParserUtil.combine("temp-", remoteGitRef.getName()), true, remoteGitRef.getSHA());
            List<GitRemote> gitHubDevGitRemotes = GitHubDevSyncUtil.getGitHubDevGitRemotes(this);
            try {
                GitHubDevSyncUtil.pushToAllRemotes(true, liferayGitHubLocalGitBranch, remoteGitRef.getName(), gitHubDevGitRemotes);
            }
            finally {
                if (localGitBranch == null) {
                    this.deleteLocalGitBranch(liferayGitHubLocalGitBranch);
                }
                this.removeGitRemotes(gitHubDevGitRemotes);
            }
        }
        if (this.localSHAExists(remoteGitRefSHA) && localGitBranch != null) {
            return this.createLocalGitBranch(localGitBranch.getName(), true, remoteGitRefSHA);
        }
        return null;
    }

    public LocalGitBranch fetch(LocalGitBranch localGitBranch, RemoteGitBranch remoteGitBranch) {
        return this.fetch(localGitBranch, true, remoteGitBranch);
    }

    public LocalGitBranch fetch(RemoteGitRef remoteGitRef) {
        return this.fetch(null, true, remoteGitRef);
    }

    public LocalGitBranch fetch(RemoteGitRef remoteGitRef, int retries) {
        return this.fetch(null, true, remoteGitRef, retries);
    }

    public void fetch(RemoteGitRepository remoteGitRepository) {
        this.fetch(remoteGitRepository.getRemoteURL());
    }

    public void fetch(RemoteGitRepository remoteGitRepository, boolean noTags) {
        this.fetch(remoteGitRepository.getRemoteURL(), noTags);
    }

    public void fetch(String remoteURL) {
        this.fetch(remoteURL, true);
    }

    public void fetch(String remoteURL, boolean noTags) {
        if (remoteURL == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Remote URL is null");
        }
        if (!GitUtil.isValidRemoteURL(remoteURL)) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Invalid remote url " + remoteURL);
        }
        StringBuilder gitBranchesSHAReportStringBuilder = new StringBuilder();
        gitBranchesSHAReportStringBuilder.append(this._getLocalGitBranchesSHAReport());
        gitBranchesSHAReportStringBuilder.append("\n");
        gitBranchesSHAReportStringBuilder.append(this._getRemoteGitBranchesSHAReport(null, remoteURL));
        StringBuilder sb = new StringBuilder();
        sb.append("git fetch -f");
        if (noTags) {
            sb.append(" --no-tags");
        } else {
            sb.append(" --tags");
        }
        sb.append(" ");
        sb.append(remoteURL);
        sb.append(" refs/heads/*:refs/remotes/origin/*");
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(3, 30000L, 1800000L, sb.toString());
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        if (executionResult.getExitValue() != 0) {
            System.out.println(gitBranchesSHAReportStringBuilder.toString());
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to fetch remote url ", remoteURL, " after ", JenkinsResultsParserUtil.toDurationString(duration), "\n", executionResult.getStandardError()));
        }
        System.out.println("Fetch completed in " + JenkinsResultsParserUtil.toDurationString(duration));
        if (duration > 60000L) {
            System.out.println(gitBranchesSHAReportStringBuilder.toString());
        }
    }

    public LocalGitBranch fetch(String branchName, LocalGitBranch localGitBranch) {
        if (localGitBranch == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Local Git branch is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git fetch -f --no-tags ");
        sb.append(String.valueOf(localGitBranch.getDirectory()));
        sb.append(" ");
        sb.append(localGitBranch.getName());
        if (branchName != null && !branchName.isEmpty()) {
            sb.append(":");
            sb.append(branchName);
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(3, 30000L, 1800000L, sb.toString());
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to fetch from local Git repository ", String.valueOf(localGitBranch.getDirectory()), "\n", executionResult.getStandardError()));
        }
        String durationString = JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start);
        System.out.println("Fetch completed in " + durationString);
        return this.createLocalGitBranch(localGitBranch.getName(), true, localGitBranch.getSHA());
    }

    public Set<File> findFiles(String fileName, String fileContentSnippet) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(fileName) || JenkinsResultsParserUtil.isNullOrEmpty(fileContentSnippet)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git grep ");
        sb.append(fileContentSnippet);
        sb.append(" | grep ");
        sb.append(fileName);
        GitUtil.ExecutionResult result = this.executeBashCommands(5, 1000L, 30000L, sb.toString());
        if (result.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to run: git grep");
        }
        Pattern pattern = Pattern.compile(JenkinsResultsParserUtil.combine("(?<filePath>.+/", fileName, ")\\:.+"));
        Matcher matcher = pattern.matcher(result.getStandardOut());
        HashSet<File> files = new HashSet<File>();
        while (matcher.find()) {
            files.add(new File(this.getWorkingDirectory(), matcher.group("filePath")));
        }
        return files;
    }

    public void gc() {
        int retries = 0;
        while (true) {
            GitUtil.ExecutionResult executionResult = null;
            boolean exceptionThrown = false;
            try {
                executionResult = this.executeBashCommands(1, 30000L, 3600000L, "git gc");
            }
            catch (RuntimeException runtimeException) {
                exceptionThrown = true;
            }
            System.out.println(executionResult.getStandardOut());
            if (exceptionThrown || executionResult.getExitValue() != 0) {
                String standardError = executionResult.getStandardError();
                Matcher matcher = _badRefPattern.matcher(standardError);
                if (matcher.find()) {
                    File badRefFile = new File(this.getWorkingDirectory(), ".git/" + matcher.group("badRef"));
                    badRefFile.delete();
                }
                if (retries > 1) {
                    throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to garbage collect Git\n", standardError));
                }
            } else {
                return;
            }
            ++retries;
            JenkinsResultsParserUtil.sleep(30000L);
            System.out.println(JenkinsResultsParserUtil.combine("Retry garbage collect Git in ", String.valueOf(30000L), "ms"));
        }
    }

    public List<String> getBranchNamesContainingSHA(String sha) {
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git branch --contains " + sha);
        if (executionResult.getExitValue() != 0) {
            String standardError = executionResult.getStandardError();
            if (standardError.contains("no such commit")) {
                return Collections.emptyList();
            }
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get branches with SHA ", sha, "\n", standardError));
        }
        String standardOut = executionResult.getStandardOut();
        if (standardOut.contains("no such commit")) {
            return Collections.emptyList();
        }
        String[] lines = standardOut.split("\n");
        ArrayList<String> branchNamesList = new ArrayList<String>(lines.length - 1);
        for (String line : lines) {
            String branchName = line.trim();
            if (branchName.startsWith("* ")) {
                branchName = branchName.substring(2);
            }
            if (branchName.isEmpty()) continue;
            branchNamesList.add(branchName);
        }
        return branchNamesList;
    }

    public String getCurrentBranchName() {
        return this.getCurrentBranchName(false);
    }

    public String getCurrentBranchName(boolean required) {
        this.waitForIndexLock();
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git branch | grep \\*");
        if (executionResult.getExitValue() != 0) {
            System.out.println(executionResult.getStandardError());
            if (required) {
                throw new GitWorkingDirectoryRuntimeException(this, "Unable to find required local branch HEAD");
            }
            return null;
        }
        String currentBranchName = executionResult.getStandardOut();
        currentBranchName = currentBranchName.replaceFirst("\\*\\s*", "");
        if ((currentBranchName = currentBranchName.trim()).isEmpty()) {
            return null;
        }
        return currentBranchName;
    }

    public LocalGitBranch getCurrentLocalGitBranch() {
        String currentBranchName = this.getCurrentBranchName();
        if (currentBranchName == null) {
            this.checkoutUpstreamLocalGitBranch();
            return this.getUpstreamLocalGitBranch();
        }
        return this.getLocalGitBranch(currentBranchName);
    }

    public List<File> getDeletedFilesList() {
        return this.getDeletedFilesList(false, null, null);
    }

    public List<File> getDeletedFilesList(boolean checkUnstagedFiles, List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers) {
        String gitDiffCommandString;
        List<File> deletedFiles;
        LocalGitBranch currentLocalGitBranch = this.getCurrentLocalGitBranch();
        if (currentLocalGitBranch == null) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to determine the current branch");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git diff --diff-filter=ADMR --name-only ");
        sb.append(this.getMergeBaseCommitSHA(currentLocalGitBranch, this.getLocalGitBranch(this.getUpstreamBranchName(), true)));
        if (!checkUnstagedFiles) {
            sb.append(" ");
            sb.append(currentLocalGitBranch.getSHA());
        }
        if ((deletedFiles = _deletedFilesMap.get(gitDiffCommandString = sb.toString())) == null) {
            GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, gitDiffCommandString);
            if (executionResult.getExitValue() == 1) {
                return Collections.emptyList();
            }
            if (executionResult.getExitValue() != 0) {
                throw new GitWorkingDirectoryRuntimeException(this, "Unable to get current branch modified files\n" + executionResult.getStandardError());
            }
            deletedFiles = new ArrayList<File>();
            String gitDiffOutput = executionResult.getStandardOut();
            for (String line : gitDiffOutput.split("\n")) {
                File deletedFile = new File(this._workingDirectory, line);
                if (deletedFile.exists()) continue;
                deletedFiles.add(deletedFile);
            }
            _deletedFilesMap.put(gitDiffCommandString, deletedFiles);
        }
        return JenkinsResultsParserUtil.getIncludedFiles(excludesPathMatchers, includesPathMatchers, deletedFiles);
    }

    public String getGitConfigProperty(String gitConfigPropertyName) {
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git config " + gitConfigPropertyName);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to read Git config property ", gitConfigPropertyName, "\n", executionResult.getStandardError()));
        }
        String configProperty = executionResult.getStandardOut();
        if (configProperty != null) {
            configProperty = configProperty.trim();
        }
        if (configProperty == null || configProperty.isEmpty()) {
            return null;
        }
        return configProperty;
    }

    public Boolean getGitConfigPropertyBoolean(String gitConfigPropertyName, Boolean defaultValue) {
        String gitConfigProperty = this.getGitConfigProperty(gitConfigPropertyName);
        if (gitConfigProperty == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return null;
        }
        return Boolean.parseBoolean(gitConfigProperty);
    }

    public File getGitDirectory() {
        return this._gitDirectory;
    }

    public GitRemote getGitRemote(String name) {
        if (name.equals("upstream")) {
            name = "upstream-temp";
        }
        if (this._gitRemotes.isEmpty()) {
            this.getGitRemotes();
        }
        name = name.trim();
        return this._gitRemotes.get(name);
    }

    public Set<String> getGitRemoteNames() {
        Map<String, GitRemote> gitRemotes = this.getGitRemotes();
        return gitRemotes.keySet();
    }

    public Map<String, GitRemote> getGitRemotes() {
        if (!this._gitRemotes.isEmpty()) {
            return this._gitRemotes;
        }
        int retries = 0;
        String standardOut = null;
        while (true) {
            if (retries > 1) {
                return this._gitRemotes;
            }
            GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git remote -v");
            if (executionResult.getExitValue() != 0) {
                throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get list of Git remotes\n", executionResult.getStandardError()));
            }
            standardOut = executionResult.getStandardOut();
            if (!(standardOut = standardOut.trim()).isEmpty()) break;
            ++retries;
            JenkinsResultsParserUtil.sleep(1000L);
        }
        Object[] lines = standardOut.split("\n");
        Arrays.sort(lines);
        int x = 0;
        for (int i = 0; i < lines.length; ++i) {
            Object line = lines[i];
            if (line == null || ((String)(line = ((String)line).trim())).isEmpty()) continue;
            x = i;
            break;
        }
        lines = (String[])Arrays.copyOfRange(lines, x, lines.length);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Found Git remotes: ");
            for (int i = 0; i < lines.length; i += 2) {
                GitRemote gitRemote = new GitRemote(this, (String[])Arrays.copyOfRange(lines, i, i + 2));
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(gitRemote.getName());
                this._gitRemotes.put(gitRemote.getName(), gitRemote);
            }
            System.out.println(sb);
        }
        catch (Throwable throwable) {
            System.out.println("Unable to parse Git remotes\n" + standardOut);
            throw throwable;
        }
        return this._gitRemotes;
    }

    public String getGitRepositoryName() {
        return this._gitRepositoryName;
    }

    public String getGitRepositoryUsername() {
        return this._gitRepositoryUsername;
    }

    public String getLatestCommitSHA() {
        List<LocalGitCommit> localGitCommits = this.log(1);
        LocalGitCommit latestLocalGitCommit = localGitCommits.get(0);
        return latestLocalGitCommit.getSHA();
    }

    public LocalGitBranch getLocalGitBranch(String branchName) {
        return this.getLocalGitBranch(branchName, false);
    }

    public LocalGitBranch getLocalGitBranch(String branchName, boolean required) {
        if (branchName.equals(this.getUpstreamBranchName())) {
            return this.getUpstreamLocalGitBranch();
        }
        if (!this.localGitBranchExists(branchName)) {
            return null;
        }
        return this._getLocalGitBranch(branchName, required);
    }

    public List<LocalGitBranch> getLocalGitBranches(String branchName) {
        LocalGitRepository localGitRepository;
        block5: {
            String upstreamBranchName = this.getUpstreamBranchName();
            localGitRepository = GitRepositoryFactory.getLocalGitRepository(this.getGitRepositoryName(), upstreamBranchName, this.getWorkingDirectory());
            if (branchName != null) {
                try {
                    return Arrays.asList(GitBranchFactory.newLocalGitBranch(localGitRepository, branchName, this.getLocalGitBranchSHA(branchName)));
                }
                catch (Exception exception) {
                    if (branchName.equals(upstreamBranchName)) break block5;
                    return null;
                }
            }
        }
        List<String> localGitBranchNames = this.getLocalGitBranchNames();
        ArrayList<LocalGitBranch> localGitBranches = new ArrayList<LocalGitBranch>(localGitBranchNames.size());
        Map<String, String> localGitBranchesShaMap = this.getLocalGitBranchesShaMap();
        for (String localGitBranchName : localGitBranchNames) {
            if (!localGitBranchesShaMap.containsKey(localGitBranchName)) {
                System.out.println("Unable to find SHA for local Git branch " + localGitBranchName);
                continue;
            }
            localGitBranches.add(GitBranchFactory.newLocalGitBranch(localGitRepository, localGitBranchName, localGitBranchesShaMap.get(localGitBranchName)));
        }
        return localGitBranches;
    }

    public String getLocalGitBranchSHA(String localGitBranchName) {
        if (localGitBranchName == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Local branch name is null");
        }
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git rev-parse " + localGitBranchName);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to determine SHA of branch ", localGitBranchName, "\n", executionResult.getStandardError()));
        }
        return executionResult.getStandardOut();
    }

    public String getMergeBaseCommitSHA(LocalGitBranch ... localGitBranches) {
        if (localGitBranches.length < 2) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Unable to perform merge-base with less than two branches");
        }
        StringBuilder sb = new StringBuilder("git merge-base");
        for (LocalGitBranch localGitBranch : localGitBranches) {
            sb.append(" ");
            sb.append(localGitBranch.getName());
        }
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, sb.toString());
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get merge base commit SHA\n", executionResult.getStandardError()));
        }
        return executionResult.getStandardOut();
    }

    public String getMergeBaseCommitSHA(String ... refNames) {
        if (refNames.length < 2) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Unable to perform merge-base with less than two commits");
        }
        StringBuilder sb = new StringBuilder("git merge-base");
        for (String refName : refNames) {
            sb.append(" ");
            sb.append(refName);
        }
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, sb.toString());
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get merge base commit SHA\n", executionResult.getStandardError()));
        }
        return executionResult.getStandardOut();
    }

    public List<File> getModifiedDirsList(boolean checkUnstagedFiles, List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers) {
        return this.getModifiedDirsList(checkUnstagedFiles, excludesPathMatchers, includesPathMatchers, this.getWorkingDirectory());
    }

    public List<File> getModifiedDirsList(boolean checkUnstagedFiles, List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers, File rootDirectory) {
        List<File> subdirectories = this.getSubdirectoriesContainingFiles(1, this.getModifiedFilesList(checkUnstagedFiles, null, null), rootDirectory);
        return JenkinsResultsParserUtil.getIncludedFiles(excludesPathMatchers, includesPathMatchers, subdirectories);
    }

    public Set<File> getModifiedFilesInCommitRange(String startingCommitSHA, String endingCommitSHA) {
        StringBuilder sb = new StringBuilder();
        sb.append("git log --name-status --no-renames --pretty=\"format:\" \"");
        sb.append(startingCommitSHA);
        sb.append("..");
        sb.append(endingCommitSHA);
        sb.append("\" | tr '\\t' ' ' | sed 's/^[^ ]* *//'");
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, sb.toString());
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get modified files\n", executionResult.getStandardError()));
        }
        String standardOut = executionResult.getStandardOut();
        HashSet<File> modifiedFiles = new HashSet<File>();
        for (String modifiedFilePath : standardOut.split("\\s+")) {
            modifiedFiles.add(new File(this.getWorkingDirectory(), modifiedFilePath));
        }
        return modifiedFiles;
    }

    public List<File> getModifiedFilesList() {
        return this.getModifiedFilesList(false, null, null);
    }

    public List<File> getModifiedFilesList(boolean checkUnstagedFiles) {
        return this.getModifiedFilesList(checkUnstagedFiles, null, null);
    }

    public List<File> getModifiedFilesList(boolean checkUnstagedFiles, List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers) {
        String gitDiffCommandString;
        List<File> modifiedFiles;
        LocalGitBranch currentLocalGitBranch = this.getCurrentLocalGitBranch();
        if (currentLocalGitBranch == null) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to determine the current branch");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git diff --diff-filter=ADMR --name-only ");
        sb.append(this.getMergeBaseCommitSHA(currentLocalGitBranch, this.getLocalGitBranch(this.getUpstreamBranchName(), true)));
        if (!checkUnstagedFiles) {
            sb.append(" ");
            sb.append(currentLocalGitBranch.getSHA());
        }
        if ((modifiedFiles = _modifiedFilesMap.get(gitDiffCommandString = sb.toString())) == null) {
            GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, gitDiffCommandString);
            if (executionResult.getExitValue() == 1) {
                return Collections.emptyList();
            }
            if (executionResult.getExitValue() != 0) {
                throw new GitWorkingDirectoryRuntimeException(this, "Unable to get current branch modified files\n" + executionResult.getStandardError());
            }
            modifiedFiles = new ArrayList<File>();
            String gitDiffOutput = executionResult.getStandardOut();
            for (String line : gitDiffOutput.split("\n")) {
                modifiedFiles.add(new File(this._workingDirectory, line));
            }
            _modifiedFilesMap.put(gitDiffCommandString, modifiedFiles);
        }
        return JenkinsResultsParserUtil.getIncludedFiles(excludesPathMatchers, includesPathMatchers, modifiedFiles);
    }

    public List<File> getModifiedFilesList(List<PathMatcher> excludesPathMatchers, List<PathMatcher> includesPathMatchers) {
        return this.getModifiedFilesList(false, excludesPathMatchers, includesPathMatchers);
    }

    public LocalGitBranch getRebasedLocalGitBranch(PullRequest pullRequest) {
        return this.getRebasedLocalGitBranch(pullRequest.getLocalSenderBranchName(), pullRequest.getSenderBranchName(), pullRequest.getSenderRemoteURL(), pullRequest.getSenderSHA(), pullRequest.getUpstreamRemoteGitBranchName(), pullRequest.getUpstreamBranchSHA());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalGitBranch getRebasedLocalGitBranch(String rebasedLocalGitBranchName, String senderBranchName, String senderRemoteURL, String senderSHA, String upstreamBranchName, String upstreamBranchSHA) {
        String currentBranchName = this.getCurrentBranchName();
        LocalGitBranch tempLocalGitBranch = null;
        try {
            if (currentBranchName == null || currentBranchName.equals(rebasedLocalGitBranchName)) {
                tempLocalGitBranch = this.createLocalGitBranch("temp-" + JenkinsResultsParserUtil.getCurrentTimeMillis());
                this.checkoutLocalGitBranch(tempLocalGitBranch);
            }
            RemoteGitRef senderRemoteGitRef = this.getRemoteGitRef(senderBranchName, senderRemoteURL, true);
            this.fetch(senderRemoteGitRef);
            LocalGitBranch rebasedLocalGitBranch = this.createLocalGitBranch(rebasedLocalGitBranchName, true, senderSHA);
            RemoteGitBranch upstreamRemoteGitBranch = this.getRemoteGitBranch(upstreamBranchName, this.getUpstreamGitRemote(), true);
            if (upstreamBranchSHA == null) {
                upstreamBranchSHA = upstreamRemoteGitBranch.getSHA();
            }
            if (!this.localSHAExists(upstreamBranchSHA)) {
                this.fetch(upstreamRemoteGitBranch);
            }
            LocalGitBranch upstreamLocalGitBranch = this.createLocalGitBranch(upstreamRemoteGitBranch.getName(), true, upstreamBranchSHA);
            rebasedLocalGitBranch = this.rebase(true, upstreamLocalGitBranch, rebasedLocalGitBranch);
            this.clean();
            this.reset("--hard");
            LocalGitBranch localGitBranch = rebasedLocalGitBranch;
            if (tempLocalGitBranch != null) {
                this.deleteLocalGitBranch(tempLocalGitBranch);
            }
            return localGitBranch;
        }
        catch (Throwable throwable) {
            if (tempLocalGitBranch != null) {
                this.deleteLocalGitBranch(tempLocalGitBranch);
            }
            throw throwable;
        }
    }

    public RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, GitRemote gitRemote) {
        return this.getRemoteGitBranch(remoteGitBranchName, gitRemote.getRemoteURL(), false);
    }

    public RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, GitRemote gitRemote, boolean required) {
        return this.getRemoteGitBranch(remoteGitBranchName, gitRemote.getRemoteURL(), required);
    }

    public RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, RemoteGitRepository remoteGitRepository) {
        return this.getRemoteGitBranch(remoteGitBranchName, remoteGitRepository.getRemoteURL(), false);
    }

    public RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, RemoteGitRepository remoteGitRepository, boolean required) {
        return this.getRemoteGitBranch(remoteGitBranchName, remoteGitRepository.getRemoteURL(), required);
    }

    public RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, String remoteURL) {
        return this.getRemoteGitBranch(remoteGitBranchName, remoteURL, false);
    }

    public RemoteGitBranch getRemoteGitBranch(String remoteGitBranchName, String remoteURL, boolean required) {
        List<RemoteGitBranch> remoteGitBranches = this.getRemoteGitBranches(remoteGitBranchName, remoteURL);
        for (RemoteGitBranch remoteGitBranch : remoteGitBranches) {
            if (!remoteGitBranchName.equals(remoteGitBranch.getName())) continue;
            return remoteGitBranch;
        }
        if (required) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to find required branch ", remoteGitBranchName, " from remote URL ", remoteURL));
        }
        return null;
    }

    public List<RemoteGitBranch> getRemoteGitBranches(GitRemote gitRemote) {
        return this.getRemoteGitBranches(null, gitRemote.getRemoteURL());
    }

    public List<RemoteGitBranch> getRemoteGitBranches(RemoteGitRepository remoteGitRepository) {
        return this.getRemoteGitBranches(null, remoteGitRepository.getRemoteURL());
    }

    public List<RemoteGitBranch> getRemoteGitBranches(String remoteURL) {
        return this.getRemoteGitBranches(null, remoteURL);
    }

    public List<RemoteGitBranch> getRemoteGitBranches(String remoteGitBranchName, GitRemote gitRemote) {
        return this.getRemoteGitBranches(remoteGitBranchName, gitRemote.getRemoteURL());
    }

    public List<RemoteGitBranch> getRemoteGitBranches(String remoteGitBranchName, RemoteGitRepository remoteGitRepository) {
        return this.getRemoteGitBranches(remoteGitBranchName, remoteGitRepository.getRemoteURL());
    }

    public List<RemoteGitBranch> getRemoteGitBranches(String remoteGitBranchName, String remoteURL) {
        return GitUtil.getRemoteGitBranches(remoteGitBranchName, this._workingDirectory, remoteURL);
    }

    public List<String> getRemoteGitBranchNames(GitRemote gitRemote) {
        return this.getRemoteGitBranchNames(gitRemote.getRemoteURL());
    }

    public List<String> getRemoteGitBranchNames(RemoteGitRepository remoteGitRepository) {
        return this.getRemoteGitBranchNames(remoteGitRepository.getRemoteURL());
    }

    public List<String> getRemoteGitBranchNames(String remoteURL) {
        ArrayList<String> remoteGitBranchNames = new ArrayList<String>();
        List<RemoteGitBranch> remoteGitBranches = this.getRemoteGitBranches(remoteURL);
        for (RemoteGitBranch remoteGitBranch : remoteGitBranches) {
            remoteGitBranchNames.add(remoteGitBranch.getName());
        }
        return remoteGitBranchNames;
    }

    public String getRemoteGitBranchSHA(String remoteGitBranchName, GitRemote gitRemote) {
        return this.getRemoteGitBranchSHA(remoteGitBranchName, gitRemote.getRemoteURL());
    }

    public String getRemoteGitBranchSHA(String remoteGitBranchName, RemoteGitRepository remoteGitRepository) {
        return this.getRemoteGitBranchSHA(remoteGitBranchName, remoteGitRepository.getRemoteURL());
    }

    public String getRemoteGitBranchSHA(String remoteGitBranchName, String remoteURL) {
        if (remoteGitBranchName == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Remote branch name is null");
        }
        if (remoteURL == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Remote URL is null");
        }
        if (!GitUtil.isValidRemoteURL(remoteURL)) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Invalid remote url " + remoteURL);
        }
        String command = JenkinsResultsParserUtil.combine("git ls-remote -h ", remoteURL, " ", remoteGitBranchName);
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(3, 30000L, 600000L, command);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get remote branch SHA ", remoteURL, " ", remoteGitBranchName, "\n", executionResult.getStandardError()));
        }
        String input = executionResult.getStandardOut();
        for (String line : input.split("\n")) {
            Matcher matcher = GitRemote.gitLsRemotePattern.matcher(line);
            if (!matcher.find()) continue;
            return matcher.group("sha");
        }
        return null;
    }

    public RemoteGitRef getRemoteGitRef(String remoteGitRefName, GitRemote gitRemote, boolean required) {
        return this.getRemoteGitRef(remoteGitRefName, gitRemote.getRemoteURL(), required);
    }

    public RemoteGitRef getRemoteGitRef(String remoteGitRefName, String remoteURL, boolean required) {
        List<RemoteGitRef> remoteGitRefs = GitUtil.getRemoteGitRefs(remoteGitRefName, this.getWorkingDirectory(), remoteURL);
        for (RemoteGitRef remoteGitRef : remoteGitRefs) {
            if (!remoteGitRefName.equals(remoteGitRef.getName())) continue;
            return remoteGitRef;
        }
        if (required) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to find required ref ", remoteGitRefName, " from remote URL ", remoteURL));
        }
        return null;
    }

    public String getUpstreamBranchName() {
        return this._upstreamBranchName;
    }

    public GitRemote getUpstreamGitRemote() {
        Map<String, GitRemote> gitRemotes = this.getGitRemotes();
        GitRemote gitRemote = gitRemotes.get("upstream-temp");
        if (gitRemote == null) {
            gitRemote = gitRemotes.get("upstream");
        }
        if (gitRemote == null) {
            gitRemote = this.addGitRemote(true, "upstream", JenkinsResultsParserUtil.combine("git@github.com:liferay/", this.getGitRepositoryName(), ".git"));
        }
        return gitRemote;
    }

    public LocalGitBranch getUpstreamLocalGitBranch() {
        String upstreamBranchName = this.getUpstreamBranchName();
        if (this.localGitBranchExists(upstreamBranchName)) {
            return this._getLocalGitBranch(upstreamBranchName, true);
        }
        RemoteGitBranch upstreamRemoteGitBranch = this.getRemoteGitBranch(upstreamBranchName, this.getGitRemote("upstream"));
        if (upstreamRemoteGitBranch == null) {
            upstreamRemoteGitBranch = this.getRemoteGitBranch(upstreamBranchName, this.getGitRemote("origin"));
        }
        String upstreamBranchSHA = upstreamRemoteGitBranch.getSHA();
        this.fetch(upstreamRemoteGitBranch);
        String currentBranchName = this.getCurrentBranchName();
        if (currentBranchName == null) {
            this.checkoutLocalGitBranch(this.createLocalGitBranch(upstreamBranchName + "-temp-" + JenkinsResultsParserUtil.getCurrentTimeMillis(), true, upstreamBranchSHA));
        }
        return this.createLocalGitBranch(upstreamBranchName, true, upstreamBranchSHA);
    }

    public RemoteGitBranch getUpstreamRemoteGitBranch() {
        return this.getRemoteGitBranch(this.getUpstreamBranchName(), this.getUpstreamGitRemote());
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public boolean gitRemoteExists(String gitRemoteName) {
        return this.getGitRemote(gitRemoteName) != null;
    }

    public boolean isOnlyPoshiFilesModified() {
        return this.isOnlyMatchingFilesModified(_poshiFileNamesMultiPattern);
    }

    public boolean isRemoteGitRepositoryAlive(String remoteURL) {
        String command = JenkinsResultsParserUtil.combine("git ls-remote -h ", remoteURL, " HEAD");
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 600000L, command);
        if (executionResult.getExitValue() != 0) {
            System.out.println("Unable to connect to " + remoteURL);
            return false;
        }
        System.out.println(remoteURL + " is alive");
        return true;
    }

    public boolean localGitBranchExists(String branchName) {
        this.waitForIndexLock();
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git branch | grep [\\s\\*]*" + branchName + "$");
        if (executionResult.getExitValue() == 0) {
            String standardOut = executionResult.getStandardOut();
            return !standardOut.isEmpty();
        }
        return false;
    }

    public boolean localSHAExists(String sha) {
        String command = "git cat-file -t " + sha;
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 180000L, command);
        return executionResult.getExitValue() == 0;
    }

    public List<LocalGitCommit> log(int num) {
        return this._log(0, num, null, null);
    }

    public List<LocalGitCommit> log(int num, File file) {
        return this._log(0, num, file, null);
    }

    public List<LocalGitCommit> log(int start, int num) {
        return this._log(start, num, null, null);
    }

    public List<LocalGitCommit> log(int start, int num, String sha) {
        return this._log(start, num, null, sha);
    }

    public List<LocalGitCommit> log(String branch1, String branch2) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("git log");
        sb.append(" --oneline ");
        sb.append(branch1);
        sb.append(" ^");
        sb.append(branch2);
        sb.append(" | wc -l");
        GitUtil.ExecutionResult result = this.executeBashCommands(5, 1000L, 30000L, sb.toString());
        if (result.getExitValue() != 0) {
            throw new IOException(JenkinsResultsParserUtil.combine("Unable to find log between ", branch1, " and ", branch2, ":\n\n", result.getStandardError()));
        }
        return this.log(Integer.parseInt(result.getStandardOut()));
    }

    public RemoteGitBranch pushToRemoteGitRepository(boolean force, LocalGitBranch localGitBranch, String remoteGitBranchName, GitRemote gitRemote) {
        return this.pushToRemoteGitRepository(force, localGitBranch, remoteGitBranchName, gitRemote.getRemoteURL());
    }

    public RemoteGitBranch pushToRemoteGitRepository(boolean force, LocalGitBranch localGitBranch, String remoteGitBranchName, RemoteGitRepository remoteGitRepository) {
        return this.pushToRemoteGitRepository(force, localGitBranch, remoteGitBranchName, remoteGitRepository.getRemoteURL());
    }

    public RemoteGitBranch pushToRemoteGitRepository(boolean force, LocalGitBranch localGitBranch, String remoteGitBranchName, String remoteURL) {
        if (localGitBranch == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Local Git branch is null");
        }
        if (remoteURL == null) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Remote URL is null");
        }
        if (!GitUtil.isValidRemoteURL(remoteURL)) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Invalid remote url " + remoteURL);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git push ");
        if (force) {
            sb.append("-f ");
        }
        sb.append(remoteURL);
        sb.append(" ");
        sb.append(localGitBranch.getName());
        if (remoteGitBranchName != null) {
            sb.append(":");
            sb.append(remoteGitBranchName);
        }
        try {
            GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 600000L, sb.toString());
            if (executionResult.getExitValue() != 0) {
                return null;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
        return (RemoteGitBranch)GitBranchFactory.newRemoteGitRef(GitRepositoryFactory.getRemoteGitRepository(remoteURL), remoteGitBranchName, localGitBranch.getSHA(), "heads");
    }

    public LocalGitBranch rebase(boolean abortOnFail, LocalGitBranch baseLocalGitBranch, LocalGitBranch localGitBranch) {
        List<String> branchNamesContainingSHA = this.getBranchNamesContainingSHA(baseLocalGitBranch.getSHA());
        if (branchNamesContainingSHA.contains(localGitBranch.getName())) {
            this.checkoutLocalGitBranch(localGitBranch);
            return localGitBranch;
        }
        this.checkoutLocalGitBranch(baseLocalGitBranch);
        this.reset("--hard " + baseLocalGitBranch.getSHA());
        String rebaseCommand = JenkinsResultsParserUtil.combine("git rebase ", baseLocalGitBranch.getName(), " ", localGitBranch.getName());
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 600000L, rebaseCommand);
        if (executionResult.getExitValue() != 0) {
            if (abortOnFail) {
                this.rebaseAbort();
            }
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to rebase ", localGitBranch.getName(), " to ", baseLocalGitBranch.getName(), "\n", executionResult.getStandardError()));
        }
        return this.getCurrentLocalGitBranch();
    }

    public void rebaseAbort() {
        this.rebaseAbort(true);
    }

    public void rebaseAbort(boolean ignoreFailure) {
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git rebase --abort");
        if (!ignoreFailure && executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to abort rebase\n", executionResult.getStandardError()));
        }
    }

    public boolean refContainsSHA(String ref, String sha) {
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git merge-base --is-ancestor " + sha + " " + ref);
        return executionResult.getExitValue() == 0;
    }

    public boolean remoteGitBranchExists(String branchName, GitRemote gitRemote) {
        return this.remoteGitBranchExists(branchName, gitRemote.getRemoteURL());
    }

    public boolean remoteGitBranchExists(String branchName, RemoteGitRepository remoteGitRepository) {
        return this.remoteGitBranchExists(branchName, remoteGitRepository.getRemoteURL());
    }

    public boolean remoteGitBranchExists(String branchName, String remoteURL) {
        return this.getRemoteGitBranch(branchName, remoteURL) != null;
    }

    public void removeGitRemote(GitRemote gitRemote) {
        if (gitRemote == null || !this.gitRemoteExists(gitRemote.getName())) {
            return;
        }
        this._gitRemotes.remove(gitRemote.getName());
    }

    public void removeGitRemotes(List<GitRemote> gitRemotes) {
        for (GitRemote gitRemote : gitRemotes) {
            this.removeGitRemote(gitRemote);
        }
    }

    public void reset(String options) {
        String command = "git reset " + options;
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(2, 30000L, 300000L, command);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to reset\n", executionResult.getStandardError()));
        }
    }

    public void setCacheBashCommands(boolean cacheBashCommands) {
        this._cacheBashCommands = cacheBashCommands;
    }

    public void stageFileInCurrentLocalGitBranch(String fileName) {
        String command = "git stage " + fileName;
        GitUtil.ExecutionResult result = this.executeBashCommands(1, 30000L, 120000L, command);
        if (result.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to stage file " + fileName);
        }
    }

    public String status() {
        for (int i = 0; i < 5; ++i) {
            try {
                String gitStatus = this._status();
                gitStatus = gitStatus.replaceAll("Finished executing Bash commands.", "");
                if (!gitStatus.startsWith("On branch")) {
                    throw new GitWorkingDirectoryRuntimeException(this, "Unable to run: git status");
                }
                return gitStatus;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                JenkinsResultsParserUtil.sleep(1000L);
                continue;
            }
        }
        throw new GitWorkingDirectoryRuntimeException(this, "Unable to run: git status");
    }

    protected GitWorkingDirectory(String upstreamBranchName, String workingDirectoryPath) throws IOException {
        this(upstreamBranchName, workingDirectoryPath, null);
    }

    protected GitWorkingDirectory(String upstreamBranchName, String workingDirectoryPath, String gitRepositoryName) throws IOException {
        this.setWorkingDirectory(workingDirectoryPath);
        this._upstreamBranchName = upstreamBranchName;
        GitRemote upstreamTempGitRemote = this.getGitRemote("upstream-temp");
        if (upstreamTempGitRemote != null) {
            this.removeGitRemote(upstreamTempGitRemote);
        }
        this.waitForIndexLock();
        if (gitRepositoryName == null || gitRepositoryName.equals("")) {
            gitRepositoryName = this.loadGitRepositoryName();
        }
        this._gitRepositoryName = gitRepositoryName;
        String remoteGitRepositoryName = this._getRemoteGitRepositoryName();
        RemoteGitRepository remoteGitRepository = GitRepositoryFactory.getRemoteGitRepository("github.com", remoteGitRepositoryName, JenkinsResultsParserUtil.getUpstreamUserName(remoteGitRepositoryName, this.getUpstreamBranchName()));
        this.addGitRemote(true, "upstream-temp", remoteGitRepository.getRemoteURL());
        this._gitRepositoryUsername = this.loadGitRepositoryUsername();
    }

    protected synchronized GitUtil.ExecutionResult executeBashCommands(int maxRetries, long retryDelay, long timeout, String ... commands) {
        String command = String.join((CharSequence)" ", commands);
        if (this._cacheBashCommands && this._executionResults.containsKey(command)) {
            System.out.println("Using cached excecution for: " + command);
            return this._executionResults.get(command);
        }
        GitUtil.ExecutionResult executionResult = GitUtil.executeBashCommands(maxRetries, retryDelay, timeout, this._workingDirectory, commands);
        this._executionResults.put(command, executionResult);
        return executionResult;
    }

    protected Map<String, String> getLocalGitBranchesShaMap() {
        String command = JenkinsResultsParserUtil.combine("git ls-remote -h ", JenkinsResultsParserUtil.getCanonicalPath(this.getWorkingDirectory()));
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 600000L, command);
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get local Git branch SHAs\n", executionResult.getStandardError()));
        }
        String input = executionResult.getStandardOut();
        String[] inputLines = input.split("\n");
        HashMap<String, String> localGitBranchesShaMap = new HashMap<String, String>();
        for (String line : inputLines) {
            Matcher matcher = GitRemote.gitLsRemotePattern.matcher(line);
            if (!matcher.find()) continue;
            localGitBranchesShaMap.put(matcher.group("name"), matcher.group("sha"));
        }
        return localGitBranchesShaMap;
    }

    protected List<String> getLocalGitBranchNames() {
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, "git for-each-ref refs/heads --format=\"%(refname)\"");
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to get local branch names\n", executionResult.getStandardError()));
        }
        String standardOut = executionResult.getStandardOut();
        return this.toShortNameList(Arrays.asList(standardOut.split("\n")));
    }

    protected LocalGitCommit getLocalGitCommit(String gitLogEntity) {
        Matcher matcher = _gitLogEntityPattern.matcher(gitLogEntity);
        if (!matcher.matches()) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, "Unable to find Git SHA");
        }
        int unixTimestamp = Integer.valueOf(matcher.group("commitTime"));
        long epochTimestamp = (long)unixTimestamp * 1000L;
        return GitCommitFactory.newLocalGitCommit(matcher.group("email"), this, matcher.group("message"), matcher.group("sha"), epochTimestamp);
    }

    protected File getRealGitDirectory(File gitFile) {
        String gitFileContent = null;
        try {
            gitFileContent = JenkinsResultsParserUtil.read(gitFile);
        }
        catch (IOException ioException) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to find real .git directory", ioException);
        }
        for (String line : gitFileContent.split("\n")) {
            Matcher matcher = _gitDirectoryPathPattern.matcher(line);
            if (!matcher.find()) continue;
            return new File(matcher.group(1));
        }
        throw new GitWorkingDirectoryIllegalArgumentException(this, "Unable to find real Git directory in " + gitFile.getPath());
    }

    protected List<File> getSubdirectoriesContainingFiles(int depth, List<File> files, File rootDirectory) {
        return JenkinsResultsParserUtil.getDirectoriesContainingFiles(JenkinsResultsParserUtil.getSubdirectories(depth, rootDirectory), files);
    }

    protected boolean isOnlyMatchingFilesModified(MultiPattern multiPattern) {
        for (File modifiedFile : this.getModifiedFilesList()) {
            if (multiPattern.matches(modifiedFile.getName()) != null) continue;
            return false;
        }
        return true;
    }

    protected String loadGitRepositoryName() {
        String gitRepositoryName;
        GitRemote upstreamGitRemote = this.getUpstreamGitRemote();
        String remoteURL = upstreamGitRemote.getRemoteURL();
        int x = remoteURL.lastIndexOf("/") + 1;
        int y = remoteURL.indexOf(".git");
        if (y == -1) {
            y = remoteURL.length();
        }
        if ((gitRepositoryName = remoteURL.substring(x, y)).equals("liferay-jenkins-tools-private")) {
            return gitRepositoryName;
        }
        if ((gitRepositoryName.equals("liferay-plugins-ee") || gitRepositoryName.equals("liferay-portal-ee")) && this._upstreamBranchName.equals("master")) {
            gitRepositoryName = gitRepositoryName.replace("-ee", "");
        }
        if (gitRepositoryName.contains("-private") && !this._upstreamBranchName.contains("-private")) {
            gitRepositoryName = gitRepositoryName.replace("-private", "");
        }
        return gitRepositoryName;
    }

    protected String loadGitRepositoryUsername() {
        GitRemote upstreamGitRemote = this.getUpstreamGitRemote();
        String remoteURL = upstreamGitRemote.getRemoteURL();
        int x = remoteURL.indexOf(":") + 1;
        int y = remoteURL.indexOf("/");
        return remoteURL.substring(x, y);
    }

    protected void setWorkingDirectory(String workingDirectoryPath) throws IOException {
        this._workingDirectory = new File(workingDirectoryPath);
        if (!this._workingDirectory.exists()) {
            throw new GitWorkingDirectoryFileNotFoundException(this, this._workingDirectory.getPath() + " is unavailable");
        }
        this._gitDirectory = new File(workingDirectoryPath, ".git");
        if (this._gitDirectory.isFile()) {
            this._gitDirectory = this.getRealGitDirectory(this._gitDirectory);
        }
        if (!this._gitDirectory.exists()) {
            throw new GitWorkingDirectoryFileNotFoundException(this, this._gitDirectory.getPath() + " is unavailable");
        }
    }

    protected List<String> toShortNameList(List<String> fullNameList) {
        ArrayList<String> shortNames = new ArrayList<String>(fullNameList.size());
        for (String fullName : fullNameList) {
            shortNames.add(fullName.substring("refs/heads/".length()));
        }
        return shortNames;
    }

    protected void waitForIndexLock() {
        int retries = 0;
        File file = new File(this._gitDirectory, "index.lock");
        while (file.exists()) {
            System.out.println("Waiting for index.lock to be cleared.");
            JenkinsResultsParserUtil.sleep(5000L);
            if (++retries < 24) continue;
            file.delete();
        }
    }

    private static List<String> _getBuildPropertyAsList(String key) {
        try {
            return JenkinsResultsParserUtil.getBuildPropertyAsList(true, key);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build property " + key, ioException);
        }
    }

    private LocalGitBranch _createLocalGitBranch(String localGitBranchName, boolean force, String startPoint) {
        String currentBranchName = this.getCurrentBranchName();
        ArrayList<String> commands = new ArrayList<String>();
        if (currentBranchName == null || currentBranchName.equals(localGitBranchName)) {
            String tempBranchName = "temp-" + JenkinsResultsParserUtil.getCurrentTimeMillis();
            RemoteGitBranch upstreamRemoteGitBranch = this.getUpstreamRemoteGitBranch();
            String upstreamGitBranchSHA = upstreamRemoteGitBranch.getSHA();
            if (!this.localSHAExists(upstreamGitBranchSHA)) {
                commands.add(JenkinsResultsParserUtil.combine("git fetch -f upstream ", upstreamRemoteGitBranch.getName(), ":", tempBranchName));
            } else {
                commands.add(JenkinsResultsParserUtil.combine("git branch -f ", tempBranchName, " ", upstreamGitBranchSHA));
            }
            commands.add(JenkinsResultsParserUtil.combine("git checkout -f ", tempBranchName));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git branch ");
        if (force) {
            sb.append("-f ");
        }
        sb.append(localGitBranchName);
        if (startPoint != null) {
            sb.append(" ");
            sb.append(startPoint);
        }
        commands.add(sb.toString());
        GitUtil.ExecutionResult executionResult = this.executeBashCommands(1, 30000L, 120000L, commands.toArray(new String[0]));
        if (executionResult.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to create local branch ", localGitBranchName, " at ", startPoint, "\n", executionResult.getStandardError()));
        }
        return this.getLocalGitBranch(localGitBranchName, true);
    }

    private boolean _deleteLocalGitBranches(String ... branchNames) {
        if (branchNames.length > 5) {
            throw new GitWorkingDirectoryIllegalArgumentException(this, JenkinsResultsParserUtil.combine("Unable to delete more than ", String.valueOf(5), " local Git branches at once"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git branch -D -f ");
        String joinedBranchNames = JenkinsResultsParserUtil.join(" ", branchNames);
        sb.append(joinedBranchNames);
        GitUtil.ExecutionResult executionResult = null;
        boolean exceptionThrown = false;
        try {
            executionResult = this.executeBashCommands(1, 30000L, 600000L, sb.toString());
        }
        catch (RuntimeException runtimeException) {
            exceptionThrown = true;
        }
        if (exceptionThrown || executionResult.getExitValue() != 0) {
            System.out.println(JenkinsResultsParserUtil.combine("Unable to delete local branches:", "\n    ", joinedBranchNames.replaceAll("\\s", "\n    ")));
            if (executionResult != null) {
                System.out.println(executionResult.getStandardError());
            }
            return false;
        }
        System.out.println(JenkinsResultsParserUtil.combine("Deleted local branches:", "\n    ", joinedBranchNames.replaceAll("\\s", "\n    ")));
        return true;
    }

    private boolean _deleteRemoteGitBranches(String remoteURL, String ... branchNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("git push --delete ");
        sb.append(remoteURL);
        sb.append(" ");
        String joinedBranchNames = JenkinsResultsParserUtil.join(" ", branchNames);
        sb.append(joinedBranchNames);
        GitUtil.ExecutionResult executionResult = null;
        boolean exceptionThrown = false;
        try {
            executionResult = this.executeBashCommands(1, 30000L, 600000L, sb.toString());
        }
        catch (RuntimeException runtimeException) {
            exceptionThrown = true;
        }
        if (exceptionThrown || executionResult.getExitValue() != 0) {
            System.out.println(JenkinsResultsParserUtil.combine("Unable to delete ", remoteURL, " branches:\n    ", joinedBranchNames.replaceAll("\\s", "\n    "), "\n", executionResult.getStandardError()));
            return false;
        }
        System.out.println(JenkinsResultsParserUtil.combine("Deleted ", remoteURL, " branches:", "\n    ", joinedBranchNames.replaceAll("\\s", "\n    ")));
        return true;
    }

    private LocalGitBranch _getLocalGitBranch(String branchName, boolean required) {
        List<LocalGitBranch> localGitBranches = this.getLocalGitBranches(branchName);
        if (localGitBranches != null && !localGitBranches.isEmpty()) {
            return localGitBranches.get(0);
        }
        if (required) {
            throw new GitWorkingDirectoryRuntimeException(this, JenkinsResultsParserUtil.combine("Unable to find required branch ", branchName, " from ", String.valueOf(this.getWorkingDirectory())));
        }
        return null;
    }

    private String _getLocalGitBranchesSHAReport() {
        StringBuilder sb = new StringBuilder("Local Git branches");
        for (LocalGitBranch localGitBranch : this.getLocalGitBranches(null)) {
            sb.append("\n    ");
            sb.append(localGitBranch.getName());
            sb.append(": ");
            sb.append(localGitBranch.getSHA());
        }
        return sb.toString();
    }

    private String _getRemoteGitBranchesSHAReport(String remoteGitBranchName, String remoteURL) {
        StringBuilder sb = new StringBuilder("Remote Git branches");
        for (RemoteGitBranch remoteGitBranch : this.getRemoteGitBranches(remoteGitBranchName, remoteURL)) {
            sb.append("\n    ");
            sb.append(remoteGitBranch.getName());
            sb.append(": ");
            sb.append(remoteGitBranch.getSHA());
        }
        return sb.toString();
    }

    private String _getRemoteGitRepositoryName() {
        String gitRepositoryName = this.getGitRepositoryName();
        if (_publicOnlyGitRepositoryNames.contains(gitRepositoryName)) {
            return GitUtil.getPublicRepositoryName(gitRepositoryName);
        }
        if (_privateOnlyGitRepositoryNames.contains(gitRepositoryName)) {
            return GitUtil.getPrivateRepositoryName(gitRepositoryName);
        }
        String upstreamBranchName = this.getUpstreamBranchName();
        if (upstreamBranchName.startsWith("faro-v") || upstreamBranchName.equals("master")) {
            return GitUtil.getPublicRepositoryName(gitRepositoryName);
        }
        return GitUtil.getPrivateRepositoryName(gitRepositoryName);
    }

    private List<LocalGitCommit> _log(int start, int num, File file, String sha) {
        String[] gitLogEntities;
        ArrayList<LocalGitCommit> localGitCommits = new ArrayList<LocalGitCommit>(num);
        String gitLog = this._log(start, num, file, "%H %ct %ae %s", sha);
        gitLog = gitLog.replaceAll("Finished executing Bash commands.", "");
        for (String gitLogEntity : gitLogEntities = gitLog.split("\n")) {
            localGitCommits.add(this.getLocalGitCommit(gitLogEntity));
        }
        return localGitCommits;
    }

    private String _log(int start, int num, File file, String format, String sha) {
        GitUtil.ExecutionResult result;
        if (sha == null || sha.isEmpty()) {
            sha = "HEAD";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("git log ");
        if (file != null) {
            sb.append("-n ");
            sb.append(num);
            sb.append(" ");
        } else {
            sb.append(sha);
            sb.append("~");
            sb.append(start + num);
            sb.append("..");
            sb.append(sha);
            sb.append("~");
            sb.append(start);
        }
        sb.append(" --pretty=format:'");
        sb.append(format);
        sb.append("'");
        if (file != null) {
            sb.append(" ");
            sb.append(JenkinsResultsParserUtil.getCanonicalPath(file));
        }
        if ((result = this.executeBashCommands(5, 1000L, 30000L, sb.toString())).getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to run: git log");
        }
        return result.getStandardOut();
    }

    private String _status() {
        String command = "git status";
        GitUtil.ExecutionResult result = this.executeBashCommands(1, 30000L, 120000L, command);
        if (result.getExitValue() != 0) {
            throw new GitWorkingDirectoryRuntimeException(this, "Unable to run: git status");
        }
        return result.getStandardOut();
    }

    protected static class GitWorkingDirectoryRuntimeException
    extends RuntimeException {
        public GitWorkingDirectoryRuntimeException(GitWorkingDirectory gitWorkingDirectory, String message) {
            this(gitWorkingDirectory, message, null);
        }

        public GitWorkingDirectoryRuntimeException(GitWorkingDirectory gitWorkingDirectory, String message, Throwable throwable) {
            this("Runtime exception", gitWorkingDirectory, message, throwable);
        }

        protected GitWorkingDirectoryRuntimeException(String exceptionName, GitWorkingDirectory gitWorkingDirectory, String message, Throwable throwable) {
            super(JenkinsResultsParserUtil.combine(exceptionName, "  occurred in ", gitWorkingDirectory.getGitRepositoryName(), "\n", message), throwable);
        }
    }

    protected static class GitWorkingDirectoryIllegalArgumentException
    extends GitWorkingDirectoryRuntimeException {
        public GitWorkingDirectoryIllegalArgumentException(GitWorkingDirectory gitWorkingDirectory, String message) {
            this(gitWorkingDirectory, message, null);
        }

        public GitWorkingDirectoryIllegalArgumentException(GitWorkingDirectory gitWorkingDirectory, String message, Throwable throwable) {
            super("Illegal argument exception", gitWorkingDirectory, message, throwable);
        }

        public GitWorkingDirectoryIllegalArgumentException(GitWorkingDirectory gitWorkingDirectory, Throwable throwable) {
            this(gitWorkingDirectory, null, throwable);
        }
    }

    protected static class GitWorkingDirectoryFileNotFoundException
    extends FileNotFoundException {
        public GitWorkingDirectoryFileNotFoundException(GitWorkingDirectory gitWorkingDirectory, String message) {
            this("File not found exception", gitWorkingDirectory, message);
        }

        protected GitWorkingDirectoryFileNotFoundException(String exceptionName, GitWorkingDirectory gitWorkingDirectory, String message) {
            super(JenkinsResultsParserUtil.combine(exceptionName, "  occurred in ", gitWorkingDirectory.getGitRepositoryName(), "\n", message));
        }
    }
}

