/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobHistory;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HistoryUtil {
    private static final Map<String, JobHistory> _jobHistories = new HashMap<String, JobHistory>();

    public static JobHistory getJobHistory(Job job) {
        String ciHistoryURL = HistoryUtil._getCIHistoryURL(job);
        if (ciHistoryURL == null) {
            return null;
        }
        JobHistory jobHistory = _jobHistories.get(ciHistoryURL);
        if (jobHistory == null) {
            jobHistory = new JobHistory(ciHistoryURL);
            _jobHistories.put(ciHistoryURL, jobHistory);
        }
        return jobHistory;
    }

    private static String _getCIHistoryURL(Job job) {
        PortalTestClassJob portalTestClassJob;
        PortalGitWorkingDirectory portalGitWorkingDirectory;
        String jobName = job.getJobName();
        String testSuiteName = null;
        if (job instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)job;
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        String upstreamBranchName = null;
        if (job instanceof PortalTestClassJob && (portalGitWorkingDirectory = (portalTestClassJob = (PortalTestClassJob)job).getPortalGitWorkingDirectory()) != null) {
            upstreamBranchName = portalGitWorkingDirectory.getUpstreamBranchName();
        }
        try {
            String ciHistoryJSONURL = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "ci.history.json.url", jobName, testSuiteName, upstreamBranchName);
            if (JenkinsResultsParserUtil.isNullOrEmpty(ciHistoryJSONURL)) {
                return null;
            }
            return ciHistoryJSONURL;
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return null;
        }
    }
}

