/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.CISystemStatusReportUtil;
import com.liferay.jenkins.results.parser.JenkinsAPIUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.PullRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JenkinsCohort {
    private static final Pattern _buildNumberPattern = Pattern.compile(".*\\/([0-9]+)");
    private static final Map<String, JenkinsCohort> _jenkinsCohorts = new HashMap<String, JenkinsCohort>();
    private static final List<String> _jenkinsMastersBlacklist = new ArrayList<String>();
    private static final Pattern _jobNamePattern = Pattern.compile("https?:.*job\\/(.*?)\\/");
    private final Map<String, JenkinsCohortJob> _jenkinsCohortJobsMap = new HashMap<String, JenkinsCohortJob>();
    private final Map<String, JenkinsMaster> _jenkinsMastersMap = new HashMap<String, JenkinsMaster>();
    private final String _name;

    public static synchronized JenkinsCohort getInstance(String cohortName) {
        if (!_jenkinsCohorts.containsKey(cohortName)) {
            _jenkinsCohorts.put(cohortName, new JenkinsCohort(cohortName));
        }
        return _jenkinsCohorts.get(cohortName);
    }

    public int getIdleJenkinsSlaveCount() {
        int idleJenkinsSlaveCount = 0;
        if (this._jenkinsCohortJobsMap.isEmpty()) {
            this.update();
        }
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            idleJenkinsSlaveCount += jenkinsMaster.getIdleJenkinsSlavesCount();
        }
        return idleJenkinsSlaveCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JenkinsMaster> getJenkinsMasters() {
        Map<String, JenkinsMaster> map = this._jenkinsMastersMap;
        synchronized (map) {
            if (!this._jenkinsMastersMap.isEmpty()) {
                return new ArrayList<JenkinsMaster>(this._jenkinsMastersMap.values());
            }
            try {
                List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(JenkinsResultsParserUtil.getBuildProperties(), JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault(), this.getName());
                for (JenkinsMaster jenkinsMaster : jenkinsMasters) {
                    this._jenkinsMastersMap.put(jenkinsMaster.getName(), jenkinsMaster);
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            return new ArrayList<JenkinsMaster>(this._jenkinsMastersMap.values());
        }
    }

    public JenkinsMaster getMostAvailableJenkinsMaster(int invokedBatchSize, int minimumRAM, int maximumSlavesPerHost) {
        String mostAvailableMasterURL = JenkinsResultsParserUtil.getMostAvailableMasterURL(JenkinsResultsParserUtil.combine("http://", this.getName(), ".liferay.com"), JenkinsResultsParserUtil.join(",", _jenkinsMastersBlacklist), invokedBatchSize, minimumRAM, maximumSlavesPerHost);
        return JenkinsMaster.getInstance(mostAvailableMasterURL.replaceAll("http://(.+)", "$1"));
    }

    public String getName() {
        return this._name;
    }

    public Set<String> getNetworkNames() {
        HashSet<String> networkNames = new HashSet<String>();
        for (JenkinsMaster jenkinsMaster : this.getJenkinsMasters()) {
            networkNames.add(jenkinsMaster.getNetworkName());
        }
        return networkNames;
    }

    public int getOfflineJenkinsSlaveCount() {
        int offlineJenkinsSlaveCount = 0;
        if (this._jenkinsCohortJobsMap.isEmpty()) {
            this.update();
        }
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            offlineJenkinsSlaveCount += jenkinsMaster.getOfflineJenkinsSlavesCount();
        }
        return offlineJenkinsSlaveCount;
    }

    public int getOnlineJenkinsSlaveCount() {
        int onlineJenkinsSlaveCount = 0;
        if (this._jenkinsCohortJobsMap.isEmpty()) {
            this.update();
        }
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            onlineJenkinsSlaveCount += jenkinsMaster.getOnlineJenkinsSlavesCount();
        }
        return onlineJenkinsSlaveCount;
    }

    public int getQueuedBuildCount() {
        int queuedBuildCount = 0;
        if (this._jenkinsCohortJobsMap.isEmpty()) {
            this.update();
        }
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            queuedBuildCount += jenkinsCohortJob.getQueuedBuildCount();
        }
        return queuedBuildCount;
    }

    public int getRunningBuildCount() {
        int runningBuildCount = 0;
        if (this._jenkinsCohortJobsMap.isEmpty()) {
            this.update();
        }
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            runningBuildCount += jenkinsCohortJob.getRunningBuildCount();
        }
        return runningBuildCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Map<String, JenkinsCohortJob> map = this._jenkinsCohortJobsMap;
        synchronized (map) {
            if (!this._jenkinsCohortJobsMap.isEmpty()) {
                return;
            }
            ArrayList callables = new ArrayList();
            final List<String> buildURLs = Collections.synchronizedList(new ArrayList());
            final Map queuedBuildURLs = Collections.synchronizedMap(new HashMap());
            for (final JenkinsMaster jenkinsMaster : this.getJenkinsMasters()) {
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() {
                        jenkinsMaster.update(false);
                        buildURLs.addAll(jenkinsMaster.getBuildURLs());
                        queuedBuildURLs.putAll(jenkinsMaster.getQueuedBuildURLs());
                        return null;
                    }
                };
                callables.add(callable);
            }
            if (!this._jenkinsMastersMap.isEmpty()) {
                ThreadPoolExecutor threadPoolExecutor = JenkinsResultsParserUtil.getNewThreadPoolExecutor(this._jenkinsMastersMap.size(), true);
                ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor, "update");
                try {
                    parallelExecutor.execute();
                }
                catch (TimeoutException timeoutException) {
                    throw new RuntimeException(timeoutException);
                }
            }
            for (String string : buildURLs) {
                this._loadBuildURL(string);
            }
            for (Map.Entry entry : queuedBuildURLs.entrySet()) {
                this._loadQueuedBuildURL(entry);
            }
        }
    }

    public void writeDataJavaScriptFile(String filePath) throws IOException {
        if (this._jenkinsCohortJobsMap.isEmpty()) {
            this.update();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var jenkinsDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");\nvar nodeData = ");
        JSONArray nodeDataTableJSONArray = new JSONArray();
        nodeDataTableJSONArray.put(Arrays.asList("Occupied Nodes", "Online Nodes", "Queued Builds", "Offline Nodes", "Idle Nodes"));
        nodeDataTableJSONArray.put(Arrays.asList(this.getRunningBuildCount(), this.getOnlineJenkinsSlaveCount(), this.getQueuedBuildCount(), this.getOfflineJenkinsSlaveCount(), this.getIdleJenkinsSlaveCount()));
        sb.append(nodeDataTableJSONArray.toString());
        sb.append(";\nvar buildLoadData = ");
        JSONArray buildLoadDataTableJSONArray = new JSONArray();
        buildLoadDataTableJSONArray.put(Arrays.asList("Name", "Total Builds", "Current Builds", "Queued Builds", "Top Level Builds"));
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            buildLoadDataTableJSONArray.put(Arrays.asList(jenkinsCohortJob.getJobName(), this._createJSONArray(jenkinsCohortJob.getTotalBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getTotalBuildCount(), jenkinsCohortJob.getTotalBuildPercentage())), this._createJSONArray(jenkinsCohortJob.getRunningBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getRunningBuildCount(), jenkinsCohortJob.getRunningBuildPercentage())), this._createJSONArray(jenkinsCohortJob.getQueuedBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getQueuedBuildCount(), jenkinsCohortJob.getQueuedBuildPercentage())), jenkinsCohortJob.getTopLevelBuildCount()));
        }
        sb.append(buildLoadDataTableJSONArray.toString());
        sb.append(";\nvar pullRequestData = ");
        JSONArray pullRequestDataTableJSONArray = new JSONArray();
        pullRequestDataTableJSONArray.put(Arrays.asList("Pull Request URL", "Sender Username", "Branch Name", "Test Suite", "Status", "Queued Duration", "Duration"));
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            String jobName = jenkinsCohortJob.getJobName();
            if (!jobName.contains("test-portal-acceptance-pullrequest")) continue;
            for (String buildURL : jenkinsCohortJob.getTopLevelBuildURLs()) {
                JSONObject jsonObject = JenkinsAPIUtil.getAPIJSONObject(buildURL);
                long queuedDuration = 0L;
                JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
                for (int i = 0; i < actionsJSONArray.length(); ++i) {
                    String clazz;
                    JSONObject actionJSONObject;
                    Object actions = actionsJSONArray.get(i);
                    if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("_class") || !(clazz = actionJSONObject.getString("_class")).equals("jenkins.metrics.impl.TimeInQueueAction")) continue;
                    queuedDuration = actionJSONObject.getLong("buildableDurationMillis");
                    break;
                }
                long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - jsonObject.getLong("timestamp");
                pullRequestDataTableJSONArray.put(this._createpullRequestDataTableRow(buildURL, JenkinsAPIUtil.getBuildParameters(jsonObject), queuedDuration, duration));
            }
            Map<String, JSONObject> queuedTopLevelBuildsJsonMap = jenkinsCohortJob.getQueuedTopLevelBuildsJsonMap();
            for (JSONObject jsonObject : queuedTopLevelBuildsJsonMap.values()) {
                try {
                    Map<String, String> buildParameters = JenkinsAPIUtil.getBuildParameters(jsonObject);
                    JSONObject taskJSONObject = jsonObject.getJSONObject("task");
                    String jobURL = taskJSONObject.getString("url");
                    long queueDuration = JenkinsResultsParserUtil.getCurrentTimeMillis() - jsonObject.optLong("inQueueSince");
                    pullRequestDataTableJSONArray.put(this._createpullRequestDataTableRow(jobURL, buildParameters, queueDuration, 0L));
                }
                catch (JSONException jsonException) {
                    System.out.println(jsonObject.toString());
                    throw new RuntimeException(jsonException);
                }
            }
        }
        sb.append(pullRequestDataTableJSONArray.toString());
        sb.append(";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    public void writeNodeDataJSONFile(String filePath) throws IOException {
        File file = new File(filePath);
        JSONObject jsonObject = null;
        if (file.exists()) {
            String fileContent = JenkinsResultsParserUtil.read(file);
            jsonObject = new JSONObject(fileContent);
        } else {
            jsonObject = new JSONObject();
            jsonObject.put("idle_nodes", (Object)new JSONArray()).put("occupied_nodes", (Object)new JSONArray()).put("offline_nodes", (Object)new JSONArray()).put("online_nodes", (Object)new JSONArray()).put("queued_builds", (Object)new JSONArray()).put("timestamps", (Object)new JSONArray());
        }
        JSONArray idleNodesJSONArray = jsonObject.getJSONArray("idle_nodes");
        idleNodesJSONArray.put(this.getIdleJenkinsSlaveCount());
        JSONArray occupiedNodesJSONArray = jsonObject.getJSONArray("occupied_nodes");
        occupiedNodesJSONArray.put(this.getRunningBuildCount());
        JSONArray offlineNodesJSONArray = jsonObject.getJSONArray("offline_nodes");
        offlineNodesJSONArray.put(this.getOfflineJenkinsSlaveCount());
        JSONArray onlineNodesJSONArray = jsonObject.getJSONArray("online_nodes");
        onlineNodesJSONArray.put(this.getOnlineJenkinsSlaveCount());
        JSONArray queuedBuildsJSONArray = jsonObject.getJSONArray("queued_builds");
        queuedBuildsJSONArray.put(this.getQueuedBuildCount());
        JSONArray timestampsJSONArray = jsonObject.getJSONArray("timestamps");
        timestampsJSONArray.put(System.currentTimeMillis());
        JenkinsResultsParserUtil.write(filePath, jsonObject.toString());
    }

    protected JenkinsCohort(String name) {
        this._name = name;
    }

    private JSONArray _createJSONArray(Object ... items) {
        JSONArray jsonArray = new JSONArray();
        for (Object item : items) {
            jsonArray.put(item);
        }
        return jsonArray;
    }

    private List<Object> _createpullRequestDataTableRow(String buildURL, Map<String, String> buildParameters, long queueDuration, long duration) {
        String githubReceiverUsername = buildParameters.get("GITHUB_RECEIVER_USERNAME");
        String repositoryName = "liferay-portal";
        String githubUpstreamBranchName = buildParameters.get("GITHUB_UPSTREAM_BRANCH_NAME");
        if (githubUpstreamBranchName != null && !githubUpstreamBranchName.equals("master")) {
            repositoryName = repositoryName + "-ee";
        }
        String githubPullRequestNumber = buildParameters.get("GITHUB_PULL_REQUEST_NUMBER");
        String githubSenderUsername = buildParameters.get("GITHUB_SENDER_USERNAME");
        String ciTestSuite = buildParameters.get("CI_TEST_SUITE");
        Matcher matcher = _buildNumberPattern.matcher(buildURL);
        String status = "Queued";
        if (matcher.find()) {
            status = "Running";
        }
        return Arrays.asList(this._createJSONArray(JenkinsResultsParserUtil.combine(repositoryName, "/", githubReceiverUsername, "#", githubPullRequestNumber), PullRequest.getURL(githubReceiverUsername, repositoryName, githubPullRequestNumber)), githubSenderUsername, githubUpstreamBranchName, ciTestSuite, this._createJSONArray(status, buildURL), this._createJSONArray(queueDuration, JenkinsResultsParserUtil.toDurationString(queueDuration)), this._createJSONArray(duration, JenkinsResultsParserUtil.toDurationString(duration)));
    }

    private String _formatBuildCountText(int buildCount, String buildPercentage) {
        return buildCount + " (" + buildPercentage + ")";
    }

    private void _loadBuildURL(String buildURL) {
        Matcher jobNameMatcher = _jobNamePattern.matcher(buildURL);
        jobNameMatcher.find();
        String jobName = jobNameMatcher.group(1);
        String downstreamJobName = null;
        if (jobName.contains("-batch")) {
            downstreamJobName = jobName;
            jobName = jobName.replace("-batch", "");
        }
        if (jobName.contains("-downstream")) {
            downstreamJobName = jobName;
            jobName = jobName.replace("-downstream", "");
        }
        if (!this._jenkinsCohortJobsMap.containsKey(jobName)) {
            this._jenkinsCohortJobsMap.put(jobName, new JenkinsCohortJob(jobName));
        }
        JenkinsCohortJob jenkinsCohortJob = this._jenkinsCohortJobsMap.get(jobName);
        if (downstreamJobName == null) {
            jenkinsCohortJob.addTopLevelBuildURL(buildURL);
        } else {
            jenkinsCohortJob.addOtherBuildURL(buildURL);
        }
    }

    private void _loadQueuedBuildURL(Map.Entry<String, JSONObject> queuedBuildURL) {
        JSONObject taskJSONObject;
        JSONObject jsonObject = queuedBuildURL.getValue();
        if (jsonObject.has("task") && (taskJSONObject = jsonObject.getJSONObject("task")).has("url")) {
            Matcher jobNameMatcher = _jobNamePattern.matcher(taskJSONObject.getString("url"));
            jobNameMatcher.find();
            String jobName = jobNameMatcher.group(1);
            String downstreamJobName = null;
            if (jobName.contains("-batch")) {
                downstreamJobName = jobName;
                jobName = jobName.replace("-batch", "");
            }
            if (jobName.contains("-downstream")) {
                downstreamJobName = jobName;
                jobName = jobName.replace("-downstream", "");
            }
            if (!this._jenkinsCohortJobsMap.containsKey(jobName)) {
                this._jenkinsCohortJobsMap.put(jobName, new JenkinsCohortJob(jobName));
            }
            JenkinsCohortJob jenkinsCohortJob = this._jenkinsCohortJobsMap.get(jobName);
            if (downstreamJobName == null) {
                jenkinsCohortJob.addQueuedTopLevelBuildJsonMapEntry(queuedBuildURL);
            } else {
                jenkinsCohortJob.addQueuedOtherBuildJsonMapEntry(queuedBuildURL);
            }
        }
    }

    static {
        try {
            String jenkinsMastersBlacklist = JenkinsResultsParserUtil.getBuildProperty("jenkins.load.balancer.blacklist");
            Collections.addAll(_jenkinsMastersBlacklist, jenkinsMastersBlacklist.split(","));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private class JenkinsCohortJob {
        private final String _jenkinsCohortJobName;
        private List<String> _otherBuildURLs = new ArrayList<String>();
        private Map<String, JSONObject> _queuedOtherBuildsJsonMap = new HashMap<String, JSONObject>();
        private Map<String, JSONObject> _queuedTopLevelBuildsJsonMap = new HashMap<String, JSONObject>();
        private List<String> _topLevelBuildURLs = new ArrayList<String>();

        public JenkinsCohortJob(String jenkinsCohortJobName) {
            this._jenkinsCohortJobName = jenkinsCohortJobName;
        }

        public void addOtherBuildURL(String buildURL) {
            this._otherBuildURLs.add(buildURL);
        }

        public void addQueuedOtherBuildJsonMapEntry(Map.Entry<String, JSONObject> queuedBuildsJsonMapEntry) {
            this._queuedOtherBuildsJsonMap.put(queuedBuildsJsonMapEntry.getKey(), queuedBuildsJsonMapEntry.getValue());
        }

        public void addQueuedTopLevelBuildJsonMapEntry(Map.Entry<String, JSONObject> queuedTopLevelBuildMapEntry) {
            this._queuedTopLevelBuildsJsonMap.put(queuedTopLevelBuildMapEntry.getKey(), queuedTopLevelBuildMapEntry.getValue());
        }

        public void addTopLevelBuildURL(String topLevelBuildURL) {
            this._topLevelBuildURLs.add(topLevelBuildURL);
        }

        public String getJobName() {
            return this._jenkinsCohortJobName;
        }

        public int getQueuedBuildCount() {
            return this._queuedTopLevelBuildsJsonMap.size() + this._queuedOtherBuildsJsonMap.size();
        }

        public String getQueuedBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getQueuedBuildCount(), JenkinsCohort.this.getQueuedBuildCount());
        }

        public Map<String, JSONObject> getQueuedTopLevelBuildsJsonMap() {
            return this._queuedTopLevelBuildsJsonMap;
        }

        public int getRunningBuildCount() {
            return this._topLevelBuildURLs.size() + this._otherBuildURLs.size();
        }

        public String getRunningBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getRunningBuildCount(), JenkinsCohort.this.getRunningBuildCount());
        }

        public int getTopLevelBuildCount() {
            return this._topLevelBuildURLs.size() + this._queuedTopLevelBuildsJsonMap.size();
        }

        public List<String> getTopLevelBuildURLs() {
            return this._topLevelBuildURLs;
        }

        public int getTotalBuildCount() {
            return this.getQueuedBuildCount() + this.getRunningBuildCount();
        }

        public String getTotalBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getTotalBuildCount(), JenkinsCohort.this.getRunningBuildCount() + JenkinsCohort.this.getQueuedBuildCount());
        }
    }
}

