/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.DefaultBuild;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsNode;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Retryable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsMaster
implements JenkinsNode<JenkinsMaster> {
    public static final Integer SLAVE_RAM_DEFAULT = 12;
    public static final Integer SLAVES_PER_HOST_DEFAULT = 2;
    protected static long maxRecentBatchAge = 120000L;
    private static final long _AVAILABLE_TIMEOUT = 300000L;
    private static final long _MAXIMUM_BUILD_AGE = 86400000L;
    private static final long _MAXIMUM_BUILD_UPDATE_DURATION = 30000L;
    private static final long _MAXIMUM_QUEUE_UPDATE_DURATION = 15000L;
    private static final Pattern _globalEnvironmentVariablesPattern = Pattern.compile("[^\\{]+(?<json>\\{.*\\})\\s+");
    private static final Map<String, JenkinsMaster> _jenkinsMasters = Collections.synchronizedMap(new HashMap());
    private static final List<String> _jenkinsMastersBlacklist = new ArrayList<String>();
    private static final Pattern _masterNamePattern = Pattern.compile("(?<cohortName>test-\\d+)-\\d+");
    private boolean _available;
    private long _availableTimestamp = -1L;
    private final Map<Long, Integer> _batchSizes = new TreeMap<Long, Integer>();
    private boolean _blacklisted;
    private final Map<String, List<JSONObject>> _buildJSONObjectsMap = new HashMap<String, List<JSONObject>>();
    private final Map<String, Long> _buildsUpdateTimes = new HashMap<String, Long>();
    private final List<String> _buildURLs = new CopyOnWriteArrayList<String>();
    private final List<DefaultBuild> _defaultBuilds = new ArrayList<DefaultBuild>();
    private Map<String, String> _globalEnvironmentVariables;
    private JenkinsCohort _jenkinsCohort;
    private final Map<String, JenkinsSlave> _jenkinsSlavesMap = Collections.synchronizedMap(new HashMap());
    private final String _masterName;
    private final String _masterRemoteURL;
    private final String _masterURL;
    private int _queueCount;
    private final Map<String, JSONObject> _queuedBuildURLs = Collections.synchronizedMap(new HashMap());
    private final List<JSONObject> _queueItemJSONObjects = new ArrayList<JSONObject>();
    private Long _queueUpdateTime;
    private int _reportedAvailableSlavesCount;
    private final Integer _slaveRAM;
    private final Integer _slavesPerHost;

    public static synchronized JenkinsMaster getInstance(String masterName) {
        if (!_jenkinsMasters.containsKey(masterName)) {
            _jenkinsMasters.put(masterName, new JenkinsMaster(masterName));
        }
        return _jenkinsMasters.get(masterName);
    }

    public static Integer getSlaveRAMMinimumDefault() {
        try {
            String propertyValue = JenkinsResultsParserUtil.getBuildProperty("slave.ram.minimum.default");
            if (propertyValue == null) {
                return SLAVE_RAM_DEFAULT;
            }
            return Integer.valueOf(propertyValue);
        }
        catch (Exception exception) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to get property '");
            sb.append("slave.ram.minimum.default");
            sb.append("', defaulting to '");
            sb.append(SLAVE_RAM_DEFAULT);
            sb.append("'");
            System.out.println(sb.toString());
            exception.printStackTrace();
            return SLAVE_RAM_DEFAULT;
        }
    }

    public static Integer getSlavesPerHostDefault() {
        try {
            String propertyValue = JenkinsResultsParserUtil.getBuildProperty("slaves.per.host.default");
            if (propertyValue == null) {
                return SLAVES_PER_HOST_DEFAULT;
            }
            return Integer.valueOf(propertyValue);
        }
        catch (Exception exception) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to get property '");
            sb.append("slaves.per.host.default");
            sb.append("', defaulting to '");
            sb.append(SLAVES_PER_HOST_DEFAULT);
            sb.append("'");
            System.out.println(sb.toString());
            exception.printStackTrace();
            return SLAVES_PER_HOST_DEFAULT;
        }
    }

    public synchronized void addRecentBatch(int batchSize) {
        this._batchSizes.put(JenkinsResultsParserUtil.getCurrentTimeMillis() + maxRecentBatchAge, batchSize);
        this.getAvailableSlavesCount();
    }

    @Override
    public int compareTo(JenkinsMaster jenkinsMaster) {
        int result;
        Integer value = null;
        Integer availableSlavesCount = this.getAvailableSlavesCount();
        Integer otherAvailableSlavesCount = jenkinsMaster.getAvailableSlavesCount();
        if (availableSlavesCount > 0 || otherAvailableSlavesCount > 0) {
            value = availableSlavesCount.compareTo(otherAvailableSlavesCount);
        }
        if (value == null || value == 0) {
            Float averageQueueLength = Float.valueOf(this.getAverageQueueLength());
            Float otherAverageQueueLength = Float.valueOf(jenkinsMaster.getAverageQueueLength());
            value = -1 * averageQueueLength.compareTo(otherAverageQueueLength);
        }
        if (value != 0) {
            return -value.intValue();
        }
        Random random = new Random();
        while ((result = random.nextInt(3) - 1) == 0) {
        }
        return result;
    }

    public int getAvailableSlavesCount() {
        return this.getIdleJenkinsSlavesCount() - this._queueCount - this._getRecentBatchSizesTotal();
    }

    public float getAverageQueueLength() {
        return ((float)this._queueCount + (float)this._getRecentBatchSizesTotal()) / (float)this.getOnlineJenkinsSlavesCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> getBuildJSONObjects(String jobName) {
        Map<String, List<JSONObject>> map = this._buildJSONObjectsMap;
        synchronized (map) {
            JSONArray buildsJSONArray;
            long currentTime;
            long buildUpdateDuration;
            List<JSONObject> buildsJSONObjects = this._buildJSONObjectsMap.get(jobName);
            Long buildsUpdateTime = this._buildsUpdateTimes.get(jobName);
            if (buildsJSONObjects != null && buildsUpdateTime != null && (buildUpdateDuration = (currentTime = JenkinsResultsParserUtil.getCurrentTimeMillis()) - buildsUpdateTime) <= 30000L) {
                return buildsJSONObjects;
            }
            buildsJSONObjects = new ArrayList<JSONObject>();
            int page = 0;
            while ((buildsJSONArray = this._getBuildsJSONArray(jobName, page)).length() != 0) {
                boolean findNextBuild = true;
                for (int i = 0; i < buildsJSONArray.length(); ++i) {
                    JSONObject buildsJSONObject = buildsJSONArray.getJSONObject(i);
                    buildsJSONObjects.add(buildsJSONObject);
                    long buildAge = JenkinsResultsParserUtil.getCurrentTimeMillis() - buildsJSONObject.getLong("timestamp");
                    if (buildAge < 86400000L) continue;
                    findNextBuild = false;
                    break;
                }
                if (!findNextBuild) break;
                ++page;
            }
            this._buildJSONObjectsMap.put(jobName, buildsJSONObjects);
            this._buildsUpdateTimes.put(jobName, JenkinsResultsParserUtil.getCurrentTimeMillis());
            return buildsJSONObjects;
        }
    }

    public List<String> getBuildURLs() {
        return new ArrayList<String>(this._buildURLs);
    }

    public List<DefaultBuild> getDefaultBuilds() {
        List<String> buildURLs = this.getBuildURLs();
        ArrayList<DefaultBuild> oldDefaultBuilds = new ArrayList<DefaultBuild>();
        for (DefaultBuild defaultBuild : this._defaultBuilds) {
            if (!buildURLs.contains(defaultBuild.getBuildURL())) {
                oldDefaultBuilds.add(defaultBuild);
                continue;
            }
            buildURLs.remove(defaultBuild.getBuildURL());
        }
        this._defaultBuilds.removeAll(oldDefaultBuilds);
        for (String buildURL : buildURLs) {
            this._defaultBuilds.add(BuildFactory.newDefaultBuild(buildURL));
        }
        return this._defaultBuilds;
    }

    public Map<String, String> getGlobalEnvironmentVariables() {
        if (this._globalEnvironmentVariables != null) {
            return this._globalEnvironmentVariables;
        }
        if (!this.isAvailable()) {
            return new HashMap<String, String>();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("import jenkins.model.Jenkins;\n");
        sb.append("def globalNodeProperties = ");
        sb.append("Jenkins.instance.getGlobalNodeProperties();\n");
        sb.append("def envVars = globalNodeProperties[0].getEnvVars();\n");
        sb.append("def sb = new StringBuilder();\n");
        sb.append("sb.append(\"{\");\n");
        sb.append("if (!envVars.isEmpty()) {\n");
        sb.append("for (def envVar : envVars.entrySet()) {\n");
        sb.append("sb.append('\"');");
        sb.append("sb.append(envVar.key);");
        sb.append("sb.append('\":\"');");
        sb.append("sb.append(envVar.value.replaceAll('\"', '\\\\\\\\\"'));");
        sb.append("sb.append('\",');");
        sb.append("}\n");
        sb.append("sb.setLength(sb.length() - 1);");
        sb.append("}\n");
        sb.append("sb.append('}');");
        sb.append("println sb;");
        this._globalEnvironmentVariables = new HashMap<String, String>();
        try {
            String results = JenkinsResultsParserUtil.executeJenkinsScript(this.getName(), sb.toString());
            Matcher globalEnvironmentVariablesMatcher = _globalEnvironmentVariablesPattern.matcher(results);
            if (!globalEnvironmentVariablesMatcher.find()) {
                return this._globalEnvironmentVariables;
            }
            JSONObject jsonObject = new JSONObject(globalEnvironmentVariablesMatcher.group("json"));
            for (String key : jsonObject.keySet()) {
                this._globalEnvironmentVariables.put(key, jsonObject.getString(key));
            }
            return this._globalEnvironmentVariables;
        }
        catch (Exception exception) {
            return this._globalEnvironmentVariables;
        }
    }

    public int getIdleJenkinsSlavesCount() {
        int idleSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline() || !jenkinsSlave.isIdle()) continue;
            ++idleSlavesCount;
        }
        return idleSlavesCount;
    }

    @Override
    public JenkinsCohort getJenkinsCohort() {
        if (this._jenkinsCohort != null) {
            return this._jenkinsCohort;
        }
        Matcher matcher = _masterNamePattern.matcher(this.getName());
        if (!matcher.find()) {
            return null;
        }
        String cohortName = matcher.group("cohortName");
        this._jenkinsCohort = JenkinsCohort.getInstance(cohortName);
        return this._jenkinsCohort;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this;
    }

    public JenkinsSlave getJenkinsSlave(String jenkinsSlaveName) {
        if (this._jenkinsSlavesMap.isEmpty()) {
            this.update();
        }
        return this._jenkinsSlavesMap.get(jenkinsSlaveName);
    }

    public List<String> getJenkinsSlaveNames() {
        List<JenkinsSlave> jenkinsSlaves = this.getJenkinsSlaves();
        ArrayList<String> jenkinsSlaveNames = new ArrayList<String>(jenkinsSlaves.size());
        for (JenkinsSlave jenkinsSlave : jenkinsSlaves) {
            jenkinsSlaveNames.add(jenkinsSlave.getName());
        }
        return jenkinsSlaveNames;
    }

    public List<JenkinsSlave> getJenkinsSlaves() {
        if (this._jenkinsSlavesMap.isEmpty()) {
            this.update();
        }
        return new ArrayList<JenkinsSlave>(this._jenkinsSlavesMap.values());
    }

    @Override
    public String getName() {
        return this._masterName;
    }

    public String getNetworkName() {
        Map<String, String> globalEnvironmentVariables = this.getGlobalEnvironmentVariables();
        String networkName = globalEnvironmentVariables.get("MASTER_NETWORK_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(networkName)) {
            return null;
        }
        return networkName;
    }

    public int getOfflineJenkinsSlavesCount() {
        int offlineJenkinsSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (!jenkinsSlave.isOffline()) continue;
            ++offlineJenkinsSlavesCount;
        }
        return offlineJenkinsSlavesCount;
    }

    public List<JenkinsSlave> getOnlineJenkinsSlaves() {
        ArrayList<JenkinsSlave> onlineJenkinsSlaves = new ArrayList<JenkinsSlave>();
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline()) continue;
            onlineJenkinsSlaves.add(jenkinsSlave);
        }
        return onlineJenkinsSlaves;
    }

    public int getOnlineJenkinsSlavesCount() {
        int onlineJenkinsSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline()) continue;
            ++onlineJenkinsSlavesCount;
        }
        return onlineJenkinsSlavesCount;
    }

    public Map<String, JSONObject> getQueuedBuildURLs() {
        return new HashMap<String, JSONObject>(this._queuedBuildURLs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JSONObject> getQueueItemJSONObjects() {
        List<JSONObject> list = this._queueItemJSONObjects;
        synchronized (list) {
            long currentTime;
            long queueUpdateDuration;
            if (this._queueUpdateTime != null && (queueUpdateDuration = (currentTime = JenkinsResultsParserUtil.getCurrentTimeMillis()) - this._queueUpdateTime) <= 15000L) {
                return this._queueItemJSONObjects;
            }
            this._queueItemJSONObjects.clear();
            try {
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(String.valueOf(this.getURL()), "/queue/api/json?tree=", "items[actions[parameters[name,value]],id,task[url]]"), false, 5000);
                JSONArray queueItemsJSONArray = jsonObject.getJSONArray("items");
                if (queueItemsJSONArray == null) {
                    this._queueUpdateTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    return this._queueItemJSONObjects;
                }
                for (int i = 0; i < queueItemsJSONArray.length(); ++i) {
                    this._queueItemJSONObjects.add(queueItemsJSONArray.getJSONObject(i));
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            this._queueUpdateTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
            return this._queueItemJSONObjects;
        }
    }

    public JenkinsSlave getRandomJenkinsSlave() {
        ArrayList<JenkinsSlave> jenkinsSlaves = new ArrayList<JenkinsSlave>(this.getJenkinsSlaves());
        while (!jenkinsSlaves.isEmpty()) {
            JenkinsSlave jenkinsSlave = JenkinsResultsParserUtil.getRandomListItem(jenkinsSlaves);
            if (!jenkinsSlave.isOffline() && jenkinsSlave.isReachable()) {
                return jenkinsSlave;
            }
            jenkinsSlaves.remove(jenkinsSlave);
        }
        return null;
    }

    public String getRemoteURL() {
        return this._masterRemoteURL;
    }

    public Integer getSlaveRAM() {
        return this._slaveRAM;
    }

    public Integer getSlavesPerHost() {
        return this._slavesPerHost;
    }

    public String getURL() {
        return this._masterURL;
    }

    public boolean isAvailable() {
        if (this._availableTimestamp == -1L || System.currentTimeMillis() - this._availableTimestamp > 300000L) {
            try {
                if (!this.isBlackListed()) {
                    JenkinsResultsParserUtil.toString("http://" + this.getName(), false, 0, 0, 0);
                    this._available = true;
                }
            }
            catch (IOException ioException) {
                System.out.println(this.getName() + " is unreachable.");
                this._available = false;
            }
            finally {
                this._availableTimestamp = System.currentTimeMillis();
            }
        }
        return this._available;
    }

    public boolean isBlackListed() {
        if (_jenkinsMastersBlacklist.contains(this.getName())) {
            this._blacklisted = true;
        }
        return this._blacklisted;
    }

    public boolean isBuildInProgress(String jobName, Map<String, String> buildParameters) {
        try {
            JSONObject jobJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(this.getURL(), "/job/", jobName, "/api/json?", "tree=builds[actions[parameters[name,value]],result,url]"), false, 5000);
            JSONArray buildsJSONArray = jobJSONObject.optJSONArray("builds");
            for (int i = 0; i < buildsJSONArray.length(); ++i) {
                JSONArray actionsJSONArray;
                JSONObject buildJSONObject = buildsJSONArray.optJSONObject(i);
                if (buildJSONObject == JSONObject.NULL || !JenkinsResultsParserUtil.isNullOrEmpty(buildJSONObject.optString("result")) || (actionsJSONArray = buildJSONObject.optJSONArray("actions")) == JSONObject.NULL) continue;
                for (int j = 0; j < actionsJSONArray.length(); ++j) {
                    JSONArray parametersJSONArray;
                    JSONObject actionJSONObject = actionsJSONArray.optJSONObject(j);
                    if (actionJSONObject == JSONObject.NULL || !Objects.equals(actionJSONObject.optString("_class"), "hudson.model.ParametersAction") || (parametersJSONArray = actionJSONObject.optJSONArray("parameters")) == JSONObject.NULL) continue;
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (int k = 0; k < parametersJSONArray.length(); ++k) {
                        JSONObject parameterJSONObject = parametersJSONArray.optJSONObject(k);
                        if (parameterJSONObject == JSONObject.NULL) continue;
                        parameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
                    }
                    boolean matchingBuildParameters = true;
                    for (Map.Entry<String, String> buildParameter : buildParameters.entrySet()) {
                        String parameterValue = (String)parameters.get(buildParameter.getKey());
                        if (Objects.equals(buildParameter.getValue(), parameterValue)) continue;
                        matchingBuildParameters = false;
                        break;
                    }
                    if (!matchingBuildParameters) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean isBuildQueued(String jobName, Map<String, String> buildParameters) {
        try {
            JSONObject queueJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(this.getURL(), "/queue/api/json?", "tree=items[actions[parameters[name,value]],task[url]]"), false, 5000);
            JSONArray itemsJSONArray = queueJSONObject.optJSONArray("items");
            for (int i = 0; i < itemsJSONArray.length(); ++i) {
                JSONArray actionsJSONArray;
                JSONObject taskJSONObject;
                String taskURL;
                JSONObject itemJSONObject = itemsJSONArray.optJSONObject(i);
                if (itemJSONObject == JSONObject.NULL || !(taskURL = (taskJSONObject = itemJSONObject.optJSONObject("task")).optString("url", "")).contains("/" + jobName + "/") || (actionsJSONArray = itemJSONObject.optJSONArray("actions")) == JSONObject.NULL) continue;
                for (int j = 0; j < actionsJSONArray.length(); ++j) {
                    JSONArray parametersJSONArray;
                    JSONObject actionJSONObject = actionsJSONArray.optJSONObject(j);
                    if (actionJSONObject == JSONObject.NULL || !Objects.equals(actionJSONObject.optString("_class"), "hudson.model.ParametersAction") || (parametersJSONArray = actionJSONObject.optJSONArray("parameters")) == JSONObject.NULL) continue;
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (int k = 0; k < parametersJSONArray.length(); ++k) {
                        JSONObject parameterJSONObject = parametersJSONArray.optJSONObject(k);
                        if (parameterJSONObject == JSONObject.NULL) continue;
                        parameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
                    }
                    boolean matchingBuildParameters = true;
                    for (Map.Entry<String, String> buildParameter : buildParameters.entrySet()) {
                        String parameterValue = (String)parameters.get(buildParameter.getKey());
                        if (Objects.equals(buildParameter.getValue(), parameterValue)) continue;
                        matchingBuildParameters = false;
                        break;
                    }
                    if (!matchingBuildParameters) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine("{availableSlavesCount=", String.valueOf(this.getAvailableSlavesCount()), ", masterURL=", this._masterURL, ", recentBatchSizesTotal=", String.valueOf(this._getRecentBatchSizesTotal()), ", reportedAvailableSlavesCount=", String.valueOf(this._reportedAvailableSlavesCount), "}");
    }

    public synchronized void update() {
        this.update(true);
    }

    public synchronized void update(boolean minimal) {
        if (!this.isAvailable()) {
            this._batchSizes.clear();
            this._buildURLs.clear();
            this._jenkinsSlavesMap.clear();
            this._queueCount = 0;
            this._queuedBuildURLs.clear();
            this._reportedAvailableSlavesCount = 0;
            return;
        }
        JSONObject computerAPIJSONObject = null;
        JSONObject queueAPIJSONObject = null;
        try {
            computerAPIJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/computer/api/json?tree=computer[displayName,", "executors[currentExecutable[url]],idle,offline,", "offlineCauseReason]")), false, 5000);
            String queueAPIQuery = "tree=items[task[name,url],url,why]";
            if (!minimal) {
                queueAPIQuery = "tree=items[actions[parameters[name,value]],inQueueSince,task[name,url],url,why]";
            }
            queueAPIJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/queue/api/json?" + queueAPIQuery)), false, 5000);
        }
        catch (Exception exception) {
            this._batchSizes.clear();
            this._buildURLs.clear();
            this._jenkinsSlavesMap.clear();
            this._queueCount = 0;
            this._queuedBuildURLs.clear();
            this._reportedAvailableSlavesCount = 0;
            System.out.println("Unable to read " + this._masterURL);
            return;
        }
        ArrayList<String> buildURLs = new ArrayList<String>();
        JSONArray computerJSONArray = computerAPIJSONObject.getJSONArray("computer");
        for (int i = 0; i < computerJSONArray.length(); ++i) {
            JSONObject computerJSONObject = computerJSONArray.getJSONObject(i);
            String jenkinsSlaveName = computerJSONObject.getString("displayName");
            if (jenkinsSlaveName.equals("master")) continue;
            JenkinsSlave jenkinsSlave = this._jenkinsSlavesMap.get(jenkinsSlaveName);
            if (jenkinsSlave != null) {
                jenkinsSlave.update(computerJSONObject);
            } else {
                jenkinsSlave = new JenkinsSlave(this, computerJSONObject);
                this._jenkinsSlavesMap.put(jenkinsSlave.getName(), jenkinsSlave);
            }
            String computerClassName = computerJSONObject.getString("_class");
            if (!computerClassName.contains("hudson.slaves.SlaveComputer")) continue;
            JSONArray executorsJSONArray = computerJSONObject.getJSONArray("executors");
            for (int j = 0; j < executorsJSONArray.length(); ++j) {
                JSONObject currentExecutableJSONObject;
                JSONObject executorJSONObject = executorsJSONArray.getJSONObject(j);
                if (!executorJSONObject.has("currentExecutable") || executorJSONObject.get("currentExecutable") == JSONObject.NULL || !(currentExecutableJSONObject = executorJSONObject.getJSONObject("currentExecutable")).has("url")) continue;
                buildURLs.add(currentExecutableJSONObject.getString("url"));
            }
        }
        this._buildURLs.clear();
        this._buildURLs.addAll(buildURLs);
        this._queueCount = 0;
        if (!queueAPIJSONObject.has("items")) {
            return;
        }
        HashMap<String, JSONObject> queuedBuildURLs = new HashMap<String, JSONObject>();
        JSONArray itemsJSONArray = queueAPIJSONObject.getJSONArray("items");
        for (int i = 0; i < itemsJSONArray.length(); ++i) {
            JSONObject taskJSONObject;
            String taskName;
            JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
            if (!itemJSONObject.has("task") || (taskName = (taskJSONObject = itemJSONObject.getJSONObject("task")).getString("name")).equals("verification-node")) continue;
            if (itemJSONObject.has("why")) {
                String offlineSlaveWhy;
                String why = itemJSONObject.optString("why");
                if (taskName.startsWith("label=") && why.contains(offlineSlaveWhy = JenkinsResultsParserUtil.combine("\u2018", taskName.substring("label=".length()), "\u2019 is offline")) || why.startsWith("There are no nodes") || why.contains("already in progress")) continue;
                if (itemJSONObject.has("url")) {
                    queuedBuildURLs.put(this.getURL() + "/" + itemJSONObject.getString("url"), itemJSONObject);
                }
            }
            ++this._queueCount;
        }
        this._queuedBuildURLs.clear();
        this._queuedBuildURLs.putAll(queuedBuildURLs);
    }

    private JenkinsMaster(String masterName) {
        this._masterName = masterName.contains(".") ? masterName.substring(0, masterName.indexOf(".")) : masterName;
        try {
            Properties properties = JenkinsResultsParserUtil.getBuildProperties();
            this._masterURL = properties.getProperty(JenkinsResultsParserUtil.combine("jenkins.local.url[", this._masterName, "]"));
            this._masterRemoteURL = properties.getProperty(JenkinsResultsParserUtil.combine("jenkins.remote.url[", this._masterName, "]"));
            if (JenkinsResultsParserUtil.isNullOrEmpty(this._masterRemoteURL) || JenkinsResultsParserUtil.isNullOrEmpty(this._masterURL)) {
                throw new IllegalArgumentException(masterName + " is unknown");
            }
            Integer slaveRAM = JenkinsMaster.getSlaveRAMMinimumDefault();
            String slaveRAMString = JenkinsResultsParserUtil.getProperty(properties, JenkinsResultsParserUtil.combine("master.property(", this._masterName, "/slave.ram)"));
            if (slaveRAMString != null && slaveRAMString.matches("\\d+")) {
                slaveRAM = Integer.valueOf(slaveRAMString);
            }
            this._slaveRAM = slaveRAM;
            Integer slavesPerHost = JenkinsMaster.getSlavesPerHostDefault();
            String slavesPerHostString = JenkinsResultsParserUtil.getProperty(properties, JenkinsResultsParserUtil.combine("master.property(", this._masterName, "/slaves.per.host)"));
            if (slavesPerHostString != null && slavesPerHostString.matches("\\d+")) {
                slavesPerHost = Integer.valueOf(slavesPerHostString);
            }
            this._slavesPerHost = slavesPerHost;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to determine URL for master " + this._masterName, exception);
        }
    }

    private JSONArray _getBuildsJSONArray(final String jobName, final int page) {
        Retryable<JSONArray> retryable = new Retryable<JSONArray>(true, 2, 10, true){

            @Override
            public JSONArray execute() {
                String url = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(String.valueOf(JenkinsMaster.this.getURL()), "/job/", jobName, "/api/json?tree=allBuilds[actions[parameters", "[name,value]],queueId,timestamp,url]{", String.valueOf(page * 100), ",", String.valueOf((page + 1) * 100), "}"));
                try {
                    JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(url, false, 5000);
                    return jsonObject.getJSONArray("allBuilds");
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        };
        return (JSONArray)retryable.executeWithRetries();
    }

    private synchronized int _getRecentBatchSizesTotal() {
        int recentBatchSizesTotal = 0;
        long currentTimestamp = JenkinsResultsParserUtil.getCurrentTimeMillis();
        ArrayList<Long> expiredTimestamps = new ArrayList<Long>(this._batchSizes.size());
        for (Map.Entry<Long, Integer> entry : this._batchSizes.entrySet()) {
            Long expirationTimestamp = entry.getKey();
            if (expirationTimestamp < currentTimestamp) {
                expiredTimestamps.add(expirationTimestamp);
                continue;
            }
            recentBatchSizesTotal += entry.getValue().intValue();
        }
        for (Long expiredTimestamp : expiredTimestamps) {
            this._batchSizes.remove(expiredTimestamp);
        }
        return recentBatchSizesTotal;
    }

    static {
        try {
            String jenkinsMastersBlacklist = JenkinsResultsParserUtil.getBuildProperty("jenkins.load.balancer.blacklist");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(jenkinsMastersBlacklist)) {
                Collections.addAll(_jenkinsMastersBlacklist, jenkinsMastersBlacklist.split(","));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

