/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildUpdater;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.jethr0.Jethr0Client;
import com.liferay.jenkins.results.parser.jethr0.Jethr0ClientFactory;
import com.liferay.jenkins.results.parser.jethr0.Jethr0MessageListener;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class Jethr0BuildUpdater
extends BaseBuildUpdater {
    private static final Pattern _jenkinsBuildURLPattern = Pattern.compile("https?://(?<masterHostname>test-\\d+-\\d+)(.liferay.com)?/.+");
    private final String _jenkinsBuildId;
    private long _jethr0BuildId;
    private final Jethr0Client _jethr0Client;
    private final long _jethr0JobId;
    private final Jethr0MessageListener _jethr0MessageListener;
    private String _jethr0Result;
    private String _jethr0Status;

    public String getJenkinsBuildId() {
        return this._jenkinsBuildId;
    }

    @Override
    public void invoke() {
        Build build = this.getBuild();
        this._invoke(build.getMaximumSlavesPerHost(), build.getMinimumSlaveRAM());
    }

    public void processMessage(Message message) throws JMSException, JSONException {
        if (!this._isCompatibleMessage(message)) {
            return;
        }
        TextMessage textMessage = (TextMessage)message;
        JSONObject jsonObject = new JSONObject(textMessage.getText());
        String status = jsonObject.getString("status");
        if (Objects.equals(status, "completed")) {
            this._processCompletedBuild(jsonObject);
        } else if (Objects.equals(status, "queued")) {
            this._processQueuedBuild(jsonObject);
        } else if (Objects.equals(status, "running")) {
            this._processRunningBuild(jsonObject);
        }
    }

    @Override
    public void reinvoke() {
        Build build = this.getBuild();
        this._invoke(build.getMaximumSlavesPerHost(), 24);
    }

    protected Jethr0BuildUpdater(Build build, long jethr0JobId) {
        super(build);
        this._jethr0JobId = jethr0JobId;
        this._jenkinsBuildId = jethr0JobId + "__" + build.getBuildName();
        try {
            this._jethr0Client = Jethr0ClientFactory.newJethr0Client(build.getJenkinsMaster());
            this._jethr0MessageListener = Jethr0MessageListener.getInstance(this._jethr0Client, jethr0JobId);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected boolean isBuildCompleted() {
        return Objects.equals(this._jethr0Status, "completed");
    }

    @Override
    protected boolean isBuildFailing() {
        return !Objects.equals(this._jethr0Result, "passed");
    }

    @Override
    protected boolean isBuildQueued() {
        return Objects.equals(this._jethr0Status, "queued");
    }

    @Override
    protected boolean isBuildRunning() {
        return Objects.equals(this._jethr0Status, "running");
    }

    @Override
    protected void runCompleted() {
        super.runCompleted();
        try {
            this._jethr0MessageListener.unsubscribe(this);
        }
        catch (JMSException jmsException) {
            throw new RuntimeException(jmsException);
        }
    }

    @Override
    protected void runQueued() {
        Build build = this.getBuild();
        build.setStatus("queued");
        if (this.isBuildRunning()) {
            this.runRunning();
        }
    }

    @Override
    protected void runStarting() {
        try {
            this._jethr0MessageListener.subscribe(this);
        }
        catch (JMSException jmsException) {
            throw new RuntimeException(jmsException);
        }
        this._jethr0Result = null;
        this._jethr0Status = null;
        super.runStarting();
    }

    private JenkinsMaster _getJenkinsMaster(String buildURL) {
        if (JenkinsResultsParserUtil.isURL(buildURL)) {
            return null;
        }
        Matcher matcher = _jenkinsBuildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            return null;
        }
        return JenkinsMaster.getInstance(matcher.group("masterHostname"));
    }

    private void _invoke(int maximumSlavesPerHost, int minimumSlaveRAM) {
        Build build = this.getBuild();
        HashMap<String, String> buildParameters = new HashMap<String, String>(build.getParameters());
        buildParameters.put("JENKINS_BUILD_ID", this.getJenkinsBuildId());
        buildParameters.put("MAX_NODE_COUNT", String.valueOf(maximumSlavesPerHost));
        buildParameters.put("MIN_NODE_RAM", String.valueOf(minimumSlaveRAM));
        if (this._jethr0BuildId > 0L) {
            this._jethr0Client.createBuildRun(this._jethr0BuildId);
        } else {
            this._jethr0Client.createBuild(build.getJobName(), buildParameters, this._jethr0JobId, build.getBuildName());
        }
        build.addInvocation(new Build.Invocation(build));
    }

    private boolean _isCompatibleMessage(Message message) throws JMSException, JSONException {
        TextMessage textMessage = (TextMessage)message;
        return this._jethr0JobId == textMessage.getLongProperty("jethr0JobId") && this._jenkinsBuildId.equals(textMessage.getStringProperty("jenkinsBuildId"));
    }

    private void _processCompletedBuild(JSONObject jsonObject) {
        String jenkinsBuildURL = jsonObject.getString("jenkinsBuildURL");
        JenkinsMaster jenkinsMaster = this._getJenkinsMaster(jenkinsBuildURL);
        Build build = this.getBuild();
        Build.Invocation buildInvocation = build.getCurrentInvocation();
        buildInvocation.setBuildURL(jenkinsBuildURL);
        buildInvocation.setJenkinsMaster(jenkinsMaster);
        build.setBuildURL(jenkinsBuildURL);
        build.setJenkinsMaster(jenkinsMaster);
        build.saveBuildURLInBuildDatabase();
        this._jethr0BuildId = jsonObject.getLong("jethr0BuildId");
        this._jethr0Result = jsonObject.getString("result");
        this._jethr0Status = "completed";
    }

    private void _processQueuedBuild(JSONObject jsonObject) {
        Build build = this.getBuild();
        Build.Invocation buildInvocation = build.getCurrentInvocation();
        String jethr0BuildURL = jsonObject.getString("jethr0BuildURL");
        buildInvocation.setBuildURL(jethr0BuildURL);
        build.setBuildURL(jethr0BuildURL);
        build.saveBuildURLInBuildDatabase();
        this._jethr0BuildId = jsonObject.getLong("jethr0BuildId");
        this._jethr0Status = "queued";
    }

    private void _processRunningBuild(JSONObject jsonObject) {
        Build build = this.getBuild();
        Build.Invocation buildInvocation = build.getCurrentInvocation();
        String jenkinsBuildURL = jsonObject.getString("jenkinsBuildURL");
        JenkinsMaster jenkinsMaster = this._getJenkinsMaster(jenkinsBuildURL);
        buildInvocation.setBuildURL(jenkinsBuildURL);
        buildInvocation.setJenkinsMaster(jenkinsMaster);
        build.setBuildURL(jenkinsBuildURL);
        build.setJenkinsMaster(jenkinsMaster);
        build.saveBuildURLInBuildDatabase();
        this._jethr0BuildId = jsonObject.getLong("jethr0BuildId");
        this._jethr0Status = "running";
    }
}

