/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchHistory;
import com.liferay.jenkins.results.parser.CloudStorageSyncUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class JobHistory {
    private static final Pattern _pattern = Pattern.compile("(?<batchName>.+)_stable");
    private final Map<String, BatchHistory> _batchHistories = new HashMap<String, BatchHistory>();
    private final URL _testrayURL;
    private final String _upstreamBranchName;

    public BatchHistory getBatchHistory(String batchName) {
        Matcher matcher = _pattern.matcher(batchName);
        if (matcher.find()) {
            batchName = matcher.group("batchName");
        }
        return this._batchHistories.get(batchName);
    }

    public URL getTestrayURL() {
        return this._testrayURL;
    }

    public String getUpstreamBranchName() {
        return this._upstreamBranchName;
    }

    protected JobHistory(String ciHistoryURL) {
        JSONObject ciHistoryJSONObject = this._getCIHistoryJSONObject(ciHistoryURL);
        if (ciHistoryJSONObject == null) {
            this._testrayURL = null;
            this._upstreamBranchName = null;
            return;
        }
        JSONArray batchesJSONArray = ciHistoryJSONObject.optJSONArray("batches");
        if (batchesJSONArray != JSONObject.NULL) {
            for (int i = 0; i < batchesJSONArray.length(); ++i) {
                BatchHistory batchHistory = new BatchHistory(this, batchesJSONArray.getJSONObject(i));
                this._batchHistories.put(batchHistory.getBatchName(), batchHistory);
            }
        }
        URL testrayURL = null;
        try {
            String testrayURLString = ciHistoryJSONObject.optString("testray_url", "https://testray.liferay.com");
            if (JenkinsResultsParserUtil.isURL(testrayURLString)) {
                testrayURL = new URL(testrayURLString);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this._testrayURL = testrayURL;
        this._upstreamBranchName = ciHistoryJSONObject.optString("upstream_branch_name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject _getCIHistoryJSONObject(String ciHistoryURL) {
        if (ciHistoryURL == null) {
            return null;
        }
        File tempGzipFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp() + ".gz");
        try {
            if (ciHistoryURL.startsWith("gs://jenkins-ci-data") || ciHistoryURL.startsWith("gs://patcher-shared") || ciHistoryURL.startsWith("gs://testray-results")) {
                CloudStorageSyncUtil.copyGCPFile(ciHistoryURL, JenkinsResultsParserUtil.getCanonicalPath(tempGzipFile));
            } else {
                JenkinsResultsParserUtil.toFile(new URL(ciHistoryURL), tempGzipFile);
            }
            String content = JenkinsResultsParserUtil.read(tempGzipFile);
            if (JenkinsResultsParserUtil.isNullOrEmpty(content)) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = new JSONObject(content);
            return jSONObject;
        }
        catch (IOException ioException) {
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (tempGzipFile.exists()) {
                JenkinsResultsParserUtil.delete(tempGzipFile);
            }
        }
    }
}

