/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LegacyDataArchiveGroup;
import com.liferay.jenkins.results.parser.LegacyDataArchiveHelper;
import com.liferay.jenkins.results.parser.LegacyDataArchivePortalVersion;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class LegacyDataArchive {
    private final String _dataArchiveType;
    private final String _databaseName;
    private final File _legacyDataArchiveFile;
    private final LegacyDataArchiveGroup _legacyDataArchiveGroup;
    private final LegacyDataArchiveHelper _legacyDataArchiveHelper;
    private final LegacyDataArchivePortalVersion _legacyDataArchivePortalVersion;
    private final GitWorkingDirectory _legacyGitWorkingDirectory;

    public String getDataArchiveType() {
        return this._dataArchiveType;
    }

    public File getLegacyDataArchiveFile() {
        return this._legacyDataArchiveFile;
    }

    public LegacyDataArchiveHelper getLegacyDataArchiveHelper() {
        return this._legacyDataArchiveHelper;
    }

    public GitWorkingDirectory getLegacyGitWorkingDirectory() {
        return this._legacyGitWorkingDirectory;
    }

    public LocalGitCommit getLocalGitCommit() {
        if (this._legacyDataArchiveFile.exists()) {
            List<LocalGitCommit> localGitCommits = this._legacyGitWorkingDirectory.log(1, this._legacyDataArchiveFile);
            return localGitCommits.get(0);
        }
        return null;
    }

    public boolean isUpdated() {
        LocalGitCommit localGitCommit = this.getLocalGitCommit();
        if (localGitCommit == null) {
            return false;
        }
        LocalGitCommit latestTestLocalGitCommit = this._legacyDataArchivePortalVersion.getLatestTestLocalGitCommit();
        String gitCommitMessage = localGitCommit.getMessage();
        return gitCommitMessage.contains(latestTestLocalGitCommit.getAbbreviatedSHA());
    }

    public void stageLegacyDataArchive() throws IOException {
        File generatedArchiveDirectory = this._legacyDataArchiveHelper.getGeneratedArchiveDirectory();
        File generatedArchiveFile = new File(JenkinsResultsParserUtil.combine(generatedArchiveDirectory.toString(), "/", this._legacyDataArchivePortalVersion.getPortalVersion(), "/", this._legacyDataArchiveGroup.getDataArchiveType(), "-", this._databaseName, ".zip"));
        if (generatedArchiveFile.exists()) {
            JenkinsResultsParserUtil.copy(generatedArchiveFile, this._legacyDataArchiveFile);
            this._legacyGitWorkingDirectory.stageFileInCurrentLocalGitBranch(JenkinsResultsParserUtil.getCanonicalPath(this._legacyDataArchiveFile));
        }
    }

    protected LegacyDataArchive(LegacyDataArchiveGroup legacyDataArchiveGroup, String databaseName) {
        this._legacyDataArchiveGroup = legacyDataArchiveGroup;
        this._databaseName = databaseName;
        this._legacyDataArchivePortalVersion = legacyDataArchiveGroup.getLegacyDataArchivePortalVersion();
        this._legacyDataArchiveHelper = this._legacyDataArchivePortalVersion.getLegacyDataArchiveHelper();
        this._legacyGitWorkingDirectory = this._legacyDataArchiveHelper.getLegacyGitWorkingDirectory();
        this._dataArchiveType = legacyDataArchiveGroup.getDataArchiveType();
        File legacyDataWorkingDirectory = this._legacyGitWorkingDirectory.getWorkingDirectory();
        this._legacyDataArchiveFile = new File(JenkinsResultsParserUtil.combine(legacyDataWorkingDirectory.toString(), "/", this._legacyDataArchivePortalVersion.getPortalVersion(), "/data-archive/", this._dataArchiveType, "-", this._databaseName, ".zip"));
    }
}

