/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LegacyDataArchive;
import com.liferay.jenkins.results.parser.LegacyDataArchiveHelper;
import com.liferay.jenkins.results.parser.LegacyDataArchivePortalVersion;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LegacyDataArchiveGroup {
    private final String _dataArchiveType;
    private final LegacyDataArchiveHelper _legacyDataArchiveHelper;
    private final LegacyDataArchivePortalVersion _legacyDataArchivePortalVersion;
    private final List<LegacyDataArchive> _legacyDataArchives;
    private final GitWorkingDirectory _legacyGitWorkingDirectory;

    public LegacyDataArchiveGroup(LegacyDataArchivePortalVersion legacyDataArchivePortalVersion, String dataArchiveType) {
        this._legacyDataArchivePortalVersion = legacyDataArchivePortalVersion;
        this._dataArchiveType = dataArchiveType;
        this._legacyDataArchiveHelper = legacyDataArchivePortalVersion.getLegacyDataArchiveHelper();
        this._legacyGitWorkingDirectory = this._legacyDataArchiveHelper.getLegacyGitWorkingDirectory();
        this._legacyDataArchives = this._getLegacyDataArchives();
    }

    public void commitLegacyDataArchives() throws IOException {
        for (LegacyDataArchive legacyDataArchive : this._legacyDataArchives) {
            if (legacyDataArchive.isUpdated()) continue;
            legacyDataArchive.stageLegacyDataArchive();
        }
        String status = this._legacyGitWorkingDirectory.status();
        if (!status.contains("nothing to commit") && !status.contains("nothing added to commit")) {
            LocalGitCommit latestTestLocalGitCommit = this._legacyDataArchivePortalVersion.getLatestTestLocalGitCommit();
            this._legacyGitWorkingDirectory.commitStagedFilesToCurrentBranch(JenkinsResultsParserUtil.combine("archive:ignore Update '", this._dataArchiveType, "' for '", this._legacyDataArchivePortalVersion.getPortalVersion(), "' at ", latestTestLocalGitCommit.getAbbreviatedSHA(), "."));
        }
    }

    public String getDataArchiveType() {
        return this._dataArchiveType;
    }

    public LegacyDataArchivePortalVersion getLegacyDataArchivePortalVersion() {
        return this._legacyDataArchivePortalVersion;
    }

    public List<LegacyDataArchive> getLegacyDataArchives() {
        return this._legacyDataArchives;
    }

    private List<LegacyDataArchive> _getLegacyDataArchives() {
        ArrayList<LegacyDataArchive> legacyDataArchives = new ArrayList<LegacyDataArchive>();
        List<String> databaseNames = this._legacyDataArchivePortalVersion.getDatabaseNames();
        for (String databaseName : databaseNames) {
            legacyDataArchives.add(new LegacyDataArchive(this, databaseName));
        }
        return legacyDataArchives;
    }
}

