/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;

public class LegacyTopLevelBuild
extends DefaultTopLevelBuild
implements PortalWorkspaceBuild {
    public LegacyTopLevelBuild(String url) {
        super(url);
    }

    public LegacyTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        String branchName = this.getBranchName();
        if (!branchName.equals("master")) {
            return "liferay-portal-ee";
        }
        return "liferay-portal";
    }

    @Override
    public String getBranchName() {
        String portalUpstreamBranchName = this.getParameterValue("PORTAL_UPSTREAM_BRANCH_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            return portalUpstreamBranchName;
        }
        return "master";
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public Workspace getWorkspace() {
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (!(workspace instanceof PortalWorkspace)) {
            return workspace;
        }
        PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = portalWorkspace.getPortalWorkspaceGitRepository();
        String portalGitHubURL = this._getPortalGitHubURL();
        if (portalWorkspaceGitRepository != null && !JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL)) {
            portalWorkspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        WorkspaceGitRepository legacyWorkspaceGitRepository = portalWorkspace.getLegacyWorkspaceGitRepository();
        String legacyGitHubURL = this._getLegacyGitHubURL();
        if (legacyWorkspaceGitRepository != null && !JenkinsResultsParserUtil.isNullOrEmpty(legacyGitHubURL)) {
            legacyWorkspaceGitRepository.setGitHubURL(legacyGitHubURL);
        }
        return workspace;
    }

    private String _getLegacyGitHubURL() {
        String legacyGitHubBranchName = this.getParameterValue("LEGACY_GITHUB_BRANCH_NAME");
        String legacyGitHubBranchUsername = this.getParameterValue("LEGACY_GITHUB_BRANCH_USERNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(legacyGitHubBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(legacyGitHubBranchUsername)) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", legacyGitHubBranchUsername, "/liferay-qa-portal-legacy-ee/tree/", legacyGitHubBranchName);
    }

    private String _getPortalGitHubURL() {
        String portalGitHubBranchName = this.getParameterValue("PORTAL_GITHUB_BRANCH_NAME");
        String portalGitHubBranchUsername = this.getParameterValue("PORTAL_GITHUB_BRANCH_USERNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubBranchUsername)) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", portalGitHubBranchUsername, "/liferay-portal/tree/", portalGitHubBranchName);
    }
}

