/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalReleaseBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MarketplaceAppPluginsTopLevelBuild
extends PluginsTopLevelBuild
implements PortalReleaseBuild {
    private static final Pattern _pattern = Pattern.compile("(?<major>\\d)(?<minor>\\d)(?<fix>\\d+)");
    private PortalRelease _portalRelease;

    public MarketplaceAppPluginsTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        String branchName = this.getBranchName();
        if (branchName.equals("master")) {
            return "liferay-portal";
        }
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        Matcher matcher = _pattern.matcher(this.getParameterValue("TEST_PORTAL_BUILD_NUMBER"));
        if (!matcher.find()) {
            throw new RuntimeException("Please set 'TEST_PORTAL_BUILD_NUMBER'");
        }
        return JenkinsResultsParserUtil.combine(matcher.group("major"), ".", matcher.group("minor"), ".x");
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        Matcher matcher = _pattern.matcher(this.getParameterValue("TEST_PORTAL_BUILD_NUMBER"));
        if (!matcher.find()) {
            throw new RuntimeException("Please set 'TEST_PORTAL_BUILD_NUMBER'");
        }
        String fix = matcher.group("fix");
        if (fix.startsWith("1")) {
            return Job.BuildProfile.DXP;
        }
        return Job.BuildProfile.PORTAL;
    }

    @Override
    public String getPluginName() {
        return this.getParameterValue("TEST_PACKAGE_FILE_NAME");
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        String portalBuildNumber = this.getParameterValue("TEST_PORTAL_BUILD_NUMBER");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBuildNumber)) {
            return null;
        }
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String portalVersion = JenkinsResultsParserUtil.getProperty(buildProperties, "portal.version", portalBuildNumber);
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalVersion)) {
            return null;
        }
        String latestPortalVersion = JenkinsResultsParserUtil.getProperty(buildProperties, "portal.version.latest", portalVersion);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(latestPortalVersion)) {
            this._portalRelease = new PortalRelease(latestPortalVersion);
            return this._portalRelease;
        }
        this._portalRelease = new PortalRelease(portalVersion);
        return this._portalRelease;
    }
}

