/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;

public class ParallelExecutor<T> {
    private static final String _PARALLEL_QUEUE_NAME = "PARALLEL_EXECUTOR:PARALLEL_QUEUE";
    private static Integer _nextId = 1;
    private final Collection<Callable<T>> _callables;
    private String _description;
    private final boolean _disposeExecutor;
    private boolean _excludeNulls;
    private ExecutorService _executorService;
    private boolean _failOnError;
    private int _id;
    private TaskRunnable<T> _taskRunnable;
    private Thread _thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParallelExecutor(Collection<Callable<T>> callables, boolean excludeNulls, ExecutorService executorService, boolean failOnError, String description) {
        Integer n = _nextId;
        synchronized (n) {
            Integer n2 = _nextId;
            Integer n3 = _nextId = Integer.valueOf(_nextId + 1);
            this._id = n2;
        }
        this._callables = callables;
        this._excludeNulls = excludeNulls;
        this._executorService = executorService;
        this._failOnError = failOnError;
        this._description = description;
        if (executorService == null) {
            this._disposeExecutor = true;
            this._executorService = Executors.newSingleThreadExecutor();
        } else {
            this._disposeExecutor = false;
        }
    }

    public ParallelExecutor(Collection<Callable<T>> callables, boolean excludeNulls, ExecutorService executorService, String purpose) {
        this(callables, excludeNulls, executorService, false, purpose);
    }

    public ParallelExecutor(Collection<Callable<T>> callables, ExecutorService executorService, String purpose) {
        this(callables, false, executorService, purpose);
    }

    public List<T> execute() throws TimeoutException {
        return this.execute(null);
    }

    public List<T> execute(Long timeoutSeconds) throws TimeoutException {
        this.start();
        return this.waitFor(timeoutSeconds);
    }

    public String getDescription() {
        return this._description;
    }

    public String getID() {
        return String.valueOf(this._id);
    }

    public boolean hasFailedTask() {
        return this._taskRunnable != null && this._taskRunnable.getFailedTaskCount() > 0;
    }

    public void shutdownNow() {
        this._executorService.shutdownNow();
    }

    public synchronized void start() {
        this._taskRunnable = new TaskRunnable<T>(this._callables, this);
        this._thread = new Thread(this._taskRunnable);
        this._thread.start();
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine("ParallelExecutor ", String.valueOf(this.getID()), " - ", this.getDescription());
    }

    public List<T> waitFor() throws TimeoutException {
        return this.waitFor(null);
    }

    public List<T> waitFor(Long timeoutSeconds) throws TimeoutException {
        if (timeoutSeconds == null) {
            timeoutSeconds = 5400L;
        }
        if (this._taskRunnable == null || this._thread == null) {
            return null;
        }
        try {
            while (this._thread.isAlive()) {
                if (this._taskRunnable.getDurationMillis() > 1000L * timeoutSeconds) {
                    this._taskRunnable.abort();
                    String durationString = JenkinsResultsParserUtil.toDurationString(this._taskRunnable.getDurationMillis());
                    throw new TimeoutException(JenkinsResultsParserUtil.combine(this.toString(), " timed out after ", durationString));
                }
                JenkinsResultsParserUtil.sleep(100L);
            }
            List<T> list = this._taskRunnable.getResults();
            return list;
        }
        finally {
            if (this._disposeExecutor) {
                this._executorService.shutdownNow();
                while (!this._executorService.isShutdown()) {
                    JenkinsResultsParserUtil.sleep(100L);
                }
                this._executorService = null;
            }
        }
    }

    private static class TaskRunnable<T>
    implements Runnable {
        private boolean _aborted;
        private List<Callable<T>> _callables;
        private final Map<String, Collection<Callable<T>>> _callablesMap;
        private List<Task<T>> _completedTasks = new ArrayList<Task<T>>();
        private ExecutorService _executorService;
        private final ParallelExecutor<T> _parallelExecutor;
        private final SortedMap<Integer, T> _resultsSortedMap = new TreeMap<Integer, T>();
        private List<Task<T>> _runningTasks = new ArrayList<Task<T>>();
        private Long _startTimeMillis;
        private final int _totalTaskCount;

        public TaskRunnable(Collection<Callable<T>> callables, ParallelExecutor<T> parallelExecutor) {
            if (parallelExecutor == null) {
                throw new IllegalArgumentException("Parallel executor is required");
            }
            this._callables = new ArrayList<Callable<T>>(callables);
            this._parallelExecutor = parallelExecutor;
            this._callablesMap = this._toCallablesMap(callables);
            this._executorService = ((ParallelExecutor)parallelExecutor)._executorService;
            this._totalTaskCount = callables.size();
        }

        public void abort() {
            this._aborted = true;
        }

        public boolean aborted() {
            return this._aborted;
        }

        public String generateStatusMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._parallelExecutor.toString());
            if (this.getRemainingTaskCount() + this.getRunningTaskCount() == 0) {
                sb.append(" completed in ");
            } else {
                sb.append(" has been running for ");
            }
            sb.append(JenkinsResultsParserUtil.toDurationString(this.getDurationMillis()));
            sb.append("\n Failed: ");
            sb.append(this.getFailedTaskCount());
            sb.append(" / Remaining: ");
            sb.append(this.getRemainingTaskCount());
            sb.append(" / Running: ");
            sb.append(this.getRunningTaskCount());
            sb.append(" / Succeeded: ");
            sb.append(this.getSucceededTaskCount());
            sb.append(" / Submitted: ");
            sb.append(this.getSubmittedTaskCount());
            sb.append(" / Total: ");
            sb.append(this.getTotalTaskCount());
            sb.append("\n Average task duration: ");
            sb.append(JenkinsResultsParserUtil.toDurationString(this.getAverageDurationMillis()));
            return sb.toString();
        }

        public long getAverageDurationMillis() {
            if (this._completedTasks.isEmpty()) {
                return 0L;
            }
            long totalDuration = 0L;
            for (Task<T> completedTask : this._completedTasks) {
                TaskCallable<T> taskCallable = completedTask.getCallable();
                totalDuration += taskCallable.getDuration().longValue();
            }
            return totalDuration / (long)this._completedTasks.size();
        }

        public long getDurationMillis() {
            if (this._startTimeMillis == null) {
                return 0L;
            }
            return System.currentTimeMillis() - this._startTimeMillis;
        }

        public int getFailedTaskCount() {
            int failedTaskCount = 0;
            for (Task<T> completedTask : this._completedTasks) {
                if (!completedTask.failed()) continue;
                ++failedTaskCount;
            }
            return failedTaskCount;
        }

        public int getRemainingTaskCount() {
            return this.getTotalTaskCount() - this.getFailedTaskCount() - this.getRunningTaskCount() - this.getSubmittedTaskCount() - this.getSucceededTaskCount();
        }

        public List<T> getResults() {
            if (!this.isComplete() && !this.aborted()) {
                return null;
            }
            return new ArrayList<T>(this._resultsSortedMap.values());
        }

        public int getRunningTaskCount() {
            int runningTaskCount = 0;
            for (Task<T> runningTask : this._runningTasks) {
                TaskCallable<T> taskCallable = runningTask.getCallable();
                if (!taskCallable.isRunning()) continue;
                ++runningTaskCount;
            }
            return runningTaskCount;
        }

        public int getSubmittedTaskCount() {
            int submittedTaskCount = 0;
            for (Task<T> runningTask : this._runningTasks) {
                TaskCallable<T> taskCallable = runningTask.getCallable();
                if (taskCallable.isRunning()) continue;
                ++submittedTaskCount;
            }
            return submittedTaskCount;
        }

        public int getSucceededTaskCount() {
            int successfulTaskCount = 0;
            for (Task<T> completedTask : this._completedTasks) {
                if (completedTask.failed()) continue;
                ++successfulTaskCount;
            }
            return successfulTaskCount;
        }

        public int getTotalTaskCount() {
            return this._totalTaskCount;
        }

        public boolean isComplete() {
            return this.getSucceededTaskCount() + this.getFailedTaskCount() == this.getTotalTaskCount();
        }

        @Override
        public void run() {
            if (this._callablesMap.isEmpty()) {
                return;
            }
            Set<Map.Entry<String, Collection<Callable<T>>>> entries = this._callablesMap.entrySet();
            this._startTimeMillis = System.currentTimeMillis();
            long lastOutputTimeMillis = this._startTimeMillis;
            for (Map.Entry<String, Collection<Callable<T>>> entry : entries) {
                if (Objects.equals(entry.getKey(), ParallelExecutor._PARALLEL_QUEUE_NAME)) continue;
                Collection<Callable<T>> collection = entry.getValue();
                Iterator<Callable<T>> iterator = collection.iterator();
                this._runningTasks.add(this._processCallable(iterator.next(), iterator));
            }
            Collection<Callable<T>> callables = this._callablesMap.get(ParallelExecutor._PARALLEL_QUEUE_NAME);
            if (callables != null && !callables.isEmpty()) {
                for (Callable callable : callables) {
                    this._runningTasks.add(this._processCallable(callable, null));
                }
            }
            while (!this._runningTasks.isEmpty()) {
                ArrayList<Task<T>> newProcessorTasks = new ArrayList<Task<T>>();
                ArrayList<Task<T>> arrayList = new ArrayList<Task<T>>();
                try {
                    long millisSinceLastOutput;
                    for (Task<T> processorTask : this._runningTasks) {
                        T result;
                        TaskCallable<T> taskCallable = processorTask.getCallable();
                        int callableIndex = this._callables.indexOf(taskCallable.getNestedCallable());
                        if (this.aborted() || Thread.interrupted()) {
                            this.abort();
                            if (!((ParallelExecutor)this._parallelExecutor)._excludeNulls) {
                                this._resultsSortedMap.put(callableIndex, null);
                            }
                            throw new RuntimeException(this._parallelExecutor + " has been aborted");
                        }
                        Future<T> future = processorTask.getFuture();
                        if (!future.isDone()) continue;
                        try {
                            result = future.get();
                        }
                        catch (InterruptedException | CancellationException | ExecutionException exception) {
                            processorTask.fail();
                            RuntimeException runtimeException = new RuntimeException("Parallel task threw an exception", exception);
                            if (((ParallelExecutor)this._parallelExecutor)._failOnError) {
                                if (!((ParallelExecutor)this._parallelExecutor)._excludeNulls) {
                                    this._resultsSortedMap.put(callableIndex, null);
                                }
                                this.abort();
                                throw runtimeException;
                            }
                            result = null;
                            runtimeException.printStackTrace();
                        }
                        if (result != null || !((ParallelExecutor)this._parallelExecutor)._excludeNulls) {
                            this._resultsSortedMap.put(callableIndex, result);
                        }
                        arrayList.add(processorTask);
                        Iterator<Callable<T>> iterator = processorTask.getIterator();
                        if (iterator == null || !iterator.hasNext()) continue;
                        newProcessorTasks.add(this._processCallable(iterator.next(), iterator));
                    }
                    if (!arrayList.isEmpty()) {
                        this._completedTasks.addAll(arrayList);
                        this._runningTasks.removeAll(arrayList);
                    }
                    if (!newProcessorTasks.isEmpty()) {
                        this._runningTasks.addAll(newProcessorTasks);
                    }
                    if ((millisSinceLastOutput = System.currentTimeMillis() - lastOutputTimeMillis) > 180000L) {
                        System.out.println(this.generateStatusMessage());
                        lastOutputTimeMillis = System.currentTimeMillis();
                    }
                    if (this._runningTasks.isEmpty()) continue;
                    JenkinsResultsParserUtil.sleep(100L);
                }
                catch (Exception exception) {
                    if (!((ParallelExecutor)this._parallelExecutor)._failOnError && !this._aborted) continue;
                    for (Task<T> task : this._runningTasks) {
                        Future<T> future = task.getFuture();
                        if (future == null || future.isCancelled()) continue;
                        if (!future.isDone()) {
                            future.cancel(true);
                            task.fail();
                            if (!((ParallelExecutor)this._parallelExecutor)._excludeNulls) {
                                TaskCallable<T> taskCallable = task.getCallable();
                                int callableIndex = this._callables.indexOf(taskCallable.getNestedCallable());
                                this._resultsSortedMap.put(callableIndex, null);
                            }
                        }
                        this._completedTasks.add(task);
                    }
                    if (!((ParallelExecutor)this._parallelExecutor)._excludeNulls) {
                        for (Callable callable : this._callables) {
                            int callableIndex = this._callables.indexOf(callable);
                            if (this._resultsSortedMap.containsKey(callableIndex)) continue;
                            this._resultsSortedMap.put(callableIndex, null);
                        }
                    }
                    this._runningTasks.removeAll(this._completedTasks);
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception);
                }
            }
            System.out.println(JenkinsResultsParserUtil.combine(this._parallelExecutor.toString(), " completed ", String.valueOf(this.getSucceededTaskCount()), " tasks in ", JenkinsResultsParserUtil.toDurationString(this.getDurationMillis()), " averaging ", JenkinsResultsParserUtil.toDurationString(this.getAverageDurationMillis()), " per task. "));
            int failedTaskCount = this.getFailedTaskCount();
            if (failedTaskCount > 0) {
                System.out.println(JenkinsResultsParserUtil.combine(String.valueOf(failedTaskCount), JenkinsResultsParserUtil.getNounForm(failedTaskCount, " tasks", " task"), " failed."));
            }
        }

        private Task<T> _processCallable(Callable<T> callable, Iterator<Callable<T>> iterator) {
            TaskCallable<T> taskCallable = new TaskCallable<T>(callable);
            Future<T> future = this._executorService.submit(taskCallable);
            return new Task<T>(iterator, taskCallable, future);
        }

        private Map<String, Collection<Callable<T>>> _toCallablesMap(Collection<Callable<T>> callables) {
            HashMap<String, Collection<Callable<T>>> callablesMap = new HashMap<String, Collection<Callable<T>>>();
            for (Callable<T> callable : callables) {
                String queueName = null;
                if (callable instanceof SequentialCallable) {
                    SequentialCallable groupedCallable = (SequentialCallable)callable;
                    queueName = groupedCallable.getQueueName();
                } else {
                    queueName = ParallelExecutor._PARALLEL_QUEUE_NAME;
                }
                if (JenkinsResultsParserUtil.isNullOrEmpty(queueName)) {
                    queueName = ParallelExecutor._PARALLEL_QUEUE_NAME;
                }
                if (!callablesMap.containsKey(queueName)) {
                    callablesMap.put(queueName, new ArrayList());
                }
                Collection callablesCollection = (Collection)callablesMap.get(queueName);
                callablesCollection.add(callable);
                callablesMap.put(queueName, callablesCollection);
            }
            return callablesMap;
        }

        private static class TaskCallable<T>
        implements Callable<T> {
            private final Callable<T> _callable;
            private Long _durationMillis;
            private Long _startTimeMillis;

            public TaskCallable(Callable<T> callable) {
                this._callable = callable;
                this._startTimeMillis = null;
            }

            @Override
            public T call() throws Exception {
                this._startTimeMillis = System.currentTimeMillis();
                try {
                    T t = this._callable.call();
                    return t;
                }
                finally {
                    this._durationMillis = System.currentTimeMillis() - this._startTimeMillis;
                }
            }

            public Long getDuration() {
                if (this.isRunning()) {
                    return System.currentTimeMillis() - this._startTimeMillis;
                }
                if (this.isDone()) {
                    return this._durationMillis;
                }
                return null;
            }

            public Callable<T> getNestedCallable() {
                return this._callable;
            }

            public boolean isDone() {
                return this._durationMillis != null;
            }

            public boolean isRunning() {
                return this._startTimeMillis != null && !this.isDone();
            }
        }

        private static class Task<T> {
            private boolean _failed;
            private final Future<T> _future;
            private final Iterator<Callable<T>> _iterator;
            private final TaskCallable<T> _processorCallable;

            public Task(Iterator<Callable<T>> iterator, TaskCallable<T> processorCallable, Future<T> future) {
                this._iterator = iterator;
                this._processorCallable = processorCallable;
                this._future = future;
                this._failed = false;
            }

            public void fail() {
                this._failed = true;
            }

            public boolean failed() {
                return this._failed;
            }

            public TaskCallable<T> getCallable() {
                return this._processorCallable;
            }

            public Future<T> getFuture() {
                return this._future;
            }

            public Iterator<Callable<T>> getIterator() {
                return this._iterator;
            }
        }
    }

    public static abstract class SequentialCallable<T>
    implements Callable<T> {
        private String _queueName;

        public SequentialCallable() {
            this(ParallelExecutor._PARALLEL_QUEUE_NAME);
        }

        public SequentialCallable(String queueName) {
            this._queueName = queueName;
        }

        @Override
        public abstract T call() throws Exception;

        public String getQueueName() {
            return this._queueName;
        }
    }
}

