/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.BaseBatchBuildData;
import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BasePortalTestBatch;
import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.TopLevelBuildData;
import com.liferay.jenkins.results.parser.Workspace;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaywrightPortalTestBatch
extends BasePortalTestBatch<PortalBatchBuildData> {
    private static final Pattern _playwrightFileNamePattern = Pattern.compile("tests/(?<filePath>(?<projectName>[^/]+)/.*.spec.ts)");

    @Override
    public void run() {
        try {
            this.executeBatch();
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
        finally {
            this.publishResults();
            this.publishPlaywrightReport();
        }
    }

    protected PlaywrightPortalTestBatch(PortalBatchBuildData portalBatchBuildData, Workspace workspace) {
        super(portalBatchBuildData, workspace);
    }

    @Override
    protected void executeBatch() throws AntException {
        BatchBuildData portalBatchBuildData = this.getBatchBuildData();
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        buildParameters.put("axis.variable", "0");
        buildParameters.put("test.batch.name", ((BaseBatchBuildData)portalBatchBuildData).getBatchName());
        AntUtil.callTarget(this.getPrimaryPortalWorkspaceDirectory(), "build-test-batch.xml", ((BaseBatchBuildData)portalBatchBuildData).getBatchName(), buildParameters, this.getEnvironmentVariables(), this.getAntLibDir());
    }

    @Override
    protected Map<String, String> getEnvironmentVariables() {
        Map<String, String> environmentVariables = super.getEnvironmentVariables();
        BatchBuildData portalBatchBuildData = this.getBatchBuildData();
        TopLevelBuildData topLevelBuildData = ((BaseBatchBuildData)portalBatchBuildData).getTopLevelBuildData();
        String portalBatchTestSelector = topLevelBuildData.getBuildParameter("PORTAL_BATCH_TEST_SELECTOR");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            Matcher matcher = _playwrightFileNamePattern.matcher(portalBatchTestSelector);
            if (matcher.matches()) {
                environmentVariables.put("PLAYWRIGHT_ARGS_0", portalBatchTestSelector);
                environmentVariables.put("PLAYWRIGHT_PROJECT_NAME", matcher.group("projectName"));
            } else {
                environmentVariables.put("PLAYWRIGHT_PROJECT_NAME", portalBatchTestSelector);
            }
        }
        return environmentVariables;
    }

    protected void publishPlaywrightReport() {
        File playwrightReportFile = new File(this.getPrimaryPortalWorkspaceDirectory(), "modules/test/playwright/playwright-report/index.html");
        if (!playwrightReportFile.exists()) {
            return;
        }
        BatchBuildData portalBatchBuildData = this.getBatchBuildData();
        try {
            JenkinsResultsParserUtil.copy(playwrightReportFile.getParentFile(), new File(((BaseBuildData)((Object)portalBatchBuildData)).getArtifactDir(), "playwright-reports"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((PortalBatchBuildData)portalBatchBuildData).getPortalBranchSHA());
        sb.append(" - ");
        sb.append(((BaseBatchBuildData)portalBatchBuildData).getBatchName());
        sb.append(" - ");
        sb.append("<a href=\"https://");
        sb.append(((BaseBatchBuildData)portalBatchBuildData).getTopLevelMasterHostname());
        sb.append(".liferay.com/userContent/");
        sb.append(((BaseBuildData)((Object)portalBatchBuildData)).getUserContentRelativePath());
        sb.append("jenkins-report.html\">Jenkins Report</a> - ");
        sb.append("<a href=\"https://");
        sb.append(((BaseBatchBuildData)portalBatchBuildData).getTopLevelMasterHostname());
        sb.append(".liferay.com/userContent/");
        sb.append(((BaseBuildData)((Object)portalBatchBuildData)).getUserContentRelativePath());
        sb.append(((BaseBuildData)((Object)portalBatchBuildData)).getRunID());
        sb.append("/playwright-reports/index.html\">Playwright Report</a>");
        sb.append("<ul>");
        for (String test : ((BaseBatchBuildData)portalBatchBuildData).getTestList()) {
            sb.append("<li>");
            sb.append(test);
            sb.append("</li>");
        }
        sb.append("</ul>");
        ((BaseBuildData)((Object)portalBatchBuildData)).setBuildDescription(sb.toString());
    }
}

