/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public abstract class PluginsGitRepositoryJob
extends GitRepositoryJob
implements PortalTestClassJob {
    protected Properties buildProperties;
    protected PortalGitWorkingDirectory portalGitWorkingDirectory;

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        String pluginsBranchName = this.getBranchName();
        String workingDirectoryPath = this.getBuildPropertyValue(JenkinsResultsParserUtil.combine("plugins.dir[", pluginsBranchName, "]"));
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(pluginsBranchName, workingDirectoryPath);
        return this.gitWorkingDirectory;
    }

    public abstract List<File> getPluginsTestBaseDirs();

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this.portalGitWorkingDirectory;
    }

    protected PluginsGitRepositoryJob(Job.BuildProfile buildProfile, String jobName, String upstreamBranchName) {
        super(buildProfile, jobName, upstreamBranchName);
        this._initialize();
    }

    protected PluginsGitRepositoryJob(JSONObject jsonObject) {
        super(jsonObject);
        this._initialize();
    }

    protected String getBuildPropertyValue(String buildPropertyName) {
        if (this.buildProperties == null) {
            try {
                this.buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build properties", ioException);
            }
        }
        return this.buildProperties.getProperty(buildPropertyName);
    }

    private void _initialize() {
        this.getGitWorkingDirectory();
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        String portalBranchName = this.getBuildPropertyValue(JenkinsResultsParserUtil.combine("plugins.portal.branch.name[", this.getBranchName(), "]"));
        File portalGitRepositoryDir = new File(this.getBuildPropertyValue(JenkinsResultsParserUtil.combine("portal.dir[", portalBranchName, "]")));
        this.jobPropertiesFiles.add(new File(portalGitRepositoryDir, "test.properties"));
        this.portalGitWorkingDirectory = (PortalGitWorkingDirectory)GitWorkingDirectoryFactory.newGitWorkingDirectory(portalBranchName, portalGitRepositoryDir.getPath());
    }
}

