/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalAcceptanceTestSuiteJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalWorkspaceJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.suite.RelevantTestSuite;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class PortalAcceptancePullRequestJob
extends PortalAcceptanceTestSuiteJob
implements PortalWorkspaceJob {
    private static List<PathMatcher> _restBuilderFilePathMatchers;
    private Boolean _centralMergePullRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchTestClassGroup> getBatchTestClassGroups() {
        List list = this.jobProperties;
        synchronized (list) {
            if (this.batchTestClassGroups != null) {
                return this.batchTestClassGroups;
            }
            PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
            Properties testProperties = JenkinsResultsParserUtil.getProperties(new File(portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
            boolean relevantEngineEnabled = Boolean.parseBoolean(testProperties.getProperty("relevant.engine.enabled"));
            if (this._isRelevantTestSuite() && relevantEngineEnabled) {
                System.out.println("Relevant engine is enabled");
                this.batchTestClassGroups = Collections.synchronizedList(new ArrayList());
                this.batchTestClassGroups.addAll(this.getBatchTestClassGroups(this.getTestBatches()));
                return this.batchTestClassGroups;
            }
            if (Objects.equals(this.getTestSuiteName(), "stable") && relevantEngineEnabled) {
                this.batchTestClassGroups = Collections.synchronizedList(this.getBatchTestClassGroups(this.getStableRuleBatchNames()));
                return this.batchTestClassGroups;
            }
            return super.getBatchTestClassGroups();
        }
    }

    public boolean isCentralMergePullRequest() {
        File modifiedFile;
        String modifiedFileName;
        if (this._centralMergePullRequest != null) {
            return this._centralMergePullRequest;
        }
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        List<File> currentBranchModifiedFiles = gitWorkingDirectory.getModifiedFilesList();
        if (currentBranchModifiedFiles.size() == 1 && (modifiedFileName = (modifiedFile = currentBranchModifiedFiles.get(0)).getName()).equals("ci-merge")) {
            this._centralMergePullRequest = true;
            return this._centralMergePullRequest;
        }
        this._centralMergePullRequest = false;
        return this._centralMergePullRequest;
    }

    @Override
    public boolean isStandaloneBatchEnabled() {
        return true;
    }

    protected PortalAcceptancePullRequestJob(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
    }

    protected PortalAcceptancePullRequestJob(JSONObject jsonObject) {
        super(jsonObject);
    }

    @Override
    protected Set<String> getRawBatchNames() {
        Set<String> batchNames = super.getRawBatchNames();
        if (this._isRelevantTestSuite() && !this._hasMatchingFiles(_restBuilderFilePathMatchers)) {
            batchNames.remove("rest-builder");
        }
        if (this._isRelevantTestSuite() && this._hasOnlyFilesInDirectory("modules")) {
            batchNames.remove("semantic-versioning");
        }
        if (this._isRelevantTestSuite() && this._hasOnlyFilesInDirectory("portal-web")) {
            String[] portalWebOnlyBatchNameMarkers = new String[]{"compile-jsp", "functional", "portal-web", "source-format"};
            TreeSet<String> portalWebOnlyBatchNames = new TreeSet<String>();
            block0: for (String batchName : batchNames) {
                for (String portalWebOnlyBatchNameMarker : portalWebOnlyBatchNameMarkers) {
                    if (!batchName.contains(portalWebOnlyBatchNameMarker)) continue;
                    portalWebOnlyBatchNames.add(batchName);
                    continue block0;
                }
            }
            return portalWebOnlyBatchNames;
        }
        return batchNames;
    }

    protected Set<String> getStableRuleBatchNames() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File baseDir = portalGitWorkingDirectory.getWorkingDirectory();
        JobProperty jobProperty = JobPropertyFactory.newJobProperty("test.batch.names", "relevant", null, "stable-rule", this, baseDir, JobProperty.Type.DEFAULT_TEST_DIR, true);
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    @Override
    protected List<TestBatch> getTestBatches() {
        if (!this._isRelevantTestSuite()) {
            return super.getTestBatches();
        }
        RelevantTestSuite relevantTestSuite = new RelevantTestSuite(this);
        List<TestBatch> testBatches = relevantTestSuite.getTestBatches(true);
        this.recordJobProperties(relevantTestSuite.getTestBatchNamesJobProperties());
        return testBatches;
    }

    private boolean _hasMatchingFiles(List<PathMatcher> pathMatchers) {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (File modifiedFile : gitWorkingDirectory.getModifiedFilesList()) {
            for (PathMatcher pathMatcher : pathMatchers) {
                if (!pathMatcher.matches(modifiedFile.toPath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _hasOnlyFilesInDirectory(String directoryName) {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        File directory = new File(gitWorkingDirectory.getWorkingDirectory(), directoryName);
        for (File modifiedFile : gitWorkingDirectory.getModifiedFilesList()) {
            if (JenkinsResultsParserUtil.isFileInDirectory(directory, modifiedFile)) continue;
            return false;
        }
        return true;
    }

    private boolean _isRelevantTestSuite() {
        String testSuiteName = this.getTestSuiteName();
        return testSuiteName.equals("relevant");
    }

    static {
        FileSystem fs = FileSystems.getDefault();
        _restBuilderFilePathMatchers = Arrays.asList(fs.getPathMatcher("glob:**/portal-tools-rest-builder/**"), fs.getPathMatcher("glob:**/rest-config*.yaml"), fs.getPathMatcher("glob:**/rest-openapi*.yaml"));
    }
}

