/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalFixpackReleasePortalTopLevelBuild
extends PortalTopLevelBuild
implements PortalWorkspaceBuild {
    private static final Pattern _pattern = Pattern.compile("(?<major>\\d)\\.(?<minor>\\d)\\.(?<fix>\\d+)");
    private PortalFixpackRelease _portalFixpackRelease;
    private PortalRelease _portalRelease;

    public PortalFixpackReleasePortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        PortalRelease portalRelease = portalFixpackRelease.getPortalRelease();
        String portalVersion = portalRelease.getPortalVersion();
        Matcher matcher = _pattern.matcher(portalVersion);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid portal version: " + portalVersion);
        }
        String branchName = JenkinsResultsParserUtil.combine(matcher.group("major"), ".", matcher.group("minor"), ".x");
        if (branchName.equals("6.1.x")) {
            return "ee-6.1.30";
        }
        if (branchName.equals("6.2.x")) {
            return "ee-6.2.10";
        }
        return branchName;
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        if (this._portalFixpackRelease != null) {
            return this._portalFixpackRelease;
        }
        try {
            URL portalFixpackURL = new URL(this.getParameterValue("TEST_BUILD_FIX_PACK_ZIP_URL"));
            this._portalFixpackRelease = new PortalFixpackRelease(portalFixpackURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._portalFixpackRelease;
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        this._portalRelease = portalFixpackRelease.getPortalRelease();
        return this._portalRelease;
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public Workspace getWorkspace() {
        String portalGitHubURL;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL = this._getPortalGitHubURL())) {
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            workspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        return workspace;
    }

    @Override
    protected String getReleaseRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    protected boolean isReleaseBuild() {
        return true;
    }

    private String _getPortalGitHubURL() {
        String portalBranchName = this.getParameterValue("TEST_PORTAL_USER_BRANCH_NAME");
        String portalBranchUsername = this.getParameterValue("TEST_PORTAL_USER_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(portalBranchUsername)) {
            return null;
        }
        String branchName = this.getBranchName();
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(portalBranchUsername);
        sb.append("/liferay-portal");
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/tree/");
        sb.append(portalBranchName);
        return sb.toString();
    }
}

