/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalRelease;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class PortalHotfixRelease {
    private static final Pattern _hotfixURLPattern = Pattern.compile("https?://.+/(?<hotfixName>liferay-(hotfix|security-de|security-dxp|dxp-\\d{4}.q\\d+.\\d+-hotfix)-(?<hotfixVersion>\\d+)(-\\d{6}-\\d)?(-)?(\\d{4})?)");
    private static final Pattern _packageNamePattern = Pattern.compile("(?<packageName>[\\.\\w]+|[\\-\\w]+)(-\\d.*)?\\.jar");
    private Element _fixpackDocumentationElement;
    private JSONObject _fixpackDocumentationJSONObject;
    private final PortalFixpackRelease _portalFixpackRelease;
    private final URL _portalHotfixReleaseURL;
    private final PortalRelease _portalRelease;

    public PortalHotfixRelease(JSONObject jsonObject) {
        this._portalHotfixReleaseURL = this._getURL(jsonObject.getString("portalHotfixURL"));
        if (this._portalHotfixReleaseURL == null) {
            throw new RuntimeException("Unable to get Portal Hotfix URL");
        }
        URL portalReleaseURL = this._getURL(jsonObject.optString("portalReleaseURL"));
        this._portalRelease = portalReleaseURL != null ? new PortalRelease(portalReleaseURL) : null;
        URL portalFixpackURL = this._getURL(jsonObject.optString("portalFixpackURL"));
        this._portalFixpackRelease = portalFixpackURL != null ? new PortalFixpackRelease(portalFixpackURL) : null;
    }

    public PortalHotfixRelease(URL portalHotfixReleaseURL) {
        this._portalHotfixReleaseURL = portalHotfixReleaseURL;
        this._portalFixpackRelease = null;
        this._portalRelease = null;
    }

    public PortalHotfixRelease(URL portalHotfixReleaseURL, PortalFixpackRelease portalFixpackRelease, PortalRelease portalRelease) {
        this._portalHotfixReleaseURL = portalHotfixReleaseURL;
        this._portalFixpackRelease = portalFixpackRelease;
        this._portalRelease = portalRelease;
    }

    public JSONObject getJSONObject() {
        JSONObject jsonObject = new JSONObject();
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        if (portalFixpackRelease != null) {
            jsonObject.put("portalFixpackURL", (Object)portalFixpackRelease.getPortalFixpackURL());
        }
        jsonObject.put("portalHotfixURL", (Object)this.getPortalHotfixReleaseURL());
        PortalRelease portalRelease = this.getPortalRelease();
        if (portalRelease != null) {
            jsonObject.put("portalReleaseURL", (Object)portalRelease.getPortalBundleTomcatURL());
        }
        return jsonObject;
    }

    public Set<String> getModifiedPackageNames() {
        Set<String> packageNames = this._getJSONPackageNames();
        if (packageNames == null) {
            packageNames = this._getXMLPackageNames();
        }
        if (packageNames == null || packageNames.isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> modifiedPackageNames = new HashSet<String>();
        for (String packageName : packageNames) {
            Matcher matcher;
            if (JenkinsResultsParserUtil.isNullOrEmpty(packageName)) continue;
            if (packageName.contains("/")) {
                packageName = packageName.substring(packageName.lastIndexOf("/") + 1);
            }
            if (!(matcher = _packageNamePattern.matcher(packageName)).find()) continue;
            modifiedPackageNames.add(matcher.group("packageName"));
        }
        return modifiedPackageNames;
    }

    public PortalFixpackRelease getPortalFixpackRelease() {
        return this._portalFixpackRelease;
    }

    public String getPortalHotfixReleaseName() {
        String portalHotfixReleaseURLString = String.valueOf(this._portalHotfixReleaseURL);
        Matcher matcher = _hotfixURLPattern.matcher(portalHotfixReleaseURLString);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("hotfixName");
    }

    public URL getPortalHotfixReleaseURL() {
        return this._portalHotfixReleaseURL;
    }

    public String getPortalHotfixReleaseVersion() {
        String portalHotfixReleaseURLString = String.valueOf(this._portalHotfixReleaseURL);
        Matcher matcher = _hotfixURLPattern.matcher(portalHotfixReleaseURLString);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("hotfixVersion");
    }

    public PortalRelease getPortalRelease() {
        return this._portalRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element _getFixpackDocumentationElement() {
        URL uRL = this._portalHotfixReleaseURL;
        synchronized (uRL) {
            if (this._fixpackDocumentationElement != null) {
                return this._fixpackDocumentationElement;
            }
            File tempDir = new File(JenkinsResultsParserUtil.getDistinctTimeStamp());
            try {
                tempDir.mkdirs();
                File hotfixFile = new File(tempDir, "hotfix.zip");
                JenkinsResultsParserUtil.toFile(this.getPortalHotfixReleaseURL(), hotfixFile);
                JenkinsResultsParserUtil.unzip(hotfixFile, tempDir);
                File fixpackDocumentationFile = new File(tempDir, "fixpack_documentation.xml");
                if (!fixpackDocumentationFile.exists()) {
                    Element element = null;
                    return element;
                }
                Document document = Dom4JUtil.parse(JenkinsResultsParserUtil.read(fixpackDocumentationFile));
                Element element = this._fixpackDocumentationElement = document.getRootElement();
                return element;
            }
            catch (Exception exception) {
                Element element2 = null;
                return element2;
            }
            finally {
                JenkinsResultsParserUtil.delete(tempDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject _getFixpackDocumentationJSONObject() {
        URL uRL = this._portalHotfixReleaseURL;
        synchronized (uRL) {
            if (this._fixpackDocumentationJSONObject != null) {
                return this._fixpackDocumentationJSONObject;
            }
            File tempDir = new File(JenkinsResultsParserUtil.getDistinctTimeStamp());
            try {
                tempDir.mkdirs();
                File hotfixFile = new File(tempDir, "hotfix.zip");
                JenkinsResultsParserUtil.toFile(this.getPortalHotfixReleaseURL(), hotfixFile);
                JenkinsResultsParserUtil.unzip(hotfixFile, tempDir);
                File fixpackDocumentationFile = new File(tempDir, "fixpack_documentation.json");
                if (!fixpackDocumentationFile.exists()) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                JSONObject jSONObject = this._fixpackDocumentationJSONObject = new JSONObject(JenkinsResultsParserUtil.read(fixpackDocumentationFile));
                return jSONObject;
            }
            catch (Exception exception) {
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            finally {
                JenkinsResultsParserUtil.delete(tempDir);
            }
        }
    }

    private Set<String> _getJSONPackageNames() {
        JSONObject fixpackDocumentationJSONObject = this._getFixpackDocumentationJSONObject();
        if (fixpackDocumentationJSONObject == null) {
            return null;
        }
        HashSet<String> packageNames = new HashSet<String>();
        JSONObject filesJSONObject = fixpackDocumentationJSONObject.getJSONObject("files");
        JSONArray jarFilesJSONArray = filesJSONObject.getJSONArray("jar_files");
        for (int i = 0; i < jarFilesJSONArray.length(); ++i) {
            JSONObject jarFileJSONObject = jarFilesJSONArray.getJSONObject(i);
            packageNames.add(jarFileJSONObject.optString("new_name"));
        }
        JSONArray lpkgFilesJSONArray = filesJSONObject.getJSONArray("lpkg_files");
        for (int i = 0; i < lpkgFilesJSONArray.length(); ++i) {
            JSONObject lpkgFilesJSONObject = lpkgFilesJSONArray.getJSONObject(i);
            JSONArray modifiedJarsJSONArray = lpkgFilesJSONObject.getJSONArray("modified_jars");
            for (int j = 0; j < modifiedJarsJSONArray.length(); ++j) {
                JSONObject modifiedJarJSONObject = modifiedJarsJSONArray.getJSONObject(j);
                packageNames.add(modifiedJarJSONObject.optString("new_name"));
            }
        }
        return packageNames;
    }

    private URL _getURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private Set<String> _getXMLPackageNames() {
        Element fixpackDocumentationElement = this._getFixpackDocumentationElement();
        if (fixpackDocumentationElement == null) {
            return null;
        }
        HashSet<String> packageNames = new HashSet<String>();
        Element checksumsElement = fixpackDocumentationElement.element("checksums");
        List fileChecksumElements = checksumsElement.elements("file-checksum");
        for (Element fileChecksumElement : fileChecksumElements) {
            packageNames.add(fileChecksumElement.attributeValue("file"));
        }
        return packageNames;
    }
}

