/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BasePortalReleaseJob;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalHotfixRelease;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;

public class PortalHotfixReleaseJob
extends BasePortalReleaseJob {
    private final PortalHotfixRelease _portalHotfixRelease;

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        PortalHotfixRelease portalHotfixRelease = this.getPortalHotfixRelease();
        if (portalHotfixRelease != null) {
            this.jsonObject.put("portal_hotfix_release", (Object)portalHotfixRelease.getJSONObject());
        }
        return this.jsonObject;
    }

    public List<File> getModifiedFiles() {
        ArrayList<File> modifiedFiles = new ArrayList<File>();
        PortalHotfixRelease portalHotfixRelease = this.getPortalHotfixRelease();
        if (portalHotfixRelease == null) {
            return modifiedFiles;
        }
        Set<String> modifiedPackageNames = portalHotfixRelease.getModifiedPackageNames();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        List<File> bndFiles = JenkinsResultsParserUtil.findFiles(portalGitWorkingDirectory.getWorkingDirectory(), "bnd.bnd");
        for (File bndFile : bndFiles) {
            Properties properties = JenkinsResultsParserUtil.getProperties(bndFile);
            String bundleSymbolicName = properties.getProperty("Bundle-SymbolicName");
            if (bundleSymbolicName == null || bundleSymbolicName.startsWith("${")) {
                File parentFile = bndFile.getParentFile();
                bundleSymbolicName = parentFile.getName();
            }
            if (!modifiedPackageNames.contains(bundleSymbolicName)) continue;
            modifiedFiles.add(bndFile);
        }
        return modifiedFiles;
    }

    public PortalHotfixRelease getPortalHotfixRelease() {
        return this._portalHotfixRelease;
    }

    protected PortalHotfixReleaseJob(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, PortalHotfixRelease portalHotfixRelease, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        this._portalHotfixRelease = portalHotfixRelease;
    }

    protected PortalHotfixReleaseJob(JSONObject jsonObject) {
        super(jsonObject);
        this._portalHotfixRelease = new PortalHotfixRelease(jsonObject.getJSONObject("portal_hotfix_release"));
    }
}

