/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalHotfixRelease;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseBuild;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalHotfixReleasePortalTopLevelBuild
extends PortalTopLevelBuild
implements PortalHotfixReleaseBuild,
PortalWorkspaceBuild {
    private static final MultiPattern _hotfixZipURLPattern = new MultiPattern("https?://.*(?<majorVersion>\\d)(?<minorVersion>\\d)(?<fixVersion>\\d{2})\\.(lpkg|zip)", "https?://.*liferay-dxp-(?<majorVersion>\\d{4}).(?<minorVersion>q\\d+).(?<fixVersion>\\d+)-hotfix-\\d+.(zip|tar.gz|lpkg)");
    private static final Pattern _patcherPortalVersion62Pattern = Pattern.compile("(?<majorVersion>6)\\.(?<minorVersion>2)\\.(?<fixVersion>\\d{2})( SP(?<servicePackVersion>\\d+))?");
    private static final Pattern _patcherPortalVersion73Pattern = Pattern.compile("fix-pack-dxp-(?<fixpackVersion>\\d+)-7310");
    private static final Pattern _patcherPortalVersionDXPPattern = Pattern.compile("fix-pack-(?<fixpackType>de|dxp)-(?<fixpackVersion>\\d+)-(?<majorVersion>\\d)(?<minorVersion>\\d)(?<fixVersion>\\d{2})");
    private static final MultiPattern _patcherPortalVersionPattern = new MultiPattern("(?<majorVersion>7)\\.(?<minorVersion>4)\\.(?<fixVersion>\\d{2})(?<updateVersion>-(ep|u)\\d+)?", "(?<majorVersion>\\d{4}).(?<minorVersion>q\\d+).(?<fixVersion>\\d+)");
    private static final Pattern _quarterlyReleaseBranchNamePattern = Pattern.compile("(?<branchName>\\d{4}.[Qq]\\d+).\\d+");
    private PortalFixpackRelease _portalFixpackRelease;
    private PortalHotfixRelease _portalHotfixRelease;
    private PortalRelease _portalRelease;

    public PortalHotfixReleasePortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        String testBuildHotfixZipURL = this.getParameterValue("TEST_BUILD_HOTFIX_ZIP_URL");
        if (JenkinsResultsParserUtil.isNullOrEmpty(testBuildHotfixZipURL)) {
            throw new RuntimeException("Please set 'TEST_BUILD_HOTFIX_ZIP_URL'");
        }
        Matcher matcher = _hotfixZipURLPattern.find(testBuildHotfixZipURL);
        if (matcher == null) {
            throw new RuntimeException("Please set a valid 'TEST_BUILD_HOTFIX_ZIP_URL'");
        }
        String portalVersion = this.getParameterValue("PATCHER_BUILD_PATCHER_PORTAL_VERSION");
        if (PortalRelease.isQuarterlyRelease(portalVersion)) {
            return this._getQuarterlyReleaseBranchName(portalVersion);
        }
        String majorVersion = matcher.group("majorVersion");
        String minorVersion = matcher.group("minorVersion");
        if (majorVersion.equals("7") && minorVersion.equals("4")) {
            return "master";
        }
        String branchName = JenkinsResultsParserUtil.combine(majorVersion, ".", minorVersion, ".x");
        if (branchName.startsWith("6")) {
            return "ee-" + branchName;
        }
        return branchName;
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        Matcher matcher;
        if (this._portalFixpackRelease != null) {
            return this._portalFixpackRelease;
        }
        String patcherPortalVersion = this.getParameterValue("PATCHER_BUILD_PATCHER_PORTAL_VERSION");
        if (JenkinsResultsParserUtil.isNullOrEmpty(patcherPortalVersion)) {
            return null;
        }
        if (patcherPortalVersion.contains("7310")) {
            matcher = _patcherPortalVersion73Pattern.matcher(patcherPortalVersion);
            if (!matcher.find()) {
                return null;
            }
            String fixpackVersion = matcher.group("fixpackVersion");
            if (!fixpackVersion.equals("1") && !fixpackVersion.equals("2")) {
                return null;
            }
            try {
                URL portalFixpackURL = new URL(JenkinsResultsParserUtil.combine("https://files.liferay.com/private/ee/fix-packs/7.3.10", "/dxp/liferay-fix-pack-dxp-", fixpackVersion, "-7310.zip"));
                this._portalFixpackRelease = new PortalFixpackRelease(portalFixpackURL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        if (!(matcher = _patcherPortalVersionDXPPattern.matcher(patcherPortalVersion)).find()) {
            return null;
        }
        try {
            URL portalFixpackURL = new URL(JenkinsResultsParserUtil.combine("https://files.liferay.com/private/ee/fix-packs/", matcher.group("majorVersion"), ".", matcher.group("minorVersion"), ".", matcher.group("fixVersion"), "/", matcher.group("fixpackType"), "/liferay-", patcherPortalVersion, ".zip"));
            this._portalFixpackRelease = new PortalFixpackRelease(portalFixpackURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._portalFixpackRelease;
    }

    @Override
    public PortalHotfixRelease getPortalHotfixRelease() {
        if (this._portalHotfixRelease != null) {
            return this._portalHotfixRelease;
        }
        try {
            this._portalHotfixRelease = new PortalHotfixRelease(new URL(this.getParameterValue("TEST_BUILD_HOTFIX_ZIP_URL")), this.getPortalFixpackRelease(), this.getPortalRelease());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return this._portalHotfixRelease;
    }

    @Override
    public PortalRelease getPortalRelease() {
        Matcher hotfixZipURLMatcher;
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        if (portalFixpackRelease != null) {
            this._portalRelease = portalFixpackRelease.getPortalRelease();
            return this._portalRelease;
        }
        String patcherPortalVersion = this.getParameterValue("PATCHER_BUILD_PATCHER_PORTAL_VERSION");
        if (patcherPortalVersion.contains("7310")) {
            Matcher matcher = _patcherPortalVersion73Pattern.matcher(patcherPortalVersion);
            String portalReleaseVersion = "7.3.10";
            if (matcher.find()) {
                String fixpackVersion = matcher.group("fixpackVersion");
                portalReleaseVersion = fixpackVersion.equals("1") || fixpackVersion.equals("2") ? "7.3.10.1" : (fixpackVersion.equals("3") ? "7.3.10.3" : "7.3.10.u" + fixpackVersion);
            }
            this._portalRelease = new PortalRelease(portalReleaseVersion);
            return this._portalRelease;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(patcherPortalVersion)) {
            Matcher patcherPortalVersion62Matcher = _patcherPortalVersion62Pattern.matcher(patcherPortalVersion);
            if (patcherPortalVersion62Matcher.find()) {
                StringBuilder sb = new StringBuilder();
                sb.append(patcherPortalVersion62Matcher.group("majorVersion"));
                sb.append(".");
                sb.append(patcherPortalVersion62Matcher.group("minorVersion"));
                sb.append(".");
                sb.append(patcherPortalVersion62Matcher.group("fixVersion"));
                String servicePackVersion = patcherPortalVersion62Matcher.group("servicePackVersion");
                if (!JenkinsResultsParserUtil.isNullOrEmpty(servicePackVersion)) {
                    sb.append(".");
                    sb.append(Integer.parseInt(servicePackVersion) + 1);
                }
                this._portalRelease = new PortalRelease(sb.toString());
                return this._portalRelease;
            }
            Matcher patcherPortalVersionMatcher = _patcherPortalVersionPattern.find(patcherPortalVersion);
            if (patcherPortalVersionMatcher != null) {
                String updateVersion;
                StringBuilder sb = new StringBuilder();
                sb.append(patcherPortalVersionMatcher.group("majorVersion"));
                sb.append(".");
                sb.append(patcherPortalVersionMatcher.group("minorVersion"));
                sb.append(".");
                sb.append(patcherPortalVersionMatcher.group("fixVersion"));
                if (!PortalRelease.isQuarterlyRelease(patcherPortalVersion) && !JenkinsResultsParserUtil.isNullOrEmpty(updateVersion = patcherPortalVersionMatcher.group("updateVersion"))) {
                    sb.append(updateVersion);
                }
                this._portalRelease = new PortalRelease(sb.toString());
                return this._portalRelease;
            }
        }
        if ((hotfixZipURLMatcher = _hotfixZipURLPattern.find(this.getParameterValue("TEST_BUILD_HOTFIX_ZIP_URL"))) == null) {
            return null;
        }
        this._portalRelease = new PortalRelease(JenkinsResultsParserUtil.combine(hotfixZipURLMatcher.group("majorVersion"), ".", hotfixZipURLMatcher.group("minorVersion"), ".", hotfixZipURLMatcher.group("fixVersion")));
        return this._portalRelease;
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public Workspace getWorkspace() {
        String portalGitHubURL;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL = this._getPortalGitHubURL())) {
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            workspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        return workspace;
    }

    @Override
    protected String getReleaseRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    protected boolean isReleaseBuild() {
        return true;
    }

    private String _getPortalGitHubURL() {
        String portalBranchName = this.getParameterValue("TEST_PORTAL_USER_BRANCH_NAME");
        String portalBranchUsername = this.getParameterValue("TEST_PORTAL_USER_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(portalBranchUsername)) {
            String updateVersion;
            String patcherPortalVersion = this.getParameterValue("PATCHER_BUILD_PATCHER_PORTAL_VERSION");
            if (JenkinsResultsParserUtil.isNullOrEmpty(patcherPortalVersion)) {
                return null;
            }
            Matcher patcherPortalVersionMatcher = _patcherPortalVersionPattern.find(patcherPortalVersion);
            if (patcherPortalVersionMatcher == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(patcherPortalVersionMatcher.group("majorVersion"));
            sb.append(".");
            sb.append(patcherPortalVersionMatcher.group("minorVersion"));
            sb.append(".");
            sb.append(patcherPortalVersionMatcher.group("fixVersion"));
            if (!PortalRelease.isQuarterlyRelease(patcherPortalVersion) && !JenkinsResultsParserUtil.isNullOrEmpty(updateVersion = patcherPortalVersionMatcher.group("updateVersion"))) {
                sb.append(updateVersion);
            }
            portalBranchUsername = "liferay";
            portalBranchName = sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(portalBranchUsername);
        sb.append("/");
        sb.append(this.getReleaseRepositoryName());
        sb.append("/tree/");
        sb.append(portalBranchName);
        return sb.toString();
    }

    private String _getQuarterlyReleaseBranchName(String portalVersion) {
        Matcher quarterlyReleaseBranchMatcher = _quarterlyReleaseBranchNamePattern.matcher(portalVersion);
        if (quarterlyReleaseBranchMatcher.find()) {
            return "release-" + quarterlyReleaseBranchMatcher.group("branchName");
        }
        return "master";
    }
}

