/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildData;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class PortalTestSuiteUpstreamControllerBuildRunner<S extends PortalTestSuiteUpstreamControllerBuildData>
extends BaseBuildRunner<S> {
    private static final Pattern _portalBranchSHAPattern = Pattern.compile("<strong>GIT ID</strong> - <a href=\"https://github.com/[^/]+/[^/]+/commit/(?<branchSHA>[0-9a-f]{40})\">[0-9a-f]{7}</a>");
    private final List<String> _invokedTestSuiteNames = new ArrayList<String>();
    private List<String> _selectedTestSuiteNames;
    private Workspace _workspace;

    @Override
    public Workspace getWorkspace() {
        if (this._workspace != null) {
            return this._workspace;
        }
        this._workspace = WorkspaceFactory.newWorkspace();
        return this._workspace;
    }

    @Override
    public void run() {
        this.invokeTestSuiteBuilds();
    }

    @Override
    public void tearDown() {
    }

    protected PortalTestSuiteUpstreamControllerBuildRunner(S buildData) {
        super(buildData);
    }

    protected String getInvocationCohortName() {
        String invocationCohortName = System.getenv("INVOCATION_COHORT_NAME");
        if (invocationCohortName != null && !invocationCohortName.isEmpty()) {
            return invocationCohortName;
        }
        Object buildData = this.getBuildData();
        return buildData.getCohortName();
    }

    protected String getJobURL() {
        String mostAvailableMasterURL = JenkinsResultsParserUtil.getMostAvailableMasterURL(JenkinsResultsParserUtil.combine("http://" + this.getInvocationCohortName() + ".liferay.com"), null, 1, 24, 2);
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        return JenkinsResultsParserUtil.combine(mostAvailableMasterURL, "/job/test-portal-testsuite-upstream(", buildData.getPortalUpstreamBranchName(), ")");
    }

    protected String getTestPortalBuildProfile(String testSuite) {
        return this._getTestSuiteBuildProperty("portal.testsuite.upstream.test.portal.build.profile", testSuite);
    }

    protected String getTestraySlackChannels(String testSuite) {
        return this._getTestSuiteBuildProperty("portal.testsuite.upstream.testray.slack.channels", testSuite);
    }

    protected String getTestraySlackIconEmoji(String testSuite) {
        return this._getTestSuiteBuildProperty("portal.testsuite.upstream.testray.slack.icon.emoji", testSuite);
    }

    protected String getTestraySlackUsername(String testSuite) {
        return this._getTestSuiteBuildProperty("portal.testsuite.upstream.testray.slack.username", testSuite);
    }

    protected void invokeTestSuiteBuilds() {
        List<String> testSuiteNames = this._getSelectedTestSuiteNames();
        if (testSuiteNames.isEmpty()) {
            System.out.println("There are no test suites to run at this time.");
            this.keepJenkinsBuild(false);
            return;
        }
        String jenkinsAuthenticationToken = null;
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            jenkinsAuthenticationToken = buildProperties.getProperty("jenkins.authentication.token");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        String portalBranchSHA = buildData.getPortalBranchSHA();
        for (String testSuiteName : testSuiteNames) {
            JSONObject previousBuildJSONObject = this._getPreviousTestSuiteBuildJSONObject(testSuiteName);
            if (previousBuildJSONObject != null && this._previousBuildHasCurrentSHA(previousBuildJSONObject, portalBranchSHA)) {
                System.out.println(testSuiteName + " was invoked on this SHA already: " + portalBranchSHA);
                continue;
            }
            String jobURL = this.getJobURL();
            StringBuilder sb = new StringBuilder();
            sb.append(jobURL);
            sb.append("/buildWithParameters?");
            sb.append("token=");
            sb.append(jenkinsAuthenticationToken);
            HashMap<String, Object> invocationParameters = new HashMap<String, Object>();
            invocationParameters.put("CI_TEST_SUITE", testSuiteName);
            invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", buildData.getJenkinsGitHubBranchName());
            invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", buildData.getJenkinsGitHubUsername());
            invocationParameters.put("PORTAL_GIT_COMMIT", portalBranchSHA);
            invocationParameters.put("PORTAL_GITHUB_URL", buildData.getPortalGitHubURL());
            invocationParameters.put("TEST_PORTAL_BUILD_PROFILE", this.getTestPortalBuildProfile(testSuiteName));
            String testrayProjectName = this._getTestrayProjectName(testSuiteName);
            if (testrayProjectName != null) {
                Object testrayRoutineName = JenkinsResultsParserUtil.combine("[", buildData.getPortalUpstreamBranchName(), "] ci:test:", testSuiteName);
                String string = JenkinsResultsParserUtil.combine(new String[]{testrayRoutineName, " - ", String.valueOf(buildData.getBuildNumber()), " - ", JenkinsResultsParserUtil.toDateString(new Date(buildData.getStartTime()), "yyyy-MM-dd[HH:mm:ss]", "America/Los_Angeles")});
                if (this._getTestrayRoutineName(testSuiteName) != null) {
                    testrayRoutineName = this._getTestrayRoutineName(testSuiteName);
                }
                invocationParameters.put("TESTRAY_BUILD_NAME", string);
                invocationParameters.put("TESTRAY_PROJECT_NAME", testrayProjectName);
                invocationParameters.put("TESTRAY_ROUTINE_NAME", testrayRoutineName);
            }
            invocationParameters.put("TESTRAY_SLACK_CHANNELS", this.getTestraySlackChannels(testSuiteName));
            invocationParameters.put("TESTRAY_SLACK_ICON_EMOJI", this.getTestraySlackIconEmoji(testSuiteName));
            invocationParameters.put("TESTRAY_SLACK_USERNAME", this.getTestraySlackUsername(testSuiteName));
            invocationParameters.putAll(buildData.getBuildParameters());
            for (Map.Entry entry : invocationParameters.entrySet()) {
                String invocationParameterValue = (String)entry.getValue();
                if (JenkinsResultsParserUtil.isNullOrEmpty(invocationParameterValue)) continue;
                sb.append("&");
                sb.append((String)entry.getKey());
                sb.append("=");
                sb.append(invocationParameterValue);
            }
            try {
                JenkinsResultsParserUtil.toString(sb.toString());
                System.out.println("Job for '" + testSuiteName + "' was invoked at " + jobURL);
                this._invokedTestSuiteNames.add(testSuiteName);
            }
            catch (IOException ioException) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to invoke a new build for test suite, '", testSuiteName, "'"));
                ioException.printStackTrace();
            }
        }
        boolean keepLogs = true;
        if (this._invokedTestSuiteNames.isEmpty()) {
            keepLogs = false;
        }
        this.keepJenkinsBuild(keepLogs);
        StringBuilder sb = new StringBuilder();
        sb.append(JenkinsResultsParserUtil.join(", ", this._invokedTestSuiteNames));
        sb.append(",");
        sb.append(" <strong>GIT ID</strong> - ");
        sb.append("<a href=\"https://github.com/");
        sb.append(buildData.getPortalGitHubUsername());
        sb.append("/");
        sb.append(buildData.getPortalGitHubRepositoryName());
        sb.append("/commit/");
        sb.append(portalBranchSHA);
        sb.append("\">");
        sb.append(this._getPortalBranchAbbreviatedSHA());
        sb.append("</a>");
        buildData.setBuildDescription(sb.toString());
        this.updateBuildDescription();
    }

    private List<Build> _getBuildHistory() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        Build build = BuildFactory.newBuild(buildData.getBuildURL(), null);
        Job job = JobFactory.newJob(buildData.getJobName());
        return job.getBuildHistory(build.getJenkinsMaster());
    }

    private List<String> _getBuildTestSuiteNames(Build build) {
        String buildDescription = build.getBuildDescription();
        if (buildDescription == null || buildDescription.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(buildDescription.split("\\s*,\\s*"));
    }

    private Map<String, Long> _getCandidateTestSuiteStaleDurations() {
        Properties buildProperties;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        String upstreamBranchName = buildData.getPortalUpstreamBranchName();
        LinkedHashMap<String, Long> candidateTestSuiteStaleDurations = new LinkedHashMap<String, Long>();
        for (String testSuiteName : this._getTestSuiteNames()) {
            String suiteStaleDuration = buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.testsuite.upstream.stale.duration[", upstreamBranchName, "][", testSuiteName, "]"));
            if (suiteStaleDuration == null) continue;
            candidateTestSuiteStaleDurations.put(testSuiteName, Long.parseLong(suiteStaleDuration) * 60L * 1000L);
        }
        return candidateTestSuiteStaleDurations;
    }

    private Map<String, Long> _getLatestTestSuiteStartTimes() {
        LinkedHashMap<String, Long> latestTestSuiteStartTimes = new LinkedHashMap<String, Long>();
        List<Build> builds = this._getBuildHistory();
        Object buildData = this.getBuildData();
        Build currentBuild = BuildFactory.newBuild(buildData.getBuildURL(), null);
        builds.remove(currentBuild);
        block0: for (String testSuiteName : this._getTestSuiteNames()) {
            for (Build build : builds) {
                List<String> buildTestSuiteNames = this._getBuildTestSuiteNames(build);
                if (!buildTestSuiteNames.contains(testSuiteName)) continue;
                latestTestSuiteStartTimes.put(testSuiteName, build.getStartTime());
                continue block0;
            }
        }
        return latestTestSuiteStartTimes;
    }

    private String _getPortalBranchAbbreviatedSHA() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        String portalBranchSHA = buildData.getPortalBranchSHA();
        return portalBranchSHA.substring(0, 7);
    }

    private JSONObject _getPreviousTestSuiteBuildJSONObject(String testSuiteName) {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            String description = previousBuildJSONObject.optString("description", "");
            if (description.contains("EXPIRE") || description.contains("SKIPPED") || !description.contains(testSuiteName)) continue;
            return previousBuildJSONObject;
        }
        return null;
    }

    private List<String> _getSelectedTestSuiteNames() {
        if (this._selectedTestSuiteNames != null) {
            return this._selectedTestSuiteNames;
        }
        this._selectedTestSuiteNames = new ArrayList<String>();
        Map<String, Long> candidateTestSuiteStaleDurations = this._getCandidateTestSuiteStaleDurations();
        Map<String, Long> latestTestSuiteStartTimes = this._getLatestTestSuiteStartTimes();
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        Long startTime = buildData.getStartTime();
        for (Map.Entry<String, Long> entry : candidateTestSuiteStaleDurations.entrySet()) {
            String testSuiteName = entry.getKey();
            if (!latestTestSuiteStartTimes.containsKey(testSuiteName)) {
                this._selectedTestSuiteNames.add(testSuiteName);
                continue;
            }
            Long testSuiteIdleDuration = startTime - latestTestSuiteStartTimes.get(testSuiteName);
            if (testSuiteIdleDuration <= entry.getValue()) continue;
            this._selectedTestSuiteNames.add(testSuiteName);
        }
        return this._selectedTestSuiteNames;
    }

    private String _getTestrayProjectName(String testSuite) {
        return this._getTestSuiteBuildProperty("portal.testsuite.upstream.testray.project.name", testSuite);
    }

    private String _getTestrayRoutineName(String testSuite) {
        String testrayRoutineName = this._getTestSuiteBuildProperty("portal.testsuite.upstream.testray.routine.name", testSuite);
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName)) {
            testrayRoutineName = this._getTestSuiteBuildProperty("portal.testsuite.upstream.testray.build.type", testSuite);
        }
        return testrayRoutineName;
    }

    private String _getTestSuiteBuildProperty(String propertyName, String testSuite) {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), propertyName, buildData.getPortalUpstreamBranchName(), testSuite);
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private List<String> _getTestSuiteNames() {
        PortalTestSuiteUpstreamControllerBuildData buildData = (PortalTestSuiteUpstreamControllerBuildData)this.getBuildData();
        try {
            return JenkinsResultsParserUtil.getBuildPropertyAsList(true, JenkinsResultsParserUtil.combine("portal.testsuite.upstream.suites[", buildData.getPortalUpstreamBranchName(), "]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private boolean _previousBuildHasCurrentSHA(JSONObject previousBuildJSONObject, String portalBranchSHA) {
        if (previousBuildJSONObject == null) {
            return false;
        }
        String description = previousBuildJSONObject.optString("description", "");
        Matcher matcher = _portalBranchSHAPattern.matcher(description);
        if (!matcher.find()) {
            return false;
        }
        String previousPortalBranchSHA = matcher.group("branchSHA");
        return portalBranchSHA.equals(previousPortalBranchSHA);
    }
}

