/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AnalyticsCloudBranchInformationBuild;
import com.liferay.jenkins.results.parser.BaseTopLevelBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.PluginsBranchInformationBuild;
import com.liferay.jenkins.results.parser.PluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalFixpackReleaseBuild;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalReleaseBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.net.MalformedURLException;
import java.net.URL;

public class PortalTopLevelBuild
extends DefaultTopLevelBuild
implements AnalyticsCloudBranchInformationBuild,
PluginsBranchInformationBuild,
PortalBranchInformationBuild,
PortalFixpackReleaseBuild,
PortalReleaseBuild {
    protected PortalFixpackRelease portalFixpackRelease;
    protected PortalRelease portalRelease;

    public PortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        String branchName = this.getBranchName();
        if (branchName.startsWith("faro-v") || branchName.equals("master")) {
            return "liferay-portal";
        }
        return "liferay-portal-ee";
    }

    @Override
    public Build.BranchInformation getOSBAsahBranchInformation() {
        if (this.fromArchive || !(this instanceof PortalWorkspaceBuild)) {
            return this.getBranchInformation("osb.asah");
        }
        PortalWorkspaceBuild portalWorkspaceBuild = (PortalWorkspaceBuild)((Object)this);
        PortalWorkspace portalWorkspace = portalWorkspaceBuild.getPortalWorkspace();
        if (portalWorkspace == null) {
            return null;
        }
        WorkspaceGitRepository workspaceGitRepository = portalWorkspace.getOSBAsahWorkspaceGitRepository();
        if (workspaceGitRepository == null) {
            return null;
        }
        return new BaseTopLevelBuild.WorkspaceBranchInformation(workspaceGitRepository);
    }

    @Override
    public Build.BranchInformation getPluginsBranchInformation() {
        if (this.fromArchive || !(this instanceof PortalWorkspaceBuild)) {
            return this.getBranchInformation("plugins");
        }
        PortalWorkspaceBuild portalWorkspaceBuild = (PortalWorkspaceBuild)((Object)this);
        PortalWorkspace portalWorkspace = portalWorkspaceBuild.getPortalWorkspace();
        if (portalWorkspace == null) {
            return null;
        }
        PluginsWorkspaceGitRepository workspaceGitRepository = portalWorkspace.getPluginsWorkspaceGitRepository();
        if (workspaceGitRepository == null) {
            return null;
        }
        return new BaseTopLevelBuild.WorkspaceBranchInformation(workspaceGitRepository);
    }

    @Override
    public Build.BranchInformation getPortalBaseBranchInformation() {
        if (this instanceof PortalWorkspaceBuild) {
            return null;
        }
        Build.BranchInformation portalBranchInformation = this.getPortalBranchInformation();
        if (portalBranchInformation == null) {
            return null;
        }
        String upstreamBranchName = portalBranchInformation.getUpstreamBranchName();
        if (upstreamBranchName.contains("-private")) {
            return this.getBranchInformation("portal.base");
        }
        return null;
    }

    @Override
    public Build.BranchInformation getPortalBranchInformation() {
        if (this.fromArchive || !(this instanceof PortalWorkspaceBuild)) {
            return this.getBranchInformation("portal");
        }
        PortalWorkspaceBuild portalWorkspaceBuild = (PortalWorkspaceBuild)((Object)this);
        PortalWorkspace portalWorkspace = portalWorkspaceBuild.getPortalWorkspace();
        if (portalWorkspace == null) {
            return null;
        }
        PortalWorkspaceGitRepository workspaceGitRepository = portalWorkspace.getPortalWorkspaceGitRepository();
        if (workspaceGitRepository == null) {
            return null;
        }
        return new BaseTopLevelBuild.WorkspaceBranchInformation(workspaceGitRepository);
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        if (this.portalFixpackRelease != null) {
            return this.portalFixpackRelease;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild == null) {
            return null;
        }
        String portalFixPackVersion = controllerBuild.getParameterValue("PORTAL_FIX_PACK_VERSION");
        if (portalFixPackVersion != null) {
            this.portalFixpackRelease = new PortalFixpackRelease(portalFixPackVersion, this.getPortalRelease());
            return this.portalFixpackRelease;
        }
        String portalFixPackZipURL = controllerBuild.getParameterValue("TEST_PORTAL_FIX_PACK_ZIP_URL");
        if (portalFixPackZipURL != null) {
            try {
                this.portalFixpackRelease = new PortalFixpackRelease(new URL(portalFixPackZipURL));
                return this.portalFixpackRelease;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return this.portalFixpackRelease;
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this.portalRelease != null) {
            return this.portalRelease;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild == null) {
            return null;
        }
        String portalBundleVersion = controllerBuild.getParameterValue("PORTAL_BUNDLE_VERSION");
        if (portalBundleVersion != null) {
            this.portalRelease = new PortalRelease(portalBundleVersion);
            return this.portalRelease;
        }
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        if (portalFixpackRelease != null) {
            this.portalRelease = portalFixpackRelease.getPortalRelease();
            return this.portalRelease;
        }
        return this.portalRelease;
    }
}

