/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.TopLevelBuildRunner;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;

public abstract class PortalTopLevelBuildRunner<T extends PortalTopLevelBuildData>
extends TopLevelBuildRunner<T> {
    private Workspace _workspace;

    @Override
    public Workspace getWorkspace() {
        if (this._workspace != null) {
            return this._workspace;
        }
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
        this._workspace = WorkspaceFactory.newWorkspace(portalTopLevelBuildData.getPortalGitHubRepositoryName(), portalTopLevelBuildData.getPortalUpstreamBranchName(), portalTopLevelBuildData.getTopLevelJobName());
        for (WorkspaceGitRepository workspaceGitRepository : this._workspace.getWorkspaceGitRepositories()) {
            workspaceGitRepository.addPropertyOption(String.valueOf((Object)portalTopLevelBuildData.getBuildProfile()));
            workspaceGitRepository.addPropertyOption(String.valueOf(portalTopLevelBuildData.getTopLevelJobName()));
            workspaceGitRepository.addPropertyOption(workspaceGitRepository.getUpstreamBranchName());
            String dockerEnabled = System.getenv("LIFERAY_DOCKER_ENABLED");
            if (dockerEnabled != null && dockerEnabled.equals("true")) {
                workspaceGitRepository.addPropertyOption("docker");
            }
            if (JenkinsResultsParserUtil.isWindows()) {
                workspaceGitRepository.addPropertyOption("windows");
                continue;
            }
            workspaceGitRepository.addPropertyOption("unix");
        }
        WorkspaceGitRepository primaryWorkspaceGitRepository = this._workspace.getPrimaryWorkspaceGitRepository();
        primaryWorkspaceGitRepository.setGitHubURL(portalTopLevelBuildData.getPortalGitHubURL());
        return this._workspace;
    }

    protected PortalTopLevelBuildRunner(T portalTopLevelBuildData) {
        super(portalTopLevelBuildData);
    }
}

