/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.BaseWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.Retryable;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.suite.RelevantTestSuite;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.json.JSONObject;

public class PortalWorkspaceGitRepository
extends BaseWorkspaceGitRepository {
    private static final int _SETUP_PROFILE_DXP_RETRY_COUNT = 2;
    private static final int _SETUP_PROFILE_DXP_RETRY_DELAY = 5;

    public boolean bypassCITestRelevant() {
        this.setUp();
        Properties testProperties = JenkinsResultsParserUtil.getProperties(new File(this.getDirectory(), "test.properties"));
        boolean relevantEngineEnabled = Boolean.parseBoolean(testProperties.getProperty("relevant.engine.enabled"));
        if (relevantEngineEnabled) {
            RelevantTestSuite relevantTestSuite = new RelevantTestSuite(this._getRelevantPortalAcceptancePullRequestJob());
            List<TestBatch> testBatches = relevantTestSuite.getTestBatches(true);
            return testBatches.isEmpty();
        }
        String ciTestRelevantBypassFilePathPatterns = JenkinsResultsParserUtil.getCIProperty(this.getUpstreamBranchName(), "ci.test.relevant.bypass.file.path.patterns", this.getName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(ciTestRelevantBypassFilePathPatterns)) {
            return false;
        }
        MultiPattern multiPattern = new MultiPattern(ciTestRelevantBypassFilePathPatterns.split("\\s*,\\s*"));
        ArrayList<String> filePaths = new ArrayList<String>();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (File modifiedFile : gitWorkingDirectory.getModifiedFilesList()) {
            filePaths.add(JenkinsResultsParserUtil.getCanonicalPath(modifiedFile));
        }
        for (File deletedFile : gitWorkingDirectory.getDeletedFilesList()) {
            filePaths.add(JenkinsResultsParserUtil.getCanonicalPath(deletedFile));
        }
        return multiPattern.matchesAll(filePaths.toArray(new String[0]));
    }

    public String getLiferayFacesAlloyURL() {
        return this._getLiferayFacesURL("liferay-faces-alloy", "liferay.faces.alloy.branch");
    }

    public String getLiferayFacesBridgeImplURL() {
        return this._getLiferayFacesURL("liferay-faces-bridge-impl", "liferay.faces.bridge.impl.branch");
    }

    public String getLiferayFacesPortalURL() {
        return this._getLiferayFacesURL("liferay-faces-portal", "liferay.faces.portal.branch");
    }

    public String getLiferayFacesShowcaseURL() {
        return this._getLiferayFacesURL("liferay-faces-showcase", "liferay.faces.showcase.branch");
    }

    public String getPluginsRepositoryDirName() {
        try {
            String lpPluginsDirString = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "portal.release.properties", "lp.plugins.dir", this.getUpstreamBranchName());
            if (JenkinsResultsParserUtil.isNullOrEmpty(lpPluginsDirString)) {
                return null;
            }
            return lpPluginsDirString.replaceAll(".*/([^/]+)", "$1");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public String getPortalPrivateRepositoryDirName() {
        return JenkinsResultsParserUtil.getGitDirectoryName("liferay-portal-ee", this.getUpstreamBranchName() + "-private");
    }

    public void setUpPortalProfile() {
        String upstreamBranchName = this.getUpstreamBranchName();
        if (upstreamBranchName.startsWith("ee-")) {
            return;
        }
        Retryable<Object> setupProfileDXPRetryable = new Retryable<Object>(true, 2, 5, true){

            @Override
            public Object execute() {
                try {
                    AntUtil.callTarget(PortalWorkspaceGitRepository.this.getDirectory(), "build.xml", "setup-profile-dxp");
                }
                catch (AntException antException) {
                    throw new RuntimeException(antException);
                }
                return null;
            }
        };
        setupProfileDXPRetryable.executeWithRetries();
    }

    public void setUpTCKHome() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String tckHome = JenkinsResultsParserUtil.getProperty(this._getPortalTestProperties(), "tck.home");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(tckHome)) {
            parameters.put("tck.home", tckHome);
        }
        try {
            AntUtil.callTarget(this.getDirectory(), "build-test-tck.xml", "prepare-tck", parameters);
        }
        catch (AntException antException) {
            throw new RuntimeException(antException);
        }
    }

    @Override
    public void writePropertiesFiles() {
        this._writeAppServerPropertiesFile();
        this._writeBuildPropertiesFile();
        this._writeReleasePropertiesFile();
        this._writeSQLPropertiesFile();
        this._writeTestPropertiesFile();
    }

    protected PortalWorkspaceGitRepository(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected PortalWorkspaceGitRepository(PullRequest pullRequest, String upstreamBranchName) {
        super(pullRequest, upstreamBranchName);
    }

    protected PortalWorkspaceGitRepository(RemoteGitRef remoteGitRef, String upstreamBranchName) {
        super(remoteGitRef, upstreamBranchName);
    }

    @Override
    protected Set<String> getPropertyOptions() {
        HashSet<String> propertyOptions = new HashSet<String>(super.getPropertyOptions());
        propertyOptions.add(this.getUpstreamBranchName());
        return propertyOptions;
    }

    private String _getLiferayFacesURL(String repositoryName, String propertyName) {
        try {
            String branchName = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "portal.test.properties", propertyName, this.getUpstreamBranchName());
            if (JenkinsResultsParserUtil.isNullOrEmpty(branchName)) {
                branchName = "master";
            }
            return JenkinsResultsParserUtil.combine("https://github.com/liferay/", repositoryName, "/tree/", branchName);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private Properties _getPortalTestProperties() {
        Properties testProperties = this.getProperties("portal.test.properties");
        String companyDefaultLocale = System.getenv("TEST_COMPANY_DEFAULT_LOCALE");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(companyDefaultLocale)) {
            testProperties.setProperty("test.company.default.locale", companyDefaultLocale);
        }
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String latestBundleVersion = JenkinsResultsParserUtil.getProperty(buildProperties, "portal.latest.bundle.version", this.getUpstreamBranchName());
        if (!JenkinsResultsParserUtil.isNullOrEmpty(latestBundleVersion)) {
            testProperties.put("test.released.release.bundle.version", latestBundleVersion);
            testProperties.put("test.released.test.portal.bundle.zip.url", JenkinsResultsParserUtil.getProperty(buildProperties, "portal.bundle.tomcat", latestBundleVersion));
        }
        return testProperties;
    }

    private PortalAcceptancePullRequestJob _getRelevantPortalAcceptancePullRequestJob() {
        String upstreamBranchName = this.getUpstreamBranchName();
        PortalGitWorkingDirectory portalGitWorkingDirectory = (PortalGitWorkingDirectory)this.getGitWorkingDirectory();
        portalGitWorkingDirectory.getGitRepositoryName();
        return (PortalAcceptancePullRequestJob)JobFactory.newJob(Job.BuildProfile.DXP, "test-portal-acceptance-pullrequest(master)", null, portalGitWorkingDirectory, upstreamBranchName, null, portalGitWorkingDirectory.getGitRepositoryName(), "relevant", upstreamBranchName);
    }

    private void _writeAppServerPropertiesFile() {
        JenkinsResultsParserUtil.writePropertiesFile(new File(this.getDirectory(), JenkinsResultsParserUtil.combine("app.server.", System.getenv("HOSTNAME"), ".properties")), this.getProperties("portal.app.server.properties"), true);
    }

    private void _writeBuildPropertiesFile() {
        JenkinsResultsParserUtil.writePropertiesFile(new File(this.getDirectory(), JenkinsResultsParserUtil.combine("build.", System.getenv("HOSTNAME"), ".properties")), this.getProperties("portal.build.properties"), true);
    }

    private void _writeReleasePropertiesFile() {
        JenkinsResultsParserUtil.writePropertiesFile(new File(this.getDirectory(), JenkinsResultsParserUtil.combine("release.", System.getenv("HOSTNAME"), ".properties")), this.getProperties("portal.release.properties"), true);
    }

    private void _writeSQLPropertiesFile() {
        JenkinsResultsParserUtil.writePropertiesFile(new File(this.getDirectory(), JenkinsResultsParserUtil.combine("sql/sql.", System.getenv("HOSTNAME"), ".properties")), this.getProperties("portal.sql.properties"), true);
    }

    private void _writeTestPropertiesFile() {
        JenkinsResultsParserUtil.writePropertiesFile(new File(this.getDirectory(), JenkinsResultsParserUtil.combine("test.", System.getenv("HOSTNAME"), ".properties")), this._getPortalTestProperties(), true);
    }
}

