/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class PoshiAxisBuild
extends AxisBuild {
    @Override
    public List<TestResult> getTestResults() {
        String status = this.getStatus();
        if (status == null || !status.equals("completed")) {
            return Collections.emptyList();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        String result = this.getResult();
        if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
            testResults.addAll(super.getTestResults());
        }
        ArrayList<String> existingTestNames = new ArrayList<String>();
        for (TestResult testResult : testResults) {
            String testNameRegex;
            String testName = testResult.getTestName();
            if (!testName.matches(testNameRegex = "test\\[([^\\]]+)\\]")) continue;
            existingTestNames.add(testName.replaceAll(testNameRegex, "$1"));
        }
        for (String poshiTestName : this._getPoshiTestNames()) {
            if (existingTestNames.contains(poshiTestName)) continue;
            JSONObject caseJSONObject = new JSONObject();
            caseJSONObject.put("className", (Object)"com.liferay.poshi.runner.PoshiRunner").put("duration", this.getDuration()).put("errorDetails", (Object)"The build failed prior to running the test.").put("errorStackTrace", (Object)"").put("name", (Object)("test[" + poshiTestName + "]")).put("status", (Object)"FAILED");
            testResults.add(TestResultFactory.newTestResult(this, caseJSONObject));
        }
        return testResults;
    }

    protected PoshiAxisBuild(String url) {
        this(url, null);
    }

    protected PoshiAxisBuild(String url, BatchBuild parentBatchBuild) {
        super(url, parentBatchBuild);
    }

    private List<String> _getPoshiTestNames() {
        String runTestCaseMethodGroup;
        String poshiTestNamesKey;
        ArrayList<String> poshiTestNames = new ArrayList<String>();
        if (this.fromArchive) {
            return poshiTestNames;
        }
        BuildDatabase buildDatabase = this.getBuildDatabase();
        Properties startProperties = buildDatabase.getProperties(this.getJobVariant() + "/start.properties");
        String poshiTestNamesString = JenkinsResultsParserUtil.getProperty(startProperties, poshiTestNamesKey = JenkinsResultsParserUtil.combine("RUN_TEST_CASE_METHOD_GROUP_", runTestCaseMethodGroup = JenkinsResultsParserUtil.getProperty(startProperties, "RUN_TEST_CASE_METHOD_GROUP"), "_", this.getAxisNumber()));
        if (poshiTestNamesString != null && !poshiTestNamesString.isEmpty()) {
            Collections.addAll(poshiTestNames, poshiTestNamesString.split(","));
        }
        return poshiTestNames;
    }
}

