/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class PoshiDownstreamBuild
extends DownstreamBuild {
    @Override
    public List<TestResult> getTestResults() {
        String status = this.getStatus();
        if (status == null || !status.equals("completed")) {
            return Collections.emptyList();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        String result = this.getResult();
        if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
            testResults.addAll(super.getTestResults());
        }
        ArrayList<String> existingTestNames = new ArrayList<String>();
        for (TestResult testResult : testResults) {
            String testNameRegex;
            String testName = testResult.getTestName();
            if (!testName.matches(testNameRegex = "test\\[([^\\]]+)\\]")) continue;
            existingTestNames.add(testName.replaceAll(testNameRegex, "$1"));
        }
        for (String poshiTestName : this._getPoshiTestNames()) {
            if (existingTestNames.contains(poshiTestName)) continue;
            JSONObject caseJSONObject = new JSONObject();
            caseJSONObject.put("className", (Object)"com.liferay.poshi.runner.PoshiRunner").put("duration", 0).put("errorDetails", (Object)"The build failed prior to running the test.").put("errorStackTrace", (Object)"").put("name", (Object)("test[" + poshiTestName + "]")).put("status", (Object)"FAILED");
            testResults.add(TestResultFactory.newTestResult(this, caseJSONObject));
        }
        return testResults;
    }

    protected PoshiDownstreamBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    private List<String> _getPoshiTestNames() {
        BuildDatabase buildDatabase = this.getBuildDatabase();
        Properties startProperties = buildDatabase.getProperties(this.getJobVariant() + "/start.properties");
        String runTestCaseMethodGroup = JenkinsResultsParserUtil.getProperty(startProperties, "RUN_TEST_CASE_METHOD_GROUP");
        String poshiTestNamesKey = JenkinsResultsParserUtil.combine("RUN_TEST_CASE_METHOD_GROUP_", runTestCaseMethodGroup, "_", this.getAxisVariable());
        String poshiTestNames = JenkinsResultsParserUtil.getProperty(startProperties, poshiTestNamesKey);
        if (JenkinsResultsParserUtil.isNullOrEmpty(poshiTestNames)) {
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Object[])poshiTestNames.split(","));
    }
}

