/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JUnitTestResult;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestHistory;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.json.JSONObject;

public class PoshiJUnitTestResult
extends JUnitTestResult {
    private static final Pattern _pattern = Pattern.compile("test\\[(?<poshiTestName>[^\\]]+)\\]");
    private TestClass _testClass;

    @Override
    public String getDisplayName() {
        String testName = this.getTestName();
        if (testName.startsWith("test[")) {
            return testName.substring(5, testName.length() - 1);
        }
        return this.getSimpleClassName() + "." + testName;
    }

    @Override
    public Element getGitHubElement() {
        String errorDetails;
        String testReportURL = this.getTestReportURL();
        Element downstreamBuildListItemElement = Dom4JUtil.getNewElement("div", null, new Object[0]);
        downstreamBuildListItemElement.add(Dom4JUtil.getNewAnchorElement(testReportURL, this.getDisplayName()));
        Build build = this.getBuild();
        String consoleText = build.getConsoleText();
        if (consoleText.contains(this.getPoshiReportURL())) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getPoshiReportURL(), "Poshi Report"));
        }
        if (consoleText.contains(this.getPoshiSummaryURL())) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getPoshiSummaryURL(), "Poshi Summary"));
        }
        if (consoleText.contains(this.getPoshiConsoleURL())) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getPoshiConsoleURL(), "Poshi Console"));
        }
        Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getConsoleOutputURL(), "Console Output"));
        TestHistory testHistory = this.getTestHistory();
        if (testHistory != null) {
            downstreamBuildListItemElement.addText(" - ");
            downstreamBuildListItemElement.add(Dom4JUtil.getNewAnchorElement(testHistory.getTestrayCaseResultURL(), JenkinsResultsParserUtil.combine("Failed ", String.valueOf(testHistory.getFailureCount()), " of last ", String.valueOf(testHistory.getTestCount()))));
        }
        if ((errorDetails = this.getErrorDetails()) != null && !errorDetails.isEmpty()) {
            Dom4JUtil.addToElement(Dom4JUtil.toCodeSnippetElement(errorDetails), new Object[0]);
        }
        if (this.hasLiferayLog()) {
            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(this.getLiferayLogURL(), "Liferay Log"));
        }
        return downstreamBuildListItemElement;
    }

    @Override
    public TestClass getTestClass() {
        if (this._testClass != null) {
            return this._testClass;
        }
        Build build = this.getBuild();
        if (!(build instanceof DownstreamBuild)) {
            return null;
        }
        DownstreamBuild downstreamBuild = (DownstreamBuild)build;
        AxisTestClassGroup axisTestClassGroup = downstreamBuild.getAxisTestClassGroup();
        if (axisTestClassGroup == null) {
            return null;
        }
        String poshiTestName = this._getPoshiTestName();
        for (TestClass testClass : axisTestClassGroup.getTestClasses()) {
            FunctionalTestClass functionalTestClass;
            if (!(testClass instanceof FunctionalTestClass) || !Objects.equals(poshiTestName, (functionalTestClass = (FunctionalTestClass)testClass).getTestClassMethodName())) continue;
            this._testClass = testClass;
            return this._testClass;
        }
        return null;
    }

    protected PoshiJUnitTestResult(Build build, JSONObject caseJSONObject) {
        super(build, caseJSONObject);
    }

    protected String getPoshiConsoleURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.getTestrayLogsURL());
        sb.append("/");
        sb.append(name.replace('#', '_'));
        sb.append("/console.txt.gz");
        return sb.toString();
    }

    protected String getPoshiReportURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.getTestrayLogsURL());
        sb.append("/");
        sb.append(name.replace('#', '_'));
        sb.append("/index.html.gz");
        return sb.toString();
    }

    protected String getPoshiSummaryURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.getTestrayLogsURL());
        sb.append("/");
        sb.append(name.replace('#', '_'));
        sb.append("/summary.html.gz");
        return sb.toString();
    }

    private String _getPoshiTestName() {
        String testName = this.getTestName();
        Matcher matcher = _pattern.matcher(testName);
        if (!matcher.find()) {
            return testName;
        }
        return matcher.group("poshiTestName");
    }
}

