/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildRunner;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.QAWebsitesGitWorkingDirectory;
import com.liferay.jenkins.results.parser.QAWebsitesWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.RemoteGitRepository;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class PoshiReleasePortalTopLevelBuildRunner
extends PortalTopLevelBuildRunner<PortalTopLevelBuildData> {
    private static final String _BUILD_GRADLE_PLUGINS_REGEX = "([\\s]*)(.*\"com\\.liferay\\.gradle\\.plugins\\.defaults\".*)";
    private static final String _DEFAULT_CI_TEST_SUITE = "poshi-release";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL = "PORTAL_GITHUB_URL";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_MASTER_CI_TEST_SUITE = "PORTAL_MASTER_CI_TEST_SUITE";
    private static final Pattern _bundleVersionPattern = Pattern.compile("Bundle-Version:[\\s]*(.*)");
    private static final Pattern _gitHubURLPattern = Pattern.compile("https://github.com/(?<username>[^/]+)/(?<repository>[^/]+)/(commits|tree)/(?<branch>[^/]+)");
    private String _gradlePluginsPoshiRunnerVersion;
    private final Map<GitWorkingDirectory, PullRequest> _pullRequests = new HashMap<GitWorkingDirectory, PullRequest>();
    private final Map<GitWorkingDirectory, RemoteGitBranch> _remoteGitBranches = new HashMap<GitWorkingDirectory, RemoteGitBranch>();

    @Override
    public Workspace getWorkspace() {
        Workspace workspace = super.getWorkspace();
        WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        primaryWorkspaceGitRepository.setRebase(true);
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
        primaryWorkspaceGitRepository.setGitHubURL(portalTopLevelBuildData.getPortalGitHubURL());
        return workspace;
    }

    @Override
    public void run() {
        this.validateBuildParameters();
        this.publishJenkinsReport();
        this.updateBuildDescription();
        this.setUpWorkspace();
        this._preparePoshiPortalPullRequests();
        this.invokeDownstreamBuilds();
        this.waitForDownstreamBuildsToComplete();
        this.publishJenkinsReport();
        this._deleteRemoteGitBranches();
    }

    protected PoshiReleasePortalTopLevelBuildRunner(PortalTopLevelBuildData portalTopLevelBuildData) {
        super(portalTopLevelBuildData);
    }

    @Override
    protected void invokeDownstreamBuilds() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        for (Map.Entry<GitWorkingDirectory, PullRequest> entry : this._pullRequests.entrySet()) {
            GitWorkingDirectory gitWorkingDirectory = entry.getKey();
            for (String jobName : this._getJobNames(gitWorkingDirectory)) {
                topLevelBuild.addDownstreamBuilds(this._getBuildInvocationURL(jobName, entry));
            }
        }
    }

    @Override
    protected void prepareInvocationBuildDataList() {
    }

    @Override
    protected void validateBuildParameters() {
        this._validateBuildParameterPortalGitHubURL();
    }

    private void _commitGradlePluginsPoshiRunnerCache(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        File buildGradleFile = null;
        if (gitWorkingDirectory instanceof PortalGitWorkingDirectory) {
            buildGradleFile = this._getBuildTestGradleFile(gitWorkingDirectory);
        }
        if (gitWorkingDirectory instanceof QAWebsitesGitWorkingDirectory) {
            buildGradleFile = new File(gitWorkingDirectory.getWorkingDirectory(), "lxc");
        }
        gitWorkingDirectory.commitFileToCurrentBranch(buildGradleFile.getCanonicalPath(), "POSHI-0 CI TESTING ONLY: Use latest gradle-plugins-poshi-runner");
        gitWorkingDirectory.commitFileToCurrentBranch(".m2-tmp", "POSHI-0 CI TESTING ONLY: FAKE GRADLE CACHE");
    }

    private LocalGitBranch _createLocalGitBranch(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        LocalGitBranch pullRequestLocalGitBranch = null;
        String branchName = gitWorkingDirectory.getUpstreamBranchName() + "-temp-pr-" + System.currentTimeMillis();
        pullRequestLocalGitBranch = gitWorkingDirectory instanceof QAWebsitesGitWorkingDirectory ? gitWorkingDirectory.createLocalGitBranch(branchName, true) : gitWorkingDirectory.createLocalGitBranch(branchName, true, this._getDistPortalBundlesBuildSHA(gitWorkingDirectory.getUpstreamBranchName()));
        gitWorkingDirectory.checkoutLocalGitBranch(pullRequestLocalGitBranch);
        gitWorkingDirectory.reset("--hard");
        this._updateGradlePluginsPoshiRunnerDependency(gitWorkingDirectory);
        this._commitGradlePluginsPoshiRunnerCache(gitWorkingDirectory);
        return pullRequestLocalGitBranch;
    }

    private PullRequest _createPortalPullRequest(GitWorkingDirectory gitWorkingDirectory) {
        try {
            LocalGitBranch localGitBranch = gitWorkingDirectory.getCurrentLocalGitBranch();
            String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
            if (gitWorkingDirectory instanceof QAWebsitesGitWorkingDirectory || !upstreamBranchName.equals("master")) {
                localGitBranch = this._createLocalGitBranch(gitWorkingDirectory);
            }
            RemoteGitBranch remoteGitBranch = gitWorkingDirectory.pushToRemoteGitRepository(true, localGitBranch, localGitBranch.getName(), this._getPullRequestRemoteGitRepository(gitWorkingDirectory));
            this._remoteGitBranches.put(gitWorkingDirectory, remoteGitBranch);
            PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
            return PullRequestFactory.newPullRequest(gitWorkingDirectory.createPullRequest("Testing Poshi Release: " + portalTopLevelBuildData.getBuildURL(), remoteGitBranch.getName(), remoteGitBranch.getUsername(), remoteGitBranch.getUsername(), "Poshi Release | " + upstreamBranchName));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to create pull request", ioException);
        }
    }

    private void _deleteRemoteGitBranches() {
        for (Map.Entry<GitWorkingDirectory, RemoteGitBranch> entry : this._remoteGitBranches.entrySet()) {
            GitWorkingDirectory gitWorkingDirectory;
            String upstreamBranchName;
            RemoteGitBranch remoteGitBranch = entry.getValue();
            if (remoteGitBranch == null || (upstreamBranchName = (gitWorkingDirectory = entry.getKey()).getUpstreamBranchName()).equals("master")) continue;
            System.out.println("Deleting remote git branch: " + gitWorkingDirectory.getGitDirectory());
            gitWorkingDirectory.deleteRemoteGitBranch(remoteGitBranch);
        }
    }

    private List<File> _getBuildGradleFiles(GitWorkingDirectory gitWorkingDirectory) {
        if (gitWorkingDirectory instanceof PortalGitWorkingDirectory) {
            return new ArrayList<File>(Arrays.asList(new File(gitWorkingDirectory.getWorkingDirectory(), "portal-web/build-test.gradle")));
        }
        if (gitWorkingDirectory instanceof QAWebsitesGitWorkingDirectory) {
            return JenkinsResultsParserUtil.findFiles(new File(gitWorkingDirectory.getWorkingDirectory(), "lxc"), "build\\.gradle");
        }
        return Collections.emptyList();
    }

    private String _getBuildInvocationURL(String jobName, Map.Entry<GitWorkingDirectory, PullRequest> entry) {
        StringBuilder sb = new StringBuilder();
        Object buildData = this.getBuildData();
        sb.append(this.getBaseInvocationURL(buildData.getCohortName()));
        sb.append("/job/");
        sb.append(jobName);
        sb.append("/buildWithParameters?token=");
        try {
            sb.append(JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
            HashMap<String, String> invocationParameters = new HashMap<String, String>();
            invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", this._getGitHubBranchName("JENKINS_GITHUB_URL"));
            invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", this._getGitHubBranchUsername("JENKINS_GITHUB_URL"));
            invocationParameters.put("JENKINS_TOP_LEVEL_BUILD_URL", buildData.getBuildURL());
            PullRequest pullRequest = entry.getValue();
            if (jobName.equals("test-qa-websites-source-format") || jobName.equals("test-portal-source-format")) {
                invocationParameters.put("JENKINS_JOB_VARIANT", "sf");
                invocationParameters.put("PULL_REQUEST_URL", pullRequest.getHtmlURL());
            } else if (jobName.startsWith("test-portal-acceptance-pullrequest")) {
                GitWorkingDirectory gitWorkingDirectory = entry.getKey();
                String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
                invocationParameters.put("CI_TEST_SUITE", this._getCITestSuite(upstreamBranchName));
                invocationParameters.put("GITHUB_PULL_REQUEST_NUMBER", pullRequest.getNumber());
                invocationParameters.put("GITHUB_RECEIVER_USERNAME", pullRequest.getReceiverUsername());
                invocationParameters.put("GITHUB_SENDER_BRANCH_NAME", pullRequest.getSenderBranchName());
                invocationParameters.put("GITHUB_SENDER_BRANCH_SHA", pullRequest.getSenderSHA());
                invocationParameters.put("GITHUB_SENDER_USERNAME", pullRequest.getSenderUsername());
                invocationParameters.put("GITHUB_UPSTREAM_BRANCH_NAME", upstreamBranchName);
                invocationParameters.put("GITHUB_UPSTREAM_BRANCH_SHA", this._getDistPortalBundlesBuildSHA(upstreamBranchName));
                invocationParameters.put("JENKINS_JOB_VARIANT", this._getCITestSuite(upstreamBranchName));
                invocationParameters.put("PORTAL_BUNDLES_DIST_URL", JenkinsResultsParserUtil.getDistPortalBundlesBuildURL(upstreamBranchName));
            }
            for (Map.Entry invocationParameter : invocationParameters.entrySet()) {
                String invocationParameterValue = (String)invocationParameter.getValue();
                if (JenkinsResultsParserUtil.isNullOrEmpty(invocationParameterValue)) continue;
                sb.append("&");
                sb.append((String)invocationParameter.getKey());
                sb.append("=");
                sb.append(invocationParameterValue);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return sb.toString();
    }

    private File _getBuildTestGradleFile(GitWorkingDirectory gitWorkingDirectory) {
        return new File(gitWorkingDirectory.getWorkingDirectory(), "portal-web/build-test.gradle");
    }

    private String _getCITestSuite(String upstreamBranchName) {
        if (upstreamBranchName.equals("master")) {
            return this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_MASTER_CI_TEST_SUITE);
        }
        return _DEFAULT_CI_TEST_SUITE;
    }

    private String _getDistPortalBundlesBuildSHA(String upstreamBranchName) throws IOException {
        String distPortalBundlesBuildURL = null;
        try {
            distPortalBundlesBuildURL = JenkinsResultsParserUtil.getDistPortalBundlesBuildURL(upstreamBranchName);
        }
        catch (Exception exception) {
            System.out.println("WARNING: Unable to get a dist portal bundle");
        }
        if (!JenkinsResultsParserUtil.isURL(distPortalBundlesBuildURL)) {
            StringBuilder sb = new StringBuilder();
            sb.append("https://github.com/liferay/liferay-portal");
            if (!upstreamBranchName.equals("master")) {
                sb.append("-ee");
            }
            sb.append("/tree/");
            sb.append(upstreamBranchName);
            RemoteGitRef remoteGitRef = GitUtil.getRemoteGitRef(sb.toString());
            return remoteGitRef.getSHA();
        }
        String distPortalBundlesBuildSHA = JenkinsResultsParserUtil.toString(distPortalBundlesBuildURL + "/git-hash");
        return distPortalBundlesBuildSHA.trim();
    }

    private String _getGitHubBranchName(String parameterName) {
        Object buildData = this.getBuildData();
        String gitHubURL = buildData.getBuildParameter(parameterName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return null;
        }
        Matcher matcher = _gitHubURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("branch");
    }

    private String _getGitHubBranchUsername(String parameterName) {
        Object buildData = this.getBuildData();
        String gitHubURL = buildData.getBuildParameter(parameterName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return null;
        }
        Matcher matcher = _gitHubURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("username");
    }

    private String _getGradlePluginsPoshiRunnerVersion() {
        if (this._gradlePluginsPoshiRunnerVersion != null) {
            return this._gradlePluginsPoshiRunnerVersion;
        }
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        File bndFile = new File(primaryWorkspaceGitRepository.getDirectory(), "modules/sdk/gradle-plugins-poshi-runner/bnd.bnd");
        try {
            String fileContent = JenkinsResultsParserUtil.read(bndFile);
            Matcher matcher = _bundleVersionPattern.matcher(fileContent);
            matcher.find();
            this._gradlePluginsPoshiRunnerVersion = matcher.group(1);
            return this._gradlePluginsPoshiRunnerVersion;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private List<String> _getJobNames(GitWorkingDirectory gitWorkingDirectory) {
        if (gitWorkingDirectory instanceof QAWebsitesGitWorkingDirectory) {
            return Collections.singletonList("test-qa-websites-source-format");
        }
        if (gitWorkingDirectory instanceof PortalGitWorkingDirectory) {
            ArrayList<String> jobNames = new ArrayList<String>();
            String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
            jobNames.add("test-portal-acceptance-pullrequest(" + upstreamBranchName + ")");
            if (upstreamBranchName.equals("master")) {
                jobNames.add("test-portal-source-format");
            }
            return jobNames;
        }
        return Collections.emptyList();
    }

    private String _getPortalGitHubURL() {
        return this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL);
    }

    private RemoteGitRepository _getPullRequestRemoteGitRepository(GitWorkingDirectory gitWorkingDirectory) {
        String portalGitHubURL = this._getPortalGitHubURL();
        Matcher matcher = GitRemote.getRemoteURLMatcher(portalGitHubURL);
        if (matcher.find()) {
            return GitRepositoryFactory.getRemoteGitRepository(matcher.group("hostname"), gitWorkingDirectory.getGitRepositoryName(), matcher.group("username"));
        }
        throw new RuntimeException("Invalid portal GitHub URL: " + portalGitHubURL);
    }

    private void _preparePoshiPortalPullRequests() {
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository primaryWorkspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        File jarFile = new File(primaryWorkspaceGitRepository.getDirectory(), ".m2-tmp/com/liferay/com.liferay.gradle.plugins.poshi.runner/" + this._getGradlePluginsPoshiRunnerVersion() + "/com.liferay.gradle.plugins.poshi.runner-" + this._getGradlePluginsPoshiRunnerVersion() + ".jar");
        if (!jarFile.exists()) {
            throw new RuntimeException("Poshi Runner Gradle Plugin cached jar does not exist: " + jarFile);
        }
        for (WorkspaceGitRepository workspaceGitRepository : workspace.getWorkspaceGitRepositories()) {
            if (!(workspaceGitRepository instanceof PortalWorkspaceGitRepository) && !(workspaceGitRepository instanceof QAWebsitesWorkspaceGitRepository)) continue;
            GitWorkingDirectory gitWorkingDirectory = workspaceGitRepository.getGitWorkingDirectory();
            this._pullRequests.put(gitWorkingDirectory, this._createPortalPullRequest(gitWorkingDirectory));
        }
    }

    private void _updateGradlePluginsPoshiRunnerDependency(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        File sourceCacheDir = new File(workspaceGitRepository.getDirectory(), ".m2-tmp/com/liferay/com.liferay.gradle.plugins.poshi.runner");
        File targetCacheDir = new File(gitWorkingDirectory.getWorkingDirectory(), ".m2-tmp/com/liferay/com.liferay.gradle.plugins.poshi.runner");
        FileUtils.copyDirectory((File)sourceCacheDir, (File)targetCacheDir);
        List<File> buildGradleFiles = this._getBuildGradleFiles(gitWorkingDirectory);
        this._updateGradlePluginsPoshiRunnerDependency(buildGradleFiles);
        if (gitWorkingDirectory instanceof QAWebsitesGitWorkingDirectory) {
            for (File buildGradleFile : buildGradleFiles) {
                String buildGradleFileContent = JenkinsResultsParserUtil.read(buildGradleFile);
                JenkinsResultsParserUtil.write(buildGradleFile, buildGradleFileContent.replaceAll("([\\s]*)(mavenLocal\\(\\))", "$1$2\n$1maven {$1\turl file(\"" + gitWorkingDirectory.getWorkingDirectory() + "/.m2-tmp\")$1}"));
            }
        }
    }

    private void _updateGradlePluginsPoshiRunnerDependency(List<File> files) throws IOException {
        for (File file : files) {
            String fileContent = JenkinsResultsParserUtil.read(file);
            JenkinsResultsParserUtil.write(file, fileContent.replaceAll(_BUILD_GRADLE_PLUGINS_REGEX, "$1$2$1classpath group: \"com.liferay\", name: \"com.liferay.gradle.plugins.poshi.runner\", version: \"" + this._getGradlePluginsPoshiRunnerVersion() + "\""));
        }
    }

    private void _validateBuildParameterPortalGitHubURL() {
        String repositoryName;
        String portalGitHubURL = this._getPortalGitHubURL();
        if (portalGitHubURL == null || portalGitHubURL.isEmpty()) {
            this.failBuildRunner("PORTAL_GITHUB_URL is null");
        }
        String failureMessage = JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL, " has an invalid Portal GitHub URL <a href=\"", portalGitHubURL, "\">", portalGitHubURL, "</a>");
        Matcher matcher = _gitHubURLPattern.matcher(portalGitHubURL);
        if (!matcher.find()) {
            this.failBuildRunner(failureMessage);
        }
        if (!(repositoryName = matcher.group("repository")).equals("liferay-portal")) {
            this.failBuildRunner(failureMessage);
        }
    }
}

