/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.liferay.jenkins.results.parser.GitCommitFactory;
import com.liferay.jenkins.results.parser.GitHubRemoteGitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitHubSecondaryRateLimitRuntimeException;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PullRequest {
    private static final String _NAME_TEST_SUITE_DEFAULT = "default";
    private static final Pattern _ciMergeSHAPattern = Pattern.compile("\\+([0-9a-f]{40})");
    private static final Pattern _gitHubPullRequestURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("https://github.com/(?<owner>[^/]+)/", "(?<gitHubRemoteGitRepositoryName>[^/]+)/pull/(?<number>\\d+)"));
    private static final Pattern _liferayContextPattern = Pattern.compile("liferay/ci:test:(?<testSuiteName>[^:]+)");
    private Boolean _autoCloseCommentAvailable;
    private String _ciMergeSHA = "";
    private List<Comment> _comments;
    private String _commonParentSHA;
    private final List<String> _fileNames = new ArrayList<String>();
    private List<GitHubRemoteGitCommit> _gitHubRemoteGitCommits;
    private GitHubRemoteGitRepository _gitHubRemoteGitRepository;
    private final String _gitHubRemoteGitRepositoryName;
    private Set<Issue> _jiraIssues;
    private JSONObject _jsonObject;
    private List<GitHubRemoteGitRepository.Label> _labels;
    private RemoteGitBranch _liferayRemoteGitBranch;
    private final Integer _number;
    private final String _ownerUsername;
    private RemoteGitBranch _senderRemoteGitBranch;

    public static String getURL(String username, String repositoryName, String pullRequestNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(username);
        sb.append("/");
        sb.append(repositoryName);
        sb.append("/pull/");
        sb.append(pullRequestNumber);
        return sb.toString();
    }

    public static boolean isValidGitHubPullRequestURL(String gitHubURL) {
        Matcher matcher = _gitHubPullRequestURLPattern.matcher(gitHubURL);
        return matcher.find();
    }

    public Comment addComment(String body) {
        body = body.replaceAll("(\\>)\\s+(\\<)", "$1$2");
        body = body.replace("&quot;", "\\&quot;");
        JSONObject dataJSONObject = new JSONObject();
        dataJSONObject.put("body", (Object)body);
        try {
            JSONObject responseJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(this._jsonObject.getString("issue_url"), "/comments"), dataJSONObject.toString());
            return new Comment(responseJSONObject);
        }
        catch (GitHubSecondaryRateLimitRuntimeException gitHubSecondaryRateLimitRuntimeException) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to post comment in GitHub pull request\n");
            sb.append("URL: ");
            sb.append(this.getURL());
            sb.append("\nMessage:\n");
            sb.append(body);
            sb.append("\n");
            NotificationUtil.sendSlackNotification(sb.toString(), "#ci-notifications", ":liferay-ci:", "Secondary rate limit exceeded", "Liferay CI");
            throw new GitHubSecondaryRateLimitRuntimeException(gitHubSecondaryRateLimitRuntimeException.getGitHubApiUrl(), gitHubSecondaryRateLimitRuntimeException.getRetryAfterSeconds(), sb.toString(), gitHubSecondaryRateLimitRuntimeException);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to post comment in GitHub pull request " + this.getURL(), ioException);
        }
    }

    public boolean addLabel(GitHubRemoteGitRepository.Label label) {
        if (label == null || this.hasLabel(label.getName())) {
            return true;
        }
        GitHubRemoteGitRepository gitHubRemoteGitRepository = this.getGitHubRemoteGitRepository();
        GitHubRemoteGitRepository.Label gitRepositoryLabel = gitHubRemoteGitRepository.getLabel(label.getName());
        if (gitRepositoryLabel == null) {
            System.out.println(JenkinsResultsParserUtil.combine("GitHubRemoteGitRepository.Label ", label.getName(), " does not exist in ", this.getGitHubRemoteGitRepositoryName()));
            return false;
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)label.getName());
        String gitHubApiUrl = JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitHubRemoteGitRepositoryName(), this.getOwnerUsername(), "issues/" + this.getNumber() + "/labels");
        try {
            JenkinsResultsParserUtil.toString(gitHubApiUrl, false, JenkinsResultsParserUtil.HttpRequestMethod.POST, jsonArray.toString());
        }
        catch (IOException ioException) {
            System.out.println("Unable to add label " + label.getName());
            ioException.printStackTrace();
            return false;
        }
        return true;
    }

    public void close() {
        if (Objects.equals(this.getState(), "open")) {
            JSONObject postContentJSONObject = new JSONObject();
            postContentJSONObject.put("state", (Object)"closed");
            try {
                JenkinsResultsParserUtil.toString(this._jsonObject.getString("url"), false, JenkinsResultsParserUtil.HttpRequestMethod.POST, postContentJSONObject.toString());
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to close pull request " + this.getHtmlURL(), ioException);
            }
        }
        this._jsonObject.put("state", (Object)"closed");
    }

    public String forward(String commentBody, String consoleURL, String forwardReceiverUsername, String forwardBranchName, String forwardSenderUsername, File gitRepositoryDir) {
        LocalGitBranch forwardLocalGitBranch;
        GitWorkingDirectory gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getUpstreamRemoteGitBranchName(), gitRepositoryDir.getAbsolutePath(), this.getGitRepositoryName());
        RemoteGitBranch forwardRemoteGitBranch = gitWorkingDirectory.pushToRemoteGitRepository(true, forwardLocalGitBranch = gitWorkingDirectory.getRebasedLocalGitBranch(forwardBranchName, this.getSenderBranchName(), this.getSenderRemoteURL(), this.getSenderSHA(), this.getUpstreamRemoteGitBranchName(), this.getUpstreamBranchSHA()), forwardLocalGitBranch.getName(), GitUtil.getUserRemoteURL(this.getGitRepositoryName(), forwardSenderUsername));
        if (forwardRemoteGitBranch == null) {
            throw new RuntimeException("Unable to push branch to GitHub");
        }
        return gitWorkingDirectory.createPullRequest(commentBody, forwardBranchName, forwardReceiverUsername, forwardSenderUsername, this.getTitle());
    }

    public URL getBaseURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://github.com/", this.getReceiverUsername(), "/", this.getGitRepositoryName(), "/tree/", this.getUpstreamRemoteGitBranchName()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String getBody() {
        return this._jsonObject.optString("body");
    }

    public String getCIMergeSHA() {
        this.getFileNames();
        return this._ciMergeSHA;
    }

    public String getCIMergeSubrepo() {
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith("/ci-merge")) continue;
            return fileName.replace("/ci-merge", "");
        }
        throw new IllegalStateException("Unable to find ci-merge file");
    }

    public List<Comment> getComments() {
        if (this._comments != null) {
            return this._comments;
        }
        this._comments = new ArrayList<Comment>();
        String gitHubApiUrl = JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitHubRemoteGitRepositoryName(), this.getOwnerUsername(), "issues/" + this.getNumber() + "/comments?per_page=100&page=");
        for (int pageNumber = 1; pageNumber <= 10; ++pageNumber) {
            try {
                JSONArray commentJSONArray = JenkinsResultsParserUtil.toJSONArray(gitHubApiUrl + pageNumber, false);
                if (commentJSONArray.length() == 0) break;
                for (int i = 0; i < commentJSONArray.length(); ++i) {
                    this._comments.add(new Comment(commentJSONArray.getJSONObject(i)));
                }
                if (commentJSONArray.length() < 100) break;
                if (pageNumber != 10) continue;
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Too many comments (>", String.valueOf(this._gitHubRemoteGitCommits.size()), ") found for ", "pull request ", this.getHtmlURL()));
            }
            catch (IOException ioException) {
                this._comments = null;
                throw new RuntimeException("Unable to get pull request comments", ioException);
            }
        }
        Collections.sort(this._comments);
        return this._comments;
    }

    public String getCommonParentSHA() {
        if (this._commonParentSHA == null) {
            this._initCommits();
        }
        return this._commonParentSHA;
    }

    public List<String> getCompletedTestSuiteNames() {
        ArrayList<String> testSuiteNames = new ArrayList<String>();
        JSONArray statusesJSONArray = this.getSenderSHAStatusesJSONArray();
        for (int i = 0; i < statusesJSONArray.length(); ++i) {
            String state;
            String testSuiteName;
            JSONObject jsonObject = statusesJSONArray.getJSONObject(i);
            Matcher matcher = _liferayContextPattern.matcher(jsonObject.getString("context"));
            if (!matcher.find() || testSuiteNames.contains(testSuiteName = matcher.group("testSuiteName")) || !Objects.equals(state = jsonObject.getString("state"), "failure") && !Objects.equals(state, "success")) continue;
            testSuiteNames.add(testSuiteName);
        }
        return testSuiteNames;
    }

    public List<String> getFileNames() {
        if (!this._fileNames.isEmpty()) {
            return this._fileNames;
        }
        this._ciMergeSHA = "";
        String filesURL = JenkinsResultsParserUtil.combine("https://api.github.com/repos/", this.getReceiverUsername(), "/", this.getGitHubRemoteGitRepositoryName(), "/pulls/", this.getNumber(), "/files");
        try {
            JSONArray filesJSONArray = JenkinsResultsParserUtil.toJSONArray(filesURL, false);
            for (int j = 0; j < filesJSONArray.length(); ++j) {
                String patch;
                Matcher matcher;
                JSONObject fileJSONObject = filesJSONArray.getJSONObject(j);
                String fileName = fileJSONObject.getString("filename");
                this._fileNames.add(fileName);
                if (!fileName.endsWith("/ci-merge") || !(matcher = _ciMergeSHAPattern.matcher(patch = fileJSONObject.getString("patch"))).find()) continue;
                String sha = matcher.group(1);
                if (matcher.find()) continue;
                this._ciMergeSHA = sha;
            }
            return this._fileNames;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get pull request file names", ioException);
        }
    }

    public List<GitHubRemoteGitCommit> getGitHubRemoteCommits() {
        if (this._gitHubRemoteGitCommits == null) {
            this._initCommits();
        }
        return this._gitHubRemoteGitCommits;
    }

    public GitHubRemoteGitCommit getGitHubRemoteGitCommit() {
        if (this._gitHubRemoteGitCommits == null) {
            this._initCommits();
        }
        return this._gitHubRemoteGitCommits.get(this._gitHubRemoteGitCommits.size() - 1);
    }

    public GitHubRemoteGitRepository getGitHubRemoteGitRepository() {
        if (this._gitHubRemoteGitRepository == null) {
            this._gitHubRemoteGitRepository = (GitHubRemoteGitRepository)GitRepositoryFactory.getRemoteGitRepository("github.com", this._gitHubRemoteGitRepositoryName, this.getOwnerUsername());
        }
        return this._gitHubRemoteGitRepository;
    }

    public String getGitHubRemoteGitRepositoryName() {
        return this._gitHubRemoteGitRepositoryName;
    }

    public String getGitRepositoryName() {
        return this.getGitHubRemoteGitRepositoryName();
    }

    public URL getHeadURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://github.com/", this.getSenderUsername(), "/", this.getGitRepositoryName(), "/tree/", this.getSenderBranchName()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String getHtmlURL() {
        return this._jsonObject.getString("html_url");
    }

    public Set<Issue> getJIRAIssues() {
        if (this._jiraIssues == null) {
            this._initJIRAIssues();
        }
        return this._jiraIssues;
    }

    public String getJSON() {
        return this._jsonObject.toString(4);
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public List<GitHubRemoteGitRepository.Label> getLabels() {
        if (this._labels == null) {
            this._refreshJSONObject();
            JSONArray labelJSONArray = this._jsonObject.getJSONArray("labels");
            this._labels = new ArrayList<GitHubRemoteGitRepository.Label>(labelJSONArray.length());
            for (int i = 0; i < labelJSONArray.length(); ++i) {
                JSONObject labelJSONObject = labelJSONArray.getJSONObject(i);
                this._labels.add(new GitHubRemoteGitRepository.Label(labelJSONObject, this.getGitHubRemoteGitRepository()));
            }
        }
        return this._labels;
    }

    public String getLocalSenderBranchName() {
        return JenkinsResultsParserUtil.combine(this.getSenderUsername(), "-", this.getNumber(), "-", this.getSenderBranchName());
    }

    public String getNumber() {
        return String.valueOf(this._number);
    }

    public String getOwnerUsername() {
        return this._ownerUsername;
    }

    public List<String> getPassingTestSuiteNames() {
        ArrayList<String> testSuiteNames = new ArrayList<String>();
        JSONArray statusesJSONArray = this.getSenderSHAStatusesJSONArray();
        for (int i = 0; i < statusesJSONArray.length(); ++i) {
            String testSuiteName;
            JSONObject jsonObject = statusesJSONArray.getJSONObject(i);
            Matcher matcher = _liferayContextPattern.matcher(jsonObject.getString("context"));
            if (!matcher.find() || testSuiteNames.contains(testSuiteName = matcher.group("testSuiteName")) || !Objects.equals(jsonObject.getString("state"), "success")) continue;
            testSuiteNames.add(testSuiteName);
        }
        return testSuiteNames;
    }

    public String getReceiverUsername() {
        JSONObject baseJSONObject = this._jsonObject.getJSONObject("base");
        JSONObject userJSONObject = baseJSONObject.getJSONObject("user");
        return userJSONObject.getString("login");
    }

    public String getRefName() {
        JSONObject baseJSONObject = this._jsonObject.getJSONObject("base");
        return baseJSONObject.getString("ref");
    }

    public String getSenderBranchName() {
        JSONObject headJSONObject = this._jsonObject.getJSONObject("head");
        return headJSONObject.getString("ref");
    }

    public RemoteGitBranch getSenderRemoteGitBranch() {
        if (this._senderRemoteGitBranch == null) {
            this._senderRemoteGitBranch = GitUtil.getRemoteGitBranch(this.getSenderBranchName(), new File(""), this.getSenderRemoteURL());
        }
        return this._senderRemoteGitBranch;
    }

    public String getSenderRemoteURL() {
        return JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderUsername(), "/", this.getGitHubRemoteGitRepositoryName());
    }

    public String getSenderSHA() {
        JSONObject headJSONObject = this._jsonObject.getJSONObject("head");
        return headJSONObject.getString("sha");
    }

    public JSONArray getSenderSHAStatusesJSONArray() {
        JSONArray statusesJSONArray = null;
        try {
            statusesJSONArray = JenkinsResultsParserUtil.toJSONArray(this._jsonObject.getString("statuses_url"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return statusesJSONArray;
    }

    public JSONObject getSenderSHAStatusJSONObject() {
        JSONObject statusJSONObject = null;
        try {
            String statusURL = this._jsonObject.getString("statuses_url");
            statusURL = statusURL.replace("statuses", "status");
            statusJSONObject = JenkinsResultsParserUtil.toJSONObject(statusURL);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return statusJSONObject;
    }

    public String getSenderUsername() {
        JSONObject headJSONObject = this._jsonObject.getJSONObject("head");
        JSONObject userJSONObject = headJSONObject.getJSONObject("user");
        return userJSONObject.getString("login");
    }

    public String getState() {
        return this._jsonObject.getString("state");
    }

    public List<String> getStatusDescriptions() {
        GitHubRemoteGitCommit gitHubRemoteGitCommit = this.getGitHubRemoteGitCommit();
        return gitHubRemoteGitCommit.getStatusDescriptions();
    }

    public String getTitle() {
        return this._jsonObject.getString("title");
    }

    public String getUpstreamBranchSHA() {
        RemoteGitBranch upstreamRemoteGitBranch = this.getUpstreamRemoteGitBranch();
        return upstreamRemoteGitBranch.getSHA();
    }

    public RemoteGitBranch getUpstreamRemoteGitBranch() {
        if (this._liferayRemoteGitBranch == null) {
            String gitRepositoryName = this.getGitRepositoryName();
            this._liferayRemoteGitBranch = GitUtil.getRemoteGitBranch(this.getUpstreamRemoteGitBranchName(), new File("."), JenkinsResultsParserUtil.combine("git@github.com:", JenkinsResultsParserUtil.getUpstreamUserName(gitRepositoryName, this.getUpstreamRemoteGitBranchName()), "/", gitRepositoryName, ".git"));
        }
        return this._liferayRemoteGitBranch;
    }

    public String getUpstreamRemoteGitBranchName() {
        JSONObject baseJSONObject = this._jsonObject.getJSONObject("base");
        return baseJSONObject.getString("ref");
    }

    public String getURL() {
        return PullRequest.getURL(this.getReceiverUsername(), this.getGitRepositoryName(), this.getNumber());
    }

    public boolean hasLabel(String labelName) {
        for (GitHubRemoteGitRepository.Label label : this.getLabels()) {
            if (!labelName.equals(label.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasRequiredCompletedTestSuites() {
        return this.hasRequiredCompletedTestSuites(false);
    }

    public boolean hasRequiredCompletedTestSuites(boolean force) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String propertyName = JenkinsResultsParserUtil.combine("ci.forward", force ? ".force" : "", ".required.completed.suites");
        String requiredCompletedTestSuiteNames = JenkinsResultsParserUtil.getProperty(buildProperties, propertyName, this.getGitRepositoryName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(requiredCompletedTestSuiteNames)) {
            return true;
        }
        List<String> completedTestSuiteNames = this.getCompletedTestSuiteNames();
        for (String requiredCompletedSuiteName : requiredCompletedTestSuiteNames.split("\\s*,\\s*")) {
            if (completedTestSuiteNames.contains(requiredCompletedSuiteName)) continue;
            return false;
        }
        return true;
    }

    public boolean hasRequiredPassingTestSuites() {
        return this.hasRequiredPassingTestSuites(false);
    }

    public boolean hasRequiredPassingTestSuites(boolean force) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String propertyName = JenkinsResultsParserUtil.combine("ci.forward", force ? ".force" : "", ".required.passing.suites");
        String requiredPassingTestSuiteNames = JenkinsResultsParserUtil.getProperty(buildProperties, propertyName, this.getGitRepositoryName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(requiredPassingTestSuiteNames)) {
            return true;
        }
        List<String> passingTestSuiteNames = this.getPassingTestSuiteNames();
        for (String requiredPassingTestSuiteName : requiredPassingTestSuiteNames.split("\\s*,\\s*")) {
            if (passingTestSuiteNames.contains(requiredPassingTestSuiteName)) continue;
            return false;
        }
        return true;
    }

    public boolean isAutoCloseCommentAvailable() {
        if (this._autoCloseCommentAvailable != null) {
            return this._autoCloseCommentAvailable;
        }
        List<Comment> comments = this.getComments();
        for (Comment comment : comments) {
            String commentBody = comment.getBody();
            if (!commentBody.contains("auto-close=\"false\"")) continue;
            this._autoCloseCommentAvailable = true;
            return this._autoCloseCommentAvailable;
        }
        this._autoCloseCommentAvailable = false;
        return this._autoCloseCommentAvailable;
    }

    public boolean isMergeSubrepoRequest() {
        for (String filename : this.getFileNames()) {
            if (!filename.endsWith("/ci-merge")) continue;
            return true;
        }
        return false;
    }

    public boolean isValidCIMergeFile() {
        List<String> fileNames = this.getFileNames();
        return fileNames.size() == 1 && this.isMergeSubrepoRequest();
    }

    public void lock() {
        try {
            JenkinsResultsParserUtil.toString(this.getIssueURL() + "/lock", false, JenkinsResultsParserUtil.HttpRequestMethod.PUT);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to lock pull request " + this.getHtmlURL(), ioException);
        }
    }

    public void refresh() {
        this._comments = null;
        this._commonParentSHA = null;
        this._gitHubRemoteGitCommits = null;
        this._labels = null;
        this.getLabels();
    }

    public void removeComment(Comment comment) {
        this.removeComment(comment.getId());
    }

    public void removeComment(String id) {
        String editCommentURL = this._jsonObject.getString("issue_url");
        editCommentURL = editCommentURL.replaceFirst("issues/\\d+", "issues");
        try {
            JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.combine(editCommentURL, "/comments/", id), false, JenkinsResultsParserUtil.HttpRequestMethod.DELETE);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to delete comment in GitHub pull request " + this.getURL(), ioException);
        }
    }

    public void removeLabel(String labelName) {
        if (!this.hasLabel(labelName)) {
            return;
        }
        String path = JenkinsResultsParserUtil.combine("issues/", this.getNumber(), "/labels/", JenkinsResultsParserUtil.fixURL(labelName));
        String gitHubApiUrl = JenkinsResultsParserUtil.getGitHubApiUrl(this.getGitHubRemoteGitRepositoryName(), this.getOwnerUsername(), path);
        try {
            JenkinsResultsParserUtil.toString(gitHubApiUrl, false, JenkinsResultsParserUtil.HttpRequestMethod.DELETE);
            this._labels = null;
        }
        catch (IOException ioException) {
            System.out.println("Unable to remove label " + labelName);
            ioException.printStackTrace();
        }
    }

    public void resetAutoCloseCommentAvailable() {
        this._autoCloseCommentAvailable = null;
    }

    public void setTestSuiteStatus(String testSuiteName, TestSuiteStatus testSuiteStatus) {
        this.setTestSuiteStatus(testSuiteName, testSuiteStatus, null);
    }

    public void setTestSuiteStatus(String testSuiteName, TestSuiteStatus testSuiteStatus, String targetURL) {
        this.setTestSuiteStatus(testSuiteName, testSuiteStatus, targetURL, null);
    }

    public void setTestSuiteStatus(String testSuiteName, TestSuiteStatus testSuiteStatus, String targetURL, String senderSHA) {
        StringBuilder sb = new StringBuilder();
        sb.append("ci:test");
        if (!testSuiteName.equals(_NAME_TEST_SUITE_DEFAULT)) {
            sb.append(":");
            sb.append(testSuiteName);
        }
        sb.append(" ");
        String testSuiteLabelPrefix = sb.toString();
        ArrayList<String> oldLabelNames = new ArrayList<String>();
        for (GitHubRemoteGitRepository.Label label : this.getLabels()) {
            String name = label.getName();
            if (!name.startsWith(testSuiteLabelPrefix)) continue;
            oldLabelNames.add(label.getName());
        }
        for (String oldLabelName : oldLabelNames) {
            this.removeLabel(oldLabelName);
        }
        sb.append(" - ");
        sb.append(StringUtils.lowerCase((String)testSuiteStatus.toString()));
        GitHubRemoteGitRepository gitHubRemoteGitRepository = this.getGitHubRemoteGitRepository();
        GitHubRemoteGitRepository.Label testSuiteLabel = gitHubRemoteGitRepository.getLabel(sb.toString());
        if (testSuiteLabel == null && gitHubRemoteGitRepository.addLabel(testSuiteStatus.getColor(), "", sb.toString())) {
            testSuiteLabel = gitHubRemoteGitRepository.getLabel(sb.toString());
        }
        this.addLabel(testSuiteLabel);
        if (targetURL == null || testSuiteStatus == TestSuiteStatus.MISSING) {
            return;
        }
        GitHubRemoteGitCommit gitHubRemoteGitCommit = this.getGitHubRemoteGitCommit();
        if (senderSHA != null && senderSHA.matches("[0-9a-f]{7,40}")) {
            gitHubRemoteGitCommit = GitCommitFactory.newGitHubRemoteGitCommit(this.getOwnerUsername(), this.getGitHubRemoteGitRepositoryName(), senderSHA);
        }
        GitHubRemoteGitCommit.Status status = GitHubRemoteGitCommit.Status.valueOf(testSuiteStatus.toString());
        String context = _NAME_TEST_SUITE_DEFAULT;
        if (!testSuiteName.equals(_NAME_TEST_SUITE_DEFAULT)) {
            context = "liferay/ci:test:" + testSuiteName;
        }
        sb = new StringBuilder();
        sb.append("\"ci:test");
        if (!testSuiteName.equals(_NAME_TEST_SUITE_DEFAULT)) {
            sb.append(":");
            sb.append(testSuiteName);
        }
        sb.append("\"");
        if (testSuiteStatus == TestSuiteStatus.ERROR || testSuiteStatus == TestSuiteStatus.FAILURE) {
            sb.append(" has FAILED.");
        } else if (testSuiteStatus == TestSuiteStatus.PENDING) {
            sb.append(" is running.");
        } else if (testSuiteStatus == TestSuiteStatus.SUCCESS) {
            sb.append(" has PASSED.");
        }
        gitHubRemoteGitCommit.setStatus(status, context, sb.toString(), targetURL);
    }

    public Comment updateComment(Comment comment) {
        return this.updateComment(comment.getBody(), comment.getId());
    }

    public Comment updateComment(String body, String id) {
        JSONObject jsonObject = new JSONObject();
        body = body.replaceAll("(\\>)\\s+(\\<)", "$1$2");
        body = body.replace("&quot;", "\\&quot;");
        jsonObject.put("body", (Object)body);
        try {
            String editCommentURL = this._jsonObject.getString("issue_url");
            editCommentURL = editCommentURL.replaceFirst("issues/\\d+", "issues");
            return new Comment(JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(editCommentURL, "/comments/", id), false, JenkinsResultsParserUtil.HttpRequestMethod.PATCH, jsonObject.toString()));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to update comment in GitHub pull request " + this.getURL(), ioException);
        }
    }

    protected PullRequest(JSONObject jsonObject) {
        JSONObject baseJSONObject = jsonObject.getJSONObject("base");
        JSONObject repoJSONObject = baseJSONObject.getJSONObject("repo");
        this._gitHubRemoteGitRepositoryName = repoJSONObject.getString("name");
        this._number = jsonObject.getInt("number");
        JSONObject ownerJSONObject = repoJSONObject.getJSONObject("owner");
        this._ownerUsername = ownerJSONObject.getString("login");
        this._jsonObject = jsonObject;
    }

    protected PullRequest(String gitHubURL) {
        Matcher matcher = _gitHubPullRequestURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid GitHub URL " + gitHubURL);
        }
        this._gitHubRemoteGitRepositoryName = matcher.group("gitHubRemoteGitRepositoryName");
        this._number = Integer.parseInt(matcher.group("number"));
        this._ownerUsername = matcher.group("owner");
        this.refresh();
    }

    protected String getGitHubApiUrl() {
        return JenkinsResultsParserUtil.getGitHubApiUrl(this._gitHubRemoteGitRepositoryName, this._ownerUsername, "pulls/" + this._number);
    }

    protected String getIssueURL() {
        return this._jsonObject.getString("issue_url");
    }

    protected void updateGithub() {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> labelNames = new ArrayList<String>();
        for (GitHubRemoteGitRepository.Label label : this.getLabels()) {
            labelNames.add(label.getName());
        }
        jsonObject.put("labels", labelNames);
        try {
            JenkinsResultsParserUtil.toJSONObject(this.getIssueURL(), jsonObject.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _initCommits() {
        String commitsURL = this._jsonObject.getString("commits_url");
        this._gitHubRemoteGitCommits = new ArrayList<GitHubRemoteGitCommit>();
        try {
            JSONArray commitsJSONArray;
            for (int pageNumber = 1; pageNumber <= 10 && (commitsJSONArray = JenkinsResultsParserUtil.toJSONArray(JenkinsResultsParserUtil.combine(commitsURL, "?per_page=100&page=", String.valueOf(pageNumber)))).length() != 0; ++pageNumber) {
                for (int i = 0; i < commitsJSONArray.length(); ++i) {
                    JSONObject commitJSONObject = commitsJSONArray.getJSONObject(i);
                    this._gitHubRemoteGitCommits.add(GitCommitFactory.newGitHubRemoteGitCommit(this.getOwnerUsername(), this.getGitRepositoryName(), commitJSONObject.getString("sha"), commitJSONObject));
                }
                if (pageNumber == 1) {
                    JSONObject firstCommitJSONObject = commitsJSONArray.getJSONObject(0);
                    JSONArray parentsJSONArray = firstCommitJSONObject.getJSONArray("parents");
                    JSONObject firstParentJSONObject = parentsJSONArray.getJSONObject(0);
                    this._commonParentSHA = firstParentJSONObject.getString("sha");
                }
                if (commitsJSONArray.length() >= 100) {
                    if (pageNumber != 10) continue;
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Too many GitHub remote commits (>", String.valueOf(this._gitHubRemoteGitCommits.size()), ") found for ", "pull request ", this.getHtmlURL()));
                }
                break;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get GitHub remote commits for pull request " + this.getHtmlURL(), ioException);
        }
    }

    private void _initJIRAIssues() {
        this.getGitHubRemoteCommits();
        this._jiraIssues = new HashSet<Issue>();
        for (GitHubRemoteGitCommit gitHubRemoteGitCommit : this._gitHubRemoteGitCommits) {
            Issue issue = gitHubRemoteGitCommit.getJIRAIssue();
            if (issue == null) continue;
            this._jiraIssues.add(issue);
        }
    }

    private void _refreshJSONObject() {
        try {
            this._jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getGitHubApiUrl(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public static enum TestSuiteStatus {
        ERROR("fccdcc"),
        FAILURE("fccdcc"),
        MISSING("eeeeee"),
        PENDING("fff4c9"),
        SUCCESS("c7e8cb");

        private final String _color;

        public String getColor() {
            return this._color;
        }

        private TestSuiteStatus(String color) {
            this._color = color;
        }
    }

    public static class Comment
    implements Comparable<Comment> {
        private static final SimpleDateFormat _UtcIso8601SimpleDateFormat;
        private final JSONObject _commentJSONObject;

        public Comment(JSONObject commentJSONObject) {
            this._commentJSONObject = commentJSONObject;
        }

        @Override
        public int compareTo(Comment comment) {
            Date createdDate = this.getCreatedDate();
            return createdDate.compareTo(comment.getCreatedDate());
        }

        public String getBody() {
            return this._commentJSONObject.getString("body");
        }

        public Date getCreatedDate() {
            try {
                return _UtcIso8601SimpleDateFormat.parse(this._commentJSONObject.getString("created_at"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to parse created date " + this._commentJSONObject.getString("created_at"), parseException);
            }
        }

        public String getId() {
            return String.valueOf(this._commentJSONObject.getLong("id"));
        }

        public Date getModifiedDate() {
            try {
                return _UtcIso8601SimpleDateFormat.parse(this._commentJSONObject.getString("modified_at"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to parse modified date " + this._commentJSONObject.getString("modified_at"), parseException);
            }
        }

        public URL getURL() {
            try {
                return new URL(this._commentJSONObject.getString("html_url"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }

        public String getUserLogin() {
            JSONObject userJSONObject = this._commentJSONObject.getJSONObject("user");
            return userJSONObject.getString("login");
        }

        static {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            _UtcIso8601SimpleDateFormat = simpleDateFormat;
        }
    }
}

