/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PullRequestPluginsTopLevelBuild
extends PluginsTopLevelBuild
implements PullRequestBuild {
    private static final Pattern _pattern = Pattern.compile("[^/]*functional[^/]*/(?<pluginName>[^/]+)/\\d+");
    private final PullRequest _pullRequest;

    public PullRequestPluginsTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
        sb.append("/liferay-plugins");
        String branchName = this.getBranchName();
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/pull/");
        sb.append(this.getParameterValue("GITHUB_PULL_REQUEST_NUMBER"));
        if (this.isFromArchive()) {
            this._pullRequest = null;
            return;
        }
        this._pullRequest = PullRequestFactory.newPullRequest(sb.toString());
    }

    @Override
    public String getBranchName() {
        String jobName = this.getJobName();
        return jobName.substring(jobName.indexOf("(") + 1, jobName.indexOf(")"));
    }

    @Override
    public String getPluginName() {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            Matcher matcher;
            String jobVariant = downstreamBuild.getParameterValue("JOB_VARIANT");
            if (jobVariant == null || !(matcher = _pattern.matcher(jobVariant)).find()) continue;
            return matcher.group("pluginName");
        }
        return null;
    }

    @Override
    public PullRequest getPullRequest() {
        return this._pullRequest;
    }

    @Override
    public String getTestSuiteName() {
        String ciTestSuite = this.getParameterValue("CI_TEST_SUITE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(ciTestSuite)) {
            ciTestSuite = "default";
        }
        return ciTestSuite;
    }

    @Override
    public Workspace getWorkspace() {
        String upstreamBranchSHA;
        PullRequest pullRequest = this.getPullRequest();
        Workspace workspace = WorkspaceFactory.newWorkspace(pullRequest.getGitRepositoryName(), pullRequest.getUpstreamRemoteGitBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
        }
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        workspaceGitRepository.setGitHubURL(pullRequest.getHtmlURL());
        String senderBranchSHA = this._getSenderBranchSHA();
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            workspaceGitRepository.setSenderBranchSHA(senderBranchSHA);
        }
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA = this._getUpstreamBranchSHA())) {
            workspaceGitRepository.setBaseBranchSHA(upstreamBranchSHA);
        }
        return workspace;
    }

    private String _getSenderBranchSHA() {
        String senderBranchSHA = this.getParameterValue("GITHUB_SENDER_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            return senderBranchSHA;
        }
        return null;
    }

    private String _getUpstreamBranchSHA() {
        String upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA)) {
            return upstreamBranchSHA;
        }
        return null;
    }
}

