/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.dom4j.Element;

public class PullRequestPortalTopLevelBuild
extends PortalTopLevelBuild
implements PortalWorkspaceBuild,
PullRequestBuild {
    private PullRequest _pullRequest;
    private Job _stableJob;
    private String _stableJobResult;

    public PullRequestPortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        this.setCompareToUpstream(true);
        String testSuiteName = this.getTestSuiteName();
        if (testSuiteName.equals("stable")) {
            this.setCompareToUpstream(false);
        }
    }

    public boolean bypassCITestRelevant() {
        String testSuiteName = this.getTestSuiteName();
        if (testSuiteName == null || !testSuiteName.equals("relevant")) {
            return false;
        }
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        if (!(workspaceGitRepository instanceof PortalWorkspaceGitRepository)) {
            return false;
        }
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = (PortalWorkspaceGitRepository)workspaceGitRepository;
        return portalWorkspaceGitRepository.bypassCITestRelevant();
    }

    @Override
    public String getBranchName() {
        String branchName = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(branchName)) {
            return branchName;
        }
        return super.getBranchName();
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public PullRequest getPullRequest() {
        if (this._pullRequest != null) {
            return this._pullRequest;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
        sb.append("/");
        sb.append(this.getBaseGitRepositoryName());
        sb.append("/pull/");
        sb.append(this.getParameterValue("GITHUB_PULL_REQUEST_NUMBER"));
        this._pullRequest = PullRequestFactory.newPullRequest(sb.toString(), this);
        return this._pullRequest;
    }

    @Override
    public String getResult() {
        Properties buildProperties;
        List<Build> downstreamBuildFailures = this.getFailedDownstreamBuilds();
        if (downstreamBuildFailures.isEmpty()) {
            return super.getResult();
        }
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        boolean pullRequestForwardUpstreamFailureComparisonEnabled = Boolean.parseBoolean(buildProperties.getProperty("pull.request.forward.upstream.failure.comparison.enabled"));
        String result = "FAILURE";
        if (!pullRequestForwardUpstreamFailureComparisonEnabled || !this.isCompareToUpstream()) {
            return result;
        }
        String testSuiteName = this.getTestSuiteName();
        if (!testSuiteName.matches("relevant|stable")) {
            return result;
        }
        String batchWhitelist = buildProperties.getProperty("pull.request.forward.upstream.failure.comparison.batch.whitelist");
        List<String> whitelistedBatchRegexes = Arrays.asList(batchWhitelist.split("\\s*,\\s*"));
        for (Build downstreamBuild : downstreamBuildFailures) {
            if (downstreamBuild.isUniqueFailure()) {
                return result;
            }
            boolean approved = false;
            String jobVariant = downstreamBuild.getJobVariant();
            jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
            for (String whiteListedBatchRegex : whitelistedBatchRegexes) {
                if (!jobVariant.matches(".*" + whiteListedBatchRegex + ".*")) continue;
                approved = true;
                break;
            }
            if (approved) continue;
            return result;
        }
        return "APPROVED";
    }

    public String getStableJobResult() {
        Job stableJob;
        if (this._stableJobResult != null) {
            return this._stableJobResult;
        }
        List<Build> stableJobDownstreamBuilds = this.getStableJobDownstreamBuilds();
        int stableJobDownstreamBuildsSize = stableJobDownstreamBuilds.size();
        if (stableJobDownstreamBuildsSize == 0) {
            return null;
        }
        String result = this.getResult();
        if (result == null) {
            return null;
        }
        if (result.equals("SUCCESS")) {
            this._stableJobResult = result;
        }
        if ((stableJob = this._getStableJob()) == null) {
            return null;
        }
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(stableJob.getBatchNames());
        int stableJobDownstreamBuildsCompletedCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, null, "completed");
        if (stableJobDownstreamBuildsCompletedCount != stableJobDownstreamBuildsSize) {
            return null;
        }
        int stableJobDownstreamBuildsSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        this._stableJobResult = stableJobDownstreamBuildsSuccessCount == stableJobDownstreamBuildsSize ? "SUCCESS" : "FAILURE";
        return this._stableJobResult;
    }

    @Override
    public Workspace getWorkspace() {
        String upstreamBranchSHA;
        PullRequest pullRequest = this.getPullRequest();
        Workspace workspace = WorkspaceFactory.newWorkspace(pullRequest.getGitRepositoryName(), pullRequest.getUpstreamRemoteGitBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
            portalWorkspace.setOSBAsahGitHubURL(this._getOSBAsahGitHubURL());
            portalWorkspace.setOSBFaroGitHubURL(this._getOSBFaroGitHubURL());
        }
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        workspaceGitRepository.setGitHubURL(pullRequest.getHtmlURL());
        String senderBranchSHA = this._getSenderBranchSHA();
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            workspaceGitRepository.setSenderBranchSHA(senderBranchSHA);
        }
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA = this._getUpstreamBranchSHA())) {
            workspaceGitRepository.setBaseBranchSHA(upstreamBranchSHA);
        }
        return workspace;
    }

    @Override
    public boolean isUniqueFailure() {
        List<Build> failedDownstreamBuilds = this.getFailedDownstreamBuilds();
        for (Build downstreamBuild : failedDownstreamBuilds) {
            if (!downstreamBuild.isUniqueFailure()) continue;
            return true;
        }
        return failedDownstreamBuilds.isEmpty();
    }

    protected Element getFailedStableJobSummaryElement() {
        Job stableJob = this._getStableJob();
        if (stableJob == null) {
            return Dom4JUtil.getNewElement("span");
        }
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(stableJob.getBatchNames());
        Element jobSummaryListElement = this.getJobSummaryListElement(false, stableJobBatchNames);
        int stableJobDownstreamBuildsSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        int stableJobDownstreamBuildsCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, null, null);
        int stableJobDownstreamBuildsFailureCount = stableJobDownstreamBuildsCount - stableJobDownstreamBuildsSuccessCount;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h4", null, String.valueOf(stableJobDownstreamBuildsFailureCount), " Failed Jobs:"), jobSummaryListElement);
    }

    protected List<Build> getStableJobDownstreamBuilds() {
        Job stableJob = this._getStableJob();
        if (stableJob != null) {
            return this.getJobVariantsDownstreamBuilds(stableJob.getBatchNames(), null, null);
        }
        return Collections.emptyList();
    }

    protected Element getStableJobResultElement() {
        Job stableJob = this._getStableJob();
        if (stableJob == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String stableJobResult = this.getStableJobResult();
        if (stableJobResult.equals("SUCCESS")) {
            sb.append(":heavy_check_mark: ");
        } else {
            sb.append(":x: ");
        }
        sb.append("ci:test:stable - ");
        sb.append(this.getJobVariantsDownstreamBuildCount(new ArrayList<String>(stableJob.getBatchNames()), "SUCCESS", null));
        sb.append(" out of ");
        List<Build> stableJobDownstreamBuilds = this.getStableJobDownstreamBuilds();
        sb.append(stableJobDownstreamBuilds.size());
        sb.append(" jobs passed");
        return Dom4JUtil.getNewElement("h3", null, sb.toString());
    }

    protected Element getStableJobSuccessSummaryElement() {
        Job stableJob = this._getStableJob();
        if (stableJob == null) {
            return Dom4JUtil.getNewElement("span");
        }
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(stableJob.getBatchNames());
        Element stableJobSummaryListElement = this.getJobSummaryListElement(true, stableJobBatchNames);
        int stableJobDownstreamBuildsSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        return Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, String.valueOf(stableJobDownstreamBuildsSuccessCount), " Successful Jobs:")), stableJobSummaryListElement);
    }

    protected Element getStableJobSummaryElement() {
        Job stableJob = this._getStableJob();
        if (stableJob == null) {
            return Dom4JUtil.getNewElement("span");
        }
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(stableJob.getBatchNames());
        int stableJobDownstreamBuildSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        List<Build> stableJobDownstreamBuilds = this.getStableJobDownstreamBuilds();
        Element detailsElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, "ci:test:stable - ", String.valueOf(stableJobDownstreamBuildSuccessCount), " out of ", String.valueOf(stableJobDownstreamBuilds.size()), " jobs PASSED")));
        int stableJobDownstreamBuildCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, null, null);
        if (stableJobDownstreamBuildSuccessCount < stableJobDownstreamBuildCount) {
            Dom4JUtil.addToElement(detailsElement, this.getFailedStableJobSummaryElement());
        }
        if (stableJobDownstreamBuildSuccessCount > 0) {
            Dom4JUtil.addToElement(detailsElement, this.getStableJobSuccessSummaryElement());
        }
        return detailsElement;
    }

    @Override
    protected Element getTopGitHubMessageElement() {
        Element rootElement = super.getTopGitHubMessageElement();
        ArrayList<Build> stableJobDownstreamBuilds = new ArrayList<Build>();
        Job stableJob = this._getStableJob();
        if (stableJob != null) {
            stableJobDownstreamBuilds.addAll(this.getStableJobDownstreamBuilds());
        }
        if (!stableJobDownstreamBuilds.isEmpty()) {
            Dom4JUtil.insertElementAfter(rootElement, null, this.getStableJobResultElement());
        }
        Element detailsElement = rootElement.element("details");
        if (!stableJobDownstreamBuilds.isEmpty()) {
            Element jobSummaryElement = detailsElement.element("details");
            Dom4JUtil.insertElementBefore(detailsElement, jobSummaryElement, this.getStableJobSummaryElement());
        }
        return rootElement;
    }

    private String _getOSBAsahGitHubURL() {
        String osbAsahGitHubURL = this.getParameterValue("OSB_ASAH_GITHUB_URL");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(osbAsahGitHubURL)) {
            return osbAsahGitHubURL;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild != null) {
            return controllerBuild.getParameterValue("OSB_ASAH_GITHUB_URL");
        }
        return null;
    }

    private String _getOSBFaroGitHubURL() {
        String osbFaroGitHubURL = this.getParameterValue("OSB_FARO_GITHUB_URL");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(osbFaroGitHubURL)) {
            return osbFaroGitHubURL;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild != null && !JenkinsResultsParserUtil.isNullOrEmpty(osbFaroGitHubURL = controllerBuild.getParameterValue("OSB_FARO_GITHUB_URL"))) {
            return osbFaroGitHubURL;
        }
        return "https://github.com/liferay/liferay-portal/tree/master";
    }

    private String _getSenderBranchSHA() {
        String senderBranchSHA = this.getParameterValue("GITHUB_SENDER_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(senderBranchSHA)) {
            return senderBranchSHA;
        }
        return null;
    }

    private synchronized Job _getStableJob() {
        if (this._stableJob != null) {
            return this._stableJob;
        }
        String testSuiteName = this.getTestSuiteName();
        if (!testSuiteName.equals("relevant")) {
            return null;
        }
        String branchName = this.getBranchName();
        Job.BuildProfile buildProfile = this.getBuildProfile();
        String jobName = this.getJobName();
        String repositoryName = this.getBaseGitRepositoryName();
        String stableTestSuiteName = "stable";
        try {
            this._stableJob = JobFactory.newJob(buildProfile, jobName, null, null, null, branchName, null, repositoryName, stableTestSuiteName, branchName);
            BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
            buildDatabase.putJob(JobFactory.getKey(buildProfile, jobName, null, branchName, null, repositoryName, stableTestSuiteName, branchName), this._stableJob);
        }
        catch (Exception exception) {
            System.out.println("Unable to create stable job for " + jobName);
            exception.printStackTrace();
        }
        return this._stableJob;
    }

    private String _getUpstreamBranchSHA() {
        String upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA");
        if (JenkinsResultsParserUtil.isSHA(upstreamBranchSHA)) {
            return upstreamBranchSHA;
        }
        String portalBundlesDistURL = this.getParameterValue("PORTAL_BUNDLES_DIST_URL");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBundlesDistURL)) {
            return null;
        }
        try {
            URL portalBundlesGitHashURL = new URL(JenkinsResultsParserUtil.getLocalURL(portalBundlesDistURL) + "/git-hash");
            if (!JenkinsResultsParserUtil.exists(portalBundlesGitHashURL)) {
                return null;
            }
            String portalBundlesGitHash = JenkinsResultsParserUtil.toString(portalBundlesGitHashURL.toString());
            if (JenkinsResultsParserUtil.isSHA(portalBundlesGitHash = portalBundlesGitHash.trim())) {
                return portalBundlesGitHash;
            }
            return null;
        }
        catch (IOException ioException) {
            return null;
        }
    }
}

