/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class QAWebsitesGitRepositoryJob
extends GitRepositoryJob
implements PortalTestClassJob,
TestSuiteJob {
    private final List<String> _projectNames;
    private final String _testSuiteName;
    private final String _upstreamBranchName;

    @Override
    public String getBranchName() {
        return this._upstreamBranchName;
    }

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        return this.gitWorkingDirectory;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("project_names", this._projectNames);
        this.jsonObject.put("test_suite_name", (Object)this._testSuiteName);
        this.jsonObject.put("upstream_branch_name", (Object)this._upstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory("master");
    }

    public List<String> getProjectNames() {
        return this._projectNames;
    }

    @Override
    public Set<String> getRawBatchNames() {
        for (String projectName : this.getProjectNames()) {
            if (!projectName.equals("playwright")) continue;
            return new HashSet<String>(Collections.singletonList("qa-websites-playwright"));
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.names");
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected QAWebsitesGitRepositoryJob(Job.BuildProfile buildProfile, String jobName, List<String> projectNames, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName);
        this._projectNames = projectNames;
        this._testSuiteName = testSuiteName;
        this._upstreamBranchName = upstreamBranchName;
        this._initialize();
    }

    protected QAWebsitesGitRepositoryJob(JSONObject jsonObject) {
        super(jsonObject);
        this._testSuiteName = jsonObject.getString("test_suite_name");
        this._upstreamBranchName = jsonObject.getString("upstream_branch_name");
        this._projectNames = new ArrayList<String>();
        JSONArray projectNamesJSONArray = jsonObject.optJSONArray("project_names");
        if (projectNamesJSONArray != null) {
            for (int i = 0; i < projectNamesJSONArray.length(); ++i) {
                String projectName = projectNamesJSONArray.getString(i);
                if (JenkinsResultsParserUtil.isNullOrEmpty(projectName)) continue;
                this._projectNames.add(projectName);
            }
        }
        this._initialize();
    }

    private File _getQAWebsitesGitRepositoryDir() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String qaWebsitesDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.dir", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesDirPath)) {
            throw new RuntimeException("Unable to find QA Websites directory path");
        }
        File qaWebsitesDir = new File(qaWebsitesDirPath);
        if (!qaWebsitesDir.exists()) {
            throw new RuntimeException("Unable to find QA Websites directory");
        }
        return qaWebsitesDir;
    }

    private String _getQAWebsitesRepositoryName() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String qaWebsitesRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.repository", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesRepository)) {
            throw new RuntimeException("Unable to find QA Websites repository");
        }
        return qaWebsitesRepository;
    }

    private void _initialize() {
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this._upstreamBranchName, this._getQAWebsitesGitRepositoryDir(), this._getQAWebsitesRepositoryName());
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
    }
}

