/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QAWebsitesGitWorkingDirectory
extends GitWorkingDirectory {
    public List<File> getModifiedProjectDirs() {
        ArrayList<File> projectDirs = new ArrayList<File>();
        File workingDirectory = this.getWorkingDirectory();
        for (File modifiedFile : this.getModifiedFilesList()) {
            File projectDir = this._getProjectDir(modifiedFile);
            if (projectDir == null || projectDir.equals(workingDirectory) || projectDirs.contains(projectDir)) continue;
            projectDirs.add(projectDir);
        }
        return projectDirs;
    }

    public List<String> getModifiedProjectNames() {
        ArrayList<String> projectNames = new ArrayList<String>();
        File workingDirectory = this.getWorkingDirectory();
        for (File projectDir : this.getModifiedProjectDirs()) {
            if (projectDir.equals(workingDirectory)) continue;
            projectNames.add(JenkinsResultsParserUtil.getPathRelativeTo(projectDir, workingDirectory));
        }
        return projectNames;
    }

    protected QAWebsitesGitWorkingDirectory(String upstreamBranchName, String workingDirectoryPath) throws IOException {
        super(upstreamBranchName, workingDirectoryPath);
    }

    protected QAWebsitesGitWorkingDirectory(String upstreamBranchName, String workingDirectoryPath, String gitRepositoryName) throws IOException {
        super(upstreamBranchName, workingDirectoryPath, gitRepositoryName);
    }

    private File _getProjectDir(File file) {
        if (file == null) {
            return null;
        }
        File canonicalFile = JenkinsResultsParserUtil.getCanonicalFile(file);
        if (canonicalFile.equals(this.getWorkingDirectory())) {
            return null;
        }
        File parentFile = canonicalFile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            return file;
        }
        if (!canonicalFile.isDirectory()) {
            return this._getProjectDir(parentFile);
        }
        File testPropertiesFile = new File(canonicalFile, "build.gradle");
        if (!testPropertiesFile.exists()) {
            return this._getProjectDir(parentFile);
        }
        return canonicalFile;
    }
}

