/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReinvokeRule {
    protected Pattern axisVariablePattern;
    protected Pattern consolePattern;
    protected Pattern jobVariantPattern;
    protected String name;
    protected String notificationRecipients;
    protected Pattern testSuiteNamePattern;
    protected Pattern topLevelBuildJobNamePattern;
    private static List<ReinvokeRule> _reinvokeRules;

    public static List<ReinvokeRule> getReinvokeRules() {
        if (_reinvokeRules != null) {
            return new ArrayList<ReinvokeRule>(_reinvokeRules);
        }
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load reinvoke rules", ioException);
        }
        _reinvokeRules = new ArrayList<ReinvokeRule>();
        for (Object propertyNameObject : buildProperties.keySet()) {
            String propertyName = propertyNameObject.toString();
            if (!propertyName.startsWith("reinvoke.rule[")) continue;
            String ruleName = propertyName.substring("reinvoke.rule[".length(), propertyName.lastIndexOf("]"));
            _reinvokeRules.add(new ReinvokeRule(buildProperties.getProperty(propertyName), ruleName));
        }
        return new ArrayList<ReinvokeRule>(_reinvokeRules);
    }

    public String getName() {
        return this.name;
    }

    public String getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public boolean matches(Build build) {
        String testSuiteName;
        TopLevelBuild topLevelBuild;
        if (build == null) {
            return false;
        }
        Matcher matcher = null;
        if (this.axisVariablePattern != null) {
            String axisVariable = null;
            if (build instanceof AxisBuild) {
                AxisBuild axisBuild = (AxisBuild)build;
                axisVariable = axisBuild.getAxisVariable();
            } else if (build instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                axisVariable = downstreamBuild.getAxisVariable();
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(axisVariable)) {
                return false;
            }
            matcher = this.axisVariablePattern.matcher(axisVariable);
            if (!matcher.find()) {
                return false;
            }
        }
        if (this.jobVariantPattern != null) {
            String jobVariant = build.getJobVariant();
            if (jobVariant == null) {
                jobVariant = "";
            }
            if (!(matcher = this.jobVariantPattern.matcher(jobVariant)).find()) {
                return false;
            }
        }
        if (this.testSuiteNamePattern != null && (topLevelBuild = build.getTopLevelBuild()) != null && !JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName = topLevelBuild.getTestSuiteName()) && !(matcher = this.testSuiteNamePattern.matcher(testSuiteName)).find()) {
            return false;
        }
        if (this.topLevelBuildJobNamePattern != null && (topLevelBuild = build.getTopLevelBuild()) != null && !(matcher = this.topLevelBuildJobNamePattern.matcher(topLevelBuild.getJobName())).find()) {
            return false;
        }
        if (this.consolePattern != null) {
            String consoleText = build.getConsoleText();
            for (String line : consoleText.split("\n")) {
                matcher = this.consolePattern.matcher(line);
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.axisVariablePattern != null) {
            sb.append("axisVariable=");
            sb.append(this.axisVariablePattern.pattern());
            sb.append("\n");
        }
        if (this.consolePattern != null) {
            sb.append("console=");
            sb.append(this.consolePattern.pattern());
            sb.append("\n");
        }
        if (this.jobVariantPattern != null) {
            sb.append("jobVariant=");
            sb.append(this.jobVariantPattern.pattern());
            sb.append("\n");
        }
        sb.append("name=");
        sb.append(this.name);
        sb.append("\n");
        if (this.notificationRecipients != null) {
            sb.append("notificationRecipients=");
            sb.append(this.notificationRecipients);
            sb.append("\n");
        }
        if (this.testSuiteNamePattern != null) {
            sb.append("testSuiteName=");
            sb.append(this.testSuiteNamePattern.pattern());
            sb.append("\n");
        }
        if (this.topLevelBuildJobNamePattern != null) {
            sb.append("topLevelJobName=");
            sb.append(this.topLevelBuildJobNamePattern.pattern());
            sb.append("\n");
        }
        return sb.toString();
    }

    private ReinvokeRule(String configurations, String ruleName) {
        this.name = ruleName;
        for (String configuration : configurations.split("\n")) {
            int x = configuration.indexOf("=");
            String name = configuration.substring(0, x);
            String value = configuration.substring(x + 1);
            if ((value = value.trim()).isEmpty()) continue;
            if (name.equals("notificationRecipients")) {
                this.notificationRecipients = value;
                continue;
            }
            Pattern pattern = Pattern.compile(value);
            if (name.equals("axisVariable")) {
                this.axisVariablePattern = pattern;
                continue;
            }
            if (name.equals("console")) {
                this.consolePattern = pattern;
                continue;
            }
            if (name.equals("jobVariant")) {
                this.jobVariantPattern = pattern;
                continue;
            }
            if (name.equals("testSuiteName")) {
                this.testSuiteNamePattern = pattern;
            }
            if (!name.equals("topLevelJobName")) continue;
            this.topLevelBuildJobNamePattern = pattern;
        }
    }
}

