/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDataFactory;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildRunner;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.ModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.PlaywrightJUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class RootCauseAnalysisToolTopLevelBuildRunner
extends PortalTopLevelBuildRunner<PortalTopLevelBuildData> {
    private static final int _COMMITS_GROUP_SIZE_MAX_DEFAULT = 5;
    private static final String _NAME_BUILD_PARAMETER_JENKINS_GITHUB_URL = "JENKINS_GITHUB_URL";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_BATCH = "PORTAL_BATCH_NAME";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_BATCH_TEST_SELECTOR = "PORTAL_BATCH_TEST_SELECTOR";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_BRANCH_SHAS = "PORTAL_BRANCH_SHAS";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_CHERRY_PICK_SHAS = "PORTAL_CHERRY_PICK_SHAS";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL = "PORTAL_GITHUB_URL";
    private static final String _NAME_BUILD_PARAMETER_PORTAL_UPSTREAM_BRANCH_NAME = "PORTAL_UPSTREAM_BRANCH_NAME";
    private static final String _NAME_BUILD_PARAMETER_RETEST_COUNT = "RETEST_COUNT";
    private static final Pattern _compareURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("https://github.com/(?<username>[^/]+)/(?<repositoryName>[^/]+)", "/compare/(?<earliestSHA>[0-9a-f]{5,40})\\.{3}", "(?<latestSHA>[0-9a-f]{5,40})"));
    private static final Pattern _portalURLPattern = Pattern.compile("https://github.com/[^/]+/(?<repositoryName>[^/]+)/tree/.+");

    @Override
    public void tearDown() {
        this.cleanUpHostServices();
        this.tearDownWorkspace();
    }

    protected RootCauseAnalysisToolTopLevelBuildRunner(PortalTopLevelBuildData portalTopLevelBuildData) {
        super(portalTopLevelBuildData);
    }

    @Override
    protected String getBaseInvocationURL(String cohortName) {
        return JenkinsResultsParserUtil.getMostAvailableMasterURL(JenkinsResultsParserUtil.combine("http://", cohortName, ".liferay.com"), 1, 24, 2);
    }

    @Override
    protected Element getJenkinsReportElement() {
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
        Workspace workspace = this.getWorkspace();
        if (workspace == null) {
            return Dom4JUtil.getNewElement("html", null, Dom4JUtil.getNewElement("h1", null, "Report building in progress for ", Dom4JUtil.getNewAnchorElement(portalTopLevelBuildData.getBuildURL(), portalTopLevelBuildData.getBuildURL())));
        }
        RootCauseAnalysisToolBuild rootCauseAnalysisToolBuild = (RootCauseAnalysisToolBuild)this.getTopLevelBuild();
        ArrayList<PortalBuildData> downstreamPortalBuildDataList = new ArrayList<PortalBuildData>();
        for (BuildData downstreamBuildData : portalTopLevelBuildData.getDownstreamBuildDataList()) {
            if (!(downstreamBuildData instanceof PortalBuildData)) continue;
            downstreamPortalBuildDataList.add((PortalBuildData)downstreamBuildData);
        }
        rootCauseAnalysisToolBuild.setDownstreamPortalBuildDataList(downstreamPortalBuildDataList);
        rootCauseAnalysisToolBuild.setWorkspaceGitRepository(workspace.getPrimaryWorkspaceGitRepository());
        return super.getJenkinsReportElement();
    }

    @Override
    protected void prepareInvocationBuildDataList() {
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
        String downstreamJobName = portalTopLevelBuildData.getJobName() + "-batch";
        for (String portalBranchSHA : this._getPortalBranchSHAs()) {
            int retestCount = this._getRetestCount();
            for (int i = 0; i < retestCount; ++i) {
                BatchBuildData batchBuildData = BuildDataFactory.newBatchBuildData(null, downstreamJobName, null);
                if (!(batchBuildData instanceof PortalBatchBuildData)) {
                    throw new RuntimeException("Invalid build data");
                }
                PortalBatchBuildData portalBatchBuildData = (PortalBatchBuildData)batchBuildData;
                portalBatchBuildData.setBuildDescription(this._getDownstreamBuildDescription(portalBranchSHA));
                portalBatchBuildData.setBatchName(this._getBatchName());
                portalBatchBuildData.setPortalBranchSHA(portalBranchSHA);
                portalBatchBuildData.setTestList(this._getTestList());
                this.addInvocationBuildData(portalBatchBuildData);
            }
        }
    }

    @Override
    protected void setUpWorkspace() {
        super.setUpWorkspace();
        Workspace workspace = this.getWorkspace();
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        GitWorkingDirectory gitWorkingDirectory = workspaceGitRepository.getGitWorkingDirectory();
        List<String> portalBranchSHAs = this._getPortalBranchSHAs();
        for (String string : portalBranchSHAs) {
            if (gitWorkingDirectory.localSHAExists(string)) continue;
            String portalGitHubURL = this._getPortalGitHubURL();
            this.failBuildRunner(JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_BRANCH_SHAS, " has SHAs that are not be found within the latest ", String.valueOf(WorkspaceGitRepository.COMMITS_HISTORY_SIZE_MAX), " commits of <a href=\"", portalGitHubURL, "\">", portalGitHubURL, "</a>"));
            return;
        }
        List<String> portalCherryPickSHAs = this._getPortalCherryPickSHAs();
        for (String portalCherryPickSHA : portalCherryPickSHAs) {
            if (gitWorkingDirectory.localSHAExists(portalCherryPickSHA)) continue;
            String portalGitHubURL = this._getPortalGitHubURL();
            this.failBuildRunner(JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_CHERRY_PICK_SHAS, " has SHAs that are not be found within the latest ", String.valueOf(WorkspaceGitRepository.COMMITS_HISTORY_SIZE_MAX), " commits of <a href=\"", portalGitHubURL, "\">", portalGitHubURL, "</a>"));
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(portalBranchSHAs);
        arrayList.addAll(portalCherryPickSHAs);
        try {
            workspaceGitRepository.storeCommitHistory(arrayList);
        }
        catch (Exception exception) {
            this.failBuildRunner("Unable to store the commit history", exception);
        }
    }

    @Override
    protected void validateBuildParameters() {
        this._validateBuildParameterJenkinsGitHubURL();
        this._validateBuildParameterPortalBatchName();
        this._validateBuildParameterPortalBatchTestSelector();
        this._validateBuildParameterPortalBranchSHAs();
        this._validateBuildParameterPortalGitHubURL();
        this._validateBuildParameterPortalUpstreamBranchName();
        this._validateBuildParameterRetestCherryPickSHA();
        this._validateBuildParameterRetestCount();
    }

    private void _failInvalidPortalRepositoryName(String buildParameter, String portalUpstreamBranchName) {
        String portalRepositoryName = "liferay-portal";
        if (!portalUpstreamBranchName.equals("master")) {
            portalRepositoryName = portalRepositoryName + "-ee";
        }
        this.failBuildRunner(JenkinsResultsParserUtil.combine(buildParameter, " should point to a ", portalRepositoryName, " GitHub URL"));
    }

    private int _getAllowedPortalBranchSHACount() {
        String allowedPortalBranchSHACount = this.getJobPropertyValue("allowed.portal.branch.shas");
        if (allowedPortalBranchSHACount == null || allowedPortalBranchSHACount.isEmpty()) {
            return -1;
        }
        return Integer.valueOf(allowedPortalBranchSHACount);
    }

    private String _getBatchName() {
        Object buildData = this.getBuildData();
        return JenkinsResultsParserUtil.getBuildParameter(buildData.getBuildURL(), _NAME_BUILD_PARAMETER_PORTAL_BATCH);
    }

    private String _getDownstreamBuildDescription(String portalBranchSHA) {
        PortalTopLevelBuildData portalTopLevelBuildData = (PortalTopLevelBuildData)this.getBuildData();
        StringBuilder sb = new StringBuilder();
        sb.append(portalBranchSHA);
        sb.append(" - ");
        sb.append(this._getBatchName());
        sb.append(" - ");
        sb.append("<a href=\"https://");
        sb.append(portalTopLevelBuildData.getTopLevelMasterHostname());
        sb.append(".liferay.com/userContent/");
        sb.append(portalTopLevelBuildData.getUserContentRelativePath());
        sb.append("jenkins-report.html\">Jenkins Report</a>");
        sb.append("<ul>");
        for (String test : this._getTestList()) {
            sb.append("<li>");
            sb.append(test);
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private int _getMaxCommitGroupCount() {
        int maxCommitGroupCount = this._getAllowedPortalBranchSHACount();
        if (maxCommitGroupCount != -1) {
            return maxCommitGroupCount;
        }
        return 5;
    }

    private int _getMaxRetestCount() {
        String maxRetestCount = this.getJobPropertyValue("maximum.retest.count");
        if (maxRetestCount == null || maxRetestCount.isEmpty()) {
            return -1;
        }
        try {
            return Integer.valueOf(maxRetestCount);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return -1;
        }
    }

    private List<String> _getPortalBranchSHAs() {
        String portalBranchSHAsString = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BRANCH_SHAS);
        if (portalBranchSHAsString == null || portalBranchSHAsString.isEmpty()) {
            Workspace workspace = this.getWorkspace();
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            GitWorkingDirectory gitWorkingDirectory = workspaceGitRepository.getGitWorkingDirectory();
            List<LocalGitCommit> localGitCommits = gitWorkingDirectory.log(1);
            LocalGitCommit localGitCommit = localGitCommits.get(0);
            return Collections.singletonList(localGitCommit.getSHA());
        }
        Matcher matcher = _compareURLPattern.matcher(portalBranchSHAsString);
        if (matcher.find()) {
            Workspace workspace = this.getWorkspace();
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            List<LocalGitCommit> rangeLocalGitCommits = new ArrayList<LocalGitCommit>();
            try {
                rangeLocalGitCommits = workspaceGitRepository.getRangeLocalGitCommits(matcher.group("earliestSHA"), matcher.group("latestSHA"));
            }
            catch (Exception exception) {
                this.failBuildRunner("Unable to store the commit history", exception);
            }
            List<List<LocalGitCommit>> localGitCommitsLists = workspaceGitRepository.partitionLocalGitCommits(rangeLocalGitCommits, this._getMaxCommitGroupCount());
            ArrayList<String> portalBranchSHAs = new ArrayList<String>();
            for (List<LocalGitCommit> localGitCommits : localGitCommitsLists) {
                LocalGitCommit localGitCommit = localGitCommits.get(0);
                portalBranchSHAs.add(localGitCommit.getSHA());
            }
            return portalBranchSHAs;
        }
        ArrayList<String> portalBranchSHAs = new ArrayList<String>();
        for (String portalBranchSHA : portalBranchSHAsString.split(",")) {
            portalBranchSHAs.add(portalBranchSHA.trim());
        }
        return portalBranchSHAs;
    }

    private List<String> _getPortalCherryPickSHAs() {
        ArrayList<String> portalCherryPickSHAList = new ArrayList<String>();
        String portalCherryPickSHAsString = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_CHERRY_PICK_SHAS);
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalCherryPickSHAsString)) {
            return portalCherryPickSHAList;
        }
        for (String portalCherryPickSHA : portalCherryPickSHAsString.split(",")) {
            portalCherryPickSHAList.add(portalCherryPickSHA.trim());
        }
        return portalCherryPickSHAList;
    }

    private String _getPortalGitHubURL() {
        return this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL);
    }

    private int _getRetestCount() {
        String retestCount = this.getBuildParameter(_NAME_BUILD_PARAMETER_RETEST_COUNT);
        if (retestCount == null || retestCount.isEmpty()) {
            return 1;
        }
        try {
            return Integer.parseInt(retestCount);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return 1;
        }
    }

    private List<String> _getTestList() {
        String portalBatchTestSelector = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH_TEST_SELECTOR);
        ArrayList<String> list = new ArrayList<String>();
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            if (!this._isModulesBatch()) {
                return list;
            }
            BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
            buildDatabase.putProperty("start.properties", _NAME_BUILD_PARAMETER_PORTAL_BATCH_TEST_SELECTOR, "**/*");
        }
        BatchTestClassGroup batchTestClassGroup = TestClassGroupFactory.newBatchTestClassGroup(this._getBatchName(), this.getJob());
        for (TestClass testClass : batchTestClassGroup.getTestClasses()) {
            if (testClass instanceof FunctionalTestClass) {
                FunctionalTestClass functionalTestClass = (FunctionalTestClass)testClass;
                list.add(functionalTestClass.getTestClassMethodName());
                continue;
            }
            if (testClass instanceof JUnitTestClass && !(testClass instanceof PlaywrightJUnitTestClass)) {
                String testClassFilePath = JenkinsResultsParserUtil.getCanonicalPath(testClass.getTestClassFile());
                list.add(testClassFilePath.replaceAll(".*/(com/.*)\\.java", "$1.class"));
                continue;
            }
            if (testClass instanceof ModulesTestClass) {
                for (TestClassMethod testClassMethod : testClass.getTestClassMethods()) {
                    list.add(testClassMethod.getName());
                }
                continue;
            }
            if (!(testClass instanceof PlaywrightJUnitTestClass)) continue;
            list.add(testClass.getName());
        }
        return list;
    }

    private boolean _isFunctionalBatch() {
        String portalBatchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH);
        return portalBatchName.startsWith("functional");
    }

    private boolean _isJUnitBatch() {
        String portalBatchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH);
        return portalBatchName.startsWith("integration") || portalBatchName.startsWith("modules-integration") || portalBatchName.startsWith("modules-unit") || portalBatchName.startsWith("unit");
    }

    private boolean _isModulesBatch() {
        String portalBatchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH);
        return portalBatchName.startsWith("js-unit") || portalBatchName.startsWith("modules-compile") || portalBatchName.startsWith("modules-semantic-versioning") || portalBatchName.startsWith("rest-builder") || portalBatchName.startsWith("service-builder");
    }

    private void _validateBuildParameterJenkinsGitHubURL() {
        String repositoryName;
        String jenkinsGitHubURL = this.getBuildParameter(_NAME_BUILD_PARAMETER_JENKINS_GITHUB_URL);
        if (jenkinsGitHubURL == null || jenkinsGitHubURL.isEmpty()) {
            return;
        }
        String failureMessage = JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_JENKINS_GITHUB_URL, " has an invalid Jenkins GitHub URL <a href=\"", jenkinsGitHubURL, "\">", jenkinsGitHubURL, "</a>");
        Matcher matcher = _portalURLPattern.matcher(jenkinsGitHubURL);
        if (!matcher.find()) {
            this.failBuildRunner(failureMessage);
        }
        if (!(repositoryName = matcher.group("repositoryName")).equals("liferay-jenkins-ee")) {
            this.failBuildRunner(failureMessage);
        }
    }

    private void _validateBuildParameterPortalBatchName() {
        String allowedPortalBatchNames;
        String portalBatchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH);
        if (portalBatchName == null || portalBatchName.isEmpty()) {
            this.failBuildRunner("PORTAL_BATCH_NAME is null");
        }
        if ((allowedPortalBatchNames = this.getJobPropertyValue(JenkinsResultsParserUtil.combine("allowed.portal.batch.names[", this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_UPSTREAM_BRANCH_NAME), "]"))) == null || allowedPortalBatchNames.isEmpty()) {
            return;
        }
        List<String> allowedPortalBatchNamesList = Arrays.asList(allowedPortalBatchNames.split(","));
        if (!allowedPortalBatchNamesList.contains(portalBatchName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(_NAME_BUILD_PARAMETER_PORTAL_BATCH);
            sb.append(" must match one of the following: ");
            sb.append("<ul>");
            for (String allowedPortalBatchName : allowedPortalBatchNamesList) {
                sb.append("<li>");
                sb.append(allowedPortalBatchName);
                sb.append("</li>");
            }
            sb.append("</ul>");
            this.failBuildRunner(sb.toString());
        }
    }

    private void _validateBuildParameterPortalBatchTestSelector() {
        if (!this._isFunctionalBatch() && !this._isJUnitBatch()) {
            return;
        }
        String portalBatchTestSelector = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH_TEST_SELECTOR);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            return;
        }
        String portalBatchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BATCH);
        this.failBuildRunner(JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_BATCH_TEST_SELECTOR, " is required for ", portalBatchName));
    }

    private void _validateBuildParameterPortalBranchSHAs() {
        Matcher matcher;
        String portalBranchSHAs = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_BRANCH_SHAS);
        if (portalBranchSHAs == null || portalBranchSHAs.isEmpty()) {
            return;
        }
        int allowedPortalBranchSHACount = this._getAllowedPortalBranchSHACount();
        if (allowedPortalBranchSHACount == -1) {
            return;
        }
        int portalBranchSHACount = StringUtils.countMatches((String)portalBranchSHAs, (String)",") + 1;
        int retestCount = this._getRetestCount();
        if (retestCount != 1) {
            allowedPortalBranchSHACount = 1;
        }
        if (portalBranchSHACount > allowedPortalBranchSHACount) {
            this.failBuildRunner(JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_BRANCH_SHAS, " may only reference ", String.valueOf(allowedPortalBranchSHACount), " portal branch SHAs"));
        }
        if ((matcher = _compareURLPattern.matcher(portalBranchSHAs)).find()) {
            String portalUpstreamBranchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_UPSTREAM_BRANCH_NAME);
            String repositoryName = matcher.group("repositoryName");
            if (repositoryName.equals("liferay-portal") && !portalUpstreamBranchName.equals("master") || repositoryName.equals("liferay-portal-ee") && portalUpstreamBranchName.equals("master")) {
                this._failInvalidPortalRepositoryName(_NAME_BUILD_PARAMETER_PORTAL_BRANCH_SHAS, portalUpstreamBranchName);
            }
        }
    }

    private void _validateBuildParameterPortalGitHubURL() {
        String repositoryName;
        String portalGitHubURL = this._getPortalGitHubURL();
        if (portalGitHubURL == null || portalGitHubURL.isEmpty()) {
            this.failBuildRunner("PORTAL_GITHUB_URL is null");
        }
        String failureMessage = JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL, " has an invalid Portal GitHub URL <a href=\"", portalGitHubURL, "\">", portalGitHubURL, "</a>");
        Matcher matcher = _portalURLPattern.matcher(portalGitHubURL);
        if (!matcher.find()) {
            this.failBuildRunner(failureMessage);
        }
        if (!(repositoryName = matcher.group("repositoryName")).equals("liferay-portal") && !repositoryName.equals("liferay-portal-ee")) {
            this.failBuildRunner(failureMessage);
        }
        String portalUpstreamBranchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_UPSTREAM_BRANCH_NAME);
        if (repositoryName.equals("liferay-portal") && !portalUpstreamBranchName.equals("master") || repositoryName.equals("liferay-portal-ee") && portalUpstreamBranchName.equals("master")) {
            this._failInvalidPortalRepositoryName(_NAME_BUILD_PARAMETER_PORTAL_GITHUB_URL, portalUpstreamBranchName);
        }
    }

    private void _validateBuildParameterPortalUpstreamBranchName() {
        String portalUpstreamBranchName = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_UPSTREAM_BRANCH_NAME);
        if (portalUpstreamBranchName == null || portalUpstreamBranchName.isEmpty()) {
            this.failBuildRunner("PORTAL_UPSTREAM_BRANCH_NAME is null");
        }
        if (portalUpstreamBranchName.matches("release-\\d{4}.q\\d+")) {
            return;
        }
        String allowedPortalUpstreamBranchNames = this.getJobPropertyValue("allowed.portal.upstream.branch.names");
        if (allowedPortalUpstreamBranchNames == null || allowedPortalUpstreamBranchNames.isEmpty()) {
            return;
        }
        List<String> allowedPortalUpstreamBranchNamesList = Arrays.asList(allowedPortalUpstreamBranchNames.split(","));
        if (!allowedPortalUpstreamBranchNamesList.contains(portalUpstreamBranchName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(_NAME_BUILD_PARAMETER_PORTAL_UPSTREAM_BRANCH_NAME);
            sb.append(" must match one of the following: ");
            sb.append("<ul>");
            for (String allowedPortalUpstreamBranchName : allowedPortalUpstreamBranchNamesList) {
                sb.append("<li>");
                sb.append(allowedPortalUpstreamBranchName);
                sb.append("</li>");
            }
            sb.append("</ul>");
            sb.append("or is not a valid release branch.");
            this.failBuildRunner(sb.toString());
        }
    }

    private void _validateBuildParameterRetestCherryPickSHA() {
        String cherryPickSHAs = this.getBuildParameter(_NAME_BUILD_PARAMETER_PORTAL_CHERRY_PICK_SHAS);
        if (cherryPickSHAs == null || cherryPickSHAs.isEmpty()) {
            return;
        }
        int retestCount = this._getRetestCount();
        if (retestCount != 1) {
            this.failBuildRunner(JenkinsResultsParserUtil.combine("Cherry-picked SHAs may not be used when retesting."));
        }
    }

    private void _validateBuildParameterRetestCount() {
        String retestCount = this.getBuildParameter(_NAME_BUILD_PARAMETER_RETEST_COUNT);
        if (retestCount == null || retestCount.isEmpty()) {
            return;
        }
        int retestCountInt = 0;
        try {
            retestCountInt = Integer.parseInt(retestCount);
        }
        catch (NumberFormatException numberFormatException) {
            this.failBuildRunner(JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_RETEST_COUNT, " parameter value: \"", retestCount, "\" is not a number."));
        }
        int maxRetestCount = this._getMaxRetestCount();
        if (retestCountInt < 0 || retestCountInt > maxRetestCount) {
            this.failBuildRunner(JenkinsResultsParserUtil.combine(_NAME_BUILD_PARAMETER_RETEST_COUNT, " must be between 0 and ", String.valueOf(maxRetestCount), "."));
        }
    }
}

