/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SecretsUtil {
    private static final String _SERVER_URL = "https://1password.liferay.com";
    private static final JenkinsResultsParserUtil.BearerHTTPAuthorization _bearerHTTPAuthorization;
    private static final Pattern _keyPattern;
    private static final Pattern _secretPropertyPattern;

    public static String getSecret(String key) {
        String secret;
        if (_bearerHTTPAuthorization == null) {
            return key;
        }
        Matcher matcher = _keyPattern.matcher(key);
        if (matcher.matches() && !JenkinsResultsParserUtil.isNullOrEmpty(secret = SecretsUtil.getSecret(matcher.group("vaultName"), matcher.group("itemTitle"), matcher.group("fieldLabel")))) {
            return secret;
        }
        return key;
    }

    public static String getSecret(String vaultName, String itemTitle, String fieldLabel) {
        if (_bearerHTTPAuthorization == null) {
            return null;
        }
        Vault vault = Vault.getInstance(vaultName);
        if (vault == null) {
            System.out.println("Vault Not Found: " + vaultName);
            return null;
        }
        Item item = vault.getItem(itemTitle);
        if (item == null) {
            System.out.println(JenkinsResultsParserUtil.combine("Item Not Found: ", vaultName, "/", itemTitle));
            return null;
        }
        Field field = item.getField(fieldLabel);
        if (field == null) {
            System.out.println(JenkinsResultsParserUtil.combine("Field Not Found: ", vaultName, "/", itemTitle, "/", fieldLabel));
            return null;
        }
        return field.value;
    }

    public static boolean isSecretProperty(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = _secretPropertyPattern.matcher(value);
        return matcher.matches();
    }

    private static JSONArray _toJSONArray(String path) {
        if (_bearerHTTPAuthorization == null) {
            return new JSONArray();
        }
        try {
            return JenkinsResultsParserUtil.toJSONArray(_SERVER_URL + path, null, _bearerHTTPAuthorization);
        }
        catch (IOException ioException) {
            System.out.println(ioException.getMessage());
            ioException.printStackTrace();
            return new JSONArray();
        }
    }

    private static JSONObject _toJSONObject(String path) {
        if (_bearerHTTPAuthorization == null) {
            return new JSONObject();
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(_SERVER_URL + path, null, (JenkinsResultsParserUtil.HTTPAuthorization)_bearerHTTPAuthorization);
        }
        catch (IOException ioException) {
            System.out.println(ioException.getMessage());
            ioException.printStackTrace();
            return null;
        }
    }

    static {
        _keyPattern = Pattern.compile("(secret\\:)?(?<vaultName>[^\\/]*)\\/(?<itemTitle>[^\\/]*)\\/(?<fieldLabel>.*)");
        _secretPropertyPattern = Pattern.compile("secret\\:(?<key>.*)");
        String token = null;
        try {
            token = JenkinsResultsParserUtil.read(new File(System.getProperty("user.home") + "/.1password.connect"));
            token = token.trim();
        }
        catch (IOException ioException) {
            token = null;
            System.out.println("Unable to load 1Password connect bearer token.");
        }
        if (token != null) {
            JenkinsResultsParserUtil.addRedactToken(token);
            _bearerHTTPAuthorization = new JenkinsResultsParserUtil.BearerHTTPAuthorization(token);
        } else {
            _bearerHTTPAuthorization = null;
        }
    }

    private static class Vault {
        public final String id;
        public final String name;
        private static final Map<String, Vault> _vaultsMap = new HashMap<String, Vault>();
        private List<Item> _items;

        public static Vault getInstance(String name) {
            return _vaultsMap.get(name);
        }

        public Item getItem(String title) {
            if (this._items == null) {
                this.init();
            }
            for (Item item : this._items) {
                if (!Objects.equals(item.title, title)) continue;
                return item;
            }
            return null;
        }

        public void init() {
            JSONArray itemsJSONArray = SecretsUtil._toJSONArray(JenkinsResultsParserUtil.combine("/v1/vaults/", this.id, "/items"));
            this._items = new ArrayList<Item>(itemsJSONArray.length());
            for (int i = 0; i < itemsJSONArray.length(); ++i) {
                JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
                this._items.add(new Item(itemJSONObject.getString("id"), itemJSONObject.getString("title"), this));
            }
        }

        private Vault(String id, String name) {
            this.id = id;
            this.name = name;
        }

        static {
            JSONArray vaultsJSONArray = new JSONArray();
            for (int i = 0; i < vaultsJSONArray.length(); ++i) {
                JSONObject vaultJSONObject = vaultsJSONArray.getJSONObject(i);
                Vault vault = new Vault(vaultJSONObject.getString("id"), vaultJSONObject.getString("name"));
                _vaultsMap.put(vault.name, vault);
            }
        }
    }

    private static class Item {
        public final String id;
        public final String title;
        private List<Field> _fields;
        private Item _linkedItem;
        private final Vault _vault;

        public Item(String id, String title, Vault vault) {
            this.id = id;
            this.title = title;
            this._vault = vault;
        }

        public Field getField(String label) {
            if (this._fields == null) {
                this.init();
            }
            for (Field field : this._fields) {
                if (!Objects.equals(field.label, label)) continue;
                return field;
            }
            if (this._linkedItem != null) {
                return this._linkedItem.getField(label);
            }
            return null;
        }

        public void init() {
            JSONObject itemJSONObject = SecretsUtil._toJSONObject(JenkinsResultsParserUtil.combine("/v1/vaults/", this._vault.id, "/items/", this.id));
            JSONArray fieldsJSONArray = itemJSONObject.getJSONArray("fields");
            this._fields = new ArrayList<Field>(fieldsJSONArray.length());
            for (int i = 0; i < fieldsJSONArray.length(); ++i) {
                JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
                try {
                    JSONObject sectionJSONObject = fieldJSONObject.optJSONObject("section");
                    if (sectionJSONObject != null) {
                        if (Objects.equals(sectionJSONObject.optString("label"), "Related Items")) {
                            this._linkedItem = this._vault.getItem(fieldJSONObject.getString("label"));
                        }
                        if (this._linkedItem != null) continue;
                    }
                    if (!fieldJSONObject.has("value")) continue;
                    this._fields.add(new Field(fieldJSONObject.getString("label"), fieldJSONObject.getString("value")));
                    continue;
                }
                catch (JSONException jsonException) {
                    System.err.println(jsonException.toString());
                    System.out.println(fieldJSONObject.toString(2));
                }
            }
        }
    }

    private static class Field {
        public final String label;
        public final String value;

        public Field(String label, String value) {
            this.label = label;
            this.value = value;
            if (!JenkinsResultsParserUtil.isNullOrEmpty(value)) {
                JenkinsResultsParserUtil.addRedactToken(value);
            }
        }
    }
}

