/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.SecretsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SecureProperties
extends Properties {
    private static final Pattern _nestedPropertyPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");

    public SecureProperties() {
    }

    public SecureProperties(Properties properties) {
        if (properties instanceof SecureProperties) {
            SecureProperties secureProperties = (SecureProperties)properties;
            for (Object key : properties.keySet()) {
                this.put(key, secureProperties.get(key, false));
            }
            return;
        }
        for (Object key : properties.keySet()) {
            this.put(key, properties.get(key));
        }
    }

    @Override
    public synchronized Object get(Object key) {
        return this.get(key, true);
    }

    public synchronized Object get(Object key, boolean getSecret) {
        String value = this._getReferencedValue(new ArrayList<String>(), (String)key);
        if (!getSecret) {
            return value;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(value) && SecretsUtil.isSecretProperty(value)) {
            value = SecretsUtil.getSecret(value);
            this.put(key, value);
        }
        return value;
    }

    @Override
    public String getProperty(String key) {
        return (String)this.get(key);
    }

    private String _getReferencedValue(List<String> previousKeys, String key) {
        if (previousKeys.contains(key)) {
            if (previousKeys.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("Found circular property reference chain:\n");
                for (String previousKey : previousKeys) {
                    sb.append(previousKey);
                    sb.append(" -> ");
                }
                sb.append(key);
                throw new IllegalStateException(sb.toString());
            }
            return JenkinsResultsParserUtil.combine("${", key, "}");
        }
        previousKeys.add(key);
        if (!this.containsKey(key)) {
            return key;
        }
        String value = JenkinsResultsParserUtil.getFilteredPropertyValue((String)super.get(key));
        Matcher matcher = _nestedPropertyPattern.matcher(value);
        String newValue = value;
        while (matcher.find()) {
            String propertyGroup = matcher.group(0);
            String propertyName = matcher.group(1);
            if (!this.containsKey(propertyName)) continue;
            newValue = newValue.replace(propertyGroup, this._getReferencedValue(new ArrayList<String>(previousKeys), propertyName));
        }
        return newValue;
    }
}

